/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_ISystemLoadStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStatistics.h"

/*!
  *  \enum enSystemLoadStatisticsType
  *  \brief type of system load statistics data.
  *
  */
enum enSystemLoadStatisticsType
{
   SPM_U32_STATISTIC_CPU_USAGE,
   SPM_U32_STATISTIC_RAM_USAGE,
   SPM_U32_STATISTIC_STARTUP_TIME,
};

/*!
  *  \class ISpmSystemLoadStatistics
  *  \brief This abstract class provides interfaces to get or set statistics data specifically for
  *         System Load (CPU, RAM, StartupTime,...).
  */
class ISpmSystemLoadStatistics : public ISpmStatistics
{
public:
// constructor
ISpmSystemLoadStatistics( const ISpmFactory& factory ) : ISpmStatistics( factory ){ }
virtual ~ISpmSystemLoadStatistics( ){ }

virtual const tChar*getInterfaceName( ) const { return( "ISpmSystemLoadStatistics" ); }

virtual tVoid bUpdateLoading( tU32 u32Load )          = 0;

virtual tVoid vEraseLoading( )                        = 0;
};

