/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_ISoftwareVersionStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStatistics.h"
/*!
   Number of first sw version statistic data pool
  */
#define SPM_U32_STATISTIC_SW_VERSION_STACK_01_MAX_INDEX               5
/*!
   Maximum elements in software version statistic data pool
  */
#define SPM_U32_STATISTIC_SW_VERSION_MAX_INDEX                        20
/*!
   Index of current running software version statistic
  */
#define SPM_U32_STATISTIC_CURRENT_SW_VERSION                          0xFF

class ISpmSoftwareVersionStatistics : public ISpmStatistics
{
public:
// constructor
ISpmSoftwareVersionStatistics( const ISpmFactory& factory ) : ISpmStatistics( factory ){ }
virtual ~ISpmSoftwareVersionStatistics( ){ }

virtual const tChar*getInterfaceName( ) const { return( "ISpmSoftwareVersionStatistics" ); }

virtual tBool vGetDataWithIndex( TSpmSoftwareVersionStatisticsData *pStatisticsData,
                        tU32  u32Index = 0 )            = 0;
};

