/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_IResetStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStatistics.h"

class ISpmResetStatistics : public ISpmStatistics
{
public:
// constructor
ISpmResetStatistics( const ISpmFactory& factory ) : ISpmStatistics( factory ){ }
virtual ~ISpmResetStatistics( ){ }

virtual const tChar*getInterfaceName( ) const { return( "ISpmResetStatistics" ); }

virtual tVoid vGetData( void *pStatisticsData, tU32  u32ObjectSize = 0 ) const  = 0;

virtual tVoid vGetData( TSpmResetElem *pStatistics, tU32  u32ObjectSize ) const = 0;
};

