/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          spm_IPowerSupplyStatistics.h
  * @PROJECT:      CMD project
  * @brief         include header file
  *
  * ----------------------------------------------------------------------------
  * @copyright     (C) 2018 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_IStatistics.h"
/*!
 * The size of voltage histogram array.
 */
#define SPM_U32_STATISTIC_VOLT_RANGE_HISTORAM_LENGTH  50
/*!
 * Step size of voltage value in voltage histogram.
 */
#define SPM_U32_STATISTIC_VOLTAGE_RANGE_RESOLUTION    (tU16)1000
/*!
 * Voltage histogram type of power supply statistic data.
 */
#define SPM_U32_STATISTIC_VOLTAGE_RANGE_HISTOGRAM     (tU32)0x00000000

class ISpmPowerSupplyStatistics : public ISpmStatistics
{
public:
// constructor
ISpmPowerSupplyStatistics( const ISpmFactory& factory ) : ISpmStatistics( factory ){ }
virtual ~ISpmPowerSupplyStatistics( ){ }

virtual const tChar*getInterfaceName( ) const { return( "ISpmPowerSupplyStatistics" ); }

virtual tVoid vUpdateVoltageHistogram( tU16 tVoltageValue )            = 0;

virtual tVoid vEraseVoltageHistogram( )                                = 0;

virtual tVoid vGetData( TSpmVoltageHistogramRangeStatisticsData *pStatistics,
                                              tU32  u32ObjectSize ) const = 0;
};

