/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISwBlock.h
  * @brief        This is header file contains interfaces to handle software block operations.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include <set>
#include <string>

// //////////////////////////////////////////////////////////////////////////////
// private class to compare the sw blocks from the SwBlockServer with the
// waiting sw blocks of this class. The original compare function would only
// work on the pointers but not on the contents. So this functionality
// can not be used.

/*!
  *  \class spm_tclCompareSwBlocks
  *  \brief This abstract class provides operator interfaces to compare software block (Strings Type) .
  */
class spm_tclCompareSwBlocks
{
public:
bool operator()( const std::string& op1,
                 const std::string& op2 ) const {
   return( op1 < op2 );
}

};


// do not sort by string pointers but by the string contents to get an ascending
// sort order of strings. Very important for includes algorithm.
typedef std::set < std::string, spm_tclCompareSwBlocks > TSpmSwBlockSet;

/*!
  *  \class ISpmSwBlockClient
  *  \brief This abstract class provides interfaces to handle software block operations.
  */
class ISpmSwBlockClient
{
public:
virtual ~ISpmSwBlockClient( ){}
virtual void vOnSwBlockLoaded( const TSpmSwBlockSet& sw )    = 0;

virtual void vOnSwBlockConnected( const TSpmSwBlockSet& sw ) = 0;

virtual void vOnSwBlockUp( const TSpmSwBlockSet& sw )        = 0;

virtual void vOnSwBlockForced( const TSpmSwBlockSet& sw )    = 0;

};

/*!
  *  \class ISpmSwBlockServer
  *  \brief This abstract class provides interfaces to add or remove clients.
  */
class ISpmSwBlockServer
{
public:
virtual ~ISpmSwBlockServer( ){}
virtual tVoid vAddClient( ISpmSwBlockClient *clt )    = 0;

virtual tVoid vRemoveClient( ISpmSwBlockClient *clt ) = 0;

};

