/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IProcessDatabase.h
  * @brief        This is header file contains interfaces related to process database..
  * @copyright    (C) 2013 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_ISpmBase.h"
#define PROC_NAME_MAX               256
#define SPM_STARTED_PROCESSES       1
#define SPM_ADDITIONAL_PROCESSES    2

/*!
  *  \class TProcessConfiguration
  *  \brief This class provides initial process configuration
          Which includes process priority, affinity,  affinity end, nicelevel and  nicelevel end.
  */
class TProcessConfiguration
{
public:
TProcessConfiguration( ){
   ProcPrio           = 0;
   Affinity           = 0;
   AffinityEnd        = 0;
   NiceLevel          = 0;
   NiceLevelEnd       = 0;
   CGroupMemLevel1    = 0;
   CGroupMemLevel2    = 0;
   handle             = 0;
   instance           = 0;
   startTimeStamp     = 0;
   isMissing          = 0;
   bSupervisionActive = TRUE;
}

tU32         ProcPrio;
tU32         Affinity;
tU32         AffinityEnd;
tU32         NiceLevel;
tU32         NiceLevelEnd;
tU32         CGroupMemLevel1;
tU32         CGroupMemLevel2;
std::string  strProcessName;              // process name
tS32         handle;
#ifdef LINUX_BUILD
   cpu_set_t cpuMask;
#endif
tU32         instance;
tU32         startTimeStamp;
tBool        isMissing;
tBool        bSupervisionActive;
};

typedef std::map < tU32, TProcessConfiguration > TMapStartedProcesses;

/*!
  *  \class TProcessSupervisionConfiguration
  *  \brief This class provides initial supervision process configuration which includes supervision mode.
  */
class TProcessSupervisionConfiguration
{
public:
TProcessSupervisionConfiguration( ){
   supervisionMode = 0;
}

tU32        supervisionMode;
std::string procName;              // process name
};


/*!
  *  \class ISpmProcessDatabase
  *  \brief This abstract class provides interfaces to access and release process database.
          It also delivers interfaces to update map with started process and additional process.
        It also supplies interface to remove process from map.
  */
class ISpmProcessDatabase : public ISpmBase
{
public:
// constructor
ISpmProcessDatabase( const ISpmFactory& factory ) : ISpmBase( factory ){ }
virtual ~ISpmProcessDatabase( ){ }

virtual tBool bUpdateMapStartedProc( const TProcessConfiguration& processConfig )             = 0;

virtual tBool bUpdateMapAdditionalProc( const TProcessConfiguration& processConfig )          = 0;

virtual tBool bUpdateExternalProcess( const TProcessSupervisionConfiguration& processConfig ) = 0;

virtual tBool bRemoveMapProc( const std::string strProcessName )                              = 0;

virtual TMapStartedProcesses& mapGetStartedProcesses( )                                       = 0;

virtual TMapStartedProcesses& mapGetAdditionalProcesses( )                                    = 0;

virtual std::vector < TProcessSupervisionConfiguration >& vecGetExternalProcesses( )          = 0;

virtual const tChar*getName( ) const                                                          = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmProcessDatabase" ); }
};

