/*!
  * \file spm_ConnectedApps.cpp
  *  \brief
  *    Describes the state of a current application.
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 14.07.11  | TMS Fischer       | initial version
  ******
  */

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#include "spm_Config.h"

#include "spm_ConnectedApps.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_ConnectedApps.cpp.trc.h"
#endif
// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"


/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// ////#define SPM_TRACE_FILE_ID   SPM_FILE_CONNAPPS

// -----------------------------------------------------------------------------
// constructor
// -----------------------------------------------------------------------------
spm_tclConnectedApp::spm_tclConnectedApp( tU32  u32AppID,
                                          tBool bLocal )
   : _u32AppStateInvalid( AMT_C_U32_STATE_INVALID )
   , _u32AppStateUninitialized( AMT_C_U32_STATE_UNINITALIZED )
   , _u32AppStateInitialized( AMT_C_U32_STATE_INITIALIZED )
   , _bIsConnected( FALSE )
   , _bIsLocal( bLocal )
   , _u32AppID( u32AppID )
   , _bWatchdog( FALSE )
   , _u32NotifyInterval( 0 )
   , _u32LastLifeSignalTime( 0 )
   , _bWatchdogError( FALSE )
   , _bNotifyProblemRequest( FALSE )
   , _u32AppStateCurrent( AMT_C_U32_STATE_UNINITALIZED )
   , _u32AppStateRequest( AMT_C_U32_STATE_INVALID )
   , _u32AppStateNewRequest( AMT_C_U32_STATE_UNINITALIZED )
   , _u32AppStateForceReq( AMT_C_U32_STATE_UNINITALIZED )
   , _u32AppStateReqStartTime( OSAL_ClockGetElapsedTime( ) )
   , _u32AppStateReqEndTime( OSAL_ClockGetElapsedTime( ) + SPM_APPREQMON_STARTUP_INTERVAL )
   , _u32FatalErrorState( 0 ){

}

// -----------------------------------------------------------------------------
// destructor
// -----------------------------------------------------------------------------
spm_tclConnectedApp::~spm_tclConnectedApp( ){
}

// -----------------------------------------------------------------------------
// set application state to Initialized
// -----------------------------------------------------------------------------
tBool spm_tclConnectedApp::bHandleAppInitialized( ){
   _u32AppStateCurrent = AMT_C_U32_STATE_INITIALIZED;
   return( TRUE );
}

