/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ICvmClient.h
  * @brief        This is header file contains interfaces to exchange the undervoltage or overvoltage information.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IWorkerClient.h"
#include "spm_IFactory.h"
// //////////////////////////////////////////////////////////////////////////////
// Interface to exchange the undervoltage/overvoltage information

/*!
  *  \class ISpmCvmClient
  *  \brief This abstract class provides interfaces to exchange the undervoltage or overvoltage information.
          This class also supplies pure virtual function to get remaining critical voltage time.
          The spm_tclFactory object creates an instance of this class.
  */
class ISpmCvmClient : public ISpmWorkerClient
{
public:
ISpmCvmClient( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmCvmClient( ){}

virtual tVoid vHandleCvmEvent( tU32 u32CvmEvent )  = 0;

virtual tU32 u32GetCurVoltageState( tVoid ) = 0;

virtual tU32 u32GetRemainingCriticalVoltageTime( ) = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmCvmClient" ); }
};

