/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_SystemStateMachineServiceHandler.h
  * @brief        This is header file for System State Machine INC client handler.
  * @copyright    (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_Config.h"
#include "spm_SCCSocketInterface.h"
#include "spm_ISystemStateMachineIncClientHandler.h"

/*!
  *  \class spm_tclSystemStateMachineServiceHandler
  *  \brief This is the client handler which provides an interface to  System State Machine Module of System Communication Controller(SCC).
          This class implements the system state machine at iMX side to handle messages from system state machine Module of System Communication Controller.

          The spm_tclFactory object creates an instance of this class. Whenever spm_tclSCCSocketInterface - Rx Thread reads a message from System Communication Controller,
          it invokes vProcessSCCMessage of this object to process the message received.
  */
class spm_tclSystemStateMachineServiceHandler : public ISpmSystemStateMachineIncClientHandler
   , public spm_tclSCCSocketInterface
{
public:
spm_tclSystemStateMachineServiceHandler( const ISpmFactory& factory );
virtual ~spm_tclSystemStateMachineServiceHandler( );

   virtual const tChar*getName( ) const { return( "spm_tclSystemStateMachineServiceHandler" ); }
   virtual tVoid vGetReferences( );
   virtual tVoid vStartCommunication( );

   virtual tBool bIsCommunicationActivated( );

   /* C_SET_STATEMACHINE_TYPE */
   virtual tBool bSetStateMachineType( eSystemSm_StateMachineType eStateMachineType );

   /* C_SET_SM_TRIGGER */
   virtual tBool bSetStateMachineTrigger( eSystemSm_StateMachineTrigger eStateMachineTrigger,
                                  eSystemSm_TriggerState        eTriggerState );

   /* C_SET_SCC_SYSTEMSTATE */
   virtual tBool bSetSCCSystemState( eSystemSm_SccSystemState eSystemState );

   /* C_SEND_APP_SYSTEMSTATE */
   virtual tBool bSetAppSystemState( eSystemSm_AppSystemState eAppSystemState );

   // ISpmBase interface functions
   virtual tVoid vHandleTraceMessage( const tUChar *puchData );

protected:

   /* C_COMPONENT_STATUS */
   //This interface is not public by intention. Only the StartCommunication can activate the communication
   virtual tVoid vSetComponentStatus( eSystemSm_ApplicationStatus eClientComponentStatus );
   /* R_COMPONENT_STATUS */
   virtual tVoid vOnComponentStatusRespond( eSystemSm_ApplicationStatus eServerComponentStatus );
   /* R_REJECT */
   virtual tVoid vOnMessageReject( tU8 /* u8RejectedMsgID */, eSystemSm_RejReason /* eRejectReason */ ) { return; }; //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
   /* R_SET_STATEMACHINE_TYPE */
   virtual tVoid vOnSetStateMachineTypeRespond( eSystemSm_StateMachineType /* eStateMachineType */ ) { return; }; //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
   /* R_SET_SM_TRIGGER */
   virtual tVoid vOnSetStateMachineTriggerRespond( tU8 /* u8NumOfTriggers */,
                                                   tU8*/*pu8SMTriggerList1 */,
                                                   tU8 /* u8NumOfSMTriggerList1 */,
                                                   tU8*/* pu8SMTriggerList2 */,
                                                   tU8 /* u8NumOfSMTriggerList2 */,
                                                   tU8*/* pu8SMTriggerList3 */,
                                                   tU8 /* u8NumOfSMTriggerList3 */ ) { return; }; //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
   /* R_SET_SCC_SYSTEMSTATE */
   /* R_SEND_APP_SYSTEMSTATE */
   /* R_SCC_SYSTEMSTATE */
   virtual tVoid vOnSCCSystemStateUpdate( eSystemSm_SccSystemState /* eSccSystemState */ ) { return; }; //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
   /* R_APP_SYSTEMSTATE */
   virtual tVoid vOnSetAppSystemStateRequest( eSystemSm_AppSystemState /* eAppSystemState */ ) { return; }; //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

   // ISpmSCCSocketInterface interface function
   virtual tVoid vProcessSCCMessage( tU8 *pu8Message );

private:

   /* R_COMPONENT_STATUS */
   tVoid vHandleIncMsgSystemSMRComponentStatus( tU8 *pu8Message );
   /* R_REJECT */
   tVoid vHandleIncMsgSystemSMRReject( tU8 *pu8Message );
   /* R_SET_STATEMACHINE_TYPE */
   tVoid vHandleIncMsgSystemSMRSetStateMachineType( tU8 *pu8Message );
   /* R_SET_SM_TRIGGER */
   tVoid vHandleIncMsgSystemSMRSetSMTrigger( tU8 *pu8Message );
   /* R_SET_SCC_SYSTEMSTATE */
   tVoid vHandleIncMsgSystemSMRSetSccSystemState( tU8 *pu8Message );
   /* R_SEND_APP_SYSTEMSTATE */
   tVoid vHandleIncMsgSystemSMRSendAppSystemState( tU8 *pu8Message );
   /* R_SCC_SYSTEMSTATE */
   tVoid vHandleIncMsgSystemSMRSccSystemState( tU8 *pu8Message );
   /* R_APP_SYSTEMSTATE */
   tVoid vHandleIncMsgSystemSMRAppSystemState( tU8 *pu8Message );

   eSystemSm_ApplicationStatus _eClientComponentStatus;
   eSystemSm_ApplicationStatus _eServerComponentStatus;

};

