/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ISystemStateMachineIncClientHandler.h
  * @brief        This is interface file for System State Machine INC client handler.
  * @copyright    (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// SPM  configuration
#include "spm_Config.h"

#include "spm_ISpmBase.h"
#include "spm_SerializeDeserialize_System_State_Machine.h"

/*!
  *  \class ISpmSystemStateMachineIncClientHandler
  *  \brief This abstract class provides interfaces to send SystemSM message to INC socket .
          This class also supplies interfaces to get current SCC System State, SCC App Status,
          Host App Status, State Machine Type obtained after processing System Communication Controller messages.
  */
class ISpmSystemStateMachineIncClientHandler : public ISpmBase
{
public:
ISpmSystemStateMachineIncClientHandler( const ISpmFactory& factory ) : ISpmBase( factory ){}
virtual ~ISpmSystemStateMachineIncClientHandler( ){}

   virtual const tChar*getInterfaceName( ) const { return( "ISpmSystemStateMachineIncClientHandler" ); }


   virtual tBool bIsCommunicationActivated( )                                                      = 0;

   /* C_SET_STATEMACHINE_TYPE */
   virtual tBool bSetStateMachineType( eSystemSm_StateMachineType eStateMachineType )              = 0 ;

   /* C_SET_SM_TRIGGER */
   virtual tBool bSetStateMachineTrigger( eSystemSm_StateMachineTrigger eStateMachineTrigger,
                                  eSystemSm_TriggerState        eTriggerState )                    = 0;

   /* C_SET_SCC_SYSTEMSTATE */
   virtual tBool bSetSCCSystemState( eSystemSm_SccSystemState eSystemState )                       = 0;

   /* C_SEND_APP_SYSTEMSTATE */
   virtual tBool bSetAppSystemState( eSystemSm_AppSystemState eAppSystemState )                    = 0;

};

