/**
  * @swcomponent    Life Cycle Management
  * @{
  * @file           spm_SCCIncMessage.h
  * @brief          This is header file for SCC INC Message.
  * @copyright      (C) 2013 -2016 Robert Bosch Engineering and Business Solutions Limited.
  *                 The reproduction, distribution and utilization of this file as well as the
  *                 communication of its contents to others without express authorization is prohibited.
  *                 Offenders will be held liable for the payment of damages.
  *                 All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

/*!
  *  \class spm_tclSCCMessage
  *  \brief
  *     This abstract class represents any message exchanged between System Communication Controller(SCC) and FC SPM through
  *     Inter Node Communication(INC). When a message is sent from FC SPM to System Communication Controller, it is a command. When a message is received in FC SPM from
  *     System Communication Controller, it is a response.
  */
class spm_tclSCCMessage
{
public:
spm_tclSCCMessage( tU8  u8MsgId,
                   tU16 u16MsgLength ){
   _pu8MsgData   = new tU8[u16MsgLength];
   _u8MsgId      = u8MsgId;
   _u16MsgLength = u16MsgLength;
}

spm_tclSCCMessage( tU8 *pu8Message,
                   tU16 u16MsgLength ){
   _pu8MsgData   = new tU8[u16MsgLength];
   _u8MsgId      = 0;
   _u16MsgLength = u16MsgLength;
   if ( NULL != _pu8MsgData ){
      memcpy( _pu8MsgData, pu8Message, _u16MsgLength );
   }
}

virtual ~spm_tclSCCMessage( ){
   delete[] _pu8MsgData;
   _pu8MsgData = NULL;
}

virtual tU8*pu8GetMsgData( ){
   return( _pu8MsgData );
}

virtual tU8 u8GetMsgId( ) const {
   return( _u8MsgId );
}

virtual tU16 u16GetMsgLength( ) const {
   return( _u16MsgLength );
}

protected:
tU8 *_pu8MsgData;
tU8  _u8MsgId;
tU16 _u16MsgLength;
private:

//avoid copy
spm_tclSCCMessage(const spm_tclSCCMessage &corfoSCCMessage);
//avoid assignment
spm_tclSCCMessage & operator = (const spm_tclSCCMessage &corfoSCCMessage);
};

