/**
  * @swcomponent    Life Cycle Management
  * @{
  * @file           spm_ISCCSocketInterface.h
  * @brief          This is header file for SCC socket interface.
  * @copyright      (C) 2013 -2016 Robert Bosch Engineering and Business Solutions Limited.
  *                 The reproduction, distribution and utilization of this file as well as the
  *                 communication of its contents to others without express authorization is prohibited.
  *                 Offenders will be held liable for the payment of damages.
  *                 All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

// SPM  configuration
#include "spm_Config.h"

#define SCC_RX_BUFFER_SIZE 500

class spm_tclSCCMessage;

/*!
  *  \class ISpmSCCSocketInterface
  *  \brief This abstract class provides interfaces to send message to INC socket .
          This class supplies interfaces to process System Communication Controller messages.
  */
class ISpmSCCSocketInterface
{
public:
ISpmSCCSocketInterface( ){}
virtual ~ISpmSCCSocketInterface( ){}

virtual tS32 s32SendToINCSocket( spm_tclSCCMessage *poSCCMessage ) = 0;

virtual tVoid vProcessSCCMessage( tU8 *pu8Message )                = 0;

};

