/*!
  * \file spm_ClientHandlerBase.cpp
  *  \brief
  *    This is the client handler base class and derived from ISpmClientHandlerBase
  *
  *
  *  \note
  *  \b PROJECT: NextGen \n
   \b SW-COMPONENT: FC SPM \n
   \b COPYRIGHT:    (c) 2011 Robert Bosch GmbH, Hildesheim \n
  *  \see
  *  \version
  * Date      | Author            | Modification
  * 06.01.11  | TMS Fischer       | initial version
  ******
  */
#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

// SPM  configuration
#include "spm_Config.h"
#include "spm_GlobDefs.h"

// my class header
#include "spm_ClientHandlerBase.h"

// interfaces class definitions
#include "spm_ICcaServer.h"
#include "spm_IFactory.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
 #include "trcGenProj/Header/spm_ClientHandlerBase.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

/******************************************************************************
  | local #define (scope: module-local)
  |-----------------------------------------------------------------------*/
// #define SPM_TRACE_FILE_ID   SPM_FILE_CLIENTHANDLERBASE

spm_tclClientHandlerBase::spm_tclClientHandlerBase( const ISpmFactory& factory,
                                                    tU32               u32AppId,
                                                    tU16               u16SrvId,
                                                    tU16               u16MajorVersion,
                                                    tU16               u16MinorVersion ) : ISpmClientHandlerBase( factory )
   , _u16RegID( 0 )
   , _u8SrvState( AMT_C_U8_SVCSTATE_NOT_AVAILABLE )
   , _u16AppId( ( tU16 )u32AppId )
   , _u16SrvId( u16SrvId )
   , _u16MajorVersion( u16MajorVersion )
   , _u16MinorVersion( u16MinorVersion )
   , _bUpregSend( FALSE )
   , _poclCcaMsgHandler( NULL ){
}

spm_tclClientHandlerBase::~spm_tclClientHandlerBase( ){
   _poclCcaMsgHandler = NULL;
}

tVoid spm_tclClientHandlerBase::vStartCommunication( ){
}

tVoid spm_tclClientHandlerBase::vGetReferences( ){
   // get all needed references now -> all SPM objects are now available
   SPM_GET_CLASS_REFERENCE_USE_VAR( _poclCcaMsgHandler, spm_tclCcaMsgHandler, ISpmCcaServer );
}

tVoid spm_tclClientHandlerBase::vUpRegFid( tU16 u16Fid ){
   std::map < tU16, tBool >::iterator it;

   it = _mapfids.find( u16Fid );

   if ( it == _mapfids.end( ) ){
      _mapfids[u16Fid] = FALSE;
   }
   if ( !_mapfids[u16Fid] ){
      gm_tclEmptyMessage oUpReg( CCA_C_U16_APP_SPM,
                                 _u16AppId,
                                 _u16RegID,
                                 U16_SPM_UPREG_COMMAND_COUNTER,
                                 _u16SrvId,
                                 u16Fid,
                                 AMT_C_U8_CCAMSG_OPCODE_UPREG );

      if ( _poclCcaMsgHandler != NULL ){
         if ( !_poclCcaMsgHandler->bPostMessage( &oUpReg ) ){
            // Error handling
            ETG_TRACE_ERRMEM( ( "spm_tclClientHandlerBase::vUpRegFid(%X) _u16SrvId=%X post failed!", u16Fid, _u16SrvId ) );
         } else {
            ETG_TRACE_USR4( ( "spm_tclClientHandlerBase::vUpRegFid() bPostMessage() for FIX=%X returned TRUE", u16Fid ) );
         }
      } else {
         ETG_TRACE_ERRMEM( ( "spm_tclClientHandlerBase::vUpRegFid() _poclCcaMsgHandler==NULL, cant UpReg for SrvId=%X", u16Fid ) );
      }
   } else {
      ETG_TRACE_USR4( ( "vUpRegFid() FID=%X allready set to TRUE. Doing nothing.", u16Fid ) );
   }
} // vUpRegFid

tVoid spm_tclClientHandlerBase::vUpRegStatusChange( tU16  u16Fid,
                                                    tBool bStatus ){
   std::map < tU16, tBool >::iterator it;

   it = _mapfids.find( u16Fid );

   if ( it != _mapfids.end( ) ){
      _mapfids[u16Fid] = bStatus;
   }
}

tVoid spm_tclClientHandlerBase::vRegisterFids( ){
   /* intentionally left blank */
}

tVoid spm_tclClientHandlerBase::vOnServiceStateAvailable( ){
}

tVoid spm_tclClientHandlerBase::vOnFirstServiceStateAvailable( ){
}

tBool spm_tclClientHandlerBase::bRegisterServices( tU32 u32AppId ){
   if ( _u16AppId == u32AppId ){
      if ( 0 == _u16RegID ){
         amt_tclServiceRegister oService( CCA_C_U16_APP_SPM,
                                          _u16AppId,
                                          _u16SrvId,
                                          _u16MajorVersion,
                                          _u16MinorVersion );
         if ( _poclCcaMsgHandler != NULL ){
            return( _poclCcaMsgHandler->bPostMessage( &oService ) );
         }
      }
   }
   return( FALSE ); // nothing registered
}

tBool spm_tclClientHandlerBase::bUnRegisterServices( tU16 u16AppId ){
   (void)u16AppId; // currently not used
   // create a new message object
   amt_tclServiceUnregister oMessageServiceUnregister( CCA_C_U16_APP_SPM, _u16AppId, _u16SrvId, _u16RegID );

   if ( oMessageServiceUnregister.bIsValid( ) ){
      if ( _poclCcaMsgHandler != NULL ){
         if ( !_poclCcaMsgHandler->bPostMessage( &oMessageServiceUnregister ) ){
            oMessageServiceUnregister.bDelete( );
            return( FALSE );
         } else {
            return( TRUE );
         }
      }
   }
   return( FALSE );
} // bUnRegisterServices

tVoid spm_tclClientHandlerBase::vHandleServiceStatus( const amt_tclServiceStatus *poSrvStatus ){
   if ( _u16SrvId == poSrvStatus->u16GetServiceID( ) ){
      tU8 t = _u8SrvState;

      _u16RegID   = poSrvStatus->u16GetRegisterID( );

      _u8SrvState = poSrvStatus->u8GetServiceState( );

      if ( _u8SrvState == AMT_C_U8_SVCSTATE_AVAILABLE ){
         vRegisterFids( );
         if ( !_bUpregSend ){
            _bUpregSend = TRUE;
            vOnFirstServiceStateAvailable( );
         }
      }

      if ( ( _u8SrvState == AMT_C_U8_SVCSTATE_AVAILABLE ) && ( t != _u8SrvState ) ){
         // change from unavailable to available just happen
         vOnServiceStateAvailable( );
      }
   }
} // vHandleServiceStatus

tBool spm_tclClientHandlerBase::bOnServiceDataMessage( amt_tclServiceData *poSrvData ){
   if ( _u16SrvId == poSrvData->u16GetServiceID( ) ){
      tU8 u8OpCode = poSrvData->u8GetOpCode( );

      if ( poSrvData->u16GetCmdCounter( ) == U16_SPM_UPREG_COMMAND_COUNTER ){
         if ( u8OpCode == AMT_C_U8_CCAMSG_OPCODE_STATUS ){
            vUpRegStatusChange( poSrvData->u16GetFunctionID( ), TRUE );
         } else if ( u8OpCode == AMT_C_U8_CCAMSG_OPCODE_ERROR ){
            ETG_TRACE_ERRMEM( ( "spm_tclClientHandlerBase::bOnServiceDataMessage() received AMT_C_U8_CCAMSG_OPCODE_ERROR for Fid=%X _u16SrvId=%X", poSrvData->u16GetFunctionID( ), _u16SrvId ) );
            vUpRegStatusChange( poSrvData->u16GetFunctionID( ), FALSE );
         }
      }

      vDispatchMessage( poSrvData );
      return( TRUE );
   }
   return( FALSE );
} // bOnServiceDataMessage

tVoid spm_tclClientHandlerBase::vHandleServiceConfirmation( const amt_tclServiceRegisterConf *poSrvConf ){
   if ( _u16SrvId == poSrvConf->u16GetServiceID( ) ){
      _u16RegID = poSrvConf->u16GetServiceID( );
   }
}

tVoid spm_tclClientHandlerBase::vOnUnknownMessage( amt_tclBaseMessage *poMessage ){
   (tVoid)poMessage;
   ETG_TRACE_COMP( ( "!!!!!!!!!!!!!  HANDLE UNKNOWN SERVICE DATA MESSAGE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!" ) );
}

