/*!
  * \file  spm_LocalApplicationManager_trace.cpp
  *  \brief
  *    Method definitions for testing via trace purposes.
  *               This list is generated.
  *
  *  \note
  *  PROJECT: NextGen
  *  SW-COMPONENT: FC SPM
  *  COPYRIGHT:    (C) 2013 - 2020 Robert Bosch GmbH, Hildesheim

  *  The reproduction, distribution and utilization of this file as
  *  well as the communication of its contents to others without express
  *  authorization is prohibited. Offenders will be held liable for the
  *  payment of damages. All rights reserved in the event of the grant
  *  of a patent, utility model or design.
  *
  ******
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"

#define ETG_S_IMPORT_INTERFACE_GENERIC
#include "etg_if.h"

#include "spm_Config.h"

// Trace specific includes can be put here
// spm_tclLocalApplicationManager_include_ext: user specific code start
// my class header
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"
// spm_tclLocalApplicationManager_include_ext: user specific code end


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS SPM_TRACE_CLASS_SPM
#include "trcGenProj/Header/spm_LocalApplicationManager_trace.cpp.trc.h"
#endif

// has to come after etg include because redefinition of macros takes place
// to meet special spm requirements of blocking early spm traces
#include "spm_trace.h"

// Spm trace specific code can be put here
// spm_tclLocalApplicationManager_include_spm: user specific code start
#include "spm_LocalApplicationManagerConfig.h"
#include "spm_CcaMsgHandler.h"
#include "spm_factory.h"
// spm_tclLocalApplicationManager_include_spm: user specific code end


tVoid spm_tclLocalApplicationManager::vHandleTraceMessage(const tUChar *puchData){
/*!
  * \fn
  *  \brief
  *    Interface function for the tracechannel.
  *
  *  \param[in]
  *    puchData - Trace command data.
  ******
  */
   tU32 u32MsgCode = ( puchData[1] << 8 ) | puchData[2];

   switch (u32MsgCode){

      case SPM_GETAPPLICATIONLIST:
      {

         // GetApplicationList: user specific code start
         vTraceApplicationsInfo();
         // GetApplicationList: user specific code end
      }
      break;

      case SPM_SPMGETAPPINFO:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);

         // SpmGetAppInfo: user specific code start
         vTraceApplicationInfo(param1); // u32AppId
         // SpmGetAppInfo: user specific code end
      }
      break;

      case SPM_SPMSWBLOCKSINFO:
      {

         // SpmSwBlocksInfo: user specific code start
         vTraceSwBlocksInfo();
         // SpmSwBlocksInfo: user specific code end
      }
      break;

      case SPM_SPMSWBLOCKINFO:
      {
         const tChar* pString1 = (const tChar*)&puchData[3];

         // SpmSwBlockInfo: user specific code start
         vTraceSwBlockInfo(pString1);
         // SpmSwBlockInfo: user specific code end
      }
      break;

      case SPM_SPMSETALTERNATIVEAPPLICATIONCONFIGURATION:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         tU32 param2 = (tU32)((puchData[7]<<24) | (puchData[8]<<16) | (puchData[9]<<8) | puchData[10]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSetAlternativeApplicationConfiguration' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmSetAlternativeApplicationConfiguration: user specific code start
         vSetAlternativeApplicationConfiguration(param1, param2);
         // SpmSetAlternativeApplicationConfiguration: user specific code end
      }
      break;

      case SPM_SPMBLOCKAPPREQ:
      {
         tU32 param1 = (tU32)((puchData[3]<<24) | (puchData[4]<<16) | (puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmBlockAppReq' was called: param1 = 0x%x", param1 ) );

         // SpmBlockAppReq: user specific code start
         _u32AppToBlock = param1;
         // SpmBlockAppReq: user specific code end
      }
      break;

      case SPM_SPMTRIGGERAPPLICATIONCONFIGURATION:
      {
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTriggerApplicationConfiguration' was called" ) );

         // SpmTriggerApplicationConfiguration: user specific code start
         bSetAllSwBlocksToNonBlockMode();
         bSetAllApplicationsInProfile();
         // SpmTriggerApplicationConfiguration: user specific code end
      }
      break;

      case SPM_SPMTESTQUEUEFULL:
      {
         // Test to simulate message queue full.
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTestQueueFull' was called: param1 = 0x%x, param2 = 0x%x", param1, param2 ) );

         // SpmTestQueueFull: user specific code start
         ETG_TRACE_USR4( ( "SPM_TRACE_TEST_QUEUE_FULL called with %d,%d", param1, param2 ) );
         bHandleAppQueueFull( (tU16)param1, (tU16)param2);
         // SpmTestQueueFull: user specific code end
      }
      break;

      case SPM_SPMTESTFILLCCASHAREDMSGBUFFER:
      {
         // Fill SharedMemory of CCA to test the error handling.
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmTestFillCcaSharedMsgBuffer' was called" ) );

         // SpmTestFillCcaSharedMsgBuffer: user specific code start
         // write useless stuff into CCA-MsgQueue till it is full
         // then call LocalAppManager->PostMessage to check error handling

         // fill fast with huge messages
         OSAL_trMessage       oTestMsg;
         while(OSAL_OK == OSAL_s32MessageCreate(&oTestMsg, 4096, OSAL_EN_MEMORY_SHARED) ){
         }

         // fill now also the reset till the powermessage does not fit.
         amt_tclPowerMessage *oTestPowerMsg;
         do {
            oTestPowerMsg = new amt_tclPowerMessage(CCA_C_U16_APP_SPM,
                                                    CCA_C_U16_APP_SPM,
                                                    AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ,
                                                    0,
                                                    0);
         } while ( ( oTestPowerMsg != NULL ) && ( oTestPowerMsg->u16GetPowerType() == AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ ) );
         // now that the shared memory is full, check the error handling
         vPostPowerMessage(CCA_C_U16_APP_SPM, AMT_C_U16_PWR_PROXY_STATE_CHANGE_REQ, 0, 0);
         delete oTestPowerMsg;
         // SpmTestFillCcaSharedMsgBuffer: user specific code end
      }
      break;

      case SPM_SPMSENDPOWERMESSAGE:
      {
         // Send a power message to a dedicated client application. Parameters = u16TargetID, u16PowerType, u32PowerData1, u32PowerData2
         tU16 param1 = (tU16)((puchData[3]<<8) | puchData[4]);
         tU16 param2 = (tU16)((puchData[5]<<8) | puchData[6]);
         tU32 param3 = (tU32)((puchData[7]<<24) | (puchData[8]<<16) | (puchData[9]<<8) | puchData[10]);
         tU32 param4 = (tU32)((puchData[11]<<24) | (puchData[12]<<16) | (puchData[13]<<8) | puchData[14]);
         ETG_TRACE_ERRMEM( ( "SPM command 'SpmSendPowerMessage' was called: param1 = 0x%x, param2 = 0x%x, param3 = 0x%x, param4 = 0x%x", param1, param2, param3, param4 ) );

         // SpmSendPowerMessage: user specific code start
         vPostPowerMessage(param1, param2, param3, param4);
         // SpmSendPowerMessage: user specific code end
      }
      break;

      default:
         //nothing to do
         break;
   } //lint !e764: switch statement possibly does not have a case --> generated trace command function
     // spm_tclLocalApplicationManagerFunction: user specific code start
     // spm_tclLocalApplicationManagerFunction: user specific code end

   return;
} // vHandleTraceMessage

// Trace specific code can be put here
// spm_tclLocalApplicationManagerFile: user specific code start
// spm_tclLocalApplicationManagerFile: user specific code end

