/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_LocalApplicationManagerConfig.h
  * @brief        This is header file contains functions for LocalApplicationManagerConfig.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_LocalApplicationManager.h"

class ISpmCcaServiceServer;


/*!
  *  \class spm_tclLocalApplicationManagerConfig
  *  \brief This class handles incoming power message and do check/kill operation on software blocks like NAVAPP, DAPIAPP and MAP.

        It uses class spm_tclCcaServiceHandlerConfig for update property.

          The spm_tclFactory object creates an instance of this class.

          This class is used by class spm_tclApplicationRequestSupervisorv to Check unacknowledged states of application.
  */
class spm_tclLocalApplicationManagerConfig : public spm_tclLocalApplicationManager
{
private:
tBool          _bNaviConnected;
tBool          _bDapiConnected;
tBool          _bMapConnected;
tBool          _bStartupEjectProcessed;
TSpmSwBlockSet _oStartUpForcedState;
tBool          _bAllowedToDump;

public:
spm_tclLocalApplicationManagerConfig( const ISpmFactory& factory,
                                      tU32               u32AppId,
                                      tU8                u8LamConfigID = 0 );
virtual ~spm_tclLocalApplicationManagerConfig( );

// implementation of interface ISpmDbClient
virtual tVoid vOnCheckForSwBlocksToKill( tU32 u32AppId );

virtual tVoid vOnKill( );

virtual tVoid vOnKillAllSwBlockApplications( tU32 u32AppId );

virtual tVoid vOnWholeSwBlockIsLoaded( const std::string& strSwBlockName );

virtual tVoid vOnWholeSwBlockIsConnected( const std::string& strSwBlockName );

virtual tVoid vOnWholeSwBlockIsInRequestedState( const std::string& strSwBlockName );

virtual tVoid vOnWholeSwBlockIsInForcedState( const std::string& strSwBlockName );

virtual tVoid vOnSetAllApplicationsToProfile( tU32  u32AppId,
                                              tU32  u32AppStateRequest,
                                              tBool bBlockmode );

virtual tVoid vOnSendUpdate( tU32  u32AppId,
                             tU32  u32RequestedState,
                             tU32  u32AppStateRequest,
                             tU32  u32AppStateNewRequest,
                             tBool bBlockmode );

virtual tVoid vOnForceAllApplicationsToProfile( tU32  u32AppId,
                                                tU32  u32NewAppState,
                                                tU32  u32AppStateRequest,
                                                tBool bBlockmode );

virtual tVoid vOnCheckRequests( tU32& u32ActiveRequests );

virtual tVoid vOnUnacknowledgeState( spm_tclConnectedApp& app );

virtual tVoid vOnSendImmediateStateChange( spm_tclConnectedApp& app );

virtual tVoid vOnTerminateMissing( spm_tclConnectedApp& app );

virtual tVoid vOnWatchdogError( spm_tclConnectedApp& app );

virtual tVoid vOnWatchdogErrorNotifyProblemReport( spm_tclConnectedApp& app );

virtual tVoid vOnWatchdogErrorNotifyProblemReportNew( spm_tclConnectedApp& app );

virtual tVoid vOnSendCriticalVoltageEvent( spm_tclConnectedApp& app,
                                           tU32                 u32Cvm );

virtual tVoid vOnTraceApplicationInfo( spm_tclConnectedApp& app );

virtual tVoid vOnTraceSwBlock( spm_tclSoftwareBlock& sb );

virtual tVoid vOnTraceSwBlockInfo( spm_tclSoftwareBlock& sb );


virtual tVoid vAddClient( ISpmSwBlockClient *clt );

virtual tVoid vRemoveClient( ISpmSwBlockClient *clt );

// used from base class -> virtual tVoid vHandleTraceMessage(const tUChar* puchData);

tU32 u32GetClientListSize( ) const { return( (tU32)_clients.size( ) ); }

protected:
// ISpmBase interface functions
virtual tVoid vGetReferences( );

// used from base class -> virtual tVoid vStartCommunication();
virtual const tChar*getName( ) const { return( "spm_tclLocalApplicationManagerConfig" ); }

virtual tVoid vOnSetAlternativeApplicationConfiguration( tU32 u32SystemState,
                                                         tU32 u32Configuration );

std::set < ISpmSwBlockClient* > _clients;
virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args );

tBool                           fOverTempActive;

ISpmCcaServiceServer           *_poclCcaServiceHandler;

};

