/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ILocalAppManager.h
  * @brief        This is header file contains interfaces to handle software blocks states, to get culprit application info,
  *               to handle application start request, application ends with success, application ends with failure and application queue is full.
  * @copyright    (C) 2012 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_ISwBlock.h"
#include "spm_IWorkerClient.h"
#include "spm_IDbClient.h"

#define SPM_U32_ADAPTER_APP  ( (tU32)0x00000001 )
#define SPM_U32_ADAPTER_DEV  ( (tU32)0x00000002 )
#define SPM_U32_ADAPTER_CAL  ( (tU32)0x00000003 )

#include <string>


/*!
  *  \class ISpmLocalAppManager
  *  \brief This abstract class provides interfaces to handle software blocks states.
          And It also delivers pure virtual functions to handle application start request,
        application ends with success , application ends with failure and application queue is full.
        It also supplies interfaces to get culprit application ID, requested application state and uninitialized application state.

  */

class ISpmLocalAppManager : public ISpmDbClient
   , public ISpmWorkerClient
   , public ISpmSwBlockServer
{
// protected:

public:
ISpmLocalAppManager( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmLocalAppManager( ){
}

public:
virtual tBool bCheckRequests( tU32& u32ActiveRequests )                 = 0;

virtual tVoid vUnacknowledgedApplicationState( )                        = 0;

virtual tBool bAllApplicationsUpAndRunning( tU32& u32AppId )            = 0;

virtual tU32  u32GetParentId( )                                         = 0;

virtual tBool bKillAllApplications( )                                   = 0;

virtual tVoid vKillSoftwareBlock( const std::string& name )             = 0;

virtual tVoid vKillSoftwareBlocksOfProcess( const std::string& name )   = 0;

virtual tBool bForceSoftwareBlock( const std::string& name,
                                   tU32               u32AppState )     = 0;

virtual tBool bAllRequestsProcessed( )                                  = 0;

virtual tBool bSetAllApplicationsInProfile( )                           = 0;

virtual tBool bForceAllApplicationsToProfile( tU32  u32Profile,
                                              tBool bForceAll = FALSE ) = 0;

virtual tVoid vHandleApplicationEndFailureTimeout( )                    = 0;

virtual tVoid vCheckForSwBlocksToKill( )                                = 0;

virtual tU32  u32GetCurrentAppState( tU32 u32AppId )                    = 0;

virtual tVoid vCheckForUnacknowledgedState( tU32& u32ActiveRequests )   = 0;

virtual tBool bSetAllSwBlocksToNonBlockMode( )                          = 0;

virtual tBool bHandleAppStartReq( const tU32 u32SourceAppID )           = 0;

virtual tBool bHandleAppInitialized( const tU32 u32SourceAppID )        = 0;

virtual tBool bHandleAppStateChangeAck( const tU32 u32SourceAppID,
                                        const tU32 u32ChangedState,
                                        const tU32 u32TimeExtension )   = 0;

virtual tBool bHandleAppEndSuccess( const tU32 u32SourceAppID )         = 0;

virtual tBool bHandleAppEndFailure( const tU32 u32SourceAppID,
                                    const tU32 u32ErrorType )           = 0;

virtual tBool bHandleAppQueueFull( tU32 u32SourceAppID,
                                   tU32 u32TargetAppId )                = 0;

virtual tBool bHandleSvmAppRegister( const tU32 u32SourceAppID,
                                     const tU32 u32RegRecFlags,
                                     const tU32 u32NotifyInterval )     = 0;

virtual tBool bHandleSvmAppNotify( const tU32 u32SourceAppID )          = 0;

virtual tBool bHandleSvmAppUnRegister( const tU32 u32SourceAppID )      = 0;

virtual tBool bHandleSvmAppNotifyProblemResponse( tU32 u32SourceAppID,
                                                  tU32 u32AppState )    = 0;

virtual tBool bCheckLifeSignals( )                                      = 0;

virtual tVoid vWatchdogError( )                                         = 0;

virtual tU32  u32GetCulpritAppID( ) const                               = 0;

virtual tU32  u32GetRequestedAppState( tU32 u32AppId )                  = 0;

virtual tU32  u32GetUninitializedAppState( tU32 u32AppId )              = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmLocalAppManager" ); }
};

