/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IGlobalApplicationManager.h
  * @brief        This is header file contains interfaces to add new local application manager,
  *                   to trigger new application state and to force intermediate state.
  * @copyright    (C) 2012 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <map>

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

#include "spm_IWorkerClient.h"
// for type "TTriggerMsg"
#include "spm_SubStateDefines.h"

class ISpmLocalAppManager;

/*!
  *  \class ISpmGlobalApplicationManager
  *  \brief This abstract class provides interfaces to handle applications states. This class also supplies interfaces to add
          new local application manager, to trigger new application state and to force intermediate state .
  */
class ISpmGlobalApplicationManager : public ISpmWorkerClient
{
public:
ISpmGlobalApplicationManager( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmGlobalApplicationManager( ){ }

// trace support for this class instance
virtual tVoid vHandleTraceMessage( const tUChar *puchData )                          = 0;

virtual tVoid vGetReferences( )                                                      = 0;

virtual tVoid vStartCommunication( )                                                 = 0;

virtual tBool bShutdownApplications( )                                               = 0;

virtual tVoid vNewSystemStateReached( tU32 u32LamId )                                = 0;

virtual tBool bProcessSystemState( tU32 u32NewSystemState,
                                   tU32 u32SystemStateReached = SPM_SYSTEM_INVALID ) = 0;

virtual tVoid vForceIntermediateState( tU32  u32Profile,
                                       tBool bForceAll )                             = 0;

virtual tVoid vTriggerAppStateChange( TTriggerMsg *tNewTrigger )                     = 0;

virtual tVoid  vTraceRemainingTime( )                                                = 0;

virtual tVoid  vAllSubStatesProcessed( )                                             = 0;

virtual tBool  bAddNewLam( tU32                 u32LamConfigId,
                           ISpmLocalAppManager *poRefLam )                           = 0;

// Implementation of interface ISpmWorkerClient
virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )                                     = 0;

// 715 Info: Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )                                 = 0;

virtual const tChar*getName( ) const                                                 = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmGlobalApplicationManager" ); }
};

