/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IDbClient.h
  * @brief        This is header file contains interfaces for database client.
  * @copyright    (C) 2013 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

class spm_tclConnectedApp;
class spm_tclSoftwareBlock;

/*!
  *  \class ISpmDbClient
  *  \brief This abstract class provides interfaces for database client. This class also delivers pure virtual function handlers for events such as
         set all application to profile , send update, whole software block connected ,whole software block is in request state, send immediate state change and
         send critical voltage events.		 .

  */
class ISpmDbClient
{
public:
virtual ~ISpmDbClient( ){}
virtual tVoid vOnCheckForSwBlocksToKill( tU32 u32AppId )                             = 0;

virtual tVoid vOnKill( )                                                             = 0;

virtual tVoid vOnKillAllSwBlockApplications( tU32 u32AppId )                         = 0;

virtual tVoid vOnWholeSwBlockIsLoaded( const std::string& strSwBlockName )           = 0;

virtual tVoid vOnWholeSwBlockIsConnected( const std::string& strSwBlockName )        = 0;

virtual tVoid vOnWholeSwBlockIsInRequestedState( const std::string& strSwBlockName ) = 0;

virtual tVoid vOnWholeSwBlockIsInForcedState( const std::string& strSwBlockName )    = 0;

virtual tVoid vOnSetAllApplicationsToProfile( tU32  u32AppId,
                                              tU32  u32AppStateRequest,
                                              tBool bBlockmode )                     = 0;

virtual tVoid vOnSendUpdate( tU32  u32AppId,
                             tU32  u32RequestedState,
                             tU32  u32AppStateRequest,
                             tU32  u32AppStateNewRequest,
                             tBool bBlockmode )                                  = 0;

virtual tVoid vOnForceAllApplicationsToProfile( tU32  u32AppId,
                                                tU32  u32NewAppState,
                                                tU32  u32AppStateRequest,
                                                tBool bBlockmode )               = 0;


// event handler for checkrequests
virtual tVoid vOnCheckRequests( tU32& u32ActiveRequests )                        = 0;

virtual tVoid vOnUnacknowledgeState( spm_tclConnectedApp& app )                  = 0;

virtual tVoid vOnSendImmediateStateChange( spm_tclConnectedApp& app )            = 0;

virtual tVoid vOnTerminateMissing( spm_tclConnectedApp& app )                    = 0;

virtual tVoid vOnWatchdogError( spm_tclConnectedApp& app )                       = 0;

virtual tVoid vOnWatchdogErrorNotifyProblemReport( spm_tclConnectedApp& app )    = 0;

virtual tVoid vOnWatchdogErrorNotifyProblemReportNew( spm_tclConnectedApp& app ) = 0;

virtual tVoid vOnSendCriticalVoltageEvent( spm_tclConnectedApp& app,
                                           tU32                 u32Cvm )         = 0;

virtual tVoid vOnTraceApplicationInfo( spm_tclConnectedApp& app )                = 0;

virtual tVoid vOnTraceSwBlock( spm_tclSoftwareBlock& sb )                        = 0;

virtual tVoid vOnTraceSwBlockInfo( spm_tclSoftwareBlock& sb )                    = 0;

};

