/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IApplicationRequestSupervisor.h
  * @brief        This is header file contains interface functions for ApplicationRequestSupervisor.
  * @copyright    (C) 2012 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IWorkerClient.h"

/*!
  *  \class ISpmApplicationRequestSupervisor
  *  \brief This abstract class provides interfaces to supervise every application state request.
          This class delivers pure virtual functions to start supervision and set termination .

  */
class ISpmApplicationRequestSupervisor
   : public ISpmWorkerClient
   , public spm_tclActive
{
public:
ISpmApplicationRequestSupervisor( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmApplicationRequestSupervisor( ){ }
virtual tVoid vStartSupervision( )                          = 0;

virtual tVoid vSetTerminate( )                              = 0;

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData ) = 0;

virtual const tChar*getName( ) const                        = 0;

virtual tVoid vGetReferences( )                             = 0;

virtual tVoid vStartCommunication( )                        = 0;

// overrides from spm_tclActive
virtual tVoid vOnStart( )                                   = 0;

virtual tVoid vOnTerminate( )                               = 0;

virtual tVoid main( )                                       = 0;

// Implementation of interface ISpmWorkerClient
virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )        = 0;

virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )            = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmApplicationRequestSupervisor" ); }
};

