/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IApplicationErrorHandler.h
  * @brief        This is header file contains interface functions for ApplicationErrorHandler.
  * @copyright    (C) 2015 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IWorkerClient.h"
#include "spm_ConnectedApps.h"

/*!
  *  \class ISpmApplicationErrorHandler
  *  \brief This abstract class provides interfaces to supervise every application state request.
          This class delivers pure virtual functions to start supervision and set termination .

  */
class ISpmApplicationErrorHandler
   : public ISpmWorkerClient
   , public spm_tclActive
{
public:
ISpmApplicationErrorHandler( const ISpmFactory& factory ) : ISpmWorkerClient( factory ){ }
virtual ~ISpmApplicationErrorHandler( ){ }

virtual tVoid vStart( const std::string& strName,
                      tU32               u32Prio = 80,
                      tU32               u32Stack = 10000 )                   = 0;

virtual tVoid vStateChangeImmediately( spm_tclConnectedApp app,
                                       tBool               bRestart = FALSE ) = 0;

virtual tVoid vStateChangeFailed( spm_tclConnectedApp app,
                                  tBool               bRestart = FALSE )      = 0;

virtual tVoid vAppEndFailure( spm_tclConnectedApp app,
                              tU32                u32ErrorType,
                              tBool               bRestart = FALSE )          = 0;

virtual tVoid vTerminateChangeFailed( spm_tclConnectedApp app,
                                      tBool               bRestart = FALSE )  = 0;

virtual tVoid vWdgNotifyProblem( spm_tclConnectedApp app,
                                 tBool               bRestart = FALSE )       = 0;

virtual tVoid vMsgQueueFull( spm_tclConnectedApp app,
                             tBool               bSender,
                             tBool               bRestart = FALSE )           = 0;

virtual tVoid vMsgQueueFull( tU32  u32AppId,
                             tBool bSender,
                             tBool bRestart = FALSE )                         = 0;

virtual tVoid vGetUnitFailedList( )                                           = 0;

virtual tVoid vTriggerUnitFailedListReceived( )                               = 0;

virtual tVoid vSetWriteEmptyUnitFailedList( tBool fWriteEmptyUnitLists )      = 0;

virtual tBool fUnitFailedListResultReceived( )                                = 0;

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar *puchData )                   = 0;

virtual const tChar*getName( ) const                                          = 0;

virtual tVoid vGetReferences( )                                               = 0;

virtual tVoid vStartCommunication( )                                          = 0;

// overrides from spm_tclActive
virtual tVoid vOnStart( )                                                     = 0;

virtual tVoid vOnTerminate( )                                                 = 0;

virtual tVoid main( )                                                         = 0;

// Implementation of interface ISpmWorkerClient
virtual tBool bHandleSynchrounousCall( tU32   u32Message,
                                       tVoid *args )                          = 0;

virtual tVoid vHandleMessage( tU32 u32Message,
                              tU32 u32Parm = 0 )                              = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmApplicationErrorHandler" ); }
};

