/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_IApplicationConfiguration.h
  * @brief        This is header file contains interface functions for read Application state configuration, write application state configuration..
  * @copyright    (C) 2012 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "spm_ISpmBase.h"

/*!
  *  \class ISpmApplicationConfiguration
  *  \brief This abstract class provides interfaces for application configuration. This class supplies pure virtual functions for to
          set and get new application state configuration, get new application state and profile of application state
        and get specific supervision configuration.

  */
class ISpmApplicationConfiguration : public ISpmBase
{
protected:
virtual tVoid vSetNewStateConfiguration( tU32               u32SystemState,
                                         const std::string& content )                      = 0;

virtual tVoid vGetSupervisionConfiguration( const std::string          & content,
                                            std::vector < std::string >& processes ) const = 0;

virtual tVoid vSetNewDefaultValue( tU32 u32SystemState,
                                   tU32 u32AppState )                                      = 0;

virtual tVoid vSetDefaultValue( tU32 u32SystemState )                                      = 0;

virtual tU32 u32GetValue( tU32 u32AppId,
                          tU32 u32Offset )                                                 = 0;

virtual tVoid vTraceInfo( tU32 u32SystemState )                                            = 0;

public:
ISpmApplicationConfiguration( const ISpmFactory& factory ) : ISpmBase( factory ){ }
virtual ~ISpmApplicationConfiguration( ){ }

virtual tVoid vStartCommunication( )                                                         = 0;

virtual tVoid vGetReferences( )                                                              = 0;


// trace handling
virtual tVoid vHandleTraceMessage( const tUChar *puchData )                                  = 0;

virtual tU32 u32GetNewAppState( tU32 u32AppId )                                              = 0;

virtual tU32 u32GetProfileAppState( tU32 u32Profile,
                                    tU32 u32AppId )                                          = 0;

virtual tVoid vNewAppInSystem( tU32 u32AppId )                                               = 0;

virtual tVoid vPrintAppInfo( tU32 u32AppId )                                                 = 0;

virtual tVoid vReadStateConfigurations( )                                                    = 0;

virtual tBool bSetSpecificStateConfiguration( tU32 u32SystemState,
                                              tU32 u32Configuration )                        = 0;

// Get a list of processes which should not be supervised during this systemstate
virtual tVoid vGetSpecificSupervisionConfiguration( tU32                         u32SystemState,
                                                    tU32                         u32Configuration,
                                                    std::vector < std::string >& processes ) = 0;


virtual tBool bSetNewAppStateTable( tU32  u32InternAppId,
                                    tU32  u32StateProfile,
                                    tU32  u32AppState,
                                    tBool bTriggerState = FALSE ) = 0;

virtual tVoid vSetDefaultStateTable( tU32 u32SystemState )        = 0;

virtual tVoid vSetValue( tU32 u32AppId,
                         tU32 u32Offset,
                         tU32 u32Value )                          = 0;

virtual const tChar*getName( ) const                              = 0;

virtual const tChar*getInterfaceName( ) const { return( "ISpmApplicationConfiguration" ); }
};

