/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         spm_ApplicationRequestSupervisor.h
  * @brief        This is header file contains functions for ApplicationRequestSupervisor.
  * @copyright    (C) 2012 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#ifndef _SPM_CONFIG_H
   #error spm_Config.h must be included!
#endif

// -----------------------------------------------------------------------------
// includes
// -----------------------------------------------------------------------------
#include "spm_IApplicationRequestSupervisor.h"

class ISpmLocalAppManager;
class ISpmApplicationDatabase;
class ISpmWorkerServer;

/*!
  *  \class spm_tclApplicationRequestSupervisor
  *  \brief This class is used to supervise of application state requests.

          It checks request by spm_tclLocalApplicationManagerConfig.
        It also remembers failed appId and failed state transition

          The spm_tclFactory object creates an instance of this class and spm_tclLocalApplicationManagerConfig
        sends request for acknowledge app state.

          spm_tclLocalApplicationManager uses this class for supervise app state.
  */
class spm_tclApplicationRequestSupervisor
   : public ISpmApplicationRequestSupervisor
{
private:
tBool                    _bThreadIsActive;
tU32                     _u32ActiveRequests;

ISpmLocalAppManager     *_poclLocalAppManager;
ISpmApplicationDatabase *_poclDb;
ISpmWorkerServer        *_poclWorkerServer;

protected:
// ISpmBase interface functions
virtual tVoid vHandleTraceMessage( const tUChar */*puchData*/ ){} //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual const tChar*getName( ) const { return( "spm_tclApplicationRequestSupervisor" ); }
virtual tVoid vStartCommunication( );

virtual tVoid vGetReferences( );

// overrides from spm_tclActive
virtual tVoid vOnStart( ){}
virtual tVoid vOnTerminate( ){}

// Implementation of interface ISpmWorkerClient
virtual tBool bHandleSynchrounousCall( tU32   /*u32Message*/,
                                       tVoid */*args*/ ){ return( FALSE ); } //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used
virtual tVoid vHandleMessage( tU32 /*u32Message*/,
                              tU32 /*u32Parm = 0*/ ){}                       //lint !e715 Symbol 'xxx' not referenced --> CURRENTLY not used

public:
spm_tclApplicationRequestSupervisor( const ISpmFactory& factory );
virtual ~spm_tclApplicationRequestSupervisor( );

virtual tVoid vStartSupervision( );

virtual tVoid vSetTerminate( ){
   spm_tclActive::vSetTerminate( );

   vStartSupervision( );
}

virtual tVoid main( );

};

