#ifndef I_LCMCCADBUSGW_SERVERLCMDBUSFI_H
#define I_LCMCCADBUSGW_SERVERLCMDBUSFI_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Ilcmccadbusgw_Client__CLIENT_NAME__.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmccadbusgateway
  * @Template:     IFrancaStub.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                Franca server interface
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"
#include "asf/stream/MemoryStream.h"

#include "org/bosch/cm/lcm_dbus_fi/lcm_dbus_fi_serviceStub.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcmccadbusgw_AppMain.h"

// Ilcmccadbusgw_ServerLcmDbusFiInclude: user specific code start
// Ilcmccadbusgw_ServerLcmDbusFiInclude: user specific code end

using namespace::asf::core;
using namespace::asf::stream;

class Ilcmccadbusgw_tclServerLcmDbusFi : public lcmccadbusgw_tclBaseIf
{
public:
    Ilcmccadbusgw_tclServerLcmDbusFi(lcmccadbusgw_tclAppMain* poMain) : lcmccadbusgw_tclBaseIf(poMain){;}
    virtual ~Ilcmccadbusgw_tclServerLcmDbusFi(){}

    virtual const tChar* getIfName() const { return( "Ilcmccadbusgw_tclServerLcmDbusFi"); };

    virtual tVoid setSystemStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYSTEM_STATES& SystemState) = 0;
    virtual tVoid setDownloadLockStatesValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_RestrictedDlLock >& DownloadLockStates) = 0;
    virtual tVoid setUpdateLockStatesValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_UpdateLockState >& UpdateLockStates) = 0;
    virtual tVoid setActiveOnOffTriggerValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SubStateType >& ActiveOnOffTrigger) = 0;
    virtual tVoid setSubStatesValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TSubStates& SubStates) = 0;
    virtual tVoid setHistoryTriggerValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_HistoryTrigger >& HistoryTrigger) = 0;
    virtual tVoid setInsertStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_CD_INSERT_STATE& InsertState) = 0;
    virtual tVoid setMediaEjectStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_MEDIA_EJECT_STATE& MediaEjectState) = 0;
    virtual tVoid setPhoneMuteStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_PHONE_MUTE_STATE& PhoneMuteState) = 0;
    virtual tVoid setOnTipperStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_KEY_STATE& OnTipperState) = 0;
    virtual tVoid setIgnitionCyclesValue(const tU32& IgnitionCycles) = 0;
    virtual tVoid setSysPwrModeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYSPWRMODE& SysPwrMode) = 0;
    virtual tVoid setSysPwrSaveModeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_b32_SYSPWRSAVEMODE& SysPwrSaveMode) = 0;
    virtual tVoid setMapDownloadLockStateValue(const tU16& MapDownloadLockState) = 0;
    virtual tVoid setStandbyTimeValue(const tU32& StandbyTime) = 0;
    virtual tVoid setPersitentStandbyTimeValue(const tU32& PersitentStandbyTime) = 0;
    virtual tVoid setIgnitionOffTimeValue(const tU32& IgnitionOffTime) = 0;
    virtual tVoid setDoorOpenTimeValue(const tU32& DoorOpenTime) = 0;
    virtual tVoid setClockDisplayTimeValue(const tU32& ClockDisplayTime) = 0;
    virtual tVoid setSystemStateTimeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TSystemStateTime& SystemStateTime) = 0;
    virtual tVoid setProcessListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_ProcessInfo& ProcessList) = 0;
    virtual tVoid setWakeupReasonValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_WAKEUP_REASON& WakeupReason) = 0;
    virtual tVoid setStartupReasonValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_STARTUP_REASON& StartupReason) = 0;
    virtual tVoid setConnectToBatteryValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TConnectToBattery& ConnectToBattery) = 0;
    virtual tVoid setCodeRequestStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_CODE_REQUEST& CodeRequestState) = 0;
    virtual tVoid setActiveStartUpSyncPointsValue(const ::std::vector< ::std::string >& ActiveStartUpSyncPoints) = 0;
    virtual tVoid setCvmEventValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_CVM_EVENT& CvmEvent) = 0;
    virtual tVoid setUBatSenseValue(const tU16& UBatSense) = 0;
    virtual tVoid setCoproStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_PROCESSOR_STATE& CoproState) = 0;
    virtual tVoid setDevicePowerOnTimeValue(const tU32& DevicePowerOnTime) = 0;
    virtual tVoid setLastSystemRuntimeValue(const tU32& LastSystemRuntime) = 0;
    virtual tVoid setCurrentSystemRuntimeValue(const tU32& CurrentSystemRuntime) = 0;
    virtual tVoid setResetListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TResetList& ResetList) = 0;
    virtual tVoid setResetCounterValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TResetCounter& ResetCounter) = 0;
    virtual tVoid setTransportModeListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_TransPortModeList& TransportModeList) = 0;
    virtual tVoid setResetHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_ResetElement >& ResetHistory) = 0;
    virtual tVoid setWakeupHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_WakeupElement >& WakeupHistory) = 0;
    virtual tVoid setStateHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& StateHistory) = 0;
    virtual tVoid setErrStateHistory01Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory01) = 0;
    virtual tVoid setErrStateHistory02Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory02) = 0;
    virtual tVoid setErrStateHistory03Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory03) = 0;
    virtual tVoid setErrStateHistory04Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory04) = 0;
    virtual tVoid setErrStateHistory05Value(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_StateChangeElement >& ErrStateHistory05) = 0;
    virtual tVoid setSwitchOnHistoryValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SwitchOnElement >& SwitchOnHistory) = 0;
    virtual tVoid setDeviceOnCounterValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TDeviceOnCounter& DeviceOnCounter) = 0;
    virtual tVoid setVoltageEventCounterValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_VoltageEventCounter& VoltageEventCounter) = 0;
    virtual tVoid setVoltageRangeHistogramValue(const ::std::vector< ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_VoltageRange >& VoltageRangeHistogram) = 0;
    virtual tVoid setCpuUsageStatisticValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_SystemStatisticsData& CpuUsageStatistic) = 0;
    virtual tVoid setRamUsageStatisticValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_SystemStatisticsData& RamUsageStatistic) = 0;
    virtual tVoid setStartupTimeStatisticValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_SystemStatisticsData& StartupTimeStatistic) = 0;
    virtual tVoid setRunlevelStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_RUNLEVEL& RunlevelState) = 0;
    virtual tVoid setRestartValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_RESTART_TYPE& Restart) = 0;
    virtual tVoid setLifesignValue(const tU32& Lifesign) = 0;
    virtual tVoid setHmiStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_HMI_STATE& HmiState) = 0;
    virtual tVoid setSystemPowerBehaviourValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYSPWR_BEHAVIOUR& SystemPowerBehaviour) = 0;
    virtual tVoid setDimStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_DIM_STATE& DimState) = 0;
    virtual tVoid setDimmingStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_b32_DIM_STATE& DimmingState) = 0;
    virtual tVoid setBluetoothStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_BT_STATE& BluetoothState) = 0;
    virtual tVoid setAudioStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_AUDIO_STATE& AudioState) = 0;
    virtual tVoid setSpiStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SPI_STATE& SpiState) = 0;
    virtual tVoid setTunerStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_TUNER_STATE& TunerState) = 0;
    virtual tVoid setWifiStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_WIFI_STATE& WifiState) = 0;
    virtual tVoid setOnOffReasonValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_OnOffReason& OnOffReason) = 0;
    virtual tVoid setWakeupListValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TWakeupList& WakeupList) = 0;
    virtual tVoid setStartupFinishedValue(const tBool& StartupFinished) = 0;
    virtual tVoid setSysStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SYS_STATE& SysState) = 0;
    virtual tVoid setMostStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TMostState& MostState) = 0;
    virtual tVoid setMostVersionValue(const ::std::string& MostVersion) = 0;
    virtual tVoid setRVCStateValue(const tBool& RVCState) = 0;
    virtual tVoid setTriggerMostRemoteResetValue(const tU32& TriggerMostRemoteReset) = 0;
    virtual tVoid setPartnumberValue(const tU32& Partnumber) = 0;
    virtual tVoid setPartnumbersValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_PartnumberList& Partnumbers) = 0;
    virtual tVoid setAlphacodeValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::TAlphacode& Alphacode) = 0;
    virtual tVoid setAlphacodesValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_AlphacodeList& Alphacodes) = 0;
    virtual tVoid setManufacturersEnableCounterValue(const tU8& ManufacturersEnableCounter) = 0;
    virtual tVoid setNoCalibrationStateValue(const tBool& NoCalibrationState) = 0;
    virtual tVoid setSecurityCommErrorValue(const tU16& SecurityCommError) = 0;
    virtual tVoid setSecurityMoreThan10VinValue(const tU16& SecurityMoreThan10Vin) = 0;
    virtual tVoid setSecurityInvalidVinValue(const tU16& SecurityInvalidVin) = 0;
    virtual tVoid setSecurityCurrentVinValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_Vin& SecurityCurrentVin) = 0;
    virtual tVoid setSecurityVinHistoryValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_VinHistory& SecurityVinHistory) = 0;
    virtual tVoid setVINValue(const ::std::string& VIN) = 0;
    virtual tVoid setSecurityStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_SECURITY_STATE& SecurityState) = 0;
    virtual tVoid setVehicleIDValue(const tU32& VehicleID) = 0;
    virtual tVoid setDisplayVariantValue(const tU32& DisplayVariant) = 0;
    virtual tVoid setReductionLevelValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_REDUCTION_LEVEL& ReductionLevel) = 0;
    virtual tVoid setStartupStateValue(const ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_STARTUP_STATE& StartupState) = 0;
    virtual tVoid setEntertainMuteValue(const tBool& EntertainMute) = 0;
    virtual tVoid setWelcomeAudioStateValue(const tBool& WelcomeAudioState) = 0;
    virtual tVoid setUnballastTimeFromEngineStoppedValue(const tU32& UnballastTimeFromEngineStopped) = 0;
    virtual tVoid setUnballastTimeBeforeUnballastValue(const tU32& UnballastTimeBeforeUnballast) = 0;
    virtual tVoid setUnballastWarningTimeValue(const tU32& UnballastWarningTime) = 0;
    virtual tVoid setDegradedCountValue(const tU32& DegradedCount) = 0;
    virtual tVoid setDegradedTimeValue(const tU32& DegradedTime) = 0;
    virtual tVoid setPhoneHandoverWarnTimeValue(const tU32& PhoneHandoverWarnTime) = 0;

    virtual tVoid sendSystemModeResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendSystemModeErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actSystemModeQueue;

    virtual tVoid sendDownloadLockStateResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendDownloadLockStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actDownloadLockStateQueue;

    virtual tVoid sendUpdateLockResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendUpdateLockErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actUpdateLockQueue;

    virtual tVoid sendOnOffTriggerResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendOnOffTriggerErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actOnOffTriggerQueue;

    virtual tVoid sendStartProcessResp(tS32& s32ReturnValOut, ::std::string& strLocationOut, tU32& u32ProcIdOut, tU32& u32SpawnDurationOut, act_t act = 0) = 0;
    virtual tVoid sendStartProcessErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actStartProcessQueue;

    virtual tVoid sendStopProcessResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendStopProcessErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actStopProcessQueue;

    virtual tVoid sendRestartProcessResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendRestartProcessErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actRestartProcessQueue;

    virtual tVoid sendStartUpSyncPointReachedResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendStartUpSyncPointReachedErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actStartUpSyncPointReachedQueue;

    virtual tVoid sendClearListResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendClearListErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actClearListQueue;

    virtual tVoid sendRestartSystemResp(::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_MRESULT& e32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendRestartSystemErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actRestartSystemQueue;

    virtual tVoid sendAudioSourceChangeResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendAudioSourceChangeErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actAudioSourceChangeQueue;

    virtual tVoid sendChangeBluetoothStateResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendChangeBluetoothStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actChangeBluetoothStateQueue;

    virtual tVoid sendChangeAudioStateResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendChangeAudioStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actChangeAudioStateQueue;

    virtual tVoid sendChangeSpiStateResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendChangeSpiStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actChangeSpiStateQueue;

    virtual tVoid sendChangeTunerStateResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendChangeTunerStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actChangeTunerStateQueue;

    virtual tVoid sendChangeWifiStateResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendChangeWifiStateErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actChangeWifiStateQueue;

    virtual tVoid sendShutdownAndTerminateCcaAppsResp(tS32& s32ResOut, act_t act = 0) = 0;
    virtual tVoid sendShutdownAndTerminateCcaAppsErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actShutdownAndTerminateCcaAppsQueue;

    virtual tVoid sendSetFactorySettingsNewResp(::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_e8_DiaglogDefsetType& DefSetStateGroupOut, ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_e8_DefSetMode& DefSetStateModeOut, tBool& DefSetStateSuccessfulOut, tU16& DefSetStateFirstDifferentParameterIdOut, act_t act = 0) = 0;
    virtual tVoid sendSetFactorySettingsNewErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actSetFactorySettingsNewQueue;

    virtual tVoid sendClearVINResp(tU32& ResultOut, act_t act = 0) = 0;
    virtual tVoid sendClearVINErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actClearVINQueue;

    virtual tVoid sendPrepareDownloadResp(tU32& ResultOut, act_t act = 0) = 0;
    virtual tVoid sendPrepareDownloadErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actPrepareDownloadQueue;

    virtual tVoid sendEndDownloadResp(tU32& ResultOut, act_t act = 0) = 0;
    virtual tVoid sendEndDownloadErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actEndDownloadQueue;

    virtual tVoid sendSetOnConfigurationResp(tU32& ResultOut, act_t act = 0) = 0;
    virtual tVoid sendSetOnConfigurationErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actSetOnConfigurationQueue;

    virtual tVoid sendSetProcessConfigurationResp(tU32& ResultOut, act_t act = 0) = 0;
    virtual tVoid sendSetProcessConfigurationErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actSetProcessConfigurationQueue;

    virtual tVoid sendEntertainDeMuteResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendEntertainDeMuteErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actEntertainDeMuteQueue;

    virtual tVoid sendEntertainMuteRequestResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendEntertainMuteRequestErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actEntertainMuteRequestQueue;

    virtual tVoid sendWelcomeAudioActivationResp(tS32& s32ReturnValOut, act_t act = 0) = 0;
    virtual tVoid sendWelcomeAudioActivationErr (const std::string &errorName, const std::string &errorMessage, act_t act = 0) = 0;
    std::queue<act_t> actWelcomeAudioActivationQueue;


// Ilcmccadbusgw_ServerLcmDbusFiDeclarationsPart: user specific code start
// Ilcmccadbusgw_ServerLcmDbusFiDeclarationsPart: user specific code end

};


#endif // I_LCMCCADBUSGW_SERVERLCMDBUSFI_H

