#ifndef __LCMCCADBUSGW_lcmccadbusgwAsfComponent_H
#define __LCMCCADBUSGW_lcmccadbusgwAsfComponent_H

/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file          lcmccadbusgwAsfComponent.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmccadbusgateway
  * @Template:     AsfClient.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                create the ASF component
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"

#include "asf/stream/MemoryStream.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcmccadbusgw_AppMain.h"

namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmccadbusgw;

    void vProxyStarter(lcmccadbusgw_tclAppMain *poServer);

    class CcaSrvProxy;

    class LcmccadbusgwAsfComponent : public BaseComponent
    {
    private:
        lcmccadbusgw_tclAppMain  *_poCcaServer;
        CcaSrvProxy           *_poCcaSrvProxy;

        DECLARE_CLASS_LOGGER();

    public:
        LcmccadbusgwAsfComponent();
        virtual ~LcmccadbusgwAsfComponent();
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

#endif // ifndef __LCMCCADBUSGW_lcmccadbusgwAsfComponent_H
