#ifndef LCMCCADBUSGWCCA_SRV_PROXY_H
#define LCMCCADBUSGWCCA_SRV_PROXY_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          CcaSrvProxy.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmccadbusgateway
  * @Template:     CcaSrvProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA server
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/cca/CcaServerHookStub.h"

#include "asf/stream/MemoryStream.h"

#include "ICcaSrvProxy.h"

class lcmccadbusgw_tclAppMain;

class _tclBaseStreamMessage : public amt_tclBaseMessage
{
public:
    _tclBaseStreamMessage (tU8 *pStreamData){
        tU32 u32Size = * ( (tU32*)( pStreamData + AMT_C_U32_BASEMSG_SIZE ) ); //lint !e826 Suspicious pointer-to-pointer conversion (area too small)

        vSetDynMsgSize(0);
        vAddDynMsgSize(u32Size);

        // Allocate in Shared Memory
        bAllocateMessage();

        vSetStreamU8(0, pStreamData, u32Size, u32Size);
    }

};

namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::asf::cca::CcaServerHook;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmccadbusgw;

    // lcmccadbusgw_Server__SERVER_NAME__NameSpace: user specific code start
    // lcmccadbusgw_Server__SERVER_NAME__NameSpace: user specific code end

    class CcaSrvProxy : public ICcaSrvProxy
        // , CCA stub
        , private CcaServerHookStub
    {
    private:
        DECLARE_CLASS_LOGGER();
        lcmccadbusgw_tclAppMain* _poMainRef;
    public:
        CcaSrvProxy(lcmccadbusgw_tclAppMain* baseRef);
        virtual ~CcaSrvProxy();

        virtual void onCcaMessage(const::boost::shared_ptr <asf::core::Blob>& request);

        virtual const tChar* getName() const { return "CcaSrvProxy"; }

        virtual tVoid vHandleMessage(lcmccadbusgw_tclBaseIf::TMsg* /*pMsg*/) {}
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
        virtual tVoid vGetReferences() {}
        virtual tVoid vStartCommunication() {}
        virtual tVoid vTraceInfo() {}

    };

} } } } // namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

#endif // ifndef LCMCCADBUSGWCCA_SRV_PROXY_H
