
#ifndef _LCMCCADBUSGW_CLIENTSPM_H
#define _LCMCCADBUSGW_CLIENTSPM_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          lcmccadbusgw_ClientSpm.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmccadbusgateway
  * @Template:     CcaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA client
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"

#include "SPM_CORE_FIProxy.h"

#include "asf/stream/MemoryStream.h"

#include "Ilcmccadbusgw_ClientSpm.h"

// lcmccadbusgw_ClientSpmInclude: user specific code start
// lcmccadbusgw_ClientSpmInclude: user specific code end

namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

    using namespace::asf::core;
    using namespace::asf::stream;
    using namespace::SPM_CORE_FI;
    using namespace::asf::core;
    using namespace::org::bosch::cm::lcmccadbusgw;

    // lcmccadbusgw_Server__SERVER_NAME__NameSpace: user specific code start
    // lcmccadbusgw_Server__SERVER_NAME__NameSpace: user specific code end

    class lcmccadbusgw_tclClientSpm : public Ilcmccadbusgw_tclClientSpm
        , public ServiceAvailableIF
        , public SystemStateCallbackIF
        , public DownloadLockStatesCallbackIF
        , public UpdateLockStatesCallbackIF
        , public ActiveOnOffTriggerCallbackIF
        , public SubStatesCallbackIF
        , public HistoryTriggerCallbackIF
        , public InsertStateCallbackIF
        , public MediaEjectStateCallbackIF
        , public PhoneMuteStateCallbackIF
        , public OnTipperStateCallbackIF
        , public IgnitionCyclesCallbackIF
        , public SysPwrModeCallbackIF
        , public SysPwrSaveModeCallbackIF
        , public MapDownloadLockStateCallbackIF
        , public StandbyTimeCallbackIF
        , public PersitentStandbyTimeCallbackIF
        , public IgnitionOffTimeCallbackIF
        , public DoorOpenTimeCallbackIF
        , public ClockDisplayTimeCallbackIF
        , public SystemStateTimeCallbackIF
        , public ProcessListCallbackIF
        , public WakeupReasonCallbackIF
        , public StartupReasonCallbackIF
        , public ConnectToBatteryCallbackIF
        , public CodeRequestStateCallbackIF
        , public ActiveStartUpSyncPointsCallbackIF
        , public CvmEventCallbackIF
        , public UBatSenseCallbackIF
        , public CoproStateCallbackIF
        , public DevicePowerOnTimeCallbackIF
        , public LastSystemRuntimeCallbackIF
        , public CurrentSystemRuntimeCallbackIF
        , public ResetListCallbackIF
        , public ResetCounterCallbackIF
        , public TransportModeListCallbackIF
        , public ResetHistoryCallbackIF
        , public WakeupHistoryCallbackIF
        , public StateHistoryCallbackIF
        , public ErrStateHistory01CallbackIF
        , public ErrStateHistory02CallbackIF
        , public ErrStateHistory03CallbackIF
        , public ErrStateHistory04CallbackIF
        , public ErrStateHistory05CallbackIF
        , public SwitchOnHistoryCallbackIF
        , public DeviceOnCounterCallbackIF
        , public VoltageEventCounterCallbackIF
        , public VoltageRangeHistogramCallbackIF
        , public CpuUsageStatisticCallbackIF
        , public RamUsageStatisticCallbackIF
        , public StartupTimeStatisticCallbackIF
        , public RunlevelStateCallbackIF
        , public RestartCallbackIF
        , public LifesignCallbackIF
        , public HmiStateCallbackIF
        , public SystemPowerBehaviourCallbackIF
        , public DimStateCallbackIF
        , public DimmingStateCallbackIF
        , public BluetoothStateCallbackIF
        , public AudioStateCallbackIF
        , public SpiStateCallbackIF
        , public TunerStateCallbackIF
        , public WifiStateCallbackIF
        , public OnOffReasonCallbackIF
        , public WakeupListCallbackIF
        , public StartupFinishedCallbackIF
        , public SysStateCallbackIF
        , public MostStateCallbackIF
        , public MostVersionCallbackIF
        , public RVCStateCallbackIF
        , public TriggerMostRemoteResetCallbackIF
        , public PartnumberCallbackIF
        , public PartnumbersCallbackIF
        , public AlphacodeCallbackIF
        , public AlphacodesCallbackIF
        , public ManufacturersEnableCounterCallbackIF
        , public NoCalibrationStateCallbackIF
        , public SecurityCommErrorCallbackIF
        , public SecurityMoreThan10VinCallbackIF
        , public SecurityInvalidVinCallbackIF
        , public SecurityCurrentVinCallbackIF
        , public SecurityVinHistoryCallbackIF
        , public VINCallbackIF
        , public SecurityStateCallbackIF
        , public VehicleIDCallbackIF
        , public DisplayVariantCallbackIF
        , public ReductionLevelCallbackIF
        , public StartupStateCallbackIF
        , public EntertainMuteCallbackIF
        , public WelcomeAudioStateCallbackIF
        , public UnballastTimeFromEngineStoppedCallbackIF
        , public UnballastTimeBeforeUnballastCallbackIF
        , public UnballastWarningTimeCallbackIF
        , public DegradedCountCallbackIF
        , public DegradedTimeCallbackIF
        , public PhoneHandoverWarnTimeCallbackIF
        , public SystemModeCallbackIF
        , public DownloadLockStateCallbackIF
        , public UpdateLockCallbackIF
        , public OnOffTriggerCallbackIF
        , public StartProcessCallbackIF
        , public StopProcessCallbackIF
        , public RestartProcessCallbackIF
        , public StartUpSyncPointReachedCallbackIF
        , public ClearListCallbackIF
        , public RestartSystemCallbackIF
        , public AudioSourceChangeCallbackIF
        , public ChangeBluetoothStateCallbackIF
        , public ChangeAudioStateCallbackIF
        , public ChangeSpiStateCallbackIF
        , public ChangeTunerStateCallbackIF
        , public ChangeWifiStateCallbackIF
        , public ShutdownAndTerminateCcaAppsCallbackIF
        , public SetFactorySettingsNewCallbackIF
        , public ClearVINCallbackIF
        , public PrepareDownloadCallbackIF
        , public EndDownloadCallbackIF
        , public SetOnConfigurationCallbackIF
        , public SetProcessConfigurationCallbackIF
        , public EntertainDeMuteCallbackIF
        , public EntertainMuteRequestCallbackIF
        , public WelcomeAudioActivationCallbackIF
    {
    private:
        DECLARE_CLASS_LOGGER();

        tBool _bSrvAvailable;

    public:
        lcmccadbusgw_tclClientSpm(lcmccadbusgw_tclAppMain* baseRef);
        virtual ~lcmccadbusgw_tclClientSpm();

        // ServiceAvailableIF
        virtual void onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        virtual void onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange);

        // SystemStateCallbackIF
        virtual void onSystemStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemStateError >& error);
        virtual void onSystemStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemStateStatus >& status);

        // DownloadLockStatesCallbackIF
        virtual void onDownloadLockStatesError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DownloadLockStatesError >& error);
        virtual void onDownloadLockStatesStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DownloadLockStatesStatus >& status);

        // UpdateLockStatesCallbackIF
        virtual void onUpdateLockStatesError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UpdateLockStatesError >& error);
        virtual void onUpdateLockStatesStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UpdateLockStatesStatus >& status);

        // ActiveOnOffTriggerCallbackIF
        virtual void onActiveOnOffTriggerError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ActiveOnOffTriggerError >& error);
        virtual void onActiveOnOffTriggerStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ActiveOnOffTriggerStatus >& status);

        // SubStatesCallbackIF
        virtual void onSubStatesError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SubStatesError >& error);
        virtual void onSubStatesStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SubStatesStatus >& status);

        // HistoryTriggerCallbackIF
        virtual void onHistoryTriggerError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< HistoryTriggerError >& error);
        virtual void onHistoryTriggerStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< HistoryTriggerStatus >& status);

        // InsertStateCallbackIF
        virtual void onInsertStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< InsertStateError >& error);
        virtual void onInsertStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< InsertStateStatus >& status);

        // MediaEjectStateCallbackIF
        virtual void onMediaEjectStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MediaEjectStateError >& error);
        virtual void onMediaEjectStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MediaEjectStateStatus >& status);

        // PhoneMuteStateCallbackIF
        virtual void onPhoneMuteStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PhoneMuteStateError >& error);
        virtual void onPhoneMuteStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PhoneMuteStateStatus >& status);

        // OnTipperStateCallbackIF
        virtual void onOnTipperStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< OnTipperStateError >& error);
        virtual void onOnTipperStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< OnTipperStateStatus >& status);

        // IgnitionCyclesCallbackIF
        virtual void onIgnitionCyclesError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< IgnitionCyclesError >& error);
        virtual void onIgnitionCyclesStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< IgnitionCyclesStatus >& status);

        // SysPwrModeCallbackIF
        virtual void onSysPwrModeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeError >& error);
        virtual void onSysPwrModeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrModeStatus >& status);

        // SysPwrSaveModeCallbackIF
        virtual void onSysPwrSaveModeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrSaveModeError >& error);
        virtual void onSysPwrSaveModeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysPwrSaveModeStatus >& status);

        // MapDownloadLockStateCallbackIF
        virtual void onMapDownloadLockStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MapDownloadLockStateError >& error);
        virtual void onMapDownloadLockStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MapDownloadLockStateStatus >& status);

        // StandbyTimeCallbackIF
        virtual void onStandbyTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StandbyTimeError >& error);
        virtual void onStandbyTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StandbyTimeStatus >& status);

        // PersitentStandbyTimeCallbackIF
        virtual void onPersitentStandbyTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PersitentStandbyTimeError >& error);
        virtual void onPersitentStandbyTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PersitentStandbyTimeStatus >& status);

        // IgnitionOffTimeCallbackIF
        virtual void onIgnitionOffTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< IgnitionOffTimeError >& error);
        virtual void onIgnitionOffTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< IgnitionOffTimeStatus >& status);

        // DoorOpenTimeCallbackIF
        virtual void onDoorOpenTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DoorOpenTimeError >& error);
        virtual void onDoorOpenTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DoorOpenTimeStatus >& status);

        // ClockDisplayTimeCallbackIF
        virtual void onClockDisplayTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ClockDisplayTimeError >& error);
        virtual void onClockDisplayTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ClockDisplayTimeStatus >& status);

        // SystemStateTimeCallbackIF
        virtual void onSystemStateTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemStateTimeError >& error);
        virtual void onSystemStateTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemStateTimeStatus >& status);

        // ProcessListCallbackIF
        virtual void onProcessListError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ProcessListError >& error);
        virtual void onProcessListStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ProcessListStatus >& status);

        // WakeupReasonCallbackIF
        virtual void onWakeupReasonError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WakeupReasonError >& error);
        virtual void onWakeupReasonStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WakeupReasonStatus >& status);

        // StartupReasonCallbackIF
        virtual void onStartupReasonError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupReasonError >& error);
        virtual void onStartupReasonStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupReasonStatus >& status);

        // ConnectToBatteryCallbackIF
        virtual void onConnectToBatteryError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ConnectToBatteryError >& error);
        virtual void onConnectToBatteryStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ConnectToBatteryStatus >& status);

        // CodeRequestStateCallbackIF
        virtual void onCodeRequestStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CodeRequestStateError >& error);
        virtual void onCodeRequestStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CodeRequestStateStatus >& status);

        // ActiveStartUpSyncPointsCallbackIF
        virtual void onActiveStartUpSyncPointsError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ActiveStartUpSyncPointsError >& error);
        virtual void onActiveStartUpSyncPointsStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ActiveStartUpSyncPointsStatus >& status);

        // CvmEventCallbackIF
        virtual void onCvmEventError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CvmEventError >& error);
        virtual void onCvmEventStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CvmEventStatus >& status);

        // UBatSenseCallbackIF
        virtual void onUBatSenseError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UBatSenseError >& error);
        virtual void onUBatSenseStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UBatSenseStatus >& status);

        // CoproStateCallbackIF
        virtual void onCoproStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CoproStateError >& error);
        virtual void onCoproStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CoproStateStatus >& status);

        // DevicePowerOnTimeCallbackIF
        virtual void onDevicePowerOnTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DevicePowerOnTimeError >& error);
        virtual void onDevicePowerOnTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DevicePowerOnTimeStatus >& status);

        // LastSystemRuntimeCallbackIF
        virtual void onLastSystemRuntimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< LastSystemRuntimeError >& error);
        virtual void onLastSystemRuntimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< LastSystemRuntimeStatus >& status);

        // CurrentSystemRuntimeCallbackIF
        virtual void onCurrentSystemRuntimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CurrentSystemRuntimeError >& error);
        virtual void onCurrentSystemRuntimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CurrentSystemRuntimeStatus >& status);

        // ResetListCallbackIF
        virtual void onResetListError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ResetListError >& error);
        virtual void onResetListStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ResetListStatus >& status);

        // ResetCounterCallbackIF
        virtual void onResetCounterError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ResetCounterError >& error);
        virtual void onResetCounterStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ResetCounterStatus >& status);

        // TransportModeListCallbackIF
        virtual void onTransportModeListError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< TransportModeListError >& error);
        virtual void onTransportModeListStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< TransportModeListStatus >& status);

        // ResetHistoryCallbackIF
        virtual void onResetHistoryError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ResetHistoryError >& error);
        virtual void onResetHistoryStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ResetHistoryStatus >& status);

        // WakeupHistoryCallbackIF
        virtual void onWakeupHistoryError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WakeupHistoryError >& error);
        virtual void onWakeupHistoryStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WakeupHistoryStatus >& status);

        // StateHistoryCallbackIF
        virtual void onStateHistoryError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StateHistoryError >& error);
        virtual void onStateHistoryStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StateHistoryStatus >& status);

        // ErrStateHistory01CallbackIF
        virtual void onErrStateHistory01Error(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory01Error >& error);
        virtual void onErrStateHistory01Status(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory01Status >& status);

        // ErrStateHistory02CallbackIF
        virtual void onErrStateHistory02Error(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory02Error >& error);
        virtual void onErrStateHistory02Status(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory02Status >& status);

        // ErrStateHistory03CallbackIF
        virtual void onErrStateHistory03Error(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory03Error >& error);
        virtual void onErrStateHistory03Status(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory03Status >& status);

        // ErrStateHistory04CallbackIF
        virtual void onErrStateHistory04Error(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory04Error >& error);
        virtual void onErrStateHistory04Status(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory04Status >& status);

        // ErrStateHistory05CallbackIF
        virtual void onErrStateHistory05Error(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory05Error >& error);
        virtual void onErrStateHistory05Status(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ErrStateHistory05Status >& status);

        // SwitchOnHistoryCallbackIF
        virtual void onSwitchOnHistoryError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SwitchOnHistoryError >& error);
        virtual void onSwitchOnHistoryStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SwitchOnHistoryStatus >& status);

        // DeviceOnCounterCallbackIF
        virtual void onDeviceOnCounterError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DeviceOnCounterError >& error);
        virtual void onDeviceOnCounterStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DeviceOnCounterStatus >& status);

        // VoltageEventCounterCallbackIF
        virtual void onVoltageEventCounterError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VoltageEventCounterError >& error);
        virtual void onVoltageEventCounterStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VoltageEventCounterStatus >& status);

        // VoltageRangeHistogramCallbackIF
        virtual void onVoltageRangeHistogramError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VoltageRangeHistogramError >& error);
        virtual void onVoltageRangeHistogramStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VoltageRangeHistogramStatus >& status);

        // CpuUsageStatisticCallbackIF
        virtual void onCpuUsageStatisticError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CpuUsageStatisticError >& error);
        virtual void onCpuUsageStatisticStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< CpuUsageStatisticStatus >& status);

        // RamUsageStatisticCallbackIF
        virtual void onRamUsageStatisticError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RamUsageStatisticError >& error);
        virtual void onRamUsageStatisticStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RamUsageStatisticStatus >& status);

        // StartupTimeStatisticCallbackIF
        virtual void onStartupTimeStatisticError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupTimeStatisticError >& error);
        virtual void onStartupTimeStatisticStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupTimeStatisticStatus >& status);

        // RunlevelStateCallbackIF
        virtual void onRunlevelStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RunlevelStateError >& error);
        virtual void onRunlevelStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RunlevelStateStatus >& status);

        // RestartCallbackIF
        virtual void onRestartError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RestartError >& error);
        virtual void onRestartStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RestartStatus >& status);

        // LifesignCallbackIF
        virtual void onLifesignError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< LifesignError >& error);
        virtual void onLifesignStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< LifesignStatus >& status);

        // HmiStateCallbackIF
        virtual void onHmiStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< HmiStateError >& error);
        virtual void onHmiStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< HmiStateStatus >& status);

        // SystemPowerBehaviourCallbackIF
        virtual void onSystemPowerBehaviourError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemPowerBehaviourError >& error);
        virtual void onSystemPowerBehaviourStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemPowerBehaviourStatus >& status);

        // DimStateCallbackIF
        virtual void onDimStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DimStateError >& error);
        virtual void onDimStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DimStateStatus >& status);

        // DimmingStateCallbackIF
        virtual void onDimmingStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DimmingStateError >& error);
        virtual void onDimmingStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DimmingStateStatus >& status);

        // BluetoothStateCallbackIF
        virtual void onBluetoothStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< BluetoothStateError >& error);
        virtual void onBluetoothStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< BluetoothStateStatus >& status);

        // AudioStateCallbackIF
        virtual void onAudioStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AudioStateError >& error);
        virtual void onAudioStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AudioStateStatus >& status);

        // SpiStateCallbackIF
        virtual void onSpiStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SpiStateError >& error);
        virtual void onSpiStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SpiStateStatus >& status);

        // TunerStateCallbackIF
        virtual void onTunerStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< TunerStateError >& error);
        virtual void onTunerStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< TunerStateStatus >& status);

        // WifiStateCallbackIF
        virtual void onWifiStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WifiStateError >& error);
        virtual void onWifiStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WifiStateStatus >& status);

        // OnOffReasonCallbackIF
        virtual void onOnOffReasonError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< OnOffReasonError >& error);
        virtual void onOnOffReasonStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< OnOffReasonStatus >& status);

        // WakeupListCallbackIF
        virtual void onWakeupListError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WakeupListError >& error);
        virtual void onWakeupListStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WakeupListStatus >& status);

        // StartupFinishedCallbackIF
        virtual void onStartupFinishedError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupFinishedError >& error);
        virtual void onStartupFinishedStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupFinishedStatus >& status);

        // SysStateCallbackIF
        virtual void onSysStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysStateError >& error);
        virtual void onSysStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SysStateStatus >& status);

        // MostStateCallbackIF
        virtual void onMostStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MostStateError >& error);
        virtual void onMostStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MostStateStatus >& status);

        // MostVersionCallbackIF
        virtual void onMostVersionError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MostVersionError >& error);
        virtual void onMostVersionStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< MostVersionStatus >& status);

        // RVCStateCallbackIF
        virtual void onRVCStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RVCStateError >& error);
        virtual void onRVCStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RVCStateStatus >& status);

        // TriggerMostRemoteResetCallbackIF
        virtual void onTriggerMostRemoteResetError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< TriggerMostRemoteResetError >& error);
        virtual void onTriggerMostRemoteResetStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< TriggerMostRemoteResetStatus >& status);

        // PartnumberCallbackIF
        virtual void onPartnumberError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PartnumberError >& error);
        virtual void onPartnumberStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PartnumberStatus >& status);

        // PartnumbersCallbackIF
        virtual void onPartnumbersError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PartnumbersError >& error);
        virtual void onPartnumbersStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PartnumbersStatus >& status);

        // AlphacodeCallbackIF
        virtual void onAlphacodeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AlphacodeError >& error);
        virtual void onAlphacodeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AlphacodeStatus >& status);

        // AlphacodesCallbackIF
        virtual void onAlphacodesError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AlphacodesError >& error);
        virtual void onAlphacodesStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AlphacodesStatus >& status);

        // ManufacturersEnableCounterCallbackIF
        virtual void onManufacturersEnableCounterError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ManufacturersEnableCounterError >& error);
        virtual void onManufacturersEnableCounterStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ManufacturersEnableCounterStatus >& status);

        // NoCalibrationStateCallbackIF
        virtual void onNoCalibrationStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< NoCalibrationStateError >& error);
        virtual void onNoCalibrationStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< NoCalibrationStateStatus >& status);

        // SecurityCommErrorCallbackIF
        virtual void onSecurityCommErrorError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityCommErrorError >& error);
        virtual void onSecurityCommErrorStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityCommErrorStatus >& status);

        // SecurityMoreThan10VinCallbackIF
        virtual void onSecurityMoreThan10VinError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityMoreThan10VinError >& error);
        virtual void onSecurityMoreThan10VinStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityMoreThan10VinStatus >& status);

        // SecurityInvalidVinCallbackIF
        virtual void onSecurityInvalidVinError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityInvalidVinError >& error);
        virtual void onSecurityInvalidVinStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityInvalidVinStatus >& status);

        // SecurityCurrentVinCallbackIF
        virtual void onSecurityCurrentVinError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityCurrentVinError >& error);
        virtual void onSecurityCurrentVinStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityCurrentVinStatus >& status);

        // SecurityVinHistoryCallbackIF
        virtual void onSecurityVinHistoryError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityVinHistoryError >& error);
        virtual void onSecurityVinHistoryStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityVinHistoryStatus >& status);

        // VINCallbackIF
        virtual void onVINError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VINError >& error);
        virtual void onVINStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VINStatus >& status);

        // SecurityStateCallbackIF
        virtual void onSecurityStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityStateError >& error);
        virtual void onSecurityStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SecurityStateStatus >& status);

        // VehicleIDCallbackIF
        virtual void onVehicleIDError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VehicleIDError >& error);
        virtual void onVehicleIDStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< VehicleIDStatus >& status);

        // DisplayVariantCallbackIF
        virtual void onDisplayVariantError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DisplayVariantError >& error);
        virtual void onDisplayVariantStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DisplayVariantStatus >& status);

        // ReductionLevelCallbackIF
        virtual void onReductionLevelError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ReductionLevelError >& error);
        virtual void onReductionLevelStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ReductionLevelStatus >& status);

        // StartupStateCallbackIF
        virtual void onStartupStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupStateError >& error);
        virtual void onStartupStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartupStateStatus >& status);

        // EntertainMuteCallbackIF
        virtual void onEntertainMuteError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EntertainMuteError >& error);
        virtual void onEntertainMuteStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EntertainMuteStatus >& status);

        // WelcomeAudioStateCallbackIF
        virtual void onWelcomeAudioStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WelcomeAudioStateError >& error);
        virtual void onWelcomeAudioStateStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WelcomeAudioStateStatus >& status);

        // UnballastTimeFromEngineStoppedCallbackIF
        virtual void onUnballastTimeFromEngineStoppedError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UnballastTimeFromEngineStoppedError >& error);
        virtual void onUnballastTimeFromEngineStoppedStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UnballastTimeFromEngineStoppedStatus >& status);

        // UnballastTimeBeforeUnballastCallbackIF
        virtual void onUnballastTimeBeforeUnballastError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UnballastTimeBeforeUnballastError >& error);
        virtual void onUnballastTimeBeforeUnballastStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UnballastTimeBeforeUnballastStatus >& status);

        // UnballastWarningTimeCallbackIF
        virtual void onUnballastWarningTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UnballastWarningTimeError >& error);
        virtual void onUnballastWarningTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UnballastWarningTimeStatus >& status);

        // DegradedCountCallbackIF
        virtual void onDegradedCountError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DegradedCountError >& error);
        virtual void onDegradedCountStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DegradedCountStatus >& status);

        // DegradedTimeCallbackIF
        virtual void onDegradedTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DegradedTimeError >& error);
        virtual void onDegradedTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DegradedTimeStatus >& status);

        // PhoneHandoverWarnTimeCallbackIF
        virtual void onPhoneHandoverWarnTimeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PhoneHandoverWarnTimeError >& error);
        virtual void onPhoneHandoverWarnTimeStatus(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PhoneHandoverWarnTimeStatus >& status);

        // SystemModeCallbackIF
        virtual void onSystemModeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemModeError >& error);
        virtual void onSystemModeResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SystemModeResult >& result);

        // DownloadLockStateCallbackIF
        virtual void onDownloadLockStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DownloadLockStateError >& error);
        virtual void onDownloadLockStateResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< DownloadLockStateResult >& result);

        // UpdateLockCallbackIF
        virtual void onUpdateLockError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UpdateLockError >& error);
        virtual void onUpdateLockResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< UpdateLockResult >& result);

        // OnOffTriggerCallbackIF
        virtual void onOnOffTriggerError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< OnOffTriggerError >& error);
        virtual void onOnOffTriggerResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< OnOffTriggerResult >& result);

        // StartProcessCallbackIF
        virtual void onStartProcessError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartProcessError >& error);
        virtual void onStartProcessResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartProcessResult >& result);

        // StopProcessCallbackIF
        virtual void onStopProcessError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StopProcessError >& error);
        virtual void onStopProcessResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StopProcessResult >& result);

        // RestartProcessCallbackIF
        virtual void onRestartProcessError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RestartProcessError >& error);
        virtual void onRestartProcessResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RestartProcessResult >& result);

        // StartUpSyncPointReachedCallbackIF
        virtual void onStartUpSyncPointReachedError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartUpSyncPointReachedError >& error);
        virtual void onStartUpSyncPointReachedResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< StartUpSyncPointReachedResult >& result);

        // ClearListCallbackIF
        virtual void onClearListError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ClearListError >& error);
        virtual void onClearListResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ClearListResult >& result);

        // RestartSystemCallbackIF
        virtual void onRestartSystemError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RestartSystemError >& error);
        virtual void onRestartSystemResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< RestartSystemResult >& result);

        // AudioSourceChangeCallbackIF
        virtual void onAudioSourceChangeError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AudioSourceChangeError >& error);
        virtual void onAudioSourceChangeResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< AudioSourceChangeResult >& result);

        // ChangeBluetoothStateCallbackIF
        virtual void onChangeBluetoothStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeBluetoothStateError >& error);
        virtual void onChangeBluetoothStateResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeBluetoothStateResult >& result);

        // ChangeAudioStateCallbackIF
        virtual void onChangeAudioStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeAudioStateError >& error);
        virtual void onChangeAudioStateResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeAudioStateResult >& result);

        // ChangeSpiStateCallbackIF
        virtual void onChangeSpiStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeSpiStateError >& error);
        virtual void onChangeSpiStateResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeSpiStateResult >& result);

        // ChangeTunerStateCallbackIF
        virtual void onChangeTunerStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeTunerStateError >& error);
        virtual void onChangeTunerStateResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeTunerStateResult >& result);

        // ChangeWifiStateCallbackIF
        virtual void onChangeWifiStateError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeWifiStateError >& error);
        virtual void onChangeWifiStateResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ChangeWifiStateResult >& result);

        // ShutdownAndTerminateCcaAppsCallbackIF
        virtual void onShutdownAndTerminateCcaAppsError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ShutdownAndTerminateCcaAppsError >& error);
        virtual void onShutdownAndTerminateCcaAppsResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ShutdownAndTerminateCcaAppsResult >& result);

        // SetFactorySettingsNewCallbackIF
        virtual void onSetFactorySettingsNewError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SetFactorySettingsNewError >& error);
        virtual void onSetFactorySettingsNewResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SetFactorySettingsNewResult >& result);

        // ClearVINCallbackIF
        virtual void onClearVINError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ClearVINError >& error);
        virtual void onClearVINResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< ClearVINResult >& result);

        // PrepareDownloadCallbackIF
        virtual void onPrepareDownloadError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PrepareDownloadError >& error);
        virtual void onPrepareDownloadResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< PrepareDownloadResult >& result);

        // EndDownloadCallbackIF
        virtual void onEndDownloadError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EndDownloadError >& error);
        virtual void onEndDownloadResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EndDownloadResult >& result);

        // SetOnConfigurationCallbackIF
        virtual void onSetOnConfigurationError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SetOnConfigurationError >& error);
        virtual void onSetOnConfigurationResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SetOnConfigurationResult >& result);

        // SetProcessConfigurationCallbackIF
        virtual void onSetProcessConfigurationError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SetProcessConfigurationError >& error);
        virtual void onSetProcessConfigurationResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< SetProcessConfigurationResult >& result);

        // EntertainDeMuteCallbackIF
        virtual void onEntertainDeMuteError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EntertainDeMuteError >& error);
        virtual void onEntertainDeMuteResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EntertainDeMuteResult >& result);

        // EntertainMuteRequestCallbackIF
        virtual void onEntertainMuteRequestError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EntertainMuteRequestError >& error);
        virtual void onEntertainMuteRequestResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< EntertainMuteRequestResult >& result);

        // WelcomeAudioActivationCallbackIF
        virtual void onWelcomeAudioActivationError(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WelcomeAudioActivationError >& error);
        virtual void onWelcomeAudioActivationResult(const ::boost::shared_ptr< SPM_CORE_FIProxy >& proxy, const boost::shared_ptr< WelcomeAudioActivationResult >& result);

    private:

        ::boost::shared_ptr <SPM_CORE_FIProxy> _SpmProxy;

    public:
        virtual const tChar* getName() const { return "lcmccadbusgw_tclClientSpm"; }

        virtual tVoid vHandleMessage(lcmccadbusgw_tclBaseIf::TMsg* pMsg);
        virtual tVoid vHandleTraceMessage(const tUChar* /*puchData*/) {}
        virtual tVoid vGetReferences();
        virtual tVoid vStartCommunication();
        virtual tVoid vTraceInfo();

        virtual tVoid sendSystemStateGet();
        virtual tVoid sendDownloadLockStatesGet();
        virtual tVoid sendUpdateLockStatesGet();
        virtual tVoid sendActiveOnOffTriggerGet();
        virtual tVoid sendSubStatesSet(::spm_core_fi_types::T_SPM_e32_SubStateType subStateType, tBool subStateData);
        virtual tVoid sendSubStatesGet();
        virtual tVoid sendHistoryTriggerGet();
        virtual tVoid sendInsertStateGet();
        virtual tVoid sendMediaEjectStateGet();
        virtual tVoid sendPhoneMuteStateGet();
        virtual tVoid sendOnTipperStateGet();
        virtual tVoid sendIgnitionCyclesGet();
        virtual tVoid sendSysPwrModeGet();
        virtual tVoid sendSysPwrSaveModeGet();
        virtual tVoid sendMapDownloadLockStateGet();
        virtual tVoid sendStandbyTimeSet(tU32 standbyTime);
        virtual tVoid sendStandbyTimeGet();
        virtual tVoid sendPersitentStandbyTimeSet(tU32 persitentStandbyTime);
        virtual tVoid sendPersitentStandbyTimeGet();
        virtual tVoid sendIgnitionOffTimeSet(tU32 ignitionOffTime);
        virtual tVoid sendIgnitionOffTimeGet();
        virtual tVoid sendDoorOpenTimeSet(tU32 doorOpenTime);
        virtual tVoid sendDoorOpenTimeGet();
        virtual tVoid sendClockDisplayTimeSet(tU32 clockDisplayTime);
        virtual tVoid sendClockDisplayTimeGet();
        virtual tVoid sendSystemStateTimeGet(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState);
        virtual tVoid sendSystemStateTimeSet(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState, tU32 tStateTimerValue);
        virtual tVoid sendProcessListGet();
        virtual tVoid sendWakeupReasonGet();
        virtual tVoid sendStartupReasonGet();
        virtual tVoid sendConnectToBatteryGet();
        virtual tVoid sendCodeRequestStateSet(::spm_core_fi_types::T_SPM_e32_CODE_REQUEST codeRequestState);
        virtual tVoid sendCodeRequestStateGet();
        virtual tVoid sendActiveStartUpSyncPointsGet();
        virtual tVoid sendCvmEventGet();
        virtual tVoid sendUBatSenseGet();
        virtual tVoid sendCoproStateSet(::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE coproState);
        virtual tVoid sendCoproStateGet();
        virtual tVoid sendDevicePowerOnTimeSet(tU32 devicePowerOnTime);
        virtual tVoid sendDevicePowerOnTimeGet();
        virtual tVoid sendLastSystemRuntimeGet();
        virtual tVoid sendCurrentSystemRuntimeGet();
        virtual tVoid sendResetListSet(tU32 resetResetList);
        virtual tVoid sendResetListGet();
        virtual tVoid sendResetCounterSet(tU32 resetCounter);
        virtual tVoid sendResetCounterGet();
        virtual tVoid sendTransportModeListSet(tU32 transPortList);
        virtual tVoid sendTransportModeListGet();
        virtual tVoid sendResetHistorySet();
        virtual tVoid sendResetHistoryGet();
        virtual tVoid sendWakeupHistorySet();
        virtual tVoid sendWakeupHistoryGet();
        virtual tVoid sendStateHistorySet();
        virtual tVoid sendStateHistoryGet();
        virtual tVoid sendErrStateHistory01Set();
        virtual tVoid sendErrStateHistory01Get();
        virtual tVoid sendErrStateHistory02Set();
        virtual tVoid sendErrStateHistory02Get();
        virtual tVoid sendErrStateHistory03Set();
        virtual tVoid sendErrStateHistory03Get();
        virtual tVoid sendErrStateHistory04Set();
        virtual tVoid sendErrStateHistory04Get();
        virtual tVoid sendErrStateHistory05Set();
        virtual tVoid sendErrStateHistory05Get();
        virtual tVoid sendSwitchOnHistorySet();
        virtual tVoid sendSwitchOnHistoryGet();
        virtual tVoid sendDeviceOnCounterGet();
        virtual tVoid sendVoltageEventCounterGet();
        virtual tVoid sendVoltageRangeHistogramGet();
        virtual tVoid sendCpuUsageStatisticGet();
        virtual tVoid sendRamUsageStatisticGet();
        virtual tVoid sendStartupTimeStatisticGet();
        virtual tVoid sendRunlevelStateGet();
        virtual tVoid sendRestartSet(::spm_core_fi_types::T_SPM_e32_RESTART_TYPE restart);
        virtual tVoid sendRestartGet();
        virtual tVoid sendLifesignGet();
        virtual tVoid sendHmiStateGet();
        virtual tVoid sendSystemPowerBehaviourGet();
        virtual tVoid sendDimStateGet();
        virtual tVoid sendDimmingStateGet();
        virtual tVoid sendBluetoothStateGet();
        virtual tVoid sendAudioStateGet();
        virtual tVoid sendSpiStateGet();
        virtual tVoid sendTunerStateGet();
        virtual tVoid sendWifiStateGet();
        virtual tVoid sendOnOffReasonSet(::spm_core_fi_types::T_SPM_e32_OnOffReason onOffReason);
        virtual tVoid sendOnOffReasonGet();
        virtual tVoid sendWakeupListSet(tU32 wakeupList);
        virtual tVoid sendWakeupListGet();
        virtual tVoid sendStartupFinishedGet();
        virtual tVoid sendSysStateGet();
        virtual tVoid sendMostStateGet();
        virtual tVoid sendMostVersionGet();
        virtual tVoid sendRVCStateSet(tBool state);
        virtual tVoid sendRVCStateGet();
        virtual tVoid sendTriggerMostRemoteResetGet();
        virtual tVoid sendTriggerMostRemoteResetSet();
        virtual tVoid sendPartnumberGet(const ::std::string& part);
        virtual tVoid sendPartnumberSet(const ::std::string& part, tU32 number);
        virtual tVoid sendPartnumbersGet();
        virtual tVoid sendAlphacodeGet(const ::std::string& part);
        virtual tVoid sendAlphacodeSet(const ::std::string& part, tU8 alphacode1, tU8 alphacode2);
        virtual tVoid sendAlphacodesGet();
        virtual tVoid sendManufacturersEnableCounterGet();
        virtual tVoid sendManufacturersEnableCounterSet(tU8 mEC);
        virtual tVoid sendNoCalibrationStateGet();
        virtual tVoid sendNoCalibrationStateSet(tBool state);
        virtual tVoid sendSecurityCommErrorGet();
        virtual tVoid sendSecurityMoreThan10VinGet();
        virtual tVoid sendSecurityInvalidVinGet();
        virtual tVoid sendSecurityCurrentVinGet();
        virtual tVoid sendSecurityVinHistoryGet();
        virtual tVoid sendVINGet();
        virtual tVoid sendSecurityStateGet();
        virtual tVoid sendVehicleIDGet();
        virtual tVoid sendDisplayVariantGet();
        virtual tVoid sendDisplayVariantSet(tU32 displayVariantNumber);
        virtual tVoid sendReductionLevelGet();
        virtual tVoid sendStartupStateGet();
        virtual tVoid sendEntertainMuteGet();
        virtual tVoid sendWelcomeAudioStateGet();
        virtual tVoid sendUnballastTimeFromEngineStoppedGet();
        virtual tVoid sendUnballastTimeBeforeUnballastGet();
        virtual tVoid sendUnballastTimeBeforeUnballastSet(tU32 u32UnballastTime);
        virtual tVoid sendUnballastWarningTimeGet();
        virtual tVoid sendUnballastWarningTimeSet(tU32 u32UnballastWarningTime);
        virtual tVoid sendDegradedCountGet();
        virtual tVoid sendDegradedTimeGet();
        virtual tVoid sendPhoneHandoverWarnTimeGet();
        virtual tVoid sendPhoneHandoverWarnTimeSet(tU32 u32Time);
        virtual tVoid sendSystemModeStart(::spm_core_fi_types::T_e8_StateModes eSystemMode);
        virtual tVoid sendDownloadLockStateStart(const ::std::string& strRestrictedDlState, ::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode);
        virtual tVoid sendUpdateLockStart(const ::std::string& strLockName, ::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest);
        virtual tVoid sendOnOffTriggerStart(::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger, tBool bState);
        virtual tVoid sendStartProcessStart(const ::std::string& strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE u32Type, tU32 u32Info);
        virtual tVoid sendStopProcessStart(const ::std::string& strLocation, tU32 u32ProcId);
        virtual tVoid sendRestartProcessStart(const ::std::string& strLocation, tU32 u32ProcId);
        virtual tVoid sendStartUpSyncPointReachedStart(const ::std::string& strNewSyncPoint);
        virtual tVoid sendClearListStart(::spm_core_fi_types::T_SPM_e32_CLEAR_LIST eList2Clear);
        virtual tVoid sendRestartSystemStart(::spm_core_fi_types::T_SPM_e32_RESTART_TYPE eRestartType);
        virtual tVoid sendAudioSourceChangeStart(::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE eAudioSrc);
        virtual tVoid sendChangeBluetoothStateStart(::spm_core_fi_types::T_SPM_e32_BT_STATE btState);
        virtual tVoid sendChangeAudioStateStart(::spm_core_fi_types::T_SPM_e32_AUDIO_STATE audioState);
        virtual tVoid sendChangeSpiStateStart(::spm_core_fi_types::T_SPM_e32_SPI_STATE spiState);
        virtual tVoid sendChangeTunerStateStart(::spm_core_fi_types::T_SPM_e32_TUNER_STATE tunerState);
        virtual tVoid sendChangeWifiStateStart(::spm_core_fi_types::T_SPM_e32_WIFI_STATE wiFiState);
        virtual tVoid sendShutdownAndTerminateCcaAppsStart(::spm_core_fi_types::T_SPM_AppIdList tAppIdList);
        virtual tVoid sendSetFactorySettingsNewStart(::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType defSetStateGroup, ::spm_diag_defset_fi_types::T_e8_DefSetMode defSetStateMode);
        virtual tVoid sendClearVINStart();
        virtual tVoid sendPrepareDownloadStart(tU32 configuration, tBool suspendBusShutdown, tU32 timeout);
        virtual tVoid sendEndDownloadStart();
        virtual tVoid sendSetOnConfigurationStart(tU32 configuration);
        virtual tVoid sendSetProcessConfigurationStart(tU32 configuration);
        virtual tVoid sendEntertainDeMuteStart();
        virtual tVoid sendEntertainMuteRequestStart();
        virtual tVoid sendWelcomeAudioActivationStart(tBool bActivateState);

        // lcmccadbusgw_ClientSpmDeclarationsPart: user specific code start
        // lcmccadbusgw_ClientSpmDeclarationsPart: user specific code end
    };

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

#endif // ifndef _LCMCCADBUSGW_CLIENTSPM_H
