/*****************************************************************************
 * @file:         lcmccadbusgw_ClientSpm.cpp
 * @PROJECT:      CMD project
 * @SW-COMPONENT: lcmccadbusgateway
 * @Template:     CcaProxy.cpp.tpl
 * ----------------------------------------------------------------------------
 *
 * @brief:  generated file
 *          CCA client
 *
 *          Do manual changes only inside tags
 *
 *          //......................: user specific code start 
 *          //......................: user specific code end 
 *
 * ----------------------------------------------------------------------------
 * @copyright   (c) 2020 Robert Bosch GmbH.
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 *****************************************************************************/

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#include "lcmccadbusgwCca2DbusWrapperlcm_dbus_fi.h"
#include "Ilcmccadbusgw_ServiceLcmDbusFi.h"

// lcmccadbusgw_ClientSpmIncludePart: user specific code start
// lcmccadbusgw_ClientSpmIncludePart: user specific code end

#include "lcmccadbusgw_ClientSpm.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
   #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_LCMCCADBUSGATEWAY_CLIENT_SPM
#include "trcGenProj/Header/lcmccadbusgw_ClientSpm.cpp.trc.h"
#endif


namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {

using namespace::asf::core;
using namespace::asf::stream;
using namespace::SPM_CORE_FI;

// lcmccadbusgw_ClientSpmIncludePart2: user specific code start
// lcmccadbusgw_ClientSpmIncludePart2: user specific code end

DEFINE_CLASS_LOGGER_AND_LEVEL("org/bosch/cm/Lcmccadbusgw/lcmccadbusgw_tclClientSpm", lcmccadbusgw_tclClientSpm, Info);


lcmccadbusgw_tclClientSpm::lcmccadbusgw_tclClientSpm(lcmccadbusgw_tclAppMain* baseRef)
   : Ilcmccadbusgw_tclClientSpm(baseRef)
   , _bSrvAvailable(FALSE)
   , _SpmProxy(SPM_CORE_FIProxy::createProxy("spmFiPort", * this) )
{
   LOG_INFO("Constructor for lcmccadbusgw_tclClientSpm called");
   ETG_TRACE_USR1( ( "Constructor for lcmccadbusgw_tclClientSpm called" ) );
   
   // lcmccadbusgw_ClientSpmlcmccadbusgw_tclClientSpm: user specific code start
   // lcmccadbusgw_ClientSpmlcmccadbusgw_tclClientSpm: user specific code end
}

lcmccadbusgw_tclClientSpm::~lcmccadbusgw_tclClientSpm(){
   LOG_INFO("~lcmccadbusgw_tclClientSpm called");
   ETG_TRACE_USR1( ( "~lcmccadbusgw_tclClientSpm called" ) );
   
   // lcmccadbusgw_ClientSpmlcmccadbusgw_tclClientSpmDest: user specific code start
   // lcmccadbusgw_ClientSpmlcmccadbusgw_tclClientSpmDest: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAvailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;

   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAvailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm : onAvailable _SpmProxy " ) );
      _SpmProxy->sendSystemStateUpReg(* this);
      _SpmProxy->sendDownloadLockStatesUpReg(* this);
      _SpmProxy->sendUpdateLockStatesUpReg(* this);
      _SpmProxy->sendActiveOnOffTriggerUpReg(* this);
      _SpmProxy->sendSubStatesUpReg(* this);
      _SpmProxy->sendHistoryTriggerUpReg(* this);
      _SpmProxy->sendInsertStateUpReg(* this);
      _SpmProxy->sendMediaEjectStateUpReg(* this);
      _SpmProxy->sendPhoneMuteStateUpReg(* this);
      _SpmProxy->sendOnTipperStateUpReg(* this);
      _SpmProxy->sendIgnitionCyclesUpReg(* this);
      _SpmProxy->sendSysPwrModeUpReg(* this);
      _SpmProxy->sendSysPwrSaveModeUpReg(* this);
      _SpmProxy->sendMapDownloadLockStateUpReg(* this);
      _SpmProxy->sendStandbyTimeUpReg(* this);
      _SpmProxy->sendPersitentStandbyTimeUpReg(* this);
      _SpmProxy->sendIgnitionOffTimeUpReg(* this);
      _SpmProxy->sendDoorOpenTimeUpReg(* this);
      _SpmProxy->sendClockDisplayTimeUpReg(* this);
      _SpmProxy->sendSystemStateTimeUpReg(* this);
      _SpmProxy->sendProcessListUpReg(* this);
      _SpmProxy->sendWakeupReasonUpReg(* this);
      _SpmProxy->sendStartupReasonUpReg(* this);
      _SpmProxy->sendConnectToBatteryUpReg(* this);
      _SpmProxy->sendCodeRequestStateUpReg(* this);
      _SpmProxy->sendActiveStartUpSyncPointsUpReg(* this);
      _SpmProxy->sendCvmEventUpReg(* this);
      _SpmProxy->sendUBatSenseUpReg(* this);
      _SpmProxy->sendCoproStateUpReg(* this);
      _SpmProxy->sendDevicePowerOnTimeUpReg(* this);
      _SpmProxy->sendLastSystemRuntimeUpReg(* this);
      _SpmProxy->sendCurrentSystemRuntimeUpReg(* this);
      _SpmProxy->sendResetListUpReg(* this);
      _SpmProxy->sendResetCounterUpReg(* this);
      _SpmProxy->sendTransportModeListUpReg(* this);
      _SpmProxy->sendResetHistoryUpReg(* this);
      _SpmProxy->sendWakeupHistoryUpReg(* this);
      _SpmProxy->sendStateHistoryUpReg(* this);
      _SpmProxy->sendErrStateHistory01UpReg(* this);
      _SpmProxy->sendErrStateHistory02UpReg(* this);
      _SpmProxy->sendErrStateHistory03UpReg(* this);
      _SpmProxy->sendErrStateHistory04UpReg(* this);
      _SpmProxy->sendErrStateHistory05UpReg(* this);
      _SpmProxy->sendSwitchOnHistoryUpReg(* this);
      _SpmProxy->sendDeviceOnCounterUpReg(* this);
      _SpmProxy->sendVoltageEventCounterUpReg(* this);
      _SpmProxy->sendVoltageRangeHistogramUpReg(* this);
      _SpmProxy->sendCpuUsageStatisticUpReg(* this);
      _SpmProxy->sendRamUsageStatisticUpReg(* this);
      _SpmProxy->sendStartupTimeStatisticUpReg(* this);
      _SpmProxy->sendRunlevelStateUpReg(* this);
      _SpmProxy->sendRestartUpReg(* this);
      _SpmProxy->sendLifesignUpReg(* this);
      _SpmProxy->sendHmiStateUpReg(* this);
      _SpmProxy->sendSystemPowerBehaviourUpReg(* this);
      _SpmProxy->sendDimStateUpReg(* this);
      _SpmProxy->sendDimmingStateUpReg(* this);
      _SpmProxy->sendBluetoothStateUpReg(* this);
      _SpmProxy->sendAudioStateUpReg(* this);
      _SpmProxy->sendSpiStateUpReg(* this);
      _SpmProxy->sendTunerStateUpReg(* this);
      _SpmProxy->sendWifiStateUpReg(* this);
      _SpmProxy->sendOnOffReasonUpReg(* this);
      _SpmProxy->sendWakeupListUpReg(* this);
      _SpmProxy->sendStartupFinishedUpReg(* this);
      _SpmProxy->sendSysStateUpReg(* this);
      _SpmProxy->sendMostStateUpReg(* this);
      _SpmProxy->sendMostVersionUpReg(* this);
      _SpmProxy->sendRVCStateUpReg(* this);
      _SpmProxy->sendTriggerMostRemoteResetUpReg(* this);
      _SpmProxy->sendPartnumberUpReg(* this);
      _SpmProxy->sendPartnumbersUpReg(* this);
      _SpmProxy->sendAlphacodeUpReg(* this);
      _SpmProxy->sendAlphacodesUpReg(* this);
      _SpmProxy->sendManufacturersEnableCounterUpReg(* this);
      _SpmProxy->sendNoCalibrationStateUpReg(* this);
      _SpmProxy->sendSecurityCommErrorUpReg(* this);
      _SpmProxy->sendSecurityMoreThan10VinUpReg(* this);
      _SpmProxy->sendSecurityInvalidVinUpReg(* this);
      _SpmProxy->sendSecurityCurrentVinUpReg(* this);
      _SpmProxy->sendSecurityVinHistoryUpReg(* this);
      _SpmProxy->sendVINUpReg(* this);
      _SpmProxy->sendSecurityStateUpReg(* this);
      _SpmProxy->sendVehicleIDUpReg(* this);
      _SpmProxy->sendDisplayVariantUpReg(* this);
      _SpmProxy->sendReductionLevelUpReg(* this);
      _SpmProxy->sendStartupStateUpReg(* this);
      _SpmProxy->sendEntertainMuteUpReg(* this);
      _SpmProxy->sendWelcomeAudioStateUpReg(* this);
      _SpmProxy->sendUnballastTimeFromEngineStoppedUpReg(* this);
      _SpmProxy->sendUnballastTimeBeforeUnballastUpReg(* this);
      _SpmProxy->sendUnballastWarningTimeUpReg(* this);
      _SpmProxy->sendDegradedCountUpReg(* this);
      _SpmProxy->sendDegradedTimeUpReg(* this);
      _SpmProxy->sendPhoneHandoverWarnTimeUpReg(* this);

      // !!! Any UpReg's with parameter will not be generated --> parameter value are specific !!!

      // lcmccadbusgw_ClientSpmonAvailableUpregParam: user specific code start
      // lcmccadbusgw_ClientSpmonAvailableUpregParam: user specific code end

      _bSrvAvailable = TRUE;
   }
   // lcmccadbusgw_ClientSpmonAvailable: user specific code start
   // lcmccadbusgw_ClientSpmonAvailable: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnavailable(const::boost::shared_ptr <asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& stateChange){
   (tVoid)stateChange;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnavailable(): CALLED" ) );
   if (_SpmProxy == proxy){
      _bSrvAvailable = FALSE;
      ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm : onUnavailable _SpmProxy " ) );
   }
   // lcmccadbusgw_ClientSpmonUnavailable: user specific code start
   // lcmccadbusgw_ClientSpmonUnavailable: user specific code end

}

void lcmccadbusgw_tclClientSpm::onSystemStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SystemStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSystemStateError: user specific code start
   // lcmccadbusgw_ClientSpmonSystemStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SystemStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSystemStateValue(oConvertCcaToDbus_T_SPM_e32_SYSTEM_STATES(status->getSystemState()));

   // lcmccadbusgw_ClientSpmonSystemStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonSystemStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDownloadLockStatesError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DownloadLockStatesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDownloadLockStatesError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDownloadLockStatesError: user specific code start
   // lcmccadbusgw_ClientSpmonDownloadLockStatesError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDownloadLockStatesStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DownloadLockStatesStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDownloadLockStatesStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDownloadLockStatesValue(oConvertCcaToDbus_T_SPM_RestrictedDlLockListGen(status->getListRestrictedLock()));

   // lcmccadbusgw_ClientSpmonDownloadLockStatesStart: user specific code start
   // lcmccadbusgw_ClientSpmonDownloadLockStatesStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUpdateLockStatesError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <UpdateLockStatesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUpdateLockStatesError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonUpdateLockStatesError: user specific code start
   // lcmccadbusgw_ClientSpmonUpdateLockStatesError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUpdateLockStatesStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <UpdateLockStatesStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUpdateLockStatesStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setUpdateLockStatesValue(oConvertCcaToDbus_T_SPM_UpdateLockStateListGen(status->getLLocks()));

   // lcmccadbusgw_ClientSpmonUpdateLockStatesStart: user specific code start
   // lcmccadbusgw_ClientSpmonUpdateLockStatesStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onActiveOnOffTriggerError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ActiveOnOffTriggerError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onActiveOnOffTriggerError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonActiveOnOffTriggerError: user specific code start
   // lcmccadbusgw_ClientSpmonActiveOnOffTriggerError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onActiveOnOffTriggerStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ActiveOnOffTriggerStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onActiveOnOffTriggerStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setActiveOnOffTriggerValue(oConvertCcaToDbus_T_SPM_e32_SubStateTypeListGen(status->getTOnOffTriggerList()));

   // lcmccadbusgw_ClientSpmonActiveOnOffTriggerStart: user specific code start
   // lcmccadbusgw_ClientSpmonActiveOnOffTriggerStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSubStatesError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SubStatesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSubStatesError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSubStatesError: user specific code start
   // lcmccadbusgw_ClientSpmonSubStatesError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSubStatesStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SubStatesStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSubStatesStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSubStatesValue(oConvertCcaToDbus_TSubStates(
                               status->getSubState(), 
                               status->getHwSubState(), 
                               status->getInternSubState()));

   // lcmccadbusgw_ClientSpmonSubStatesStart: user specific code start
   // lcmccadbusgw_ClientSpmonSubStatesStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onHistoryTriggerError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <HistoryTriggerError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onHistoryTriggerError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonHistoryTriggerError: user specific code start
   // lcmccadbusgw_ClientSpmonHistoryTriggerError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onHistoryTriggerStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <HistoryTriggerStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onHistoryTriggerStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setHistoryTriggerValue(oConvertCcaToDbus_T_SPM_HistoryTriggerListGen(status->getTTriggeredStates()));

   // lcmccadbusgw_ClientSpmonHistoryTriggerStart: user specific code start
   // lcmccadbusgw_ClientSpmonHistoryTriggerStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onInsertStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <InsertStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onInsertStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonInsertStateError: user specific code start
   // lcmccadbusgw_ClientSpmonInsertStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onInsertStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <InsertStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onInsertStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setInsertStateValue(oConvertCcaToDbus_T_SPM_e32_CD_INSERT_STATE(status->getInsertState()));

   // lcmccadbusgw_ClientSpmonInsertStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonInsertStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMediaEjectStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <MediaEjectStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMediaEjectStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonMediaEjectStateError: user specific code start
   // lcmccadbusgw_ClientSpmonMediaEjectStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMediaEjectStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <MediaEjectStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMediaEjectStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setMediaEjectStateValue(oConvertCcaToDbus_T_SPM_e32_MEDIA_EJECT_STATE(status->getMediaEjectState()));

   // lcmccadbusgw_ClientSpmonMediaEjectStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonMediaEjectStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPhoneMuteStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <PhoneMuteStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPhoneMuteStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonPhoneMuteStateError: user specific code start
   // lcmccadbusgw_ClientSpmonPhoneMuteStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPhoneMuteStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <PhoneMuteStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPhoneMuteStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setPhoneMuteStateValue(oConvertCcaToDbus_T_SPM_e32_PHONE_MUTE_STATE(status->getPhoneMuteState()));

   // lcmccadbusgw_ClientSpmonPhoneMuteStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonPhoneMuteStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onOnTipperStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <OnTipperStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onOnTipperStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonOnTipperStateError: user specific code start
   // lcmccadbusgw_ClientSpmonOnTipperStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onOnTipperStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <OnTipperStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onOnTipperStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setOnTipperStateValue(oConvertCcaToDbus_T_SPM_e32_KEY_STATE(status->getOnTipperState()));

   // lcmccadbusgw_ClientSpmonOnTipperStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonOnTipperStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onIgnitionCyclesError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <IgnitionCyclesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onIgnitionCyclesError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonIgnitionCyclesError: user specific code start
   // lcmccadbusgw_ClientSpmonIgnitionCyclesError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onIgnitionCyclesStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <IgnitionCyclesStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onIgnitionCyclesStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setIgnitionCyclesValue(status->getIgnitionCycle());

   // lcmccadbusgw_ClientSpmonIgnitionCyclesStart: user specific code start
   // lcmccadbusgw_ClientSpmonIgnitionCyclesStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSysPwrModeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SysPwrModeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSysPwrModeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSysPwrModeError: user specific code start
   // lcmccadbusgw_ClientSpmonSysPwrModeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSysPwrModeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SysPwrModeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSysPwrModeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSysPwrModeValue(oConvertCcaToDbus_T_SPM_e32_SYSPWRMODE(status->getSysPwrMode()));

   // lcmccadbusgw_ClientSpmonSysPwrModeStart: user specific code start
   // lcmccadbusgw_ClientSpmonSysPwrModeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSysPwrSaveModeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SysPwrSaveModeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSysPwrSaveModeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSysPwrSaveModeError: user specific code start
   // lcmccadbusgw_ClientSpmonSysPwrSaveModeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSysPwrSaveModeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SysPwrSaveModeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSysPwrSaveModeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSysPwrSaveModeValue(oConvertCcaToDbus_T_SPM_b32_SYSPWRSAVEMODE(status->getSysPwrSaveMode()));

   // lcmccadbusgw_ClientSpmonSysPwrSaveModeStart: user specific code start
   // lcmccadbusgw_ClientSpmonSysPwrSaveModeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMapDownloadLockStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <MapDownloadLockStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMapDownloadLockStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonMapDownloadLockStateError: user specific code start
   // lcmccadbusgw_ClientSpmonMapDownloadLockStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMapDownloadLockStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <MapDownloadLockStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMapDownloadLockStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setMapDownloadLockStateValue(status->getU16AppIdLockOwner());

   // lcmccadbusgw_ClientSpmonMapDownloadLockStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonMapDownloadLockStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStandbyTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StandbyTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStandbyTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStandbyTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonStandbyTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStandbyTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StandbyTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStandbyTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setStandbyTimeValue(status->getStandbyTime());

   // lcmccadbusgw_ClientSpmonStandbyTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonStandbyTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPersitentStandbyTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <PersitentStandbyTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPersitentStandbyTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonPersitentStandbyTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonPersitentStandbyTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPersitentStandbyTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <PersitentStandbyTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPersitentStandbyTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setPersitentStandbyTimeValue(status->getPersitentStandbyTime());

   // lcmccadbusgw_ClientSpmonPersitentStandbyTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonPersitentStandbyTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onIgnitionOffTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <IgnitionOffTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onIgnitionOffTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonIgnitionOffTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonIgnitionOffTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onIgnitionOffTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <IgnitionOffTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onIgnitionOffTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setIgnitionOffTimeValue(status->getIgnitionOffTime());

   // lcmccadbusgw_ClientSpmonIgnitionOffTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonIgnitionOffTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDoorOpenTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DoorOpenTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDoorOpenTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDoorOpenTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonDoorOpenTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDoorOpenTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DoorOpenTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDoorOpenTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDoorOpenTimeValue(status->getDoorOpenTime());

   // lcmccadbusgw_ClientSpmonDoorOpenTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonDoorOpenTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onClockDisplayTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ClockDisplayTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onClockDisplayTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonClockDisplayTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonClockDisplayTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onClockDisplayTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ClockDisplayTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onClockDisplayTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setClockDisplayTimeValue(status->getClockDisplayTime());

   // lcmccadbusgw_ClientSpmonClockDisplayTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonClockDisplayTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemStateTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SystemStateTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemStateTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSystemStateTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonSystemStateTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemStateTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SystemStateTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemStateTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSystemStateTimeValue(oConvertCcaToDbus_TSystemStateTime(
                               status->getTSystemState(), 
                               status->getTStateTimerValue()));

   // lcmccadbusgw_ClientSpmonSystemStateTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonSystemStateTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onProcessListError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ProcessListError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onProcessListError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonProcessListError: user specific code start
   // lcmccadbusgw_ClientSpmonProcessListError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onProcessListStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ProcessListStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onProcessListStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setProcessListValue(oConvertCcaToDbus_T_SPM_ProcessInfo(status->getTProcesses()));

   // lcmccadbusgw_ClientSpmonProcessListStart: user specific code start
   // lcmccadbusgw_ClientSpmonProcessListStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWakeupReasonError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <WakeupReasonError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWakeupReasonError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonWakeupReasonError: user specific code start
   // lcmccadbusgw_ClientSpmonWakeupReasonError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWakeupReasonStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <WakeupReasonStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWakeupReasonStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setWakeupReasonValue(oConvertCcaToDbus_T_SPM_e32_WAKEUP_REASON(status->getWakeupReason()));

   // lcmccadbusgw_ClientSpmonWakeupReasonStart: user specific code start
   // lcmccadbusgw_ClientSpmonWakeupReasonStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupReasonError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StartupReasonError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupReasonError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStartupReasonError: user specific code start
   // lcmccadbusgw_ClientSpmonStartupReasonError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupReasonStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StartupReasonStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupReasonStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setStartupReasonValue(oConvertCcaToDbus_T_SPM_e32_STARTUP_REASON(status->getStartupReason()));

   // lcmccadbusgw_ClientSpmonStartupReasonStart: user specific code start
   // lcmccadbusgw_ClientSpmonStartupReasonStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onConnectToBatteryError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ConnectToBatteryError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onConnectToBatteryError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonConnectToBatteryError: user specific code start
   // lcmccadbusgw_ClientSpmonConnectToBatteryError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onConnectToBatteryStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ConnectToBatteryStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onConnectToBatteryStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setConnectToBatteryValue(oConvertCcaToDbus_TConnectToBattery(
                               status->getConnectToBatteryState(), 
                               status->getConnectToBatteryCount()));

   // lcmccadbusgw_ClientSpmonConnectToBatteryStart: user specific code start
   // lcmccadbusgw_ClientSpmonConnectToBatteryStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCodeRequestStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <CodeRequestStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCodeRequestStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonCodeRequestStateError: user specific code start
   // lcmccadbusgw_ClientSpmonCodeRequestStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCodeRequestStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <CodeRequestStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCodeRequestStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setCodeRequestStateValue(oConvertCcaToDbus_T_SPM_e32_CODE_REQUEST(status->getCodeRequestState()));

   // lcmccadbusgw_ClientSpmonCodeRequestStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonCodeRequestStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onActiveStartUpSyncPointsError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ActiveStartUpSyncPointsError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onActiveStartUpSyncPointsError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonActiveStartUpSyncPointsError: user specific code start
   // lcmccadbusgw_ClientSpmonActiveStartUpSyncPointsError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onActiveStartUpSyncPointsStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ActiveStartUpSyncPointsStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onActiveStartUpSyncPointsStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setActiveStartUpSyncPointsValue(oConvertCcaToDbus_tStringListGen(status->getTStartupSyncPointList()));

   // lcmccadbusgw_ClientSpmonActiveStartUpSyncPointsStart: user specific code start
   // lcmccadbusgw_ClientSpmonActiveStartUpSyncPointsStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCvmEventError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <CvmEventError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCvmEventError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonCvmEventError: user specific code start
   // lcmccadbusgw_ClientSpmonCvmEventError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCvmEventStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <CvmEventStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCvmEventStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setCvmEventValue(oConvertCcaToDbus_T_SPM_e32_CVM_EVENT(status->getCvmEvent()));

   // lcmccadbusgw_ClientSpmonCvmEventStart: user specific code start
   // lcmccadbusgw_ClientSpmonCvmEventStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUBatSenseError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <UBatSenseError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUBatSenseError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonUBatSenseError: user specific code start
   // lcmccadbusgw_ClientSpmonUBatSenseError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUBatSenseStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <UBatSenseStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUBatSenseStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setUBatSenseValue(status->getUBatSense());

   // lcmccadbusgw_ClientSpmonUBatSenseStart: user specific code start
   // lcmccadbusgw_ClientSpmonUBatSenseStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCoproStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <CoproStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCoproStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonCoproStateError: user specific code start
   // lcmccadbusgw_ClientSpmonCoproStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCoproStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <CoproStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCoproStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setCoproStateValue(oConvertCcaToDbus_T_SPM_e32_PROCESSOR_STATE(status->getCoproState()));

   // lcmccadbusgw_ClientSpmonCoproStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonCoproStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDevicePowerOnTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DevicePowerOnTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDevicePowerOnTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDevicePowerOnTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonDevicePowerOnTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDevicePowerOnTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DevicePowerOnTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDevicePowerOnTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDevicePowerOnTimeValue(status->getDevicePowerOnTime());

   // lcmccadbusgw_ClientSpmonDevicePowerOnTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonDevicePowerOnTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onLastSystemRuntimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <LastSystemRuntimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onLastSystemRuntimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonLastSystemRuntimeError: user specific code start
   // lcmccadbusgw_ClientSpmonLastSystemRuntimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onLastSystemRuntimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <LastSystemRuntimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onLastSystemRuntimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setLastSystemRuntimeValue(status->getU32RunTime());

   // lcmccadbusgw_ClientSpmonLastSystemRuntimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonLastSystemRuntimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCurrentSystemRuntimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <CurrentSystemRuntimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCurrentSystemRuntimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonCurrentSystemRuntimeError: user specific code start
   // lcmccadbusgw_ClientSpmonCurrentSystemRuntimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCurrentSystemRuntimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <CurrentSystemRuntimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCurrentSystemRuntimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setCurrentSystemRuntimeValue(status->getU32RunTime());

   // lcmccadbusgw_ClientSpmonCurrentSystemRuntimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonCurrentSystemRuntimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onResetListError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ResetListError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onResetListError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonResetListError: user specific code start
   // lcmccadbusgw_ClientSpmonResetListError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onResetListStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ResetListStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onResetListStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setResetListValue(oConvertCcaToDbus_TResetList(
                               status->getLastResetReason(), 
                               status->getDateHour(), 
                               status->getDateMinute(), 
                               status->getDateDay(), 
                               status->getDateMonth(), 
                               status->getDateYear(), 
                               status->getCoproResetByHmi(), 
                               status->getCoproResetByUndervoltage(), 
                               status->getHmiResetByCoproStartup(), 
                               status->getHmiResetByCoproRun(), 
                               status->getHmiResetByCoproShutdown(), 
                               status->getHmiResetByHmiWdg(), 
                               status->getHmiResetByHmiApp(), 
                               status->getHmiResetByHmiException(), 
                               status->getHmiResetByHmiExtern(), 
                               status->getHmiResetByHmiDownload(), 
                               status->getHmiResetByHmiDiag(), 
                               status->getFgsResetByHmi()));

   // lcmccadbusgw_ClientSpmonResetListStart: user specific code start
   // lcmccadbusgw_ClientSpmonResetListStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onResetCounterError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ResetCounterError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onResetCounterError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonResetCounterError: user specific code start
   // lcmccadbusgw_ClientSpmonResetCounterError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onResetCounterStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ResetCounterStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onResetCounterStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setResetCounterValue(oConvertCcaToDbus_TResetCounter(
                               status->getTLastResetDate(), 
                               status->getTLastResetReason(), 
                               status->getU32ApApplicationError(), 
                               status->getU32ApSoftware(), 
                               status->getU32ApEcuReset(), 
                               status->getU32ApDownload(), 
                               status->getU32ApDownloadError(), 
                               status->getU32ApOvertemperature(), 
                               status->getU32ApUser(), 
                               status->getU32ApLcmIntern(), 
                               status->getU32ApWarmstartCount(), 
                               status->getU32ApPowerOnCount(), 
                               status->getU32ApPowerLossCount(), 
                               status->getU32ApPowerOffCount(), 
                               status->getU32ApSccCount(), 
                               status->getU32ApUnknownCount(), 
                               status->getU32SccHwWdtCount(), 
                               status->getU32SccPowerOnCount(), 
                               status->getU32SccColdstartCount(), 
                               status->getU32SccAppmodeChangeCount(), 
                               status->getU32SccDuringLpwCount(), 
                               status->getU32SccDuringPllOszCount(), 
                               status->getU32SccDuringSWCount(), 
                               status->getU32SccWarmstartCount()));

   // lcmccadbusgw_ClientSpmonResetCounterStart: user specific code start
   // lcmccadbusgw_ClientSpmonResetCounterStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onTransportModeListError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <TransportModeListError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onTransportModeListError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonTransportModeListError: user specific code start
   // lcmccadbusgw_ClientSpmonTransportModeListError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onTransportModeListStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <TransportModeListStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onTransportModeListStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setTransportModeListValue(oConvertCcaToDbus_T_SPM_TransPortModeList(status->getTransportModeList()));

   // lcmccadbusgw_ClientSpmonTransportModeListStart: user specific code start
   // lcmccadbusgw_ClientSpmonTransportModeListStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onResetHistoryError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ResetHistoryError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onResetHistoryError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonResetHistoryError: user specific code start
   // lcmccadbusgw_ClientSpmonResetHistoryError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onResetHistoryStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ResetHistoryStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onResetHistoryStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setResetHistoryValue(oConvertCcaToDbus_T_ResetElementListGen(status->getTResetList()));

   // lcmccadbusgw_ClientSpmonResetHistoryStart: user specific code start
   // lcmccadbusgw_ClientSpmonResetHistoryStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWakeupHistoryError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <WakeupHistoryError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWakeupHistoryError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonWakeupHistoryError: user specific code start
   // lcmccadbusgw_ClientSpmonWakeupHistoryError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWakeupHistoryStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <WakeupHistoryStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWakeupHistoryStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setWakeupHistoryValue(oConvertCcaToDbus_T_WakeupElementListGen(status->getTWakeupList()));

   // lcmccadbusgw_ClientSpmonWakeupHistoryStart: user specific code start
   // lcmccadbusgw_ClientSpmonWakeupHistoryStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStateHistoryError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StateHistoryError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStateHistoryError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStateHistoryError: user specific code start
   // lcmccadbusgw_ClientSpmonStateHistoryError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStateHistoryStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StateHistoryStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStateHistoryStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setStateHistoryValue(oConvertCcaToDbus_T_StateChangeElementListGen(status->getTStateList()));

   // lcmccadbusgw_ClientSpmonStateHistoryStart: user specific code start
   // lcmccadbusgw_ClientSpmonStateHistoryStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory01Error(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ErrStateHistory01Error>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory01Error(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonErrStateHistory01Error: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory01Error: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory01Status(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ErrStateHistory01Status>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory01Status(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setErrStateHistory01Value(oConvertCcaToDbus_T_StateChangeElementListGen(status->getTStateList()));

   // lcmccadbusgw_ClientSpmonErrStateHistory01Start: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory01Start: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory02Error(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ErrStateHistory02Error>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory02Error(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonErrStateHistory02Error: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory02Error: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory02Status(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ErrStateHistory02Status>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory02Status(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setErrStateHistory02Value(oConvertCcaToDbus_T_StateChangeElementListGen(status->getTStateList()));

   // lcmccadbusgw_ClientSpmonErrStateHistory02Start: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory02Start: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory03Error(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ErrStateHistory03Error>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory03Error(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonErrStateHistory03Error: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory03Error: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory03Status(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ErrStateHistory03Status>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory03Status(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setErrStateHistory03Value(oConvertCcaToDbus_T_StateChangeElementListGen(status->getTStateList()));

   // lcmccadbusgw_ClientSpmonErrStateHistory03Start: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory03Start: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory04Error(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ErrStateHistory04Error>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory04Error(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonErrStateHistory04Error: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory04Error: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory04Status(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ErrStateHistory04Status>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory04Status(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setErrStateHistory04Value(oConvertCcaToDbus_T_StateChangeElementListGen(status->getTStateList()));

   // lcmccadbusgw_ClientSpmonErrStateHistory04Start: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory04Start: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory05Error(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ErrStateHistory05Error>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory05Error(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonErrStateHistory05Error: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory05Error: user specific code end
}

void lcmccadbusgw_tclClientSpm::onErrStateHistory05Status(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ErrStateHistory05Status>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onErrStateHistory05Status(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setErrStateHistory05Value(oConvertCcaToDbus_T_StateChangeElementListGen(status->getTStateList()));

   // lcmccadbusgw_ClientSpmonErrStateHistory05Start: user specific code start
   // lcmccadbusgw_ClientSpmonErrStateHistory05Start: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSwitchOnHistoryError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SwitchOnHistoryError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSwitchOnHistoryError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSwitchOnHistoryError: user specific code start
   // lcmccadbusgw_ClientSpmonSwitchOnHistoryError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSwitchOnHistoryStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SwitchOnHistoryStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSwitchOnHistoryStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSwitchOnHistoryValue(oConvertCcaToDbus_T_SwitchOnElementListGen(status->getTSwitchOnList()));

   // lcmccadbusgw_ClientSpmonSwitchOnHistoryStart: user specific code start
   // lcmccadbusgw_ClientSpmonSwitchOnHistoryStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDeviceOnCounterError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DeviceOnCounterError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDeviceOnCounterError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDeviceOnCounterError: user specific code start
   // lcmccadbusgw_ClientSpmonDeviceOnCounterError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDeviceOnCounterStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DeviceOnCounterStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDeviceOnCounterStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDeviceOnCounterValue(oConvertCcaToDbus_TDeviceOnCounter(
                               status->getU32DeviceWakeupCount(), 
                               status->getU32DeviceUserOnCount()));

   // lcmccadbusgw_ClientSpmonDeviceOnCounterStart: user specific code start
   // lcmccadbusgw_ClientSpmonDeviceOnCounterStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVoltageEventCounterError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <VoltageEventCounterError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVoltageEventCounterError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonVoltageEventCounterError: user specific code start
   // lcmccadbusgw_ClientSpmonVoltageEventCounterError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVoltageEventCounterStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <VoltageEventCounterStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVoltageEventCounterStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setVoltageEventCounterValue(oConvertCcaToDbus_T_SPM_VoltageEventCounter(status->getTVoltageEventCounter()));

   // lcmccadbusgw_ClientSpmonVoltageEventCounterStart: user specific code start
   // lcmccadbusgw_ClientSpmonVoltageEventCounterStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVoltageRangeHistogramError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <VoltageRangeHistogramError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVoltageRangeHistogramError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonVoltageRangeHistogramError: user specific code start
   // lcmccadbusgw_ClientSpmonVoltageRangeHistogramError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVoltageRangeHistogramStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <VoltageRangeHistogramStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVoltageRangeHistogramStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setVoltageRangeHistogramValue(oConvertCcaToDbus_T_SPM_VoltageRangeListGen(status->getListVoltageRangeHistogram()));

   // lcmccadbusgw_ClientSpmonVoltageRangeHistogramStart: user specific code start
   // lcmccadbusgw_ClientSpmonVoltageRangeHistogramStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCpuUsageStatisticError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <CpuUsageStatisticError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCpuUsageStatisticError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonCpuUsageStatisticError: user specific code start
   // lcmccadbusgw_ClientSpmonCpuUsageStatisticError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onCpuUsageStatisticStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <CpuUsageStatisticStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onCpuUsageStatisticStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setCpuUsageStatisticValue(oConvertCcaToDbus_T_SPM_SystemStatisticsData(status->getTCpuUsageStatisticsData()));

   // lcmccadbusgw_ClientSpmonCpuUsageStatisticStart: user specific code start
   // lcmccadbusgw_ClientSpmonCpuUsageStatisticStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRamUsageStatisticError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <RamUsageStatisticError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRamUsageStatisticError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonRamUsageStatisticError: user specific code start
   // lcmccadbusgw_ClientSpmonRamUsageStatisticError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRamUsageStatisticStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <RamUsageStatisticStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRamUsageStatisticStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setRamUsageStatisticValue(oConvertCcaToDbus_T_SPM_SystemStatisticsData(status->getTRamUsageStatisticsData()));

   // lcmccadbusgw_ClientSpmonRamUsageStatisticStart: user specific code start
   // lcmccadbusgw_ClientSpmonRamUsageStatisticStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupTimeStatisticError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StartupTimeStatisticError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupTimeStatisticError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStartupTimeStatisticError: user specific code start
   // lcmccadbusgw_ClientSpmonStartupTimeStatisticError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupTimeStatisticStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StartupTimeStatisticStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupTimeStatisticStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setStartupTimeStatisticValue(oConvertCcaToDbus_T_SPM_SystemStatisticsData(status->getTStartupTimeStatisticsData()));

   // lcmccadbusgw_ClientSpmonStartupTimeStatisticStart: user specific code start
   // lcmccadbusgw_ClientSpmonStartupTimeStatisticStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRunlevelStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <RunlevelStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRunlevelStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonRunlevelStateError: user specific code start
   // lcmccadbusgw_ClientSpmonRunlevelStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRunlevelStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <RunlevelStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRunlevelStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setRunlevelStateValue(oConvertCcaToDbus_T_SPM_e32_RUNLEVEL(status->getERunlevel()));

   // lcmccadbusgw_ClientSpmonRunlevelStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonRunlevelStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRestartError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <RestartError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRestartError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonRestartError: user specific code start
   // lcmccadbusgw_ClientSpmonRestartError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRestartStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <RestartStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRestartStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setRestartValue(oConvertCcaToDbus_T_SPM_e32_RESTART_TYPE(status->getRestart()));

   // lcmccadbusgw_ClientSpmonRestartStart: user specific code start
   // lcmccadbusgw_ClientSpmonRestartStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onLifesignError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <LifesignError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onLifesignError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonLifesignError: user specific code start
   // lcmccadbusgw_ClientSpmonLifesignError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onLifesignStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <LifesignStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onLifesignStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setLifesignValue(status->getLifesign());

   // lcmccadbusgw_ClientSpmonLifesignStart: user specific code start
   // lcmccadbusgw_ClientSpmonLifesignStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onHmiStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <HmiStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onHmiStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonHmiStateError: user specific code start
   // lcmccadbusgw_ClientSpmonHmiStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onHmiStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <HmiStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onHmiStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setHmiStateValue(oConvertCcaToDbus_T_SPM_e32_HMI_STATE(status->getHmiState()));

   // lcmccadbusgw_ClientSpmonHmiStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonHmiStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemPowerBehaviourError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SystemPowerBehaviourError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemPowerBehaviourError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSystemPowerBehaviourError: user specific code start
   // lcmccadbusgw_ClientSpmonSystemPowerBehaviourError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemPowerBehaviourStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SystemPowerBehaviourStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemPowerBehaviourStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSystemPowerBehaviourValue(oConvertCcaToDbus_T_SPM_e32_SYSPWR_BEHAVIOUR(status->getESystemPowerBehaviour()));

   // lcmccadbusgw_ClientSpmonSystemPowerBehaviourStart: user specific code start
   // lcmccadbusgw_ClientSpmonSystemPowerBehaviourStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDimStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DimStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDimStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDimStateError: user specific code start
   // lcmccadbusgw_ClientSpmonDimStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDimStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DimStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDimStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDimStateValue(oConvertCcaToDbus_T_SPM_e32_DIM_STATE(status->getDimState()));

   // lcmccadbusgw_ClientSpmonDimStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonDimStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDimmingStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DimmingStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDimmingStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDimmingStateError: user specific code start
   // lcmccadbusgw_ClientSpmonDimmingStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDimmingStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DimmingStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDimmingStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDimmingStateValue(oConvertCcaToDbus_T_SPM_b32_DIM_STATE(status->getDimState()));

   // lcmccadbusgw_ClientSpmonDimmingStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonDimmingStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onBluetoothStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <BluetoothStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onBluetoothStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonBluetoothStateError: user specific code start
   // lcmccadbusgw_ClientSpmonBluetoothStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onBluetoothStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <BluetoothStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onBluetoothStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setBluetoothStateValue(oConvertCcaToDbus_T_SPM_e32_BT_STATE(status->getBtState()));

   // lcmccadbusgw_ClientSpmonBluetoothStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonBluetoothStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAudioStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <AudioStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAudioStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonAudioStateError: user specific code start
   // lcmccadbusgw_ClientSpmonAudioStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAudioStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <AudioStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAudioStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setAudioStateValue(oConvertCcaToDbus_T_SPM_e32_AUDIO_STATE(status->getAudioState()));

   // lcmccadbusgw_ClientSpmonAudioStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonAudioStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSpiStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SpiStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSpiStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSpiStateError: user specific code start
   // lcmccadbusgw_ClientSpmonSpiStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSpiStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SpiStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSpiStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSpiStateValue(oConvertCcaToDbus_T_SPM_e32_SPI_STATE(status->getSpiState()));

   // lcmccadbusgw_ClientSpmonSpiStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonSpiStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onTunerStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <TunerStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onTunerStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonTunerStateError: user specific code start
   // lcmccadbusgw_ClientSpmonTunerStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onTunerStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <TunerStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onTunerStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setTunerStateValue(oConvertCcaToDbus_T_SPM_e32_TUNER_STATE(status->getTunerState()));

   // lcmccadbusgw_ClientSpmonTunerStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonTunerStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWifiStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <WifiStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWifiStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonWifiStateError: user specific code start
   // lcmccadbusgw_ClientSpmonWifiStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWifiStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <WifiStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWifiStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setWifiStateValue(oConvertCcaToDbus_T_SPM_e32_WIFI_STATE(status->getWiFiState()));

   // lcmccadbusgw_ClientSpmonWifiStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonWifiStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onOnOffReasonError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <OnOffReasonError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onOnOffReasonError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonOnOffReasonError: user specific code start
   // lcmccadbusgw_ClientSpmonOnOffReasonError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onOnOffReasonStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <OnOffReasonStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onOnOffReasonStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setOnOffReasonValue(oConvertCcaToDbus_T_SPM_e32_OnOffReason(status->getOnOffReason()));

   // lcmccadbusgw_ClientSpmonOnOffReasonStart: user specific code start
   // lcmccadbusgw_ClientSpmonOnOffReasonStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWakeupListError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <WakeupListError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWakeupListError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonWakeupListError: user specific code start
   // lcmccadbusgw_ClientSpmonWakeupListError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWakeupListStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <WakeupListStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWakeupListStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setWakeupListValue(oConvertCcaToDbus_TWakeupList(
                               status->getWakeUpReason1(), 
                               status->getWakeUpReason2(), 
                               status->getWakeUpReason3(), 
                               status->getWakeUpReason4(), 
                               status->getWakeUpReason5(), 
                               status->getWakeUpReason6(), 
                               status->getWakeUpReason7(), 
                               status->getWakeUpReason8(), 
                               status->getWakeUpReason9(), 
                               status->getWakeUpReason10()));

   // lcmccadbusgw_ClientSpmonWakeupListStart: user specific code start
   // lcmccadbusgw_ClientSpmonWakeupListStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupFinishedError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StartupFinishedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupFinishedError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStartupFinishedError: user specific code start
   // lcmccadbusgw_ClientSpmonStartupFinishedError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupFinishedStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StartupFinishedStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupFinishedStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setStartupFinishedValue(status->getStartupFinishedState());

   // lcmccadbusgw_ClientSpmonStartupFinishedStart: user specific code start
   // lcmccadbusgw_ClientSpmonStartupFinishedStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSysStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SysStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSysStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSysStateError: user specific code start
   // lcmccadbusgw_ClientSpmonSysStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSysStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SysStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSysStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSysStateValue(oConvertCcaToDbus_T_SPM_e32_SYS_STATE(status->getSysState()));

   // lcmccadbusgw_ClientSpmonSysStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonSysStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMostStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <MostStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMostStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonMostStateError: user specific code start
   // lcmccadbusgw_ClientSpmonMostStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMostStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <MostStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMostStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setMostStateValue(oConvertCcaToDbus_TMostState(
                               status->getMostEvent(), 
                               status->getMostConfigurationState(), 
                               status->getFirstReceiveTime(), 
                               status->getTLAState(), 
                               status->getOvertemperatureMostOff()));

   // lcmccadbusgw_ClientSpmonMostStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonMostStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMostVersionError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <MostVersionError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMostVersionError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonMostVersionError: user specific code start
   // lcmccadbusgw_ClientSpmonMostVersionError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onMostVersionStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <MostVersionStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onMostVersionStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setMostVersionValue(status->getMostVersion());

   // lcmccadbusgw_ClientSpmonMostVersionStart: user specific code start
   // lcmccadbusgw_ClientSpmonMostVersionStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRVCStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <RVCStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRVCStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonRVCStateError: user specific code start
   // lcmccadbusgw_ClientSpmonRVCStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRVCStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <RVCStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRVCStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setRVCStateValue(status->getState());

   // lcmccadbusgw_ClientSpmonRVCStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonRVCStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onTriggerMostRemoteResetError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <TriggerMostRemoteResetError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onTriggerMostRemoteResetError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonTriggerMostRemoteResetError: user specific code start
   // lcmccadbusgw_ClientSpmonTriggerMostRemoteResetError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onTriggerMostRemoteResetStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <TriggerMostRemoteResetStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onTriggerMostRemoteResetStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setTriggerMostRemoteResetValue(status->getTrigger());

   // lcmccadbusgw_ClientSpmonTriggerMostRemoteResetStart: user specific code start
   // lcmccadbusgw_ClientSpmonTriggerMostRemoteResetStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPartnumberError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <PartnumberError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPartnumberError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonPartnumberError: user specific code start
   // lcmccadbusgw_ClientSpmonPartnumberError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPartnumberStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <PartnumberStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPartnumberStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setPartnumberValue(status->getPartnumber());

   // lcmccadbusgw_ClientSpmonPartnumberStart: user specific code start
   // lcmccadbusgw_ClientSpmonPartnumberStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPartnumbersError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <PartnumbersError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPartnumbersError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonPartnumbersError: user specific code start
   // lcmccadbusgw_ClientSpmonPartnumbersError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPartnumbersStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <PartnumbersStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPartnumbersStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setPartnumbersValue(oConvertCcaToDbus_T_SPM_PartnumberList(status->getParts()));

   // lcmccadbusgw_ClientSpmonPartnumbersStart: user specific code start
   // lcmccadbusgw_ClientSpmonPartnumbersStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAlphacodeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <AlphacodeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAlphacodeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonAlphacodeError: user specific code start
   // lcmccadbusgw_ClientSpmonAlphacodeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAlphacodeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <AlphacodeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAlphacodeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setAlphacodeValue(oConvertCcaToDbus_TAlphacode(
                               status->getAlphacode1(), 
                               status->getAlphacode2()));

   // lcmccadbusgw_ClientSpmonAlphacodeStart: user specific code start
   // lcmccadbusgw_ClientSpmonAlphacodeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAlphacodesError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <AlphacodesError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAlphacodesError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonAlphacodesError: user specific code start
   // lcmccadbusgw_ClientSpmonAlphacodesError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAlphacodesStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <AlphacodesStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAlphacodesStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setAlphacodesValue(oConvertCcaToDbus_T_SPM_AlphacodeList(status->getParts()));

   // lcmccadbusgw_ClientSpmonAlphacodesStart: user specific code start
   // lcmccadbusgw_ClientSpmonAlphacodesStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onManufacturersEnableCounterError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ManufacturersEnableCounterError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onManufacturersEnableCounterError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonManufacturersEnableCounterError: user specific code start
   // lcmccadbusgw_ClientSpmonManufacturersEnableCounterError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onManufacturersEnableCounterStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ManufacturersEnableCounterStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onManufacturersEnableCounterStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setManufacturersEnableCounterValue(status->getMEC());

   // lcmccadbusgw_ClientSpmonManufacturersEnableCounterStart: user specific code start
   // lcmccadbusgw_ClientSpmonManufacturersEnableCounterStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onNoCalibrationStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <NoCalibrationStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onNoCalibrationStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonNoCalibrationStateError: user specific code start
   // lcmccadbusgw_ClientSpmonNoCalibrationStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onNoCalibrationStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <NoCalibrationStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onNoCalibrationStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setNoCalibrationStateValue(status->getState());

   // lcmccadbusgw_ClientSpmonNoCalibrationStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonNoCalibrationStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityCommErrorError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SecurityCommErrorError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityCommErrorError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSecurityCommErrorError: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityCommErrorError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityCommErrorStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SecurityCommErrorStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityCommErrorStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSecurityCommErrorValue(status->getCommErrorCount());

   // lcmccadbusgw_ClientSpmonSecurityCommErrorStart: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityCommErrorStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityMoreThan10VinError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SecurityMoreThan10VinError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityMoreThan10VinError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSecurityMoreThan10VinError: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityMoreThan10VinError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityMoreThan10VinStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SecurityMoreThan10VinStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityMoreThan10VinStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSecurityMoreThan10VinValue(status->getMoreThan10VinCount());

   // lcmccadbusgw_ClientSpmonSecurityMoreThan10VinStart: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityMoreThan10VinStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityInvalidVinError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SecurityInvalidVinError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityInvalidVinError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSecurityInvalidVinError: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityInvalidVinError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityInvalidVinStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SecurityInvalidVinStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityInvalidVinStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSecurityInvalidVinValue(status->getInvalidVinCount());

   // lcmccadbusgw_ClientSpmonSecurityInvalidVinStart: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityInvalidVinStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityCurrentVinError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SecurityCurrentVinError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityCurrentVinError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSecurityCurrentVinError: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityCurrentVinError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityCurrentVinStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SecurityCurrentVinStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityCurrentVinStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSecurityCurrentVinValue(oConvertCcaToDbus_T_SPM_Vin(status->getCurrentVin()));

   // lcmccadbusgw_ClientSpmonSecurityCurrentVinStart: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityCurrentVinStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityVinHistoryError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SecurityVinHistoryError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityVinHistoryError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSecurityVinHistoryError: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityVinHistoryError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityVinHistoryStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SecurityVinHistoryStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityVinHistoryStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSecurityVinHistoryValue(oConvertCcaToDbus_T_SPM_VinHistory(status->getVinHistory()));

   // lcmccadbusgw_ClientSpmonSecurityVinHistoryStart: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityVinHistoryStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVINError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <VINError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVINError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonVINError: user specific code start
   // lcmccadbusgw_ClientSpmonVINError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVINStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <VINStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVINStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setVINValue(status->getVehicleIdentificationNumber());

   // lcmccadbusgw_ClientSpmonVINStart: user specific code start
   // lcmccadbusgw_ClientSpmonVINStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SecurityStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSecurityStateError: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSecurityStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SecurityStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSecurityStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setSecurityStateValue(oConvertCcaToDbus_T_SPM_e32_SECURITY_STATE(status->getState()));

   // lcmccadbusgw_ClientSpmonSecurityStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonSecurityStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVehicleIDError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <VehicleIDError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVehicleIDError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonVehicleIDError: user specific code start
   // lcmccadbusgw_ClientSpmonVehicleIDError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onVehicleIDStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <VehicleIDStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onVehicleIDStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setVehicleIDValue(status->getU32VehicleID());

   // lcmccadbusgw_ClientSpmonVehicleIDStart: user specific code start
   // lcmccadbusgw_ClientSpmonVehicleIDStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDisplayVariantError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DisplayVariantError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDisplayVariantError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDisplayVariantError: user specific code start
   // lcmccadbusgw_ClientSpmonDisplayVariantError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDisplayVariantStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DisplayVariantStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDisplayVariantStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDisplayVariantValue(status->getDisplayVariantNumber());

   // lcmccadbusgw_ClientSpmonDisplayVariantStart: user specific code start
   // lcmccadbusgw_ClientSpmonDisplayVariantStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onReductionLevelError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ReductionLevelError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onReductionLevelError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonReductionLevelError: user specific code start
   // lcmccadbusgw_ClientSpmonReductionLevelError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onReductionLevelStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ReductionLevelStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onReductionLevelStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setReductionLevelValue(oConvertCcaToDbus_T_SPM_e32_REDUCTION_LEVEL(status->getReductionLevelState()));

   // lcmccadbusgw_ClientSpmonReductionLevelStart: user specific code start
   // lcmccadbusgw_ClientSpmonReductionLevelStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StartupStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStartupStateError: user specific code start
   // lcmccadbusgw_ClientSpmonStartupStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartupStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StartupStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartupStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setStartupStateValue(oConvertCcaToDbus_T_SPM_e32_STARTUP_STATE(status->getStartupState()));

   // lcmccadbusgw_ClientSpmonStartupStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonStartupStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onEntertainMuteError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <EntertainMuteError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEntertainMuteError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonEntertainMuteError: user specific code start
   // lcmccadbusgw_ClientSpmonEntertainMuteError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onEntertainMuteStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <EntertainMuteStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEntertainMuteStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setEntertainMuteValue(status->getBMuteState());

   // lcmccadbusgw_ClientSpmonEntertainMuteStart: user specific code start
   // lcmccadbusgw_ClientSpmonEntertainMuteStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWelcomeAudioStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <WelcomeAudioStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWelcomeAudioStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonWelcomeAudioStateError: user specific code start
   // lcmccadbusgw_ClientSpmonWelcomeAudioStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWelcomeAudioStateStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <WelcomeAudioStateStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWelcomeAudioStateStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setWelcomeAudioStateValue(status->getBEnabled());

   // lcmccadbusgw_ClientSpmonWelcomeAudioStateStart: user specific code start
   // lcmccadbusgw_ClientSpmonWelcomeAudioStateStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnballastTimeFromEngineStoppedError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <UnballastTimeFromEngineStoppedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnballastTimeFromEngineStoppedError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonUnballastTimeFromEngineStoppedError: user specific code start
   // lcmccadbusgw_ClientSpmonUnballastTimeFromEngineStoppedError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnballastTimeFromEngineStoppedStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <UnballastTimeFromEngineStoppedStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnballastTimeFromEngineStoppedStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setUnballastTimeFromEngineStoppedValue(status->getU32TimeFromEngineStopped());

   // lcmccadbusgw_ClientSpmonUnballastTimeFromEngineStoppedStart: user specific code start
   // lcmccadbusgw_ClientSpmonUnballastTimeFromEngineStoppedStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnballastTimeBeforeUnballastError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <UnballastTimeBeforeUnballastError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnballastTimeBeforeUnballastError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonUnballastTimeBeforeUnballastError: user specific code start
   // lcmccadbusgw_ClientSpmonUnballastTimeBeforeUnballastError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnballastTimeBeforeUnballastStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <UnballastTimeBeforeUnballastStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnballastTimeBeforeUnballastStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setUnballastTimeBeforeUnballastValue(status->getU32UnballastTime());

   // lcmccadbusgw_ClientSpmonUnballastTimeBeforeUnballastStart: user specific code start
   // lcmccadbusgw_ClientSpmonUnballastTimeBeforeUnballastStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnballastWarningTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <UnballastWarningTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnballastWarningTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonUnballastWarningTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonUnballastWarningTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUnballastWarningTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <UnballastWarningTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUnballastWarningTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setUnballastWarningTimeValue(status->getU32UnballastWarningTime());

   // lcmccadbusgw_ClientSpmonUnballastWarningTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonUnballastWarningTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDegradedCountError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DegradedCountError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDegradedCountError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDegradedCountError: user specific code start
   // lcmccadbusgw_ClientSpmonDegradedCountError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDegradedCountStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DegradedCountStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDegradedCountStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDegradedCountValue(status->getU32DegradedCount());

   // lcmccadbusgw_ClientSpmonDegradedCountStart: user specific code start
   // lcmccadbusgw_ClientSpmonDegradedCountStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDegradedTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DegradedTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDegradedTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDegradedTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonDegradedTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDegradedTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DegradedTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDegradedTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setDegradedTimeValue(status->getU32DegradedTime());

   // lcmccadbusgw_ClientSpmonDegradedTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonDegradedTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPhoneHandoverWarnTimeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <PhoneHandoverWarnTimeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPhoneHandoverWarnTimeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonPhoneHandoverWarnTimeError: user specific code start
   // lcmccadbusgw_ClientSpmonPhoneHandoverWarnTimeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPhoneHandoverWarnTimeStatus(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <PhoneHandoverWarnTimeStatus>& status){
   (tVoid)proxy;
   (tVoid)status;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPhoneHandoverWarnTimeStatus(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   if (poDbusSrv) poDbusSrv->setPhoneHandoverWarnTimeValue(status->getU32Time());

   // lcmccadbusgw_ClientSpmonPhoneHandoverWarnTimeStart: user specific code start
   // lcmccadbusgw_ClientSpmonPhoneHandoverWarnTimeStart: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemModeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SystemModeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemModeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSystemModeError: user specific code start
   // lcmccadbusgw_ClientSpmonSystemModeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSystemModeResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SystemModeResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSystemModeResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actSystemModeResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actSystemModeQueue.size() != 0){
         actSystemModeResult = poDbusSrv->actSystemModeQueue.front();
         poDbusSrv->actSystemModeQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actSystemModeQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendSystemModeResp(oResp, actSystemModeResult);

   // lcmccadbusgw_ClientSpmonSystemModeResult: user specific code start
   // lcmccadbusgw_ClientSpmonSystemModeResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onDownloadLockStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <DownloadLockStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDownloadLockStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonDownloadLockStateError: user specific code start
   // lcmccadbusgw_ClientSpmonDownloadLockStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onDownloadLockStateResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <DownloadLockStateResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onDownloadLockStateResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actDownloadLockStateResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actDownloadLockStateQueue.size() != 0){
         actDownloadLockStateResult = poDbusSrv->actDownloadLockStateQueue.front();
         poDbusSrv->actDownloadLockStateQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actDownloadLockStateQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendDownloadLockStateResp(oResp, actDownloadLockStateResult);

   // lcmccadbusgw_ClientSpmonDownloadLockStateResult: user specific code start
   // lcmccadbusgw_ClientSpmonDownloadLockStateResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onUpdateLockError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <UpdateLockError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUpdateLockError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonUpdateLockError: user specific code start
   // lcmccadbusgw_ClientSpmonUpdateLockError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onUpdateLockResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <UpdateLockResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onUpdateLockResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actUpdateLockResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actUpdateLockQueue.size() != 0){
         actUpdateLockResult = poDbusSrv->actUpdateLockQueue.front();
         poDbusSrv->actUpdateLockQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actUpdateLockQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendUpdateLockResp(oResp, actUpdateLockResult);

   // lcmccadbusgw_ClientSpmonUpdateLockResult: user specific code start
   // lcmccadbusgw_ClientSpmonUpdateLockResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onOnOffTriggerError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <OnOffTriggerError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onOnOffTriggerError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonOnOffTriggerError: user specific code start
   // lcmccadbusgw_ClientSpmonOnOffTriggerError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onOnOffTriggerResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <OnOffTriggerResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onOnOffTriggerResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actOnOffTriggerResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actOnOffTriggerQueue.size() != 0){
         actOnOffTriggerResult = poDbusSrv->actOnOffTriggerQueue.front();
         poDbusSrv->actOnOffTriggerQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actOnOffTriggerQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendOnOffTriggerResp(s32Resp, actOnOffTriggerResult);

   // lcmccadbusgw_ClientSpmonOnOffTriggerResult: user specific code start
   // lcmccadbusgw_ClientSpmonOnOffTriggerResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onStartProcessError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StartProcessError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartProcessError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStartProcessError: user specific code start
   // lcmccadbusgw_ClientSpmonStartProcessError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartProcessResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StartProcessResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartProcessResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actStartProcessResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actStartProcessQueue.size() != 0){
         actStartProcessResult = poDbusSrv->actStartProcessQueue.front();
         poDbusSrv->actStartProcessQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actStartProcessQueue size is not valid" ) );
      }
   }
   tS32 oRespS32ReturnVal = result->getS32ReturnVal();
   ::std::string oRespStrLocation = result->getStrLocation();
   tU32 oRespU32ProcId = result->getU32ProcId();
   tU32 oRespU32SpawnDuration = result->getU32SpawnDuration();
   if (poDbusSrv) poDbusSrv->sendStartProcessResp(
                               oRespS32ReturnVal, 
                               oRespStrLocation, 
                               oRespU32ProcId, 
                               oRespU32SpawnDuration, actStartProcessResult);

   // lcmccadbusgw_ClientSpmonStartProcessResult: user specific code start
   // lcmccadbusgw_ClientSpmonStartProcessResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onStopProcessError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StopProcessError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStopProcessError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStopProcessError: user specific code start
   // lcmccadbusgw_ClientSpmonStopProcessError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStopProcessResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StopProcessResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStopProcessResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actStopProcessResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actStopProcessQueue.size() != 0){
         actStopProcessResult = poDbusSrv->actStopProcessQueue.front();
         poDbusSrv->actStopProcessQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actStopProcessQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendStopProcessResp(oResp, actStopProcessResult);

   // lcmccadbusgw_ClientSpmonStopProcessResult: user specific code start
   // lcmccadbusgw_ClientSpmonStopProcessResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onRestartProcessError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <RestartProcessError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRestartProcessError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonRestartProcessError: user specific code start
   // lcmccadbusgw_ClientSpmonRestartProcessError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRestartProcessResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <RestartProcessResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRestartProcessResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actRestartProcessResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actRestartProcessQueue.size() != 0){
         actRestartProcessResult = poDbusSrv->actRestartProcessQueue.front();
         poDbusSrv->actRestartProcessQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actRestartProcessQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendRestartProcessResp(oResp, actRestartProcessResult);

   // lcmccadbusgw_ClientSpmonRestartProcessResult: user specific code start
   // lcmccadbusgw_ClientSpmonRestartProcessResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onStartUpSyncPointReachedError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <StartUpSyncPointReachedError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartUpSyncPointReachedError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonStartUpSyncPointReachedError: user specific code start
   // lcmccadbusgw_ClientSpmonStartUpSyncPointReachedError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onStartUpSyncPointReachedResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <StartUpSyncPointReachedResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onStartUpSyncPointReachedResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actStartUpSyncPointReachedResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actStartUpSyncPointReachedQueue.size() != 0){
         actStartUpSyncPointReachedResult = poDbusSrv->actStartUpSyncPointReachedQueue.front();
         poDbusSrv->actStartUpSyncPointReachedQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actStartUpSyncPointReachedQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendStartUpSyncPointReachedResp(s32Resp, actStartUpSyncPointReachedResult);

   // lcmccadbusgw_ClientSpmonStartUpSyncPointReachedResult: user specific code start
   // lcmccadbusgw_ClientSpmonStartUpSyncPointReachedResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onClearListError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ClearListError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onClearListError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonClearListError: user specific code start
   // lcmccadbusgw_ClientSpmonClearListError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onClearListResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ClearListResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onClearListResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actClearListResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actClearListQueue.size() != 0){
         actClearListResult = poDbusSrv->actClearListQueue.front();
         poDbusSrv->actClearListQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actClearListQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendClearListResp(s32Resp, actClearListResult);

   // lcmccadbusgw_ClientSpmonClearListResult: user specific code start
   // lcmccadbusgw_ClientSpmonClearListResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onRestartSystemError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <RestartSystemError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRestartSystemError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonRestartSystemError: user specific code start
   // lcmccadbusgw_ClientSpmonRestartSystemError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onRestartSystemResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <RestartSystemResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onRestartSystemResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actRestartSystemResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actRestartSystemQueue.size() != 0){
         actRestartSystemResult = poDbusSrv->actRestartSystemQueue.front();
         poDbusSrv->actRestartSystemQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actRestartSystemQueue size is not valid" ) );
      }
   }
   ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_SPM_e32_MRESULT oResp = oConvertCcaToDbus_T_SPM_e32_MRESULT(result->getE32ReturnVal());
   if (poDbusSrv) poDbusSrv->sendRestartSystemResp(oResp, actRestartSystemResult);

   // lcmccadbusgw_ClientSpmonRestartSystemResult: user specific code start
   // lcmccadbusgw_ClientSpmonRestartSystemResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onAudioSourceChangeError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <AudioSourceChangeError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAudioSourceChangeError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonAudioSourceChangeError: user specific code start
   // lcmccadbusgw_ClientSpmonAudioSourceChangeError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onAudioSourceChangeResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <AudioSourceChangeResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onAudioSourceChangeResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actAudioSourceChangeResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actAudioSourceChangeQueue.size() != 0){
         actAudioSourceChangeResult = poDbusSrv->actAudioSourceChangeQueue.front();
         poDbusSrv->actAudioSourceChangeQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actAudioSourceChangeQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendAudioSourceChangeResp(s32Resp, actAudioSourceChangeResult);

   // lcmccadbusgw_ClientSpmonAudioSourceChangeResult: user specific code start
   // lcmccadbusgw_ClientSpmonAudioSourceChangeResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onChangeBluetoothStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ChangeBluetoothStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeBluetoothStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonChangeBluetoothStateError: user specific code start
   // lcmccadbusgw_ClientSpmonChangeBluetoothStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onChangeBluetoothStateResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ChangeBluetoothStateResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeBluetoothStateResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actChangeBluetoothStateResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actChangeBluetoothStateQueue.size() != 0){
         actChangeBluetoothStateResult = poDbusSrv->actChangeBluetoothStateQueue.front();
         poDbusSrv->actChangeBluetoothStateQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actChangeBluetoothStateQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendChangeBluetoothStateResp(s32Resp, actChangeBluetoothStateResult);

   // lcmccadbusgw_ClientSpmonChangeBluetoothStateResult: user specific code start
   // lcmccadbusgw_ClientSpmonChangeBluetoothStateResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onChangeAudioStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ChangeAudioStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeAudioStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonChangeAudioStateError: user specific code start
   // lcmccadbusgw_ClientSpmonChangeAudioStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onChangeAudioStateResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ChangeAudioStateResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeAudioStateResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actChangeAudioStateResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actChangeAudioStateQueue.size() != 0){
         actChangeAudioStateResult = poDbusSrv->actChangeAudioStateQueue.front();
         poDbusSrv->actChangeAudioStateQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actChangeAudioStateQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendChangeAudioStateResp(s32Resp, actChangeAudioStateResult);

   // lcmccadbusgw_ClientSpmonChangeAudioStateResult: user specific code start
   // lcmccadbusgw_ClientSpmonChangeAudioStateResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onChangeSpiStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ChangeSpiStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeSpiStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonChangeSpiStateError: user specific code start
   // lcmccadbusgw_ClientSpmonChangeSpiStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onChangeSpiStateResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ChangeSpiStateResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeSpiStateResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actChangeSpiStateResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actChangeSpiStateQueue.size() != 0){
         actChangeSpiStateResult = poDbusSrv->actChangeSpiStateQueue.front();
         poDbusSrv->actChangeSpiStateQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actChangeSpiStateQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendChangeSpiStateResp(s32Resp, actChangeSpiStateResult);

   // lcmccadbusgw_ClientSpmonChangeSpiStateResult: user specific code start
   // lcmccadbusgw_ClientSpmonChangeSpiStateResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onChangeTunerStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ChangeTunerStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeTunerStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonChangeTunerStateError: user specific code start
   // lcmccadbusgw_ClientSpmonChangeTunerStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onChangeTunerStateResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ChangeTunerStateResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeTunerStateResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actChangeTunerStateResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actChangeTunerStateQueue.size() != 0){
         actChangeTunerStateResult = poDbusSrv->actChangeTunerStateQueue.front();
         poDbusSrv->actChangeTunerStateQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actChangeTunerStateQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendChangeTunerStateResp(s32Resp, actChangeTunerStateResult);

   // lcmccadbusgw_ClientSpmonChangeTunerStateResult: user specific code start
   // lcmccadbusgw_ClientSpmonChangeTunerStateResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onChangeWifiStateError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ChangeWifiStateError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeWifiStateError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonChangeWifiStateError: user specific code start
   // lcmccadbusgw_ClientSpmonChangeWifiStateError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onChangeWifiStateResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ChangeWifiStateResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onChangeWifiStateResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actChangeWifiStateResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actChangeWifiStateQueue.size() != 0){
         actChangeWifiStateResult = poDbusSrv->actChangeWifiStateQueue.front();
         poDbusSrv->actChangeWifiStateQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actChangeWifiStateQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendChangeWifiStateResp(s32Resp, actChangeWifiStateResult);

   // lcmccadbusgw_ClientSpmonChangeWifiStateResult: user specific code start
   // lcmccadbusgw_ClientSpmonChangeWifiStateResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onShutdownAndTerminateCcaAppsError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ShutdownAndTerminateCcaAppsError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onShutdownAndTerminateCcaAppsError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonShutdownAndTerminateCcaAppsError: user specific code start
   // lcmccadbusgw_ClientSpmonShutdownAndTerminateCcaAppsError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onShutdownAndTerminateCcaAppsResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ShutdownAndTerminateCcaAppsResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onShutdownAndTerminateCcaAppsResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actShutdownAndTerminateCcaAppsResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actShutdownAndTerminateCcaAppsQueue.size() != 0){
         actShutdownAndTerminateCcaAppsResult = poDbusSrv->actShutdownAndTerminateCcaAppsQueue.front();
         poDbusSrv->actShutdownAndTerminateCcaAppsQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actShutdownAndTerminateCcaAppsQueue size is not valid" ) );
      }
   }
   tS32 s32Resp = 0;
   if (poDbusSrv) poDbusSrv->sendShutdownAndTerminateCcaAppsResp(s32Resp, actShutdownAndTerminateCcaAppsResult);

   // lcmccadbusgw_ClientSpmonShutdownAndTerminateCcaAppsResult: user specific code start
   // lcmccadbusgw_ClientSpmonShutdownAndTerminateCcaAppsResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onSetFactorySettingsNewError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SetFactorySettingsNewError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSetFactorySettingsNewError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSetFactorySettingsNewError: user specific code start
   // lcmccadbusgw_ClientSpmonSetFactorySettingsNewError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSetFactorySettingsNewResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SetFactorySettingsNewResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSetFactorySettingsNewResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actSetFactorySettingsNewResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actSetFactorySettingsNewQueue.size() != 0){
         actSetFactorySettingsNewResult = poDbusSrv->actSetFactorySettingsNewQueue.front();
         poDbusSrv->actSetFactorySettingsNewQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actSetFactorySettingsNewQueue size is not valid" ) );
      }
   }
   ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_e8_DiaglogDefsetType oRespDefSetStateGroup = oConvertCcaToDbus_T_e8_DiaglogDefsetType(result->getDefSetStateGroup());
   ::org::bosch::cm::lcm_dbus_fi::lcm_dbus_fi_service::T_e8_DefSetMode oRespDefSetStateMode = oConvertCcaToDbus_T_e8_DefSetMode(result->getDefSetStateMode());
   tBool oRespDefSetStateSuccessful = result->getDefSetStateSuccessful();
   tU16 oRespDefSetStateFirstDifferentParameterId = result->getDefSetStateFirstDifferentParameterId();
   if (poDbusSrv) poDbusSrv->sendSetFactorySettingsNewResp(
                               oRespDefSetStateGroup, 
                               oRespDefSetStateMode, 
                               oRespDefSetStateSuccessful, 
                               oRespDefSetStateFirstDifferentParameterId, actSetFactorySettingsNewResult);

   // lcmccadbusgw_ClientSpmonSetFactorySettingsNewResult: user specific code start
   // lcmccadbusgw_ClientSpmonSetFactorySettingsNewResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onClearVINError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <ClearVINError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onClearVINError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonClearVINError: user specific code start
   // lcmccadbusgw_ClientSpmonClearVINError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onClearVINResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <ClearVINResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onClearVINResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actClearVINResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actClearVINQueue.size() != 0){
         actClearVINResult = poDbusSrv->actClearVINQueue.front();
         poDbusSrv->actClearVINQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actClearVINQueue size is not valid" ) );
      }
   }
   tU32 oResp = result->getResult();
   if (poDbusSrv) poDbusSrv->sendClearVINResp(oResp, actClearVINResult);

   // lcmccadbusgw_ClientSpmonClearVINResult: user specific code start
   // lcmccadbusgw_ClientSpmonClearVINResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onPrepareDownloadError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <PrepareDownloadError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPrepareDownloadError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonPrepareDownloadError: user specific code start
   // lcmccadbusgw_ClientSpmonPrepareDownloadError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onPrepareDownloadResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <PrepareDownloadResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onPrepareDownloadResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actPrepareDownloadResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actPrepareDownloadQueue.size() != 0){
         actPrepareDownloadResult = poDbusSrv->actPrepareDownloadQueue.front();
         poDbusSrv->actPrepareDownloadQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actPrepareDownloadQueue size is not valid" ) );
      }
   }
   tU32 oResp = result->getResult();
   if (poDbusSrv) poDbusSrv->sendPrepareDownloadResp(oResp, actPrepareDownloadResult);

   // lcmccadbusgw_ClientSpmonPrepareDownloadResult: user specific code start
   // lcmccadbusgw_ClientSpmonPrepareDownloadResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onEndDownloadError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <EndDownloadError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEndDownloadError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonEndDownloadError: user specific code start
   // lcmccadbusgw_ClientSpmonEndDownloadError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onEndDownloadResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <EndDownloadResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEndDownloadResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actEndDownloadResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actEndDownloadQueue.size() != 0){
         actEndDownloadResult = poDbusSrv->actEndDownloadQueue.front();
         poDbusSrv->actEndDownloadQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actEndDownloadQueue size is not valid" ) );
      }
   }
   tU32 oResp = result->getResult();
   if (poDbusSrv) poDbusSrv->sendEndDownloadResp(oResp, actEndDownloadResult);

   // lcmccadbusgw_ClientSpmonEndDownloadResult: user specific code start
   // lcmccadbusgw_ClientSpmonEndDownloadResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onSetOnConfigurationError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SetOnConfigurationError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSetOnConfigurationError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSetOnConfigurationError: user specific code start
   // lcmccadbusgw_ClientSpmonSetOnConfigurationError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSetOnConfigurationResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SetOnConfigurationResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSetOnConfigurationResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actSetOnConfigurationResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actSetOnConfigurationQueue.size() != 0){
         actSetOnConfigurationResult = poDbusSrv->actSetOnConfigurationQueue.front();
         poDbusSrv->actSetOnConfigurationQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actSetOnConfigurationQueue size is not valid" ) );
      }
   }
   tU32 oResp = result->getResult();
   if (poDbusSrv) poDbusSrv->sendSetOnConfigurationResp(oResp, actSetOnConfigurationResult);

   // lcmccadbusgw_ClientSpmonSetOnConfigurationResult: user specific code start
   // lcmccadbusgw_ClientSpmonSetOnConfigurationResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onSetProcessConfigurationError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <SetProcessConfigurationError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSetProcessConfigurationError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonSetProcessConfigurationError: user specific code start
   // lcmccadbusgw_ClientSpmonSetProcessConfigurationError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onSetProcessConfigurationResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <SetProcessConfigurationResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onSetProcessConfigurationResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actSetProcessConfigurationResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actSetProcessConfigurationQueue.size() != 0){
         actSetProcessConfigurationResult = poDbusSrv->actSetProcessConfigurationQueue.front();
         poDbusSrv->actSetProcessConfigurationQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actSetProcessConfigurationQueue size is not valid" ) );
      }
   }
   tU32 oResp = result->getResult();
   if (poDbusSrv) poDbusSrv->sendSetProcessConfigurationResp(oResp, actSetProcessConfigurationResult);

   // lcmccadbusgw_ClientSpmonSetProcessConfigurationResult: user specific code start
   // lcmccadbusgw_ClientSpmonSetProcessConfigurationResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onEntertainDeMuteError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <EntertainDeMuteError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEntertainDeMuteError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonEntertainDeMuteError: user specific code start
   // lcmccadbusgw_ClientSpmonEntertainDeMuteError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onEntertainDeMuteResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <EntertainDeMuteResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEntertainDeMuteResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actEntertainDeMuteResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actEntertainDeMuteQueue.size() != 0){
         actEntertainDeMuteResult = poDbusSrv->actEntertainDeMuteQueue.front();
         poDbusSrv->actEntertainDeMuteQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actEntertainDeMuteQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendEntertainDeMuteResp(oResp, actEntertainDeMuteResult);

   // lcmccadbusgw_ClientSpmonEntertainDeMuteResult: user specific code start
   // lcmccadbusgw_ClientSpmonEntertainDeMuteResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onEntertainMuteRequestError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <EntertainMuteRequestError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEntertainMuteRequestError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonEntertainMuteRequestError: user specific code start
   // lcmccadbusgw_ClientSpmonEntertainMuteRequestError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onEntertainMuteRequestResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <EntertainMuteRequestResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onEntertainMuteRequestResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actEntertainMuteRequestResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actEntertainMuteRequestQueue.size() != 0){
         actEntertainMuteRequestResult = poDbusSrv->actEntertainMuteRequestQueue.front();
         poDbusSrv->actEntertainMuteRequestQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actEntertainMuteRequestQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendEntertainMuteRequestResp(oResp, actEntertainMuteRequestResult);

   // lcmccadbusgw_ClientSpmonEntertainMuteRequestResult: user specific code start
   // lcmccadbusgw_ClientSpmonEntertainMuteRequestResult: user specific code end
}
void lcmccadbusgw_tclClientSpm::onWelcomeAudioActivationError(const::boost::shared_ptr <SPM_CORE_FIProxy>  & proxy, const boost::shared_ptr <WelcomeAudioActivationError>& error){
   (tVoid)proxy;
   (tVoid)error;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWelcomeAudioActivationError(): CALLED" ) );
   // lcmccadbusgw_ClientSpmonWelcomeAudioActivationError: user specific code start
   // lcmccadbusgw_ClientSpmonWelcomeAudioActivationError: user specific code end
}

void lcmccadbusgw_tclClientSpm::onWelcomeAudioActivationResult(const::boost::shared_ptr <SPM_CORE_FIProxy> & proxy, const boost::shared_ptr <WelcomeAudioActivationResult>& result){
   (tVoid)proxy;
   (tVoid)result;
   ETG_TRACE_USR1( ( "lcmccadbusgw_tclClientSpm::onWelcomeAudioActivationResult(): CALLED" ) );

   Ilcmccadbusgw_tclServerLcmDbusFi* poDbusSrv = dynamic_cast<Ilcmccadbusgw_tclServerLcmDbusFi*>(_cpoMain->getHandler("Ilcmccadbusgw_tclServerLcmDbusFi"));
   act_t actWelcomeAudioActivationResult = 0;
   if (poDbusSrv){
      if (poDbusSrv->actWelcomeAudioActivationQueue.size() != 0){
         actWelcomeAudioActivationResult = poDbusSrv->actWelcomeAudioActivationQueue.front();
         poDbusSrv->actWelcomeAudioActivationQueue.pop();
      } else {
         ETG_TRACE_ERRMEM( ( "actWelcomeAudioActivationQueue size is not valid" ) );
      }
   }
   tS32 oResp = result->getS32ReturnVal();
   if (poDbusSrv) poDbusSrv->sendWelcomeAudioActivationResp(oResp, actWelcomeAudioActivationResult);

   // lcmccadbusgw_ClientSpmonWelcomeAudioActivationResult: user specific code start
   // lcmccadbusgw_ClientSpmonWelcomeAudioActivationResult: user specific code end
}

tVoid lcmccadbusgw_tclClientSpm::vHandleMessage(lcmccadbusgw_tclBaseIf::TMsg* pMsg) {
   // lcmccadbusgw_ClientSpmvHandleMessage: user specific code start
   (tVoid)pMsg;
   // lcmccadbusgw_ClientSpmvHandleMessage: user specific code end
}

tVoid lcmccadbusgw_tclClientSpm::vGetReferences() {
   // lcmccadbusgw_ClientSpmvGetReferences: user specific code start
   // lcmccadbusgw_ClientSpmvGetReferences: user specific code end
}

tVoid lcmccadbusgw_tclClientSpm::vStartCommunication() {
   // lcmccadbusgw_ClientSpmvStartCommunication: user specific code start
   // lcmccadbusgw_ClientSpmvStartCommunication: user specific code end
}

tVoid lcmccadbusgw_tclClientSpm::vTraceInfo() {
   // lcmccadbusgw_ClientSpmvTraceInfo: user specific code start
   // lcmccadbusgw_ClientSpmvTraceInfo: user specific code end
}

tVoid lcmccadbusgw_tclClientSpm::sendSystemStateGet() {
    // lcmccadbusgw_tclClientSpm::sendSystemStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSystemStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSystemStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDownloadLockStatesGet() {
    // lcmccadbusgw_tclClientSpm::sendDownloadLockStatesGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDownloadLockStatesGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDownloadLockStatesGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDownloadLockStatesGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDownloadLockStatesGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUpdateLockStatesGet() {
    // lcmccadbusgw_tclClientSpm::sendUpdateLockStatesGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUpdateLockStatesGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUpdateLockStatesGet(* this);

    // lcmccadbusgw_tclClientSpm::sendUpdateLockStatesGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUpdateLockStatesGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendActiveOnOffTriggerGet() {
    // lcmccadbusgw_tclClientSpm::sendActiveOnOffTriggerGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendActiveOnOffTriggerGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendActiveOnOffTriggerGet(* this);

    // lcmccadbusgw_tclClientSpm::sendActiveOnOffTriggerGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendActiveOnOffTriggerGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSubStatesSet(::spm_core_fi_types::T_SPM_e32_SubStateType subStateType, tBool subStateData) {
    // lcmccadbusgw_tclClientSpm::sendSubStatesSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSubStatesSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSubStatesSet(* this, subStateType, subStateData);

    // lcmccadbusgw_tclClientSpm::sendSubStatesSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSubStatesSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSubStatesGet() {
    // lcmccadbusgw_tclClientSpm::sendSubStatesGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSubStatesGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSubStatesGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSubStatesGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSubStatesGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendHistoryTriggerGet() {
    // lcmccadbusgw_tclClientSpm::sendHistoryTriggerGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendHistoryTriggerGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendHistoryTriggerGet(* this);

    // lcmccadbusgw_tclClientSpm::sendHistoryTriggerGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendHistoryTriggerGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendInsertStateGet() {
    // lcmccadbusgw_tclClientSpm::sendInsertStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendInsertStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendInsertStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendInsertStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendInsertStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendMediaEjectStateGet() {
    // lcmccadbusgw_tclClientSpm::sendMediaEjectStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMediaEjectStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendMediaEjectStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendMediaEjectStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMediaEjectStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPhoneMuteStateGet() {
    // lcmccadbusgw_tclClientSpm::sendPhoneMuteStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPhoneMuteStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPhoneMuteStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendPhoneMuteStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPhoneMuteStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendOnTipperStateGet() {
    // lcmccadbusgw_tclClientSpm::sendOnTipperStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnTipperStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendOnTipperStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendOnTipperStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnTipperStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendIgnitionCyclesGet() {
    // lcmccadbusgw_tclClientSpm::sendIgnitionCyclesGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendIgnitionCyclesGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendIgnitionCyclesGet(* this);

    // lcmccadbusgw_tclClientSpm::sendIgnitionCyclesGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendIgnitionCyclesGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSysPwrModeGet() {
    // lcmccadbusgw_tclClientSpm::sendSysPwrModeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSysPwrModeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSysPwrModeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSysPwrModeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSysPwrModeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSysPwrSaveModeGet() {
    // lcmccadbusgw_tclClientSpm::sendSysPwrSaveModeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSysPwrSaveModeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSysPwrSaveModeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSysPwrSaveModeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSysPwrSaveModeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendMapDownloadLockStateGet() {
    // lcmccadbusgw_tclClientSpm::sendMapDownloadLockStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMapDownloadLockStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendMapDownloadLockStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendMapDownloadLockStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMapDownloadLockStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStandbyTimeSet(tU32 standbyTime) {
    // lcmccadbusgw_tclClientSpm::sendStandbyTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStandbyTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStandbyTimeSet(* this, standbyTime);

    // lcmccadbusgw_tclClientSpm::sendStandbyTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStandbyTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStandbyTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendStandbyTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStandbyTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStandbyTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendStandbyTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStandbyTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeSet(tU32 persitentStandbyTime) {
    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPersitentStandbyTimeSet(* this, persitentStandbyTime);

    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPersitentStandbyTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPersitentStandbyTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeSet(tU32 ignitionOffTime) {
    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendIgnitionOffTimeSet(* this, ignitionOffTime);

    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendIgnitionOffTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendIgnitionOffTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDoorOpenTimeSet(tU32 doorOpenTime) {
    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDoorOpenTimeSet(* this, doorOpenTime);

    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDoorOpenTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDoorOpenTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDoorOpenTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendClockDisplayTimeSet(tU32 clockDisplayTime) {
    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendClockDisplayTimeSet(* this, clockDisplayTime);

    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendClockDisplayTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendClockDisplayTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClockDisplayTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSystemStateTimeGet(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState) {
    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSystemStateTimeGet(* this, tSystemState);

    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSystemStateTimeSet(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState, tU32 tStateTimerValue) {
    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSystemStateTimeSet(* this, tSystemState, tStateTimerValue);

    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemStateTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendProcessListGet() {
    // lcmccadbusgw_tclClientSpm::sendProcessListGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendProcessListGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendProcessListGet(* this);

    // lcmccadbusgw_tclClientSpm::sendProcessListGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendProcessListGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWakeupReasonGet() {
    // lcmccadbusgw_tclClientSpm::sendWakeupReasonGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupReasonGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWakeupReasonGet(* this);

    // lcmccadbusgw_tclClientSpm::sendWakeupReasonGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupReasonGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStartupReasonGet() {
    // lcmccadbusgw_tclClientSpm::sendStartupReasonGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupReasonGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStartupReasonGet(* this);

    // lcmccadbusgw_tclClientSpm::sendStartupReasonGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupReasonGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendConnectToBatteryGet() {
    // lcmccadbusgw_tclClientSpm::sendConnectToBatteryGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendConnectToBatteryGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendConnectToBatteryGet(* this);

    // lcmccadbusgw_tclClientSpm::sendConnectToBatteryGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendConnectToBatteryGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCodeRequestStateSet(::spm_core_fi_types::T_SPM_e32_CODE_REQUEST codeRequestState) {
    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCodeRequestStateSet(* this, codeRequestState);

    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCodeRequestStateGet() {
    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCodeRequestStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCodeRequestStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendActiveStartUpSyncPointsGet() {
    // lcmccadbusgw_tclClientSpm::sendActiveStartUpSyncPointsGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendActiveStartUpSyncPointsGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendActiveStartUpSyncPointsGet(* this);

    // lcmccadbusgw_tclClientSpm::sendActiveStartUpSyncPointsGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendActiveStartUpSyncPointsGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCvmEventGet() {
    // lcmccadbusgw_tclClientSpm::sendCvmEventGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCvmEventGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCvmEventGet(* this);

    // lcmccadbusgw_tclClientSpm::sendCvmEventGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCvmEventGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUBatSenseGet() {
    // lcmccadbusgw_tclClientSpm::sendUBatSenseGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUBatSenseGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUBatSenseGet(* this);

    // lcmccadbusgw_tclClientSpm::sendUBatSenseGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUBatSenseGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCoproStateSet(::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE coproState) {
    // lcmccadbusgw_tclClientSpm::sendCoproStateSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCoproStateSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCoproStateSet(* this, coproState);

    // lcmccadbusgw_tclClientSpm::sendCoproStateSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCoproStateSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCoproStateGet() {
    // lcmccadbusgw_tclClientSpm::sendCoproStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCoproStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCoproStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendCoproStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCoproStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeSet(tU32 devicePowerOnTime) {
    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDevicePowerOnTimeSet(* this, devicePowerOnTime);

    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDevicePowerOnTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDevicePowerOnTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendLastSystemRuntimeGet() {
    // lcmccadbusgw_tclClientSpm::sendLastSystemRuntimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendLastSystemRuntimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendLastSystemRuntimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendLastSystemRuntimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendLastSystemRuntimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCurrentSystemRuntimeGet() {
    // lcmccadbusgw_tclClientSpm::sendCurrentSystemRuntimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCurrentSystemRuntimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCurrentSystemRuntimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendCurrentSystemRuntimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCurrentSystemRuntimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendResetListSet(tU32 resetResetList) {
    // lcmccadbusgw_tclClientSpm::sendResetListSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetListSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendResetListSet(* this, resetResetList);

    // lcmccadbusgw_tclClientSpm::sendResetListSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetListSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendResetListGet() {
    // lcmccadbusgw_tclClientSpm::sendResetListGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetListGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendResetListGet(* this);

    // lcmccadbusgw_tclClientSpm::sendResetListGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetListGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendResetCounterSet(tU32 resetCounter) {
    // lcmccadbusgw_tclClientSpm::sendResetCounterSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetCounterSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendResetCounterSet(* this, resetCounter);

    // lcmccadbusgw_tclClientSpm::sendResetCounterSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetCounterSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendResetCounterGet() {
    // lcmccadbusgw_tclClientSpm::sendResetCounterGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetCounterGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendResetCounterGet(* this);

    // lcmccadbusgw_tclClientSpm::sendResetCounterGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetCounterGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendTransportModeListSet(tU32 transPortList) {
    // lcmccadbusgw_tclClientSpm::sendTransportModeListSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTransportModeListSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendTransportModeListSet(* this, transPortList);

    // lcmccadbusgw_tclClientSpm::sendTransportModeListSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTransportModeListSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendTransportModeListGet() {
    // lcmccadbusgw_tclClientSpm::sendTransportModeListGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTransportModeListGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendTransportModeListGet(* this);

    // lcmccadbusgw_tclClientSpm::sendTransportModeListGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTransportModeListGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendResetHistorySet() {
    // lcmccadbusgw_tclClientSpm::sendResetHistorySet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetHistorySet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendResetHistorySet(* this);

    // lcmccadbusgw_tclClientSpm::sendResetHistorySetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetHistorySetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendResetHistoryGet() {
    // lcmccadbusgw_tclClientSpm::sendResetHistoryGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetHistoryGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendResetHistoryGet(* this);

    // lcmccadbusgw_tclClientSpm::sendResetHistoryGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendResetHistoryGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWakeupHistorySet() {
    // lcmccadbusgw_tclClientSpm::sendWakeupHistorySet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupHistorySet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWakeupHistorySet(* this);

    // lcmccadbusgw_tclClientSpm::sendWakeupHistorySetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupHistorySetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWakeupHistoryGet() {
    // lcmccadbusgw_tclClientSpm::sendWakeupHistoryGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupHistoryGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWakeupHistoryGet(* this);

    // lcmccadbusgw_tclClientSpm::sendWakeupHistoryGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupHistoryGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStateHistorySet() {
    // lcmccadbusgw_tclClientSpm::sendStateHistorySet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStateHistorySet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStateHistorySet(* this);

    // lcmccadbusgw_tclClientSpm::sendStateHistorySetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStateHistorySetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStateHistoryGet() {
    // lcmccadbusgw_tclClientSpm::sendStateHistoryGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStateHistoryGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStateHistoryGet(* this);

    // lcmccadbusgw_tclClientSpm::sendStateHistoryGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStateHistoryGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory01Set() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01Set: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01Set: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory01Set(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01SetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01SetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory01Get() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01Get: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01Get: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory01Get(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01GetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory01GetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory02Set() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02Set: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02Set: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory02Set(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02SetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02SetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory02Get() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02Get: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02Get: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory02Get(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02GetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory02GetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory03Set() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03Set: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03Set: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory03Set(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03SetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03SetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory03Get() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03Get: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03Get: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory03Get(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03GetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory03GetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory04Set() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04Set: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04Set: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory04Set(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04SetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04SetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory04Get() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04Get: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04Get: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory04Get(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04GetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory04GetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory05Set() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05Set: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05Set: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory05Set(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05SetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05SetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendErrStateHistory05Get() {
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05Get: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05Get: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendErrStateHistory05Get(* this);

    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05GetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendErrStateHistory05GetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSwitchOnHistorySet() {
    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistorySet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistorySet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSwitchOnHistorySet(* this);

    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistorySetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistorySetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSwitchOnHistoryGet() {
    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistoryGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistoryGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSwitchOnHistoryGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistoryGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSwitchOnHistoryGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDeviceOnCounterGet() {
    // lcmccadbusgw_tclClientSpm::sendDeviceOnCounterGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDeviceOnCounterGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDeviceOnCounterGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDeviceOnCounterGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDeviceOnCounterGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendVoltageEventCounterGet() {
    // lcmccadbusgw_tclClientSpm::sendVoltageEventCounterGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVoltageEventCounterGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendVoltageEventCounterGet(* this);

    // lcmccadbusgw_tclClientSpm::sendVoltageEventCounterGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVoltageEventCounterGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendVoltageRangeHistogramGet() {
    // lcmccadbusgw_tclClientSpm::sendVoltageRangeHistogramGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVoltageRangeHistogramGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendVoltageRangeHistogramGet(* this);

    // lcmccadbusgw_tclClientSpm::sendVoltageRangeHistogramGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVoltageRangeHistogramGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendCpuUsageStatisticGet() {
    // lcmccadbusgw_tclClientSpm::sendCpuUsageStatisticGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCpuUsageStatisticGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendCpuUsageStatisticGet(* this);

    // lcmccadbusgw_tclClientSpm::sendCpuUsageStatisticGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendCpuUsageStatisticGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRamUsageStatisticGet() {
    // lcmccadbusgw_tclClientSpm::sendRamUsageStatisticGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRamUsageStatisticGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRamUsageStatisticGet(* this);

    // lcmccadbusgw_tclClientSpm::sendRamUsageStatisticGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRamUsageStatisticGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStartupTimeStatisticGet() {
    // lcmccadbusgw_tclClientSpm::sendStartupTimeStatisticGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupTimeStatisticGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStartupTimeStatisticGet(* this);

    // lcmccadbusgw_tclClientSpm::sendStartupTimeStatisticGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupTimeStatisticGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRunlevelStateGet() {
    // lcmccadbusgw_tclClientSpm::sendRunlevelStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRunlevelStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRunlevelStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendRunlevelStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRunlevelStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRestartSet(::spm_core_fi_types::T_SPM_e32_RESTART_TYPE restart) {
    // lcmccadbusgw_tclClientSpm::sendRestartSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRestartSet(* this, restart);

    // lcmccadbusgw_tclClientSpm::sendRestartSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRestartGet() {
    // lcmccadbusgw_tclClientSpm::sendRestartGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRestartGet(* this);

    // lcmccadbusgw_tclClientSpm::sendRestartGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendLifesignGet() {
    // lcmccadbusgw_tclClientSpm::sendLifesignGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendLifesignGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendLifesignGet(* this);

    // lcmccadbusgw_tclClientSpm::sendLifesignGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendLifesignGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendHmiStateGet() {
    // lcmccadbusgw_tclClientSpm::sendHmiStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendHmiStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendHmiStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendHmiStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendHmiStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSystemPowerBehaviourGet() {
    // lcmccadbusgw_tclClientSpm::sendSystemPowerBehaviourGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemPowerBehaviourGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSystemPowerBehaviourGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSystemPowerBehaviourGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemPowerBehaviourGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDimStateGet() {
    // lcmccadbusgw_tclClientSpm::sendDimStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDimStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDimStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDimStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDimStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDimmingStateGet() {
    // lcmccadbusgw_tclClientSpm::sendDimmingStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDimmingStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDimmingStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDimmingStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDimmingStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendBluetoothStateGet() {
    // lcmccadbusgw_tclClientSpm::sendBluetoothStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendBluetoothStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendBluetoothStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendBluetoothStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendBluetoothStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendAudioStateGet() {
    // lcmccadbusgw_tclClientSpm::sendAudioStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAudioStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendAudioStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendAudioStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAudioStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSpiStateGet() {
    // lcmccadbusgw_tclClientSpm::sendSpiStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSpiStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSpiStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSpiStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSpiStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendTunerStateGet() {
    // lcmccadbusgw_tclClientSpm::sendTunerStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTunerStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendTunerStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendTunerStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTunerStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWifiStateGet() {
    // lcmccadbusgw_tclClientSpm::sendWifiStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWifiStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWifiStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendWifiStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWifiStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendOnOffReasonSet(::spm_core_fi_types::T_SPM_e32_OnOffReason onOffReason) {
    // lcmccadbusgw_tclClientSpm::sendOnOffReasonSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnOffReasonSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendOnOffReasonSet(* this, onOffReason);

    // lcmccadbusgw_tclClientSpm::sendOnOffReasonSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnOffReasonSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendOnOffReasonGet() {
    // lcmccadbusgw_tclClientSpm::sendOnOffReasonGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnOffReasonGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendOnOffReasonGet(* this);

    // lcmccadbusgw_tclClientSpm::sendOnOffReasonGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnOffReasonGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWakeupListSet(tU32 wakeupList) {
    // lcmccadbusgw_tclClientSpm::sendWakeupListSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupListSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWakeupListSet(* this, wakeupList);

    // lcmccadbusgw_tclClientSpm::sendWakeupListSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupListSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWakeupListGet() {
    // lcmccadbusgw_tclClientSpm::sendWakeupListGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupListGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWakeupListGet(* this);

    // lcmccadbusgw_tclClientSpm::sendWakeupListGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWakeupListGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStartupFinishedGet() {
    // lcmccadbusgw_tclClientSpm::sendStartupFinishedGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupFinishedGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStartupFinishedGet(* this);

    // lcmccadbusgw_tclClientSpm::sendStartupFinishedGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupFinishedGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSysStateGet() {
    // lcmccadbusgw_tclClientSpm::sendSysStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSysStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSysStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSysStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSysStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendMostStateGet() {
    // lcmccadbusgw_tclClientSpm::sendMostStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMostStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendMostStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendMostStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMostStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendMostVersionGet() {
    // lcmccadbusgw_tclClientSpm::sendMostVersionGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMostVersionGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendMostVersionGet(* this);

    // lcmccadbusgw_tclClientSpm::sendMostVersionGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendMostVersionGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRVCStateSet(tBool state) {
    // lcmccadbusgw_tclClientSpm::sendRVCStateSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRVCStateSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRVCStateSet(* this, state);

    // lcmccadbusgw_tclClientSpm::sendRVCStateSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRVCStateSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRVCStateGet() {
    // lcmccadbusgw_tclClientSpm::sendRVCStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRVCStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRVCStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendRVCStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRVCStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetGet() {
    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendTriggerMostRemoteResetGet(* this);

    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetSet() {
    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendTriggerMostRemoteResetSet(* this);

    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendTriggerMostRemoteResetSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPartnumberGet(const ::std::string& part) {
    // lcmccadbusgw_tclClientSpm::sendPartnumberGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPartnumberGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPartnumberGet(* this, part);

    // lcmccadbusgw_tclClientSpm::sendPartnumberGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPartnumberGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPartnumberSet(const ::std::string& part, tU32 number) {
    // lcmccadbusgw_tclClientSpm::sendPartnumberSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPartnumberSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPartnumberSet(* this, part, number);

    // lcmccadbusgw_tclClientSpm::sendPartnumberSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPartnumberSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPartnumbersGet() {
    // lcmccadbusgw_tclClientSpm::sendPartnumbersGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPartnumbersGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPartnumbersGet(* this);

    // lcmccadbusgw_tclClientSpm::sendPartnumbersGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPartnumbersGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendAlphacodeGet(const ::std::string& part) {
    // lcmccadbusgw_tclClientSpm::sendAlphacodeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAlphacodeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendAlphacodeGet(* this, part);

    // lcmccadbusgw_tclClientSpm::sendAlphacodeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAlphacodeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendAlphacodeSet(const ::std::string& part, tU8 alphacode1, tU8 alphacode2) {
    // lcmccadbusgw_tclClientSpm::sendAlphacodeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAlphacodeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendAlphacodeSet(* this, part, alphacode1, alphacode2);

    // lcmccadbusgw_tclClientSpm::sendAlphacodeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAlphacodeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendAlphacodesGet() {
    // lcmccadbusgw_tclClientSpm::sendAlphacodesGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAlphacodesGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendAlphacodesGet(* this);

    // lcmccadbusgw_tclClientSpm::sendAlphacodesGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAlphacodesGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterGet() {
    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendManufacturersEnableCounterGet(* this);

    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterSet(tU8 mEC) {
    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendManufacturersEnableCounterSet(* this, mEC);

    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendManufacturersEnableCounterSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendNoCalibrationStateGet() {
    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendNoCalibrationStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendNoCalibrationStateSet(tBool state) {
    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendNoCalibrationStateSet(* this, state);

    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendNoCalibrationStateSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSecurityCommErrorGet() {
    // lcmccadbusgw_tclClientSpm::sendSecurityCommErrorGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityCommErrorGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSecurityCommErrorGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSecurityCommErrorGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityCommErrorGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSecurityMoreThan10VinGet() {
    // lcmccadbusgw_tclClientSpm::sendSecurityMoreThan10VinGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityMoreThan10VinGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSecurityMoreThan10VinGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSecurityMoreThan10VinGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityMoreThan10VinGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSecurityInvalidVinGet() {
    // lcmccadbusgw_tclClientSpm::sendSecurityInvalidVinGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityInvalidVinGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSecurityInvalidVinGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSecurityInvalidVinGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityInvalidVinGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSecurityCurrentVinGet() {
    // lcmccadbusgw_tclClientSpm::sendSecurityCurrentVinGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityCurrentVinGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSecurityCurrentVinGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSecurityCurrentVinGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityCurrentVinGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSecurityVinHistoryGet() {
    // lcmccadbusgw_tclClientSpm::sendSecurityVinHistoryGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityVinHistoryGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSecurityVinHistoryGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSecurityVinHistoryGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityVinHistoryGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendVINGet() {
    // lcmccadbusgw_tclClientSpm::sendVINGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVINGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendVINGet(* this);

    // lcmccadbusgw_tclClientSpm::sendVINGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVINGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSecurityStateGet() {
    // lcmccadbusgw_tclClientSpm::sendSecurityStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSecurityStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendSecurityStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSecurityStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendVehicleIDGet() {
    // lcmccadbusgw_tclClientSpm::sendVehicleIDGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVehicleIDGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendVehicleIDGet(* this);

    // lcmccadbusgw_tclClientSpm::sendVehicleIDGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendVehicleIDGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDisplayVariantGet() {
    // lcmccadbusgw_tclClientSpm::sendDisplayVariantGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDisplayVariantGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDisplayVariantGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDisplayVariantGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDisplayVariantGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDisplayVariantSet(tU32 displayVariantNumber) {
    // lcmccadbusgw_tclClientSpm::sendDisplayVariantSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDisplayVariantSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDisplayVariantSet(* this, displayVariantNumber);

    // lcmccadbusgw_tclClientSpm::sendDisplayVariantSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDisplayVariantSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendReductionLevelGet() {
    // lcmccadbusgw_tclClientSpm::sendReductionLevelGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendReductionLevelGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendReductionLevelGet(* this);

    // lcmccadbusgw_tclClientSpm::sendReductionLevelGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendReductionLevelGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStartupStateGet() {
    // lcmccadbusgw_tclClientSpm::sendStartupStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStartupStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendStartupStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartupStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendEntertainMuteGet() {
    // lcmccadbusgw_tclClientSpm::sendEntertainMuteGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEntertainMuteGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendEntertainMuteGet(* this);

    // lcmccadbusgw_tclClientSpm::sendEntertainMuteGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEntertainMuteGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWelcomeAudioStateGet() {
    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioStateGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioStateGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWelcomeAudioStateGet(* this);

    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioStateGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioStateGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUnballastTimeFromEngineStoppedGet() {
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeFromEngineStoppedGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeFromEngineStoppedGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUnballastTimeFromEngineStoppedGet(* this);

    // lcmccadbusgw_tclClientSpm::sendUnballastTimeFromEngineStoppedGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeFromEngineStoppedGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastGet() {
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUnballastTimeBeforeUnballastGet(* this);

    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastSet(tU32 u32UnballastTime) {
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUnballastTimeBeforeUnballastSet(* this, u32UnballastTime);

    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastTimeBeforeUnballastSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUnballastWarningTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeSet(tU32 u32UnballastWarningTime) {
    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUnballastWarningTimeSet(* this, u32UnballastWarningTime);

    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUnballastWarningTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDegradedCountGet() {
    // lcmccadbusgw_tclClientSpm::sendDegradedCountGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDegradedCountGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDegradedCountGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDegradedCountGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDegradedCountGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDegradedTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendDegradedTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDegradedTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDegradedTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendDegradedTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDegradedTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeGet() {
    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeGet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeGet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPhoneHandoverWarnTimeGet(* this);

    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeGetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeGetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeSet(tU32 u32Time) {
    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeSet: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeSet: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPhoneHandoverWarnTimeSet(* this, u32Time);

    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeSetEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPhoneHandoverWarnTimeSetEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSystemModeStart(::spm_core_fi_types::T_e8_StateModes eSystemMode) {
    // lcmccadbusgw_tclClientSpm::sendSystemModeStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemModeStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSystemModeStart(* this, eSystemMode);

    // lcmccadbusgw_tclClientSpm::sendSystemModeStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSystemModeStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendDownloadLockStateStart(const ::std::string& strRestrictedDlState, ::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode) {
    // lcmccadbusgw_tclClientSpm::sendDownloadLockStateStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDownloadLockStateStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendDownloadLockStateStart(* this, strRestrictedDlState, eRestrictedDlMode);

    // lcmccadbusgw_tclClientSpm::sendDownloadLockStateStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendDownloadLockStateStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendUpdateLockStart(const ::std::string& strLockName, ::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest) {
    // lcmccadbusgw_tclClientSpm::sendUpdateLockStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUpdateLockStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendUpdateLockStart(* this, strLockName, eLockRequest);

    // lcmccadbusgw_tclClientSpm::sendUpdateLockStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendUpdateLockStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendOnOffTriggerStart(::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger, tBool bState) {
    // lcmccadbusgw_tclClientSpm::sendOnOffTriggerStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnOffTriggerStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendOnOffTriggerStart(* this, eSwitchOnTrigger, bState);

    // lcmccadbusgw_tclClientSpm::sendOnOffTriggerStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendOnOffTriggerStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStartProcessStart(const ::std::string& strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE u32Type, tU32 u32Info) {
    // lcmccadbusgw_tclClientSpm::sendStartProcessStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartProcessStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStartProcessStart(* this, strLocation, u32Prio, u32Affinity, u32AffinityEnd, u32NiceLevel, u32NiceLevelEnd, u32Type, u32Info);

    // lcmccadbusgw_tclClientSpm::sendStartProcessStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartProcessStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStopProcessStart(const ::std::string& strLocation, tU32 u32ProcId) {
    // lcmccadbusgw_tclClientSpm::sendStopProcessStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStopProcessStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStopProcessStart(* this, strLocation, u32ProcId);

    // lcmccadbusgw_tclClientSpm::sendStopProcessStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStopProcessStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRestartProcessStart(const ::std::string& strLocation, tU32 u32ProcId) {
    // lcmccadbusgw_tclClientSpm::sendRestartProcessStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartProcessStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRestartProcessStart(* this, strLocation, u32ProcId);

    // lcmccadbusgw_tclClientSpm::sendRestartProcessStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartProcessStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendStartUpSyncPointReachedStart(const ::std::string& strNewSyncPoint) {
    // lcmccadbusgw_tclClientSpm::sendStartUpSyncPointReachedStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartUpSyncPointReachedStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendStartUpSyncPointReachedStart(* this, strNewSyncPoint);

    // lcmccadbusgw_tclClientSpm::sendStartUpSyncPointReachedStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendStartUpSyncPointReachedStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendClearListStart(::spm_core_fi_types::T_SPM_e32_CLEAR_LIST eList2Clear) {
    // lcmccadbusgw_tclClientSpm::sendClearListStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClearListStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendClearListStart(* this, eList2Clear);

    // lcmccadbusgw_tclClientSpm::sendClearListStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClearListStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendRestartSystemStart(::spm_core_fi_types::T_SPM_e32_RESTART_TYPE eRestartType) {
    // lcmccadbusgw_tclClientSpm::sendRestartSystemStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartSystemStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendRestartSystemStart(* this, eRestartType);

    // lcmccadbusgw_tclClientSpm::sendRestartSystemStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendRestartSystemStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendAudioSourceChangeStart(::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE eAudioSrc) {
    // lcmccadbusgw_tclClientSpm::sendAudioSourceChangeStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAudioSourceChangeStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendAudioSourceChangeStart(* this, eAudioSrc);

    // lcmccadbusgw_tclClientSpm::sendAudioSourceChangeStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendAudioSourceChangeStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendChangeBluetoothStateStart(::spm_core_fi_types::T_SPM_e32_BT_STATE btState) {
    // lcmccadbusgw_tclClientSpm::sendChangeBluetoothStateStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeBluetoothStateStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendChangeBluetoothStateStart(* this, btState);

    // lcmccadbusgw_tclClientSpm::sendChangeBluetoothStateStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeBluetoothStateStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendChangeAudioStateStart(::spm_core_fi_types::T_SPM_e32_AUDIO_STATE audioState) {
    // lcmccadbusgw_tclClientSpm::sendChangeAudioStateStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeAudioStateStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendChangeAudioStateStart(* this, audioState);

    // lcmccadbusgw_tclClientSpm::sendChangeAudioStateStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeAudioStateStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendChangeSpiStateStart(::spm_core_fi_types::T_SPM_e32_SPI_STATE spiState) {
    // lcmccadbusgw_tclClientSpm::sendChangeSpiStateStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeSpiStateStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendChangeSpiStateStart(* this, spiState);

    // lcmccadbusgw_tclClientSpm::sendChangeSpiStateStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeSpiStateStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendChangeTunerStateStart(::spm_core_fi_types::T_SPM_e32_TUNER_STATE tunerState) {
    // lcmccadbusgw_tclClientSpm::sendChangeTunerStateStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeTunerStateStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendChangeTunerStateStart(* this, tunerState);

    // lcmccadbusgw_tclClientSpm::sendChangeTunerStateStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeTunerStateStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendChangeWifiStateStart(::spm_core_fi_types::T_SPM_e32_WIFI_STATE wiFiState) {
    // lcmccadbusgw_tclClientSpm::sendChangeWifiStateStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeWifiStateStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendChangeWifiStateStart(* this, wiFiState);

    // lcmccadbusgw_tclClientSpm::sendChangeWifiStateStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendChangeWifiStateStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendShutdownAndTerminateCcaAppsStart(::spm_core_fi_types::T_SPM_AppIdList tAppIdList) {
    // lcmccadbusgw_tclClientSpm::sendShutdownAndTerminateCcaAppsStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendShutdownAndTerminateCcaAppsStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendShutdownAndTerminateCcaAppsStart(* this, tAppIdList);

    // lcmccadbusgw_tclClientSpm::sendShutdownAndTerminateCcaAppsStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendShutdownAndTerminateCcaAppsStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSetFactorySettingsNewStart(::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType defSetStateGroup, ::spm_diag_defset_fi_types::T_e8_DefSetMode defSetStateMode) {
    // lcmccadbusgw_tclClientSpm::sendSetFactorySettingsNewStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSetFactorySettingsNewStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSetFactorySettingsNewStart(* this, defSetStateGroup, defSetStateMode);

    // lcmccadbusgw_tclClientSpm::sendSetFactorySettingsNewStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSetFactorySettingsNewStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendClearVINStart() {
    // lcmccadbusgw_tclClientSpm::sendClearVINStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClearVINStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendClearVINStart(* this);

    // lcmccadbusgw_tclClientSpm::sendClearVINStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendClearVINStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendPrepareDownloadStart(tU32 configuration, tBool suspendBusShutdown, tU32 timeout) {
    // lcmccadbusgw_tclClientSpm::sendPrepareDownloadStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPrepareDownloadStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendPrepareDownloadStart(* this, configuration, suspendBusShutdown, timeout);

    // lcmccadbusgw_tclClientSpm::sendPrepareDownloadStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendPrepareDownloadStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendEndDownloadStart() {
    // lcmccadbusgw_tclClientSpm::sendEndDownloadStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEndDownloadStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendEndDownloadStart(* this);

    // lcmccadbusgw_tclClientSpm::sendEndDownloadStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEndDownloadStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSetOnConfigurationStart(tU32 configuration) {
    // lcmccadbusgw_tclClientSpm::sendSetOnConfigurationStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSetOnConfigurationStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSetOnConfigurationStart(* this, configuration);

    // lcmccadbusgw_tclClientSpm::sendSetOnConfigurationStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSetOnConfigurationStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendSetProcessConfigurationStart(tU32 configuration) {
    // lcmccadbusgw_tclClientSpm::sendSetProcessConfigurationStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSetProcessConfigurationStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendSetProcessConfigurationStart(* this, configuration);

    // lcmccadbusgw_tclClientSpm::sendSetProcessConfigurationStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendSetProcessConfigurationStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendEntertainDeMuteStart() {
    // lcmccadbusgw_tclClientSpm::sendEntertainDeMuteStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEntertainDeMuteStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendEntertainDeMuteStart(* this);

    // lcmccadbusgw_tclClientSpm::sendEntertainDeMuteStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEntertainDeMuteStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendEntertainMuteRequestStart() {
    // lcmccadbusgw_tclClientSpm::sendEntertainMuteRequestStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEntertainMuteRequestStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendEntertainMuteRequestStart(* this);

    // lcmccadbusgw_tclClientSpm::sendEntertainMuteRequestStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendEntertainMuteRequestStartEnd: user specific code end
}
tVoid lcmccadbusgw_tclClientSpm::sendWelcomeAudioActivationStart(tBool bActivateState) {
    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioActivationStart: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioActivationStart: user specific code end
    
    if (_SpmProxy) _SpmProxy->sendWelcomeAudioActivationStart(* this, bActivateState);

    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioActivationStartEnd: user specific code start
    // lcmccadbusgw_tclClientSpm::sendWelcomeAudioActivationStartEnd: user specific code end
}

// lcmccadbusgw_ClientSpmDefinitioPart: user specific code start
// lcmccadbusgw_ClientSpmDefinitioPart: user specific code end

}}}} // namespace org { namespace bosch { namespace cm { namespace lcmccadbusgw {
