#ifndef I_LCMCCADBUSGW_CLIENTSPM_H
#define I_LCMCCADBUSGW_CLIENTSPM_H

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Ilcmccadbusgw_ClientSpm.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: lcmccadbusgateway
  * @Template:     ICcaProxy.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                CCA server interface
  *
  *                Do manual changes only inside tags
  *
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  *
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2020 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "lcmccadbusgw_AppMain.h"

// Ilcmccadbusgw_ClientSpmInclude: user specific code start
// Ilcmccadbusgw_ClientSpmInclude: user specific code end

#include "SPM_CORE_FIProxy.h"

class Ilcmccadbusgw_tclClientSpm : public lcmccadbusgw_tclBaseIf
{
public:
    Ilcmccadbusgw_tclClientSpm(lcmccadbusgw_tclAppMain* poMain) : lcmccadbusgw_tclBaseIf(poMain){;}
    virtual ~Ilcmccadbusgw_tclClientSpm(){}

    virtual const tChar* getIfName() const { return( "Ilcmccadbusgw_tclClientSpm"); };

    virtual tVoid sendSystemStateGet() = 0;
    virtual tVoid sendDownloadLockStatesGet() = 0;
    virtual tVoid sendUpdateLockStatesGet() = 0;
    virtual tVoid sendActiveOnOffTriggerGet() = 0;
    virtual tVoid sendSubStatesSet(::spm_core_fi_types::T_SPM_e32_SubStateType subStateType, tBool subStateData) = 0;
    virtual tVoid sendSubStatesGet() = 0;
    virtual tVoid sendHistoryTriggerGet() = 0;
    virtual tVoid sendInsertStateGet() = 0;
    virtual tVoid sendMediaEjectStateGet() = 0;
    virtual tVoid sendPhoneMuteStateGet() = 0;
    virtual tVoid sendOnTipperStateGet() = 0;
    virtual tVoid sendIgnitionCyclesGet() = 0;
    virtual tVoid sendSysPwrModeGet() = 0;
    virtual tVoid sendSysPwrSaveModeGet() = 0;
    virtual tVoid sendMapDownloadLockStateGet() = 0;
    virtual tVoid sendStandbyTimeSet(tU32 standbyTime) = 0;
    virtual tVoid sendStandbyTimeGet() = 0;
    virtual tVoid sendPersitentStandbyTimeSet(tU32 persitentStandbyTime) = 0;
    virtual tVoid sendPersitentStandbyTimeGet() = 0;
    virtual tVoid sendIgnitionOffTimeSet(tU32 ignitionOffTime) = 0;
    virtual tVoid sendIgnitionOffTimeGet() = 0;
    virtual tVoid sendDoorOpenTimeSet(tU32 doorOpenTime) = 0;
    virtual tVoid sendDoorOpenTimeGet() = 0;
    virtual tVoid sendClockDisplayTimeSet(tU32 clockDisplayTime) = 0;
    virtual tVoid sendClockDisplayTimeGet() = 0;
    virtual tVoid sendSystemStateTimeGet(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState) = 0;
    virtual tVoid sendSystemStateTimeSet(::spm_core_fi_types::T_SPM_e32_SYSTEM_STATES tSystemState, tU32 tStateTimerValue) = 0;
    virtual tVoid sendProcessListGet() = 0;
    virtual tVoid sendWakeupReasonGet() = 0;
    virtual tVoid sendStartupReasonGet() = 0;
    virtual tVoid sendConnectToBatteryGet() = 0;
    virtual tVoid sendCodeRequestStateSet(::spm_core_fi_types::T_SPM_e32_CODE_REQUEST codeRequestState) = 0;
    virtual tVoid sendCodeRequestStateGet() = 0;
    virtual tVoid sendActiveStartUpSyncPointsGet() = 0;
    virtual tVoid sendCvmEventGet() = 0;
    virtual tVoid sendUBatSenseGet() = 0;
    virtual tVoid sendCoproStateSet(::spm_core_fi_types::T_SPM_e32_PROCESSOR_STATE coproState) = 0;
    virtual tVoid sendCoproStateGet() = 0;
    virtual tVoid sendDevicePowerOnTimeSet(tU32 devicePowerOnTime) = 0;
    virtual tVoid sendDevicePowerOnTimeGet() = 0;
    virtual tVoid sendLastSystemRuntimeGet() = 0;
    virtual tVoid sendCurrentSystemRuntimeGet() = 0;
    virtual tVoid sendResetListSet(tU32 resetResetList) = 0;
    virtual tVoid sendResetListGet() = 0;
    virtual tVoid sendResetCounterSet(tU32 resetCounter) = 0;
    virtual tVoid sendResetCounterGet() = 0;
    virtual tVoid sendTransportModeListSet(tU32 transPortList) = 0;
    virtual tVoid sendTransportModeListGet() = 0;
    virtual tVoid sendResetHistorySet() = 0;
    virtual tVoid sendResetHistoryGet() = 0;
    virtual tVoid sendWakeupHistorySet() = 0;
    virtual tVoid sendWakeupHistoryGet() = 0;
    virtual tVoid sendStateHistorySet() = 0;
    virtual tVoid sendStateHistoryGet() = 0;
    virtual tVoid sendErrStateHistory01Set() = 0;
    virtual tVoid sendErrStateHistory01Get() = 0;
    virtual tVoid sendErrStateHistory02Set() = 0;
    virtual tVoid sendErrStateHistory02Get() = 0;
    virtual tVoid sendErrStateHistory03Set() = 0;
    virtual tVoid sendErrStateHistory03Get() = 0;
    virtual tVoid sendErrStateHistory04Set() = 0;
    virtual tVoid sendErrStateHistory04Get() = 0;
    virtual tVoid sendErrStateHistory05Set() = 0;
    virtual tVoid sendErrStateHistory05Get() = 0;
    virtual tVoid sendSwitchOnHistorySet() = 0;
    virtual tVoid sendSwitchOnHistoryGet() = 0;
    virtual tVoid sendDeviceOnCounterGet() = 0;
    virtual tVoid sendVoltageEventCounterGet() = 0;
    virtual tVoid sendVoltageRangeHistogramGet() = 0;
    virtual tVoid sendCpuUsageStatisticGet() = 0;
    virtual tVoid sendRamUsageStatisticGet() = 0;
    virtual tVoid sendStartupTimeStatisticGet() = 0;
    virtual tVoid sendRunlevelStateGet() = 0;
    virtual tVoid sendRestartSet(::spm_core_fi_types::T_SPM_e32_RESTART_TYPE restart) = 0;
    virtual tVoid sendRestartGet() = 0;
    virtual tVoid sendLifesignGet() = 0;
    virtual tVoid sendHmiStateGet() = 0;
    virtual tVoid sendSystemPowerBehaviourGet() = 0;
    virtual tVoid sendDimStateGet() = 0;
    virtual tVoid sendDimmingStateGet() = 0;
    virtual tVoid sendBluetoothStateGet() = 0;
    virtual tVoid sendAudioStateGet() = 0;
    virtual tVoid sendSpiStateGet() = 0;
    virtual tVoid sendTunerStateGet() = 0;
    virtual tVoid sendWifiStateGet() = 0;
    virtual tVoid sendOnOffReasonSet(::spm_core_fi_types::T_SPM_e32_OnOffReason onOffReason) = 0;
    virtual tVoid sendOnOffReasonGet() = 0;
    virtual tVoid sendWakeupListSet(tU32 wakeupList) = 0;
    virtual tVoid sendWakeupListGet() = 0;
    virtual tVoid sendStartupFinishedGet() = 0;
    virtual tVoid sendSysStateGet() = 0;
    virtual tVoid sendMostStateGet() = 0;
    virtual tVoid sendMostVersionGet() = 0;
    virtual tVoid sendRVCStateSet(tBool state) = 0;
    virtual tVoid sendRVCStateGet() = 0;
    virtual tVoid sendTriggerMostRemoteResetGet() = 0;
    virtual tVoid sendTriggerMostRemoteResetSet() = 0;
    virtual tVoid sendPartnumberGet(const ::std::string& part) = 0;
    virtual tVoid sendPartnumberSet(const ::std::string& part, tU32 number) = 0;
    virtual tVoid sendPartnumbersGet() = 0;
    virtual tVoid sendAlphacodeGet(const ::std::string& part) = 0;
    virtual tVoid sendAlphacodeSet(const ::std::string& part, tU8 alphacode1, tU8 alphacode2) = 0;
    virtual tVoid sendAlphacodesGet() = 0;
    virtual tVoid sendManufacturersEnableCounterGet() = 0;
    virtual tVoid sendManufacturersEnableCounterSet(tU8 mEC) = 0;
    virtual tVoid sendNoCalibrationStateGet() = 0;
    virtual tVoid sendNoCalibrationStateSet(tBool state) = 0;
    virtual tVoid sendSecurityCommErrorGet() = 0;
    virtual tVoid sendSecurityMoreThan10VinGet() = 0;
    virtual tVoid sendSecurityInvalidVinGet() = 0;
    virtual tVoid sendSecurityCurrentVinGet() = 0;
    virtual tVoid sendSecurityVinHistoryGet() = 0;
    virtual tVoid sendVINGet() = 0;
    virtual tVoid sendSecurityStateGet() = 0;
    virtual tVoid sendVehicleIDGet() = 0;
    virtual tVoid sendDisplayVariantGet() = 0;
    virtual tVoid sendDisplayVariantSet(tU32 displayVariantNumber) = 0;
    virtual tVoid sendReductionLevelGet() = 0;
    virtual tVoid sendStartupStateGet() = 0;
    virtual tVoid sendEntertainMuteGet() = 0;
    virtual tVoid sendWelcomeAudioStateGet() = 0;
    virtual tVoid sendUnballastTimeFromEngineStoppedGet() = 0;
    virtual tVoid sendUnballastTimeBeforeUnballastGet() = 0;
    virtual tVoid sendUnballastTimeBeforeUnballastSet(tU32 u32UnballastTime) = 0;
    virtual tVoid sendUnballastWarningTimeGet() = 0;
    virtual tVoid sendUnballastWarningTimeSet(tU32 u32UnballastWarningTime) = 0;
    virtual tVoid sendDegradedCountGet() = 0;
    virtual tVoid sendDegradedTimeGet() = 0;
    virtual tVoid sendPhoneHandoverWarnTimeGet() = 0;
    virtual tVoid sendPhoneHandoverWarnTimeSet(tU32 u32Time) = 0;
    virtual tVoid sendSystemModeStart(::spm_core_fi_types::T_e8_StateModes eSystemMode) = 0;
    virtual tVoid sendDownloadLockStateStart(const ::std::string& strRestrictedDlState, ::spm_core_fi_types::T_e8_DownloadLockStates eRestrictedDlMode) = 0;
    virtual tVoid sendUpdateLockStart(const ::std::string& strLockName, ::spm_core_fi_types::T_e8_UpdateLockCommand eLockRequest) = 0;
    virtual tVoid sendOnOffTriggerStart(::spm_core_fi_types::T_SPM_e32_SubStateType eSwitchOnTrigger, tBool bState) = 0;
    virtual tVoid sendStartProcessStart(const ::std::string& strLocation, tU32 u32Prio, tU32 u32Affinity, tU32 u32AffinityEnd, tU32 u32NiceLevel, tU32 u32NiceLevelEnd, ::spm_core_fi_types::T_SPM_e32_START_PROC_TYPE u32Type, tU32 u32Info) = 0;
    virtual tVoid sendStopProcessStart(const ::std::string& strLocation, tU32 u32ProcId) = 0;
    virtual tVoid sendRestartProcessStart(const ::std::string& strLocation, tU32 u32ProcId) = 0;
    virtual tVoid sendStartUpSyncPointReachedStart(const ::std::string& strNewSyncPoint) = 0;
    virtual tVoid sendClearListStart(::spm_core_fi_types::T_SPM_e32_CLEAR_LIST eList2Clear) = 0;
    virtual tVoid sendRestartSystemStart(::spm_core_fi_types::T_SPM_e32_RESTART_TYPE eRestartType) = 0;
    virtual tVoid sendAudioSourceChangeStart(::spm_core_fi_types::T_SPM_e32_AUDIO_SOURCE eAudioSrc) = 0;
    virtual tVoid sendChangeBluetoothStateStart(::spm_core_fi_types::T_SPM_e32_BT_STATE btState) = 0;
    virtual tVoid sendChangeAudioStateStart(::spm_core_fi_types::T_SPM_e32_AUDIO_STATE audioState) = 0;
    virtual tVoid sendChangeSpiStateStart(::spm_core_fi_types::T_SPM_e32_SPI_STATE spiState) = 0;
    virtual tVoid sendChangeTunerStateStart(::spm_core_fi_types::T_SPM_e32_TUNER_STATE tunerState) = 0;
    virtual tVoid sendChangeWifiStateStart(::spm_core_fi_types::T_SPM_e32_WIFI_STATE wiFiState) = 0;
    virtual tVoid sendShutdownAndTerminateCcaAppsStart(::spm_core_fi_types::T_SPM_AppIdList tAppIdList) = 0;
    virtual tVoid sendSetFactorySettingsNewStart(::spm_diag_defset_fi_types::T_e8_DiaglogDefsetType defSetStateGroup, ::spm_diag_defset_fi_types::T_e8_DefSetMode defSetStateMode) = 0;
    virtual tVoid sendClearVINStart() = 0;
    virtual tVoid sendPrepareDownloadStart(tU32 configuration, tBool suspendBusShutdown, tU32 timeout) = 0;
    virtual tVoid sendEndDownloadStart() = 0;
    virtual tVoid sendSetOnConfigurationStart(tU32 configuration) = 0;
    virtual tVoid sendSetProcessConfigurationStart(tU32 configuration) = 0;
    virtual tVoid sendEntertainDeMuteStart() = 0;
    virtual tVoid sendEntertainMuteRequestStart() = 0;
    virtual tVoid sendWelcomeAudioActivationStart(tBool bActivateState) = 0;

// Ilcmccadbusgw_ClientSpmDeclarationsPart: user specific code start
// Ilcmccadbusgw_ClientSpmDeclarationsPart: user specific code end

};


#endif // I_LCMCCADBUSGW_CLIENTSPM_H

