/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         systemd_interface.h
  * @brief        Implementation of the Systemd Interface
  * @copyright    (C) 2014 - 2016 Robert Bosch Engineering and Business Solutions Limited.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include <systemd/sd-daemon.h>
#include <time.h>
#include <signal.h>
#include <unistd.h>
//needed for bool
#include <stdbool.h>
//string.h needed for memset
#include <string.h>
//needed for specific 32 bit or 16 bit datatype
#include <stdint.h>


/*
    *******************Class Related Information********************
    *******************Class Related Information********************
  */

/*Application has to derive from this base class and
   override the OnAppWatchdog() method to notify systemd
   about watchdog status(return status is checked(true))*/
/********************Class Related Information*********************/
class SystemdIF
{
public:
virtual bool OnAppWatchdog( ) = 0;

virtual ~SystemdIF( ){}

};

/*
  *********************************Class Related Information************************************
   This class currently supports watchdog notification and status notifictaion( READY) to SYSTEMD
   The Application has to create this class, after deriving from SystemdIF
  */

/*A timer is started with the pre-configured watchdog interval and after every timer elapse,
   the OnAppWatchdog method  is called and the application has to return true, if not, Systemd restarts
   the application(or service)*/
/**********************************Class Related Information*************************************/
class systemd_interface
{
private:
//CCAAPPID
uint32_t          u_CcaAppId;

//pre-configured watchdog interval from service file
int32_t           watchdog_interval;

// process environment variable
char             *_poenv_config;

//timerid
timer_t           timerID;

// contains signal events
struct sigevent   SignalEvent;

// Action to be taken for the sigevent
struct sigaction  SignalAction;

// The timing information to the timer
struct itimerspec timerSpecs;

//Systemd interface of the application
SystemdIF        *_poAppSystemdIF;

public:
systemd_interface( SystemdIF *AppSystemdIF,
                   uint32_t   CcaAppId );
virtual ~systemd_interface( );

virtual void systemd_notify_ready( );

static void timer_expiry_handler( int        sigNumb,
                                  siginfo_t *si,
                                  void      *uc );

};


//C++ has the concept of "name-mangling", so if someone wants
//to load this library dynamically using dl_open() and dl_sym(),
//this function acts as the entry point for dlsym
#ifdef __cplusplus
   extern "C"
   {
   systemd_interface*GetSystemdInterface( SystemdIF *component,
                                          uint32_t   Appid );

   }
#endif

