/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         LcmBaseAppComponent.h
  * @brief        Implementation of the LcmBaseAppComponent component
  * @copyright    (C) 2014 - 2016 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#pragma once

#include "asf/core/BaseComponent.h"
#include "asf/core/Logger.h"
#include "asf/core/Timer.h"
#include "org/genivi/NodeStateManager/ConsumerProxy.h"
#include "org/genivi/NodeStateManager/LifecycleControlProxy.h"
#include "org/genivi/NodeStateManager/LifeCycleConsumerStub.h"
// \todo: boost::shared_ptr is used here cause by ASF interface.
namespace org {
namespace bosch {
namespace cm {
namespace lcm {
namespace lcmbaseappcomponent {

using namespace ::org::genivi::NodeStateManager::Consumer;
using namespace ::org::genivi::NodeStateManager::LifeCycleConsumer;
using namespace ::org::genivi::NodeStateManager::LifecycleControl;
using namespace ::org::genivi::NodeStateManager::LcmErrorTypes;
using namespace ::org::genivi::NodeStateManager::LcmBasicTypes;
using namespace ::org::bosch::cm::lcm;
using namespace ::asf::core;

class LcmApplicationControlIF
{

private:
DECLARE_CLASS_LOGGER( );

public:
// ApplicationMode Changes
virtual ~LcmApplicationControlIF( );
virtual _NsmErrorStatus_e OnAppModeChange( _Nsm_Shutdown_Type_e newAppMode,
                                           _Nsm_Shutdown_Type_e oldAppMode ) = 0;

// Watchdog Handling
virtual bool OnAppWatchdog( )                                                = 0;

// LcmServiceRegistration
virtual void OnLcmRegistered( )                                              = 0;

// handling persistency
virtual void onLoadPersistency( ){}
virtual void onSavePersistency( ){}

//Handling Error and Response to be implemented by derived Application
virtual void OnAppLifecycleRequestCompleteError( _NsmErrorStatus_e  error,
                                                 const std::string& name    = "",
                                                 const std::string& message = "" );

virtual void OnAppLifecycleRequestCompleteResponse( _NsmErrorStatus_e response );

virtual void onAppRegisterShutdownClientError( _NsmErrorStatus_e  error,
                                               const std::string& name      = "",
                                               const std::string& message   = "" );

virtual void onAppRegisterShutdownClientResponse( _NsmErrorStatus_e response );

virtual void onAppUnRegisterShutdownClientError( _NsmErrorStatus_e  error,
                                                 const std::string& name    = "",
                                                 const std::string& message = "" );

virtual void onAppUnRegisterShutdownClientResponse( _NsmErrorStatus_e response );


};

class LcmBaseAppComponent
   : private ServiceAvailableIF
// LifeCycleConsumerStub
   , private LifeCycleConsumerStub
// ConsumerProxy
   , private RegisterShutdownClientCallbackIF
   , private UnRegisterShutdownClientCallbackIF
   , private LifecycleRequestCompleteCallbackIF
//, Timer
   , private TimerCallbackIF
{
private:
DECLARE_CLASS_LOGGER( );

std::string _sNotifySocket;
std::vector < std::string > _CommandLineArguments;

Timer _SystemdWdNotifyTimer;
uint32 _SystemdWdNotifyTimeMSec;

Timer _SystemdWdNotifyPreTimer;
uint32 _SystemdWdPreTimeMSec;
uint32 _SystemdWdNotifyPreTimeout_Percentage;

Timer _SystemdStartupPreTimer;
uint32 _SystemdStartupPreTimeMSec;
uint32 _SystemdStartupPreTimeout_Percentage;

bool _ConsumerServiceRegistered;
bool _ShutdownClientRegistrationDone;
bool _AppStartReady;
_Nsm_Shutdown_Type_e _currentAppMode;
const std::string _busName;
const std::string _objName;
const ::boost::shared_ptr < LcmApplicationControlIF > _ApplicationCb;
boost::shared_ptr < LifecycleRequestRequest > _lifeCycleRequestRequest;

void  CheckAppStartReady( );

void  PrintTimeoutErrMemEntries( const std::string& strType );

void  PrintSdNotifyErrMemEntries( const int          ErrorNumber,
                                  const std::string& strType );

public:
LcmBaseAppComponent( const std::string      & busName,
                     const std::string      & objName,
                     LcmApplicationControlIF& ApplicationCb );
LcmBaseAppComponent( LcmApplicationControlIF& ApplicationCb );
virtual ~LcmBaseAppComponent( );

const std::vector < std::string > getCommandLineArguments( ){ return( _CommandLineArguments ); }
void  setAppStartReady( );

//void  setBusObjNames(const std::string& busName, const std::string& objName);
void SendLifeCycleRequestCompleteRequest( );

// ServiceAvailableIF implementation
virtual void onAvailable( const boost::shared_ptr < Proxy >& proxy,
                          const ServiceStateChange         & stateChange );

virtual void onUnavailable( const boost::shared_ptr < Proxy >& proxy,
                            const ServiceStateChange         & stateChange );

// TimerCallbackIF implementation
virtual void onExpired( asf::core::Timer                            & timer,
                        boost::shared_ptr < asf::core::TimerPayload > payload );

// LifeCycleConsumerStub implementation
virtual void onLifecycleRequestRequest( const ::boost::shared_ptr < LifecycleRequestRequest >& request );

virtual void onLifecycleRequestCompleteError( const ::boost::shared_ptr < ConsumerProxy >                & proxy,
                                              const ::boost::shared_ptr < LifecycleRequestCompleteError >& error );

virtual void onLifecycleRequestCompleteResponse( const ::boost::shared_ptr < ConsumerProxy >                   & proxy,
                                                 const ::boost::shared_ptr < LifecycleRequestCompleteResponse >& response );

// ConsumerProxy
// RegisterShutdownClientCallbackIF
virtual void onRegisterShutdownClientError( const ::boost::shared_ptr < ConsumerProxy >              & proxy,
                                            const ::boost::shared_ptr < RegisterShutdownClientError >& error );

virtual void onRegisterShutdownClientResponse( const ::boost::shared_ptr < ConsumerProxy >                 & proxy,
                                               const ::boost::shared_ptr < RegisterShutdownClientResponse >& response );

// UnRegisterShutdownClientCallbackIF
virtual void onUnRegisterShutdownClientError( const ::boost::shared_ptr < ConsumerProxy >                & proxy,
                                              const ::boost::shared_ptr < UnRegisterShutdownClientError >& error );

virtual void onUnRegisterShutdownClientResponse( const ::boost::shared_ptr < ConsumerProxy >                   & proxy,
                                                 const ::boost::shared_ptr < UnRegisterShutdownClientResponse >& response );

// pure virtual functions
// ServiceAvailableIF implementation
// virtual void onServiceAvailable  (const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange) = 0;
// virtual void onServiceUnavailable(const boost::shared_ptr<Proxy>& proxy, const ServiceStateChange &stateChange) = 0;

std::string getNotifySocket( ){ return( _sNotifySocket ); }

private:
::boost::shared_ptr < ConsumerProxy > _consumerProxy;
};

class LcmExtendedApplicationControlIF
{

private:
DECLARE_CLASS_LOGGER( );

public:
virtual ~LcmExtendedApplicationControlIF( );
// ApplicationMode Changes
virtual uint32 OnAppModeChange( _Nsm_Shutdown_Type_e newAppMode,
                                _Nsm_Shutdown_Type_e oldAppMode ) = 0;

// Watchdog Handling
virtual bool OnAppWatchdog( )                                     = 0;

// LcmServiceRegistration
virtual void OnLcmRegistered( )                                   = 0;

// handling persistency
virtual void onLoadPersistency( ){}
virtual void onSavePersistency( ){}

// Handling Error and Response to be implemented by derived Application
virtual void onExtAppSetAppHealthStatusError( _NsmErrorStatus_e  error,
                                              const std::string& name    = "",
                                              const std::string& message = "" );

virtual void onExtAppSetAppHealthStatusResponse( _NsmErrorStatus_e response );

virtual void onExtAppSetApplicationModeError( _NsmErrorStatus_e  error,
                                              const std::string& name    = "",
                                              const std::string& message = "" );

virtual void onExtAppSetApplicationModeResponse( _NsmErrorStatus_e response );

virtual void onExtSetBootModeError( _NsmErrorStatus_e  error,
                                    const std::string& name              = "",
                                    const std::string& message           = "" );

virtual void onExtSetBootModeResponse( _NsmErrorStatus_e response );

virtual void onExtSetNodeStateError( _NsmErrorStatus_e  error,
                                     const std::string& name             = "",
                                     const std::string& message          = "" );

virtual void onExtSetNodeStateResponse( _NsmErrorStatus_e response );

};

class LcmExtendedBaseAppComponent
   : public BaseComponent
   , private ServiceAvailableIF
// LifecycleControlProxy
   , private SetBootModeCallbackIF
   , private SetNodeStateCallbackIF
   , private SetApplicationModeCallbackIF
   , private SetAppHealthStatusCallbackIF
{
private:
DECLARE_CLASS_LOGGER( );

public:
LcmExtendedBaseAppComponent( std::string busName,
                             std::string objName );
virtual ~LcmExtendedBaseAppComponent( );

// ServiceAvailableIF implementation
virtual void onAvailable( const boost::shared_ptr < Proxy >& proxy,
                          const ServiceStateChange         & stateChange );

virtual void onUnavailable( const boost::shared_ptr < Proxy >& proxy,
                            const ServiceStateChange         & stateChange );

// TimerCallbackIF implementation
virtual void onExpired( asf::core::Timer                            & timer,
                        boost::shared_ptr < asf::core::TimerPayload > payload );

// LifecycleControlStub implementation
// SetBootModeCallbackIF
virtual void onSetAppHealthStatusError( const ::boost::shared_ptr < LifecycleControlProxy >  & proxy,
                                        const ::boost::shared_ptr < SetAppHealthStatusError >& error )               = 0;

virtual void onSetAppHealthStatusResponse( const ::boost::shared_ptr < LifecycleControlProxy >     & proxy,
                                           const ::boost::shared_ptr < SetAppHealthStatusResponse >& response )      = 0;

// SetNodeStateCallbackIF
virtual void onSetApplicationModeError( const ::boost::shared_ptr < LifecycleControlProxy >  & proxy,
                                        const ::boost::shared_ptr < SetApplicationModeError >& error )               = 0;

virtual void onSetApplicationModeResponse( const ::boost::shared_ptr < LifecycleControlProxy >     & proxy,
                                           const ::boost::shared_ptr < SetApplicationModeResponse >& response )      = 0;

// SetApplicationModeCallbackIF
virtual void onSetBootModeError( const ::boost::shared_ptr < LifecycleControlProxy >& proxy,
                                 const ::boost::shared_ptr < SetBootModeError >     & error )                        = 0;

virtual void onSetBootModeResponse( const ::boost::shared_ptr < LifecycleControlProxy >& proxy,
                                    const ::boost::shared_ptr < SetBootModeResponse >  & response )                  = 0;

// SetAppHealthStatusCallbackIF
virtual void onSetNodeStateError( const ::boost::shared_ptr < LifecycleControlProxy >& proxy,
                                  const ::boost::shared_ptr < SetNodeStateError >    & error )                       = 0;

virtual void onSetNodeStateResponse( const ::boost::shared_ptr < LifecycleControlProxy >& proxy,
                                     const ::boost::shared_ptr < SetNodeStateResponse > & response )                 = 0;

private:
::boost::shared_ptr < LifecycleControlProxy > _lifecyclecontrolProxy;
};

}
}
}
}
}

