/**
  * @swcomponent  Life Cycle Management
  * @{
  * @file         genericDBusClient.h
  * @brief
  * @copyright    (C) 2013 - 2018 Robert Bosch GmbH.
  *               The reproduction, distribution and utilization of this file as well as the
  *               communication of its contents to others without express authorization is prohibited.
  *               Offenders will be held liable for the payment of damages.
  *               All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */
#pragma once

#include <iostream>

#include "asf/core/Logger.h"
#include "asf/core/Proxy.h"
#include "asf/core/Timer.h"

#include "asf/stream/MemoryStream.h"

#include "genericAsfDBusProxy.h"
// \todo: boost::shared_ptr is used here cause by ASF interface.
using namespace ::asf::core;
using namespace ::asf::stream;

class genericDBusClient : public ServiceAvailableIF
   , public genericAsfDBusCallbackIF
{
private:
static ::asf::core::Logger _logger;

int _sock;
bool _bSrvAvailable;

uint16 u16FuncIdCounter;

typedef enum
{
   eSignal = 0,
   eProperty
}ETypes;

typedef struct
{
   std::string strFuncName;
   ETypes eType;
}TPropertyConf;

std::map < uint16, TPropertyConf > _mapSignalRegs;

void getStructFromMsg( std::string    & strSockMsg,
                       int              curType,
                       DBusMessageIter *pPayloadIterator );

void getArrayFromMsg( std::string    & strSockMsg,
                      int              curType,
                      DBusMessageIter *pPayloadIterator );

void getIntFromMsg( std::string    & strSockMsg,
                    int              curType,
                    DBusMessageIter *pPayloadIterator );

void getStringFromMsg( std::string    & strSockMsg,
                       int              curType,
                       DBusMessageIter *pPayloadIterator );

public:
genericDBusClient( const std::string& portName,
                   int                sock,
                   const std::string& strInterface );
virtual ~genericDBusClient( );

// ServiceAvailableIF
virtual void onAvailable( const ::boost::shared_ptr < asf::core::Proxy >& proxy,
                          const asf::core::ServiceStateChange           & stateChange );

virtual void onUnavailable( const ::boost::shared_ptr < asf::core::Proxy >& proxy,
                            const asf::core::ServiceStateChange           & stateChange );

// SinkMuteStateChangedCallbackIF
virtual void onSignalChangedError( const ::boost::shared_ptr < genericAsfDBusProxy >& proxy,
                                   uint16                                             funcId );

virtual void onSignalChangedSignal( const ::boost::shared_ptr < genericAsfDBusProxy >& proxy,
                                    uint16                                             funcId,
                                    ::asf::dbus::DBusMessage                         & message );

virtual void addSignalRegistration( const std::string sigName );

virtual void addPropertyRegistration( const std::string propertyName );

private:
::boost::shared_ptr < genericAsfDBusProxy > _genericProxy;
};

