/*****************************************************************************
  * (c) Robert Bosch Car Multimedia GmbH
  *
  * THIS FILE IS GENERATED. DO NOT EDIT.
  * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
  ****************************************************************************/

#include "genericAsfStarter.h"
#include "asf/cca/CcaConnector.h"
#include "asf/cca/CcaImportedPort.h"
#include "asf/core/Application.h"
#include "asf/core/ComponentContainer.h"
#include "asf/core/ComponentDescription.h"
#include "asf/core/ContextData.h"
#include "asf/core/Logger.h"
#include "asf/core/RequiredPort.h"
#include "asf/core/SignalHandler.h"
#include "asf/dbus/DBusConnector.h"
#include "asf/dbus/DBusImportedPort.h"
#include "com/bosch/cm/asf/lang/cca/Connectors.h"
#include "com/bosch/cm/asf/lang/cca/ConnectorsJson.h"
#include "com/bosch/cm/asf/lang/dbus/Connectors.h"
#include "com/bosch/cm/asf/lang/dbus/ConnectorsJson.h"
#include "genericAsfDBusProxy.h"
#include "genericDBusClient.h"
#include <cstdio>
// \todo: boost::shared_ptr is used here cause by ASF interface.
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

DEFINE_CLASS_LOGGER_AND_LEVEL( "org/bosch/cm/Datacollector/genericAsfComponent", genericAsfComponent, Info );

typedef struct
{
   std::string strTarget;
   std::string strObject;
   std::string strInterface;
   bool bTerminate;
   OSAL_tThreadID tid;
   genericAsfComponent *poRefProxy;
} TDBusSockInfo;

std::map < int, TDBusSockInfo > tDBusSocketInfo;
int                             currentSock = 0;

genericAsfComponent::genericAsfComponent( )
   : BaseComponent( ){
   //_poProxy->addSignalRegistration("VolumeChanged");
   //_poProxy->addSignalRegistration("NumberOfMainConnectionsChanged");
   //_poProxy->addSignalRegistration("SourceAdded");
   //_poProxy->addSignalRegistration("SourceRemoved");
   //_poProxy->addSignalRegistration("NewMainConnection");
   //_poProxy->addSignalRegistration("MainConnectionState");
   //_poProxy->addSignalRegistration("MainSourceSoundProperty");
   //_poProxy->addSignalRegistration("SinkMuteState");

   _sock                             = currentSock;
   tDBusSocketInfo[_sock].poRefProxy = this;
   _poProxy                          = new genericDBusClient( "MyUsedPort", _sock, tDBusSocketInfo[_sock].strInterface );

}

genericAsfComponent::~genericAsfComponent( ){
}

void genericAsfComponent::addSignalRegistration( const std::string& strSigName ){
   _poProxy->addSignalRegistration( strSigName );
}

void genericAsfComponent::addPropertyRegistration( const std::string& strSigName ){
   _poProxy->addPropertyRegistration( strSigName );
}

/**
  * If the meaning of "DatacollectorAsf" isn't clear, then there should be a description here.
  */

DEFINE_LOGGER_AND_LEVEL( _logger, "/org/bosch/cm/datacollector/DatacollectorAsf", Info );

/* static */ const char*genericAsfStarter::asfComponent = "asfComponent";

void importGenericAsfStarted( const std::string& strTarget,
                              const std::string& strObject,
                              const std::string& strInterface,
                              int                sock ){
   ::asf::core::Application *app = ::asf::core::Application::getApplication( );
   //LOG_ASSERT_FATAL_MSG_STATIC(app, "Can't attach DatacollectorAsf, because no Application is instantiated");

   ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusConnector;
   {
      ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression1;
      {
         __expression1.setBusType( ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__Session );
      }
      dbusConnector = __expression1;
   }
   {
      std::string jsonPayload;
      serializeJson( dbusConnector, jsonPayload );
      LOG_INFO_STATIC( "Creating connector %s (%s), configuration: %s", "dbusConnector", "DBusConnector", jsonPayload.c_str( ) );
   }
   ::boost::shared_ptr < ::asf::dbus::DBusConnector > dbusConnector_( new ::asf::dbus::DBusConnector( * app, dbusConnector ) );

   app->addStarter( dbusConnector_ );

   // Expression

   ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector dbusSystemConnector;
   {
      ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector __expression2;
      {
         __expression2.setBusType( ::com::bosch::cm::asf::lang::dbus::Connectors::DBusConnector::BusType__System );
      }
      dbusSystemConnector = __expression2;
   }
   {
      std::string jsonPayload;
      serializeJson( dbusSystemConnector, jsonPayload );
      LOG_INFO_STATIC( "Creating connector %s (%s), configuration: %s", "dbusSystemConnector", "DBusConnector", jsonPayload.c_str( ) );
   }
   ::boost::shared_ptr < ::asf::dbus::DBusConnector > dbusSystemConnector_( new ::asf::dbus::DBusConnector( * app, dbusSystemConnector ) );
   app->addStarter( dbusSystemConnector_ );

   // Thread 'AsfClientThread'

   ::asf::core::ComponentContainerSharedPtr           AsfClientThread( new ::asf::core::ComponentContainer( "AsfClientThread", ::asf::core::ThreadConfiguration( 1 ) ) );
   app->addContainer( AsfClientThread );

   // Component 'genericAsfComponent asfComponent'

   currentSock = sock;

   ::boost::shared_ptr < ::asf::core::ComponentFactory < genericAsfComponent > > asfComponentFactory( new ::asf::core::ComponentFactory < genericAsfComponent > );
   ::asf::core::ComponentDescriptionSharedPtr                                    asfComponentDescription( new ::asf::core::ComponentDescription( 1, "asfComponent", /* immediate =
                                                                                                                                                                      */
                                                                                                                                                 true,              /*
                                                                                                                                                                       threadBridge
                                                                                                                                                                       =
                                                                                                                                                                      */
                                                                                                                                                 false, asfComponentFactory ) );
   AsfClientThread->addComponentDescription( asfComponentDescription );

   //::asf::core::RequiredPort& asfComponent_audioFiPort = asfComponentDescription->addRequiredPort (::asf::core::RequiredPort ("org.genivi.audiomanager.CommandInterface",
   // "MyUsedPort"));
   //(void)asfComponent_audioFiPort; // prevent unused variable warning
   //::asf::dbus::DBusImportedPort& audioFiImport = dbusSystemConnector_->importByName ("org.genivi.audiomanager", "/org/genivi/audiomanager/CommandInterface");
   //audioFiImport.setServiceName("org.genivi.audiomanager.CommandInterface");
   //::asf::core::ComponentMessageAdapter::bind (asfComponent_audioFiPort, audioFiImport);

   ::asf::core::RequiredPort& asfComponent_myFiPort = asfComponentDescription->addRequiredPort( ::asf::core::RequiredPort( strInterface.c_str( ), "MyUsedPort" ) );
   ::asf::dbus::DBusImportedPort& myFiImport        = dbusSystemConnector_->importByName( strTarget.c_str( ), strObject.c_str( ) );
   myFiImport.setServiceName( strInterface.c_str( ) );
   ::asf::core::ComponentMessageAdapter::bind( asfComponent_myFiPort, myFiImport );

   LOG_INFO_STATIC( "Starting application 'DatacollectorAsf' version 1.0.0" );

   app->start( );
} // importGenericAsfStarted

int executeGenericAsfStarted( const std::string& strTarget,
                              const std::string& strObject,
                              const std::string& strInterface,
                              int                sock ){
   printf( "executeGenericAsfStarted() called\n" );

   ::asf::core::ContextData context;
   std::vector < std::string > arguments;

   ::asf::core::Application *app = ::asf::core::Application::createApplication( "org.bosch.cm.procip", "genericAsfComponent", ::asf::core::Version( 1, 0, 0, "" ), arguments );

   app->enableExceptionHandler( true );

   importGenericAsfStarted( strTarget, strObject, strInterface, sock );

   int exitCode = app->waitForCompletion( );
   ::asf::core::Application::deleteApplication( );

   printf( "Exiting from application 'DatacollectorAsf', exit code=%d\n", exitCode );
   return( exitCode );
} // executeGenericAsfStarted

/*
   int main(int argc, char* argv[]) {
   ::org::bosch::cm::datacollector::DatacollectorAsf_enabledASFSignalHandler = true;
   ::asf::core::SignalHandler asfSignalHandler;
   ::boost::shared_ptr< ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach();
   return ::org::bosch::cm::datacollector::executeDatacollectorAsf(argc, argv);
   }
  */


int startGenericAsfDbusClient( const std::string& strTarget,
                               const std::string& strObject,
                               const std::string& strInterface,
                               int                sock ){

   printf( "startGenericAsfDbusClient() called\n" );
   ::asf::core::SignalHandler asfSignalHandler;
   ::boost::shared_ptr < ::asf::threading::Thread > mainThread = ::asf::threading::Thread::attach( );
   return( executeGenericAsfStarted( strTarget, strObject, strInterface, sock ) );
}

TDBusSockInfo splitDBusStartConfig( const std::string& strDBusConfig ){

   TDBusSockInfo dbusInfo;

   dbusInfo.poRefProxy = NULL;
   dbusInfo.tid        = OSAL_ERROR;
   dbusInfo.bTerminate = false;

   printf( "splitDBusStartConfig(): Analyse Config: '%s'\n", strDBusConfig.c_str( ) );

   std::string strDBusSplit = strDBusConfig.c_str( );
   // get "<target><object><interface>"
   size_t      startPos     = strDBusSplit.find( "<" );
   size_t      endPos       = strDBusSplit.find( ">" );

   if ( ( startPos != std::string::npos ) && ( endPos != std::string::npos ) ){
      startPos          += 1;
      dbusInfo.strTarget = strDBusSplit.substr( startPos, endPos - startPos );
      printf( "splitDBusStartConfig()(): Target '%s'\n", dbusInfo.strTarget.c_str( ) );

   }

   strDBusSplit = strDBusSplit.substr( endPos + 1 );
   startPos     = strDBusSplit.find( "<" );
   endPos       = strDBusSplit.find( ">" );
   if ( ( startPos != std::string::npos ) && ( endPos != std::string::npos ) ){
      startPos          += 1;
      dbusInfo.strObject = strDBusSplit.substr( startPos, endPos - startPos );
      printf( "splitDBusStartConfig()(): Object '%s'\n", dbusInfo.strObject.c_str( ) );

   }

   strDBusSplit = strDBusSplit.substr( endPos + 1 );
   startPos     = strDBusSplit.find( "<" );
   endPos       = strDBusSplit.find( ">" );
   if ( ( startPos != std::string::npos ) && ( endPos != std::string::npos ) ){
      startPos             += 1;
      dbusInfo.strInterface = strDBusSplit.substr( startPos, endPos - startPos );
      printf( "splitDBusStartConfig()(): Interface '%s'\n", dbusInfo.strInterface.c_str( ) );

   }

   return( dbusInfo );
} // splitDBusStartConfig

void vDBusHandlerThread( tVoid *pvArg ){
   int sock = (int)((intptr_t)pvArg);

   printf( "vDBusHandlerThread --> started\n" );
   (void)startGenericAsfDbusClient( tDBusSocketInfo[sock].strTarget, tDBusSocketInfo[sock].strObject, tDBusSocketInfo[sock].strInterface, sock );
   printf( "vDBusHandlerThread --> stopped\n" );
   OSAL_s32ThreadDelete( tDBusSocketInfo[sock].tid );
}

void vAddDBusSignalRegister( const std::string& strSigName,
                             int                sock ){
   printf( "vAddDBusSignalRegister(): '%s'\n", strSigName.c_str( ) );
   if ( tDBusSocketInfo[sock].poRefProxy != NULL ){
      printf( "vAddDBusSignalRegister(): DBus active!\n" );
      tDBusSocketInfo[sock].poRefProxy->addSignalRegistration( strSigName );

   }
}

void vAddDBusPropertyRegister( const std::string& strPropertyName,
                               int                sock ){
   printf( "vAddDBusPropertyRegister(): '%s'\n", strPropertyName.c_str( ) );
   if ( tDBusSocketInfo[sock].poRefProxy != NULL ){
      printf( "vAddDBusPropertyRegister(): DBus active!\n" );
      tDBusSocketInfo[sock].poRefProxy->addPropertyRegistration( strPropertyName );

   }
}

void vStartDBusHandler( const std::string& strDBusConfig,
                        int                sock ){

   tDBusSocketInfo[sock]            = splitDBusStartConfig( strDBusConfig );
   tDBusSocketInfo[sock].poRefProxy = NULL;

   tChar                  szMyProcSpecName[32] = { 0 };

   // start receiving thread
   sprintf( szMyProcSpecName, "DBusSimu%d", OSAL_ClockGetElapsedTime( ) );

   OSAL_trThreadAttribute rAttr;
   rAttr.szName              = (tString)szMyProcSpecName;
   rAttr.s32StackSize        = 4096;
   rAttr.u32Priority         = 100;
   rAttr.pfEntry             = (OSAL_tpfThreadEntry)vDBusHandlerThread;
   rAttr.pvArg               = ( tPVoid )( intptr_t ) sock;

   tDBusSocketInfo[sock].tid = OSAL_ThreadSpawn( &rAttr );
   if ( tDBusSocketInfo[sock].tid == OSAL_ERROR ){
      printf( "vStartDBusHandler(): Failed to spawn thread!\n" );
   }
} // vStartDBusHandler

