/*****************************************************************************
  * (c) Robert Bosch Car Multimedia GmbH
  *
  * THIS FILE IS GENERATED. DO NOT EDIT.
  * ANY CHANGES WILL BE REPLACED ON THE NEXT GENERATOR EXECUTION
  ****************************************************************************/

#include "asf/core/ComponentMessageAdapter.h"
#include "asf/core/Logger.h"
#include "asf/core/Types.h"
#include "asf/dbus/DBusTypesJson.h"
#include "asf/dbus/DefaultTypesDBus.h"
#include "boost/shared_ptr.hpp"
#include "genericAsfDBusProxy.h"

#include "asf/dbus/DBusDaemonProxy.h"
#include "asf/dbus/DBusPropertiesProxyWrapper.h"
#include "asf/dbus/DBusProxyDelegate.h"
#include "asf/dbus/DBusMessage.h"
// \todo: boost::shared_ptr is used here cause by ASF interface.
DEFINE_CLASS_LOGGER_AND_LEVEL( "org/bosch/cm/Datacollector/genericAsfComponent", genericAsfDBusProxy, Info );
DEFINE_LOGGER_AND_LEVEL( _logger, "/genericAsfDbusClient", Info );

class genericAsfDBusProxyCallback : public ::asf::dbus::DBusProxyCallback
{
public:
genericAsfDBusProxyCallback( uint16 functionId,
                             void  *callback ) :
   ::asf::dbus::DBusProxyCallback( functionId, callback )
{}

bool processMessage( ::asf::dbus::DBusMessage& message ){
   printf( "genericAsfDBusProxyCallback::processMessage(): %d\n", _functionId );
   const ::boost::shared_ptr < genericAsfDBusProxy >& proxyShared = ::boost::static_pointer_cast < genericAsfDBusProxy >( message.getDBusProxyShared( ) ); // no
                                                                                                                                                                                    // RTTI,
                                                                                                                                                                                    // use
                                                                                                                                                                                    // static_pointer_cast
                                                                                                                                                                                    // instead
                                                                                                                                                                                    // of
                                                                                                                                                                                    // dynamic_pointer_cast
   ( (genericAsfDBusCallbackIF*)_callback )->onSignalChangedSignal( proxyShared, _functionId, message );
   return( true );
}

bool onServiceUnavailable( const ::boost::shared_ptr < ::asf::core::Proxy >& baseProxy ){
   ::boost::shared_ptr < genericAsfDBusProxy > proxyShared = ::boost::static_pointer_cast < genericAsfDBusProxy >( baseProxy ); // no RTTI, use static_pointer_cast instead of

   // dynamic_pointer_cast

   ( (genericAsfDBusCallbackIF*)_callback )->onSignalChangedError( proxyShared, _functionId );
   return( true );
}

static ::asf::core::Logger& _logger;

};

::asf::core::Logger& genericAsfDBusProxyCallback::_logger( genericAsfDBusProxy::_logger );

genericAsfDBusProxy::genericAsfDBusProxy ( const std::string              & portName,
                                           ::asf::core::ServiceAvailableIF& serviceAvailable,
                                           const std::string              & strInterface ) :
   ::asf::dbus::DBusProxy( portName, strInterface.c_str( ), serviceAvailable, _logger ){
   printf( "genericAsfDBusProxy::genericAsfDBusProxy()\n" );
}

genericAsfDBusProxy::~genericAsfDBusProxy( ){
   sendDeregisterAll( );
}

act_t genericAsfDBusProxy::addMethodCallback( uint16 methodId,
                                              uint32 serial,
                                              void  *cb ){
   printf( "genericAsfDBusProxy::addMethodCallback()\n" );
   (void)serial;
   genericAsfDBusProxyCallback *callback = new genericAsfDBusProxyCallback( methodId, cb );
   CHECK_ALLOCATION( callback );
   // to do -> new interface:  _dbusProxyDelegate->addMethodCallback (serial, ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback >(callback));
   return( reinterpret_cast < act_t >( callback ) );
}

act_t genericAsfDBusProxy::addSignalCallback( uint16             signalId,
                                              const std::string& signal,
                                              void              *cb ){
   printf( "genericAsfDBusProxy::addSignalCallback()\n" );
   (void)signal;
   genericAsfDBusProxyCallback *callback = new genericAsfDBusProxyCallback( signalId, cb );
   CHECK_ALLOCATION( callback );
   // to do -> new interface:  _dbusProxyDelegate->registerSignalCallback (signal, reinterpret_cast<act_t>(callback), ::boost::shared_ptr< ::asf::dbus::DBusProxyCallback
   // >(callback));
   return( reinterpret_cast < act_t >( callback ) );
}

void genericAsfDBusProxy::sendDeregisterAll( ){
}

act_t genericAsfDBusProxy::sendSignalRegister( const std::string       & signalName,
                                               uint16                    funcId,
                                               genericAsfDBusCallbackIF& cb ){
   LOG_ASSERT( _dbusDaemonProxy );
   printf( "genericAsfDBusProxy::sendPropertyChangedRegister()\n" );

   _dbusDaemonProxy->addMatch( "signal", _dbusProxyDelegate->getDBusObjectPath( ), _dbusProxyDelegate->getInterfaceName( ), signalName );
   act_t act = addSignalCallback( funcId, signalName, &cb );
   //LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, signal, &cb, act);
   return( act );
}

act_t genericAsfDBusProxy::sendPropertyRegister( const std::string       & propertyName,
                                                 uint16                    funcId,
                                                 genericAsfDBusCallbackIF& cb ){
   LOG_ASSERT( _dbusDaemonProxy );
   _dbusPropertiesProxyWrapper->registerProperty( );
   act_t act = addSignalCallback( funcId, propertyName, &cb );
   //LOG_INFO ("-> send%sRegister(cb=%p), returning act=%" PRIuPTR, "ActiveOnOffTrigger", &cb, act);
   printf( "genericAsfDBusProxy::sendPropertyRegister(): %d\n", funcId );
   return( act );
}

act_t genericAsfDBusProxy::sendPropertyGet( const std::string       & propertyName,
                                            uint16                    funcId,
                                            genericAsfDBusCallbackIF& cb ){
   genericAsfDBusProxyCallback *callback = new genericAsfDBusProxyCallback( funcId, &cb );

   _dbusPropertiesProxyWrapper->sendGetProperty( propertyName, ::boost::shared_ptr < ::asf::dbus::DBusProxyCallback >( callback ) );
   printf( "genericAsfDBusProxy::sendPropertyGet(): %d\n", funcId );
   return( reinterpret_cast < act_t >( callback ) );
}

bool genericAsfDBusProxy::sendPropertyChangedDeregister( const std::string& signalName,
                                                         act_t              act ){
   #if 0 // to do -> new interface:
      bool rv = _dbusProxyDelegate->deregisterSignalCallback( signalName, act, _dbusDaemonProxy );
      //LOG_INFO ("-> send%sDeregister(act=%" PRIuPTR "), returning %d", "NumberOfMainConnectionsChanged", act, static_cast<int>(rv));
      return( rv );

   #else
      (void)signalName;
      (void)act;
      return( 1 );

   #endif
}

void genericAsfDBusProxy::sendPropertyChangedDeregisterAll( ){
   //LOG_INFO ("-> send%sDeregisterAll()", "NumberOfMainConnectionsChanged");
   //_dbusProxyDelegate->deregisterSignalCallback("NumberOfMainConnectionsChanged", 0, _dbusDaemonProxy, false);
}

