/**
 * @copyright (c) 2015-2023 Robert Bosch Car Multimedia GmbH
 * @addtogroup NavMiddleware
 * @{
 */

#include <sstream>
#include "NavMiddleware.h"
#include "Export.h"

/**
 * Major version change:
 * •	Changes (edit and delete) in NavMiddleware.h
 * •	Edit/Deletes in Info and Settings Objects
 * •	Adding new members to existing Info/Settings objects
 * •	Changing the order of values in PropertyIdentifiers.h (adding new values at end of each range does not affect binary compatibility)
 *
 * Minor version change:
 * •	Adding methods to NavMiddleware.h
 * •	Adding new Info/Setting Objects or enum definitions
 * •	Adding new enums to PropertyIdentifiers.h to the end of each range
 *
 * CMA, CMC or CMS changes will no longer influence our interface version (as of today)!
 *
 *
 * Version history
 * DATE       | VERSION | COMMENT
 * -------------------------------------------
 * 2015-11-18 | 23.0    | setLanguage modified
 * 2015-11-19 | 24.1    | enum DataUpdateStatus extended
 * 2015-11-19 | 25.0    | zoomIn/zoomOut modified
 * 2015-11-25 | 26.0    | CurrentCoordinates added to addressInputInfo
 * 2015-11-30 | 27.0    | MapRepresentation interfaces modified
 * 2015-12-01 | 28.1    | Added release traffic message list functionality
 * 2015-12-04 | 30.0    | enum MapCameraMode modified in MapInfos.h
 * 2015-12-08 | 31.0    | DestinationMemory NavMiddleware interface change
 *                        (2 new interfaces added, 2 of them renamed)
 * 2015-12-10 | 32.0    | Renamed MapScrollingInformationSettings to MapDetailTriggerSettings
 * 2015-12-10 | 33.0    | ApplicationControl required NavDataUpdateOnOff now
 * 2015-12-11 | 34.0    | Change in getMap*Info() interfaces
 * 2015-12-11 | 35.0    | ApplicationControl requires: NAV_FI
 * 2015-12-15 | 35.1    | OFF-Road Maneuver Symbols Renamed
 * 2015-12-17 | 36.0    | Added new PropertyUpdate identifiers for DestinationMemory
 * 2015-12-18 | 37.0    | Added current destination index in ArrivalInfos and WaypointInfos
 * 2015-12-16 ¦ 37.1    | Added XUrgend traffic message functionality
 * 2015-12-21 | 38.0    | Extend setLangauge method with TrafficTextLanguage
 * 2016-01-04 | 38.1    | Image data added to RouteListInfos::RouteListElementInfo
 * 2016-01-05 | 39.0    | JunctionView data moved from NextManeuverInfos to JunctionViewInfo;
 *                        SignPostInfo added for SignPost information
 * 2016-01-04 | 40.0    | Removed show/hideRouteAlternative and added showRouteOverview request
 * 2016-01-07 | 41.0    | switchToLinkedMode() interface changed
 * 2016-01-07 | 42.0    | centerMapToGeoPosition interfaces modified
 * 2016-01-08 | 43.0    | DestinationMemory uses POI_FI
 * 2016-01-08 | 44.0    | ASF application import feature
 * 2016-01-07 | 45.0    | MapViewType added to isInLinkedMode()
 * 2016-01-08 | 46.0    | Added two DestinationMemory interfaces for removal of all destinations
 *                        from the last destination list and/or specific category
 * 2016-01-08 | 47.0    | New interface added showWeatherAlertsInMap
 * 2016-01-11 | 48.0    | Add current and available sort orders to LocationInfos class
 * 2016-01-12 | 48.1    | New interface added getHorizonEvent
 * 2016-01-12 | 49.0    | WeatherMapMode removed from MapInfos.h
 * 2016-01-13 | 50.0    | Added coordinate to RouteListElementInfo in RouteInfos.h
 * 2016-01-13 | 51.0    | Country code and sub contry code added to DistanceTimeInfo
 * 2016-01-14 | 52.0    | Support Async and Sync service registration with different cma-files.
 * 2016-01-14 | 53.0    | Added DeformedImageDescription to JunctionViewInfo
 * 2016-01-15 | 54.0    | Added SpeedcamInfo for horizon speed camera information;
 *                        Added SafetyCameraSettings;
 * 2016-01-15 | 55.0    | Added mapScale to showLocationsInMap() interface
 * 2016-01-18 | 56.0    | LastDeparture methods added to DestinationMemory control/info
 * 2016-01-18 | 56.1    | Interface extended with a function to set speed limit data
 * 2016-01-19 | 57.0    | Modified RouteCriteria and RouteOptions Settings
 * 2016-01-16 | 58.0    | Added numbered icons; changed middleware interface of location input
 * 2016-01-21 | 58.1    | Map: New method setMapCameraAndViewModes
 * 2016-01-21 | 58.2    | Added avoid(cancel)RouteListElements interface
 * 2016-01-21 | 59.0    | Interface extended to determine LocationType
 * 2016-01-22 | 59.1    | MapWidget: Added new MAP_MODE_WIDGET and showMapWidget method
 * 2016-01-22 | 59.2    | Added Carsor to PickingResultType
 * 2016-01-22 | 59.3    | nbrOfAddressbook entries returned by method
 * 2016-01-22 | 60.0    | Renamed JunctionViewInfo to ManeuverViewInfo. Added a new field ManeuverViewType
 *                        GUIDANCE_JUNCTIONVIEW_CHANGED renamed to GUIDANCE_MANEUVERVIEW_CHANGED.
 *                        Safety camera settings added to navmiddleware interface.
 * 2016-01-22 | 60.1    | Added traffic sign
 * 2016-01-25 | 60.2    | Added new startStoredRouteCalculation method
 * 2016-01-25 | 60.3    | Map ViewSettings added to navmiddleware interface.
 * 2016-01-22 | 60.4    | Added IntersectionMapMode parameter to method showIntersectionMap (with default value)
 * 2016-01-27 | 60.5    | Added DestinationMemory interface to support storing/fetching tours.
 * 2016-01-27 | 61.0    | Extend TrafficMessageSetting with downloadWheneverDestinationIsSet, trafficRequestFrequencyInSecond
 * 2016-01-28 | 61.1    | Added new Info object and property Identifier for traffic reception status
 * 2016-01-28 | 62.0    | Add set function for TrafficSign; add assignment Operator for validValue
 * 2016-01-29 | 63.0    | Added new DestinationMemory interfaces to fetch additional details about route/destination.
 *                        Modified info object (added setter methods)
 * 2016-01-29 | 64.0    | Added traffic icons; extended TrafficMessageInfo class with traffic image data reference.
 * 2016-01-28 | 65.0    | Refactor POI input interface: Setting of (HMI) context and search scope in start methods,
 *                        improve method names and parameter ordering
 * 2016-02-04 | 65.1    | Added new map property MAP_INTERSECTION_MAP_VECTOR_DATA_CHANGED
 *                        Added new MapInfo types: IntersectionMapDataRoadClass, IntersectionNumber, IntersectionMapScreenPosition
 *                                                 IntersectionMapScreenPositionList, IntersectionMapRoadLine, IntersectionMapRoadLineList
 *                                                 IntersectionMapVectorData, IntersectionMapVectorDataList
 *                        Added new method getIntersectionMapVectorDataList
 * 2016-02-05 | 66.0    | Added m_ecoRatingToNext(Final)Destination and EcoRating enum to ArrivalInfosAlternatives
 * 2016-02-08 | 67.0    | Added intersectionMapId to ManeuverViewType
 * 2016-02-09 | 68.0    | In MapInfos.h, changed types of m_startOffset to uint32_t and m_selectedIndex to int32_t.
 * 2016-02-09 | 68.1    | Added new interface deleteAvoidAreaPreview()
 * 2016-02-09 | 69.0    | Added new interfaces to support deletion of tours (routes) from DestinationMemory.
 *                        Removed ::navmiddleware;:DestinationInfo::Category from existing DestinationMemory-related route interfaces.
 *                        Removed functions setLocationWithLinkId and setLocationWithPoiId: Not used by HMI; HMI uses
 *                        setLocationWithPickingResult instead
 * 2016-02-04 | 70.0    | Changed method name getIntersectionMapVectorDataList to getIntersectionMapVectorDataInfos
 *                        Introduced types IntersectionMapVectorDataInfos and IntersectionMapVectorDataInfos::IntersectionMapVectorDataInfo
 * 2016-02-10 | 71.0    | Added LimitedFeature-member to ConfigurationInfos along with its activate/deactivate methods
 * 2016-02-12 | 71.1    | Added new modifyDestinationAttributes method
 * 2016-02-12 | 71.2    | Added new methods for POI shortcut configuration
 * 2016-02-15 | 72.0    | Added new interfaces for entering the engineering menu using ::navmiddleware::enterEngineeringMenu and
 *                        exiting using ::navmiddleware::exitEngineeringMenu
 * 2016-02-16 | 73.0    | Changed distance value from int to formatted string with unit in TrafficSignInfo
 * 2016-02-16 | 74.0    | Added mapViewType to getNominalScaleInfos() and getMapCameraInfos() interfaces
 * 2016-02-16 | 75.0    | Added settings for protected overtaking zone and toll booth information
 * 2016-02-16 | 76.0    | Added Poi icons to picking results; extended Map Info's
 * 2016-02-17 | 77.0    | add RoadProperties to PositionInfo
 * 2016-02-18 | 78.0    | add location string to DestinationInfo
 * 2016-02-19 | 79.0    | Add software variant support (only recompilation needed)
 * 2016-02-22 | 80.0    | Removed light mode "twilight" (not used by current projects)
 * 2016-02-22 | 81.0    | 1. Add new methods to NavMiddleware (requestAddressDetailsForCoordinate, getAddressDetailsOfCoordinate)
 *                        2. extend and refactor LocationDetailInfos object
 * 2016-02-23 | 82.0    | Added enum DirectionDescription.Changed direction value type from unsigned int to enum DirectionDescription.
 * 2016-02-29 | 83.0    | Extended the Where Am I info with the Road number image blob data
 * 2016-02-25 | 83.1    | Added support for sorting address book items by a number (SORTINGALGORITHM_BY_ENTRY_POSITION_ASC, SORTINGALGORITHM_BY_ENTRY_POSITION_DESC)
 * 2016-02-29 | 84.0    | New interface and classes for NavDataUpdate compatibility check, modify NAVDATAUPATE_INSTALLATION_STARTED
 * 2016-03-02 | 84.1    | Added new method setLocationWithDestinationMemoryId(const DestinationMemoryId& destinationMemoryId)
 * 2016-03-03 | 85.0    | In MapService:ElementDetailInfoDestination:
 *                        - Changed type of destinationNumber from uint8 to uint16.
 *                        - Replaced HmiRouteId with RouteId.
 *                        In MapInfos:
 *                        - Extended PickingResultDetail with a new class PickingResultDetailDestination.
 * 2016-03-03 | 86.0    | Added mapViewType to addAvoidAreaPreview() interface
 * 2016-03-03 | 86.1    | Add new interface centerMapToScreenPosition()
 * 2016-03-04 | 87.0    | Added the Approaching destination flag in RouteInfo
 * 2016-03-02 | 88.0    | Added new method startTourCalculation and added/modified types in InfoTypes.h
 * 2016-03-08 | 89.0    | Added the recalculating route flag in maneuver infos
 * 2016-03-07 | 90.0    | Added new members PixelPerMeterFactor to existing MapCameraInfos
 * 2016-13.10 | 91.0    | changes the return value of the getTrafficMessageDetailsInfo
 * 2016-03-14 | 92.0    | Change JamAheadListInfo: Substitute boolean active state with activity state enumeration
 * 2016-03-15 | 93.0    | AllSensorDataInfo extended with a flag to indicate almanac validity
 * 2016-03-15 | 94.0    | Added new interface to support the reordering of address book items.
 *                        Extended existing requestDestinationList() interface to support sorting algorithm.
 * 2016-03-18 | 94.1    | Added new interface to support deleting address book items by using the PoiId (pick from map).
 * 2016-03-21 | 95.0    | Add enumeration for sounds used in addressbook attributes
 * 2016-03-21 | 96.0    | Removed getAvoidAreaInfos non const method
                          Modified types in ConfigurationInfos
                          Added Property identifier CONFIGURATION_AVOID_AREA_LIST_CHANGED
 * 2016-03-22 | 97.0    | Added additional parameter to freezeMap, unFreezeMap and isMapFrozen methods
 * 2016-03-23 | 98.0    | ZoomInStep and ZoomOutStep interface changed, new parameter stepCount included
 * 2016-03-23 | 99.0    | Added new flags in NextManeuverInfos to indicate combined maneuvers and intermediate destinations,
 *                        removed recalculating route flag and extended maneuverSymbol enum to indicate recalculating route.
 * 2016-03-24 | 100.0   | Added new interface for traffic info present in route list
 * 2016-03-24 | 101.0   | In MapInfos:
 *                        - Extended PickingResultDetail with two new class PickingResultDetailStormAttributes and PickingResultDetailStormPosition.
 * 2016-03-24 | 102.0   | Added new interface for showing the cross hair on MAP
 * 2016-03-28 | 103.0   | Added additional parameter to handleTouch method
 * 2016-03-29 | 104.0   | Extend ArrivalInfoAlternative with m_indexOfReferencedAlternative member
 * 2016-03-31 | 104.1   | Extend the existing DestinationInfo::SortingAlgorithm with the sorting by IconId
 * 2016-04-01 | 104.2   | Extend the existing DestinationInfo::SortingAlgorithm with sorting by alias
 * 2016-03-24 | 105.0   | In MapInfos:
 *                        - Extended PickingResultDetail with new class PickingResultDetailWeatherAlert.
 * 2016-04-01 | 106.0   | Add Date and TimeFormat to ConfigurationInfos
 * 2016-04-04 | 107.0   | - Removed a number of deprecated map control methods
 *                        - Extended MapSettings with settings for secondary map view.
 *                        - renamed updateChangeMapView to updateChangeMapViewSettings for consistency
 *                        - renamed applyChangeMapView to applyChangeMapViewSettings for consistency
 *                        - renamed getChangeMapView to getChangeMapViewSettings for consistency
 * 2016-04-04 | 107.1   | Extend the existing DestinationInfo::SortingAlgorithm with the sorting by Group
 * 2016-04-05 | 108.0   | Extend the speed limit info with m_speedLimitInHmiDistanceUnit
 * 2016-04-05 | 109.0   | Removed MapViewType parameter from configureLightMode(),
 *                        changed navmiddleware::LightMode to navmiddleware:ConfigurationInfos::LightMode
 * 2016-04-06 | 110.0   | Extended class PickingResultDetailStormPosition with new elements
 * 2016-04-11 | 111.0   | Removed showMultiViewMode method from map
 * 2016-04-11 | 112.0   | Extend the existing DestinationInfo with the property routeCriterion
 * 2016-04-11 | 113.0   | Extended class TouchEventInfo with getter method for each type
 * 2016-04-11 | 113.0   | Add parameter iconTypeUsage to undoLastPoiEntrySelection; extend LocationInfos structure
 * 2016-04-12 | 114.0   | Extended HorizonEventInfo with list of sound file paths,
 *                        extended HorizonEvent enum with ADDRESSBOOK_POI_APPROACH
 * 2016-04-13 | 115.0   | Modify class TouchEventInfo
 * 2016-04-13 | 116.0   | Added requestSdsHouseNumberPatterns, LOCATION_SDS_PATTERNS_CHANGED and SdsHouseNumberPatternsInfos
 * 2016-04-13 | 117.0   | Added additional parameter MapViewType for existing map interface requestPickingDetails()
 * 2016-04-14 | 118.0   | Added additional parameter to startScrollingMap and stopScrollingMap methods.
 * 2016-04-14 | 119.0   | Extended class MapCameraInfos.
 *                        Renamed MapCameraInfos::getMapScale() to MapCameraInfos::getFormattedMapScale()
 *                        Introduced integer map scale to MapCameraInfos. -> MapCameraInfos::getMapScale()
 * 2016-04-15 | 120.0   | Extended class PickingResultDetailWeatherAlert with new elements
 * 2016-04-15 | 120.1   | Add new methods to NavMiddleware (replaceStoredRoute, renameStoredRoute)
 * 2016-04-15 | 121.0   | add MapViewType to selectHighlightedRoute() interface
 * 2016-04-15 | 121.1   | Provide navmiddleware interface method to set a map scale for a map view
 * 2016-04-18 | 122.0   | Extends LocationInfos with TYPE_POI_CATEGORY
 * 2016-04-08 | 123.0   | Changed/extended class PickingResults::PickingResultDetailPoi: Added m_selectionCriterion,
 *                           changed m_poiId to plain value (no ValidValue any more)
 * 2016-04-29 | 124.0   | Extends MapInfos with date item for Weather alert
 * 2016-04-29 | 125.0   | Added the traffic Reception state in the trafficRecpetionStatusInfo Object and added a new getter
 *                        for count of all traffic messages. Changed the return type of getTrafficReceptionStatusInfo to valid value
 * 2016-05-02 | 126.0   | Major refactoring of DestinationMemory interface
 * 2016-05-11 | 127.0   | Modify distance and direction to ValidValue in DestinationMemoryEntryAttributes
 * 2016-05-11 | 127.1   | Added get methods for the traffic reception state.
 * 2016-05-11 | 128.0   | DestinationMemoryDestination Info object extended with DestinationMemoryDestinationDetails
 * 2016-05-11 | 129.0   | Extend RefinementWithIdInfos::RefinementWithId with Distance and Direction information
 * 2016-05-11 | 129.1   | Provide navmiddleware interface method to get data loading status and data rendering status for HMI
 * 2016-05-13 | 130.0   | Order of DestinationMemory property updates changed
 * 2016-05-18 | 131.0   | Modified middleware interface return type for user icon getter
 * 2016-05-19 | 132.0   | Add DestinationMemoryItem as a composite for Entry and Route objects.
                          Add DestinationMemoryItem::IdElement as a composite for Entry and Route ids.
                          Modify getLastDestinationList, removeLastDestinationListItem to accept both Entry and Route objects/ids.
                          Rename removeLastDestinationListItem to removeLastDestinationListItems.
 * 2016-05-20 | 133.0   | Data types of Maximum and Minimum HouseNumbers from SdsHouseNumberPatternsInfos changed to String
 * 2016-05-23 | 133.1   | New interface showSetLocationInMap() added
 * 2016-05-26 | 134.0   | Added Toll booth warning flag to HorizonEventInfo
 * 2016-05-30 | 135.0   | Headline string is provided in case of traffic icon pick from map
 * 2016-05-30 | 135.1   | Add new interface startStoredRouteCalculationWithDestinationMemoryId
 * 2016-05-31 | 135.2   | Add interface to get free text search speller info
 * 2016-05-31 | 136.0   | Changed return type of "getUserPoiIcons" method from reference to copy
 * 2016-06-01 | 137.0   | Add interface to optimize waypoints and extend WaypointInfos
 * 2016-05-24 | 138.0   | Modify type of Distance as an enumeration in DestinationMemoryEntryAttributes
 * 2016-06-06 | 139.0   | Change VoiceTag as ValidValue type in DestinationMemoryEntryAttributes
 * 2016-06-08 | 140.0   | Show POI Info in two lines of POI list element
 * 2016-06-08 | 141.0   | Extended TrafficServiceReceptionStatusInfo with the reception time
 * 2016-06-09 | 142.0   | Extend RouteListElementInfo with length of an element as a number
 * 2016-06-09 | 143.0   | Modify SortingAlgorithm enumeration to support sort by 'Alias' in ascending and descending order
 * 2016-06-09 | 143.1   | Provide lock/unlock to support multithreading environments (winsim, regressiontest)
 * 2016-06-11 | 144.0   | LocationDetailInfos::LocationDetailInfo::Type order of the enum entries changed as well as new entries added
 * 2016-06-10 | 145.0   | Extend NavDataComponent for USB and SMARTPHONE
 *                        getDownloadProgress() API changed to getProgress() in NavDataUpdateStatus
 * 2016-06-15 | 146.0   | Added isAlongRoute flag for Traffic Messages in TrafficMessageDetailsInfo
                          Moved UserRule from TrafficMessageInfoBase to TrafficMessageDetailsInfo
 * 2016-06-16 | 147.0   | Modified the NextManeuverInfos class design to give relevant next maneuver informations
 * 2016-06-16 | 148.0   | Return as reference in getDirection() and getVoiceTag() and write new methods to invalidate them
 * 2016-06-16 | 148.1   | Adding operator== to EngineeringInfos
 * 2016-06-16 | 149.0   | In startScrollingMap interface : scrollSpeed modified and added a new additional parameter "maxScrollInPixels"
 * 2016-06-17 | 150.0   | Extended ArrivalInfosAlternatives with route color values
 * 2016-06-20 | 151.0   | Added ROUTE_CALCULATION_ERROR__ROUTE_IMPOSSIBLE in RouteCalculationError
 * 2016-06-16 | 151.1   | Added new interface for Continuous Map Rotation
 * 2016-06-21 | 152.0   | NavDataUpdateStatus extended by remaining seconds, product and region name
 * 2016-06-21 | 152.1   | 2 new PropertyIndentifiers for lifecycle management (active nav data update) added
 * 2016-06-21 | 153.0   | signature of showRouteOverview() extended with MoreRoutesTypeValue
 * 2016-06-21 | 154.0   | Added fields m_address, m_houseNumber, m_street, m_city, m_state, m_country to
 *                        PickingResultDetailAddressBookPoi to provide additional details of picked address book entry.
 * 2016-06-22 | 154.1   | Adding new methods getWeatherFeaturesStatusInfo to NavMiddleware.h
 *                        Adding new WeatherFeaturesStatusInfo class, Adding new enums MAP_WEATHER_FEATURES_STATUS_CHANGED to PropertyIdentifiers.h
 * 2016-06-22 | 155.0   | Added Audio display on map setting
 * 2016-06-22 | 155.1   | Modify SortingAlgorithm enumeration to support sort of recent destinations sorted alphabetically
 * 2016-06-23 | 156.0   | Provide starting letters and indices for POI category index bar
 * 2016-06-23 | 157.0   | Refactor Free Text Search interface
 * 2016-06-23 | 157.1   | Property Update DATAUPDATESTATUS__PROCESS_COMPLETE changed to DOWNLOAD_UPDATE_SUCCESSFULLY_FINISHED
 * 2016-06-23 | 157.2   | Added a new interface getAddressbookMediaPath() to get the Address book media path
 * 2016-06-24 | 158.0   | Added Last 5 Cities Interface and Modified Start Interface for HierarchialAddressInput
 * 2016-06-24 | 159.0   | Added m_airDistance and m_direction to PickingResult in MapInfos.h
 * 2016-06-27 | 160.0   | Added Show all freeway exits on map setting
 * 2016-06-27 | 161.0   | Modify:Return the list of current available devices instead of each device status using getNavDataDeviceInfos
 * 2016-06-28 | 162.0   | Added getLastGuidedRouteNumberOfWaypointsReached function
 *                        Changed startStoredRouteCalculationWithDestinationMemoryId function (new parameter uint32_t numberOfWaypointsToSkip)
 *                        Changed requestLastDestinationList function (new parameter DestinationMemoryItemList::Filter requestFilter)
 *                        Added timestamp to DestinationMemoryItem structure
 * 2016-06-28 | 163.0   | Added new info class for traffic icon selection list
 *                        Added request for traffic icon selection list
 *                        Added getter for Traffic Icon selection list info.
 *                        Modified the traffic settings object.
 * 2016-06-30 | 164.0   | releasePickInMap() method is made const to fix lint warning.
 * 2016-06-21 | 165.0   | Extended MapSettings with settings on Stepwise zooming on Map and
 *                        Extended the zooming interface with stepwise zooming option along with zooming on nominal scales.
 *                        Changed the order of the parameters(cameraAnimation is made as the last parameter)
 * 2016-06-30 | 166.0   | Provide coordinate as part of LocationDetails
 * 2016-06-30 | 166.1   | Tracking dots feature introduced.
 *                        updateMapTrackingDotsSettings(MapTrackingDotsSettings)
 *                        applyMapTrackingDotsSettings()
 *                        MapTrackingDotsSettings getMapTrackingDotsSettings()
 *                        deleteAllTrackingDots()
 * 2016-07-04 | 167.0   | flag useSpeedLimitFromCamera in SpeedLimitData replaced by enum SpeedLimitUsage.
 *                        SpeedLimitData extended with m_overspeedWarningFromExternalSource
 *                        to hold overspeed warning set from external source.
 * 2016-07-04 | 167.1   | Added NAVDATAUPDATE_UPDATE_INFO_CHANGED property update for requestAvailableUpdates
 * 2016-07-04 | 168.0   | speedCamDistance type changed from int to string ( formatted string with unit)
 * 2016-07-01 | 169.0   | Extended MapView configureLightMode() with LightModeSettings
 * 2016-07-07 | 169.1   | [Location Input] Add further search scope types for FTS.
 * 2016-07-07 | 170.0   | Added ZipCode as a part of destinationDetails
 * 2016-07-05 | 171.0   | Modify DestinationMemoryStatus to store the number of stored routes.
 * 2016-07-08 | 171.1   | Added property update for change in guidance settings.
 * 2016-07-08 | 172.0   | Extend signature of method insertWaypoint() with WaypointEditMode
 * 2016-07-09 | 173.0   | Added new member m_locationDetailInfos to PickingResultDetailPoi in MapInfos.h
 * 2016-07-09 | 174.0   | Add new getter for NavDataUpdateStatus and add/modify update status enumerations
 * 2016-07-06 | 174.1   | Added new element in the TrafficIconSelectionCriteria enum.
 * 2016-07-11 | 175.0   | Extended RouteListElementInfo class for traffic icon data
 * 2016-07-11 | 176.0   | Added new members (address data) to DestinationInfo
 * 2016-07-12 | 176.1   | Added External Location Interfaces in LocationInput
 * 2016-07-12 | 176.2   | Added new element in the DataUpdateStatus enumeration.
 * 2016-07-12 | 177.0   | Refactored NavDataUpdateInfos (cleanup enums, fix toString, etc.)
 * 2016-07-13 | 178.0   | Added touch gestures (Tap, Swipe, Rotate, Pinch) to TouchActions in MapInfos.h
 * 2016-07-13 | 179.0   | Add property update store for storeEntry interface functions
 *                        Add DestinationMemoryStoreEntryStatus in DestinationMemoryInfos.h
 *                        Remove getStoredEntryId function
 *                        Add getStoreEntryStatus function
 * 2016-07-14 | 180.0   | TouchEventInfo internal behavior and description updated
 * 2016-07-15 | 181.0   | Extended signature of requestFreeTextSearchResults() with filterType.
 * 2016-07-15 | 182.0   | Extend NextManeuverInfos with destination direction information
 * 2016-07-15 | 183.0   | Extended AllSensorDataInfo with speed value as int.
 * 2016-07-15 | 184.0   | Added new members of detailed address data to DestinationInfo and PickingResultDetailDestination
 *                        of PickingResultInfos
 * 2016-07-16 | 185.0   | Modified GuidanceSettings. Renamed getHorizonTrafficAnnouncement() as getTrafficAnnouncements()
 * 2016-07-16 | 186.0   | New map mode(MAP_MODE_COMPASS_NAVI) introduced
 * 2016-07-16 | 187.0   | Added new interface showTrafficDetourInMap() and added new enum MAP_MODE_TRAFFIC_DETOUR to MapCameraMode.
 * 2016-07-17 | 188.1   | Added new enum LocationInputType, VisibleListInfo and new method showLocationsInMap for POI icons
 * 2016-07-19 | 189.0   | Change in RouteElementsInfo status for AvoidElements from bool to enumerator
 * 2016-07-19 | 190.0   | Change then name of MapViewTypes to MapViewSettingsType in ::navmiddleware::settings
 *                        to resolve name conflicts with ::navmiddleware::MapViewType
 * 2016-07-20 | 191.0   | Added new members(TimestampDate) to destinationMemoryInfos
 * 2016-07-21 | 192.0   | Extended RouteListInfos with destinationOfSegment value and added new enum value TURN_LIST_ICON_TYPE_WAYPOINT_FLAG
 * 2016-07-21 | 193.0   | Modified the Traffic sign information settings and removed unwanted TrafficSignId enum values in GuidanceInfos
 * 2016-07-22 | 194.0   | Remove deprecated enum values from NavDataUpdateStatus::DataUpdateStatus
 * 2016-07-22 | 195.0   | Add m_navigationUnitIdentifier to ConfigurationInfos
 * 2016-07-23 | 195.1   | Provide error property update if picking off map locations
 * 2016-07-23 | 195.2   | Provide navigation data version info
 * 2016-07-25 | 196.0   | Added the m_tappedDirection in the TouchGestureTap of TouchEventInfo.
 * 2016-07-25 | 196.1   | getRemainingTimeInSeconds of NavDataUpdateInfo is set to const.
 * 2016-07-26 | 197.0   | Add calculation status of alternative routes in ArrivalInfosAlternatives
 * 2016-07-28 | 198.0   | Added interface(setFreeTextSearchSortOrder) for sorting Fts Result and extended startFreeTextSearchInput
 *                        with sortOrder parameter.
 * 2016-07-29 | 198.1   | Added interface(setSelectionOfAllUpdates) for NavDataUpdate
 * 2016-08-01 | 199.0   | Renamed property identifier MAP_MULTIVIEWMODE_CHANGED to MAP_SET_MAP_CAMERA_AND_VIEW_MODES_DONE
 * 2016-08-01 | 200.0   | MOve getDescription (NavDataUpdateInfos) implementation to NavDataUpdateControl
 * 2016-08-04 | 201.0   | Add new route settings - Enable Route Alternative for Renault ST2.1
 * 2016-08-04 | 201.1   | Add new interface replaceEntryLocation() to replace stored location for the given entry
 * 2016-08-04 | 201.2   | Added NavDataUpdateSelection class to NavDataUpdateInfos.
 *                        New interface added (getUpdateSelectionStatus) for NavDataUpdate.
 * 2016-08-04 | 201.3   | Added new method in NavMiddleware.h(RestoreDefaultSettings)
 * 2016-08-05 | 202.0   | Extended TrafficImpactRouteAlternativeInfos with user confirmed dynamization information
 * 2016-08-06 | 202.1   | Added interface (releaseXUrgentTrafficMessage) for getting a trigger from HMI on the confirmation of a XUrgent traffic message by user.
 * 2016-08-08 | 203.0   | In ManeuverViewInfo, getmaneuverViewType() renamed to getManeuverViewType().
 *                        In SignPostInfo isSignpostAvailable() renamed to isSignPostAvailable(), setSignpost() renamed to setSignPost.
 * 2016-08-09 | 204.0   | LocationCategoryInfo extended with poiCategoryId
 * 2016-08-09 | 205.0   | In TouchActions within MapInfos, new parameter m_touchActionScrollOnHold is added
 * 2016-08-10 | 206.0   | GnssMode is provided as an Enum instead of a string
 * 2016-08-10 | 206.1   | Added new method switchToFreeMode()
 * 2016-08-10 | 206.2   | Added new interface to release traffic message when user moves out from traffic message details screen.
 * 2016-08-11 | 206.3   | New Interface added in Position (setPositionByCoordinates)
 * 2016-08-11 | 207.0   | Updated the interface showTrafficDetourInMap() with new parameter CameraAnimation.
 * 2016-08-15 | 208.0   | Changed to one general applySettings function, instead of many setting specific apply functions
 * 2016-08-19 | 209.0   | Changed return type of selectAddressCategoryForInput and clearAddressCategory from bool to void
 * 2016-08-18 | 209.1   | Added interface (storeRoute) to add existing route to a different category.
 *                        Added new enum definition DestinationMemoryRoute::Category
 * 2016-08-22 | 210.0   | Added m_airDistance and m_direction to PickingResults in MapInfos.h
 * 2016-08-22 | 211.0   | Modified removeAllLastDestinationListItems functions with a request filter (DestinationMemoryItemList::Filter) as an input parameter.
 * 2016-08-23 | 212.0   | Use LocationDetailInfos in DestinationInfos, instead of single strings
 * 2016-08-24 | 213.0   | Adapt PickingResultDetailAddressBookPoi class for additional details with LocationDetailInfos
 * 2016-08-25 | 214.0   | Changed implementation of template ::navmiddleware::ValidValue::getValueOr()
 * 2016-08-26 | 215.0   | Removed deprecated methods NavDataUpdate
 * 2016-08-26 | 216.0   | Extend and modify the existing DestinationInfo::SortingAlgorithm with new values to support sorting alphabetically in descending.
 * 2016-08-29 | 217.0   | Extend signature of method deleteWaypoint() with WaypointEditMode
 * 2016-08-30 | 218.0   | Extended ConfigurationInfos with 'displayTimeUTCOffset' value
 * 2016-09-06 | 218.1   | Extended NavDataUpdateInfos with 'updateInfoRangeList'
 * 2016-09-07 | 219.0   | Extend signature of method replaceWaypointLocation() with WaypointEditMode
 * 2016-09-07 | 220.0   | Modified ::navmiddleware::MapViewType to ::navmiddleware::MapViewId,
 *                        ::navmiddleware::settings::MapViewSettingsType to ::navmiddleware::settings::MapHMISplitMode
 *                        and removed the handleTouch interface since this is not required.
 * 2016-09-02 | 221.0   | ShowLocationsInMap interface modification
 * 2016-09-07 | 221.1   | Extend the existing DestinationInfo::SortingAlgorithm with SORTINGALGORITHM_BY_LAST_CREATION_TIME for requestStoredRoutes.
 * 2016-09-08 | 222.0   | Added new parameter MapViewVisibility to interface freezeMap
 *                        Added new enum MapViewVisibility to MapInfos.h
 * 2016-09-09 | 223.0   | added distances to RouteInfo
 * 2016-09-09 | 224.0   | removed m_pixelPerMeterFactor from MapCameraInfos
 *                      | added m_scaleBarWidthInPixel to MapCameraInfos
 * 2016-09-15 | 224.1   | Added new interface function removeRoute to remove list of routes
 * 2016-09-15 | 225.0   | Modification on NavDataUpdateInfos - no signature change
 * 2016-09-24 | 226.0   | Extended ConfigurationInfos and the interface 'setDisplayTimeOffset()' with 'timeZoneAndDSTConsideration' value
 * 2016-09-28 | 227.0   | Modification on NavDataUpdateInfos - structure altered
 * 2016-09-29 | 228.0   | Resolving ambiguous naming in the interfaces.
 *                        MapRepresentation enum is split into 3 enums MapSplitMode, MapOrientation and MapPitch.
 *                        New structure MapRepresentation is introduced which is a combination of MapOrientation and MapPitch.
 *                        enum ViewSize is removed.
 * 2016-09-28 | 229.0   | Enhance use-case : m_range of VisibleListInfo structure, used in showLocationsInMap for POI
 * 2016-10-13 | 230.0	| Import Neusoft extension interfaces CW39
 * 2016-25-10 | 231.0   | Import Neusoft extension interfaces CW40
 * 2016-10-10 | 232.0   | Extend DeviceStatus enum of NavDataDeviceInfo
 * 2016-10-18 | 233.0   | Remove unused m_distanceToStartPositionAsValue and m_offsetAsInt from RouteListElementInfo
 * 2016-10-19 | 234.0   | Remove obsolete members from PickingResultDetailAddressBookPoi and PickingResultDetailPoi class
 * 2016-10-12 | 235.0   | Hierarchical POI input: Remove IconTypeUsage and numFirstEntries from functions,
 *                        remove speller related functions and properties
 * 2016-11 -1 | 236.0 	| Import Neusoft interface changes CW 42
 * 2016-10-20 | 237.0   | Added a new value TURN_LIST_ICON_TYPE_BORDER_CROSSING in enum TurnListIconType of RouteListInfos
 * 2016-10-24 | 238.0   | Added a new value DATEFORMAT_MM_DD_YYYY_DASH & DATEFORMAT_YYYY_MM_DD_DASH in enum DateFormat of InfoTypes
 * 2016-10-26 | 239.0   | Removed DATEFORMAT_YYYY_DD_MM_DASH & Renamed DATEFORMAT_YYYY_MM_MDD_JPN to DATEFORMAT_YYYY_MM_DD_JPN in enum DateFormat of InfoTypes
 * 2016-11-15 | 240.0   | Import Neusoft extension interfaces CW44
 * 2016-11-02 | 240.0   | Extend route list element with ETA; Extend routelistinfos with RouteListElementIndexMap; Extend VehicleProfile with vehicleType and engineType
 * 2016-11-07 | 241.0   | Extend DestinationMemoryStatus with functions:
 *                         - getNumberOfHomeEntries()
 *                         - getNumberOfWorkEntries()
 *                         - getNumberOfPreviousDestionationItems(DestinationMemoryItemList::Filter filter)
 * 2016-10-28 | 242.0   | Added getStoredRouteStatus interface function and removed getStoredRouteId().
 *                        Property DESTINATIONMEMORY_ROUTE_STORED renamed to DESTINATIONMEMORY_STORE
 * 2016-11-09 | 243.0   | Modified PositionInfos
 *                        - renamed AllSensorDataInfo to GnssDataInfo.
 *                        - added HemisphereLatitude to GnssDataInfo.
 *                        - added HemisphereLongitude to GnssDataInfo.
 * 2016-11-09 | 243.0   | Extend LocationSearchScope with new TYPE__CONNECTED_TO_CURRENT_LOCATION_POI;
 *                      | add new function setLocationWithPoiData
 *                      | Extend RouteInfos with POIData for freeway exits
 * 2016-11-09 | 243.0   | Extend DestinationMemoryRoute with functions:
 *                         - getFinalDestinationName()
 *                         - getWaypointsName()
 * 2016-11-15 | 240.0   | Import Neusoft extension interfaces CW44
 * 2016-11-16 | xxx.x   | Extend method startRouteListInfo with additional parameter to configure the content of the route list
 * 2016-11-17 | 243.0   | Add new function setLocationWithWaypointIndex()
 * 2016-11-21 | xxx.x   | Remove parameter 'sortOrder' from function startFreeTextSearchInput
 *                        (It's not sensibly possible to let HMI set the default sort order of FTS.)
 * 2016-11-21 | 243.0   | Extend the following functions with the input parameter - const ::std::string& freeTextSearchString:
 *                         - requestEntryList()
 *                         - requestStoredRoutes()
 * 2016-11-23 |         | Added new MapCameraMode MAP_MODE_SETTINGS_LEFT_MAP_SCALE, which will be used by HMI only for
 *            |         | setting the left view map scale from settings.
 * 2016-11-23 | xxx.x   | Change signature of method deleteWaypoint() - now it's possible to delete more than one waypoint
 *                        Extend ArrivalInfo with POIReachabilityStatus
 *                        Remove method RouteListElementInfo::addTrafficEventIconCategoryIcon() because it's not needed anymore
 * 2016-11-23 | 244.0	| Import Neusoft interface changes CW 45
 * 2016-11-29 | 245.0	| Import Neusoft interface changes CW 46
 * 2016-11-30 | xxx.x   | New interfaces to control trip-files replay.
 *                        New class in PositionInfos (trip-files interface related).
 * 2016-11-30 | xxx.x   | Add parameter RestoreType to restoreFactorySettings()
 * 2016-11-30 | xxx.x   | Extend RouteListElementInfo with traffic sense
 * 2016-12-01 | xxx.x   | Add support for generic configuration values at startup (key/value)
 * 2016-12-01 | xxx.x   | Add support for map on multiple screens
 * 2016-12-02 | xxx.x   | Add an additional parameter camera animation to the interface method showLocationsInMap()
 * 2016-12-05 | xxx.x   | Add new settings class MapDynamicIconSettings for selecting dynamic POI
 *            |         | categories for map icon display.
 * 2016-12-06 | 246.0   | Import Neusoft interface changes CW 47
 * 2016-12-07 | xxx.x   | New interface showSatelliteImagesInMap(...) and new MapCameraMode introduced
 * 2016-12-07 | xxx.x   | Added new interface showTrafficOverviewMap()
 * 2016-12-09 | xxx.x   | Added map settings for lightmode, traffic display, weather display, junction view display
 * 2016-12-12 | 247.0   | Import Neusoft interface changes CW 48
 * 2016-12-21 | 248.0   | Import interface changes CW 49
 * 2016-12-27 | 249.0   | Import interface changes CW 50
 * 2016-12-27 | 250.0   | Import interface changes from Neusoft CW 50
 * 2017-01-03 | 251.0   | Import interface changes CW 51
 * 2016-12-23 | xxx.x   | Implement a new settings handler for the new MapDynamicIconSettings class.
 * 2017-01-02 | xxx.x   | New info class,new methods for request and new propertyIdentifier has been added for WeatherData
 * 2017-01-03 | xxx.x   | Extend showLocationsInMap(...) with map scale parameter
 * 2017-01-05 | xxx.x   | Extend HorizonEventInfo with avoid area name list
 * 2017-01-03 | xxx.x   | Extend showLocationsInMap(...) with map scale parameter
 * 2017-01-05 | xxx.x   | Extend HorizonEventInfo with avoid area name list
 * 2017-01-10 | 252.0   | Import interface changes CW 52
 * 2017-01-16 | xxx.x   | New interface for calculating route and starting Guidance to the destination
 * 2017-01-13 | xxx.x   | New request interface (installUpdateFromUrl) for SOTA source
 *                        New DEVICETYPE__SOTA (NavDataUpdateInfos)
 * 2017-01-17 | xxx.x   | Added new interface showAddressbookIconsInMap() to display addressbook icons
 * 2017-01-19 | xxx.x   | Extend NavDataUpdateOverviewInfo with UpdateableAreaName
 * 2017-01-19 | xxx.x   | Extend ArrivalInfos and ArrivalInfosAlternatives for Fuel Consumption and Traffic Delay
 * 2017-01-19 | xxx.x   | Extended weatherInfos with location type and list of weather reports
 * 2017-01-19 | xxx.x   | Add ErrorCode to LocationInfos
 * 2017-01-19 | xxx.x   | Extend ConfigurationInfos with non-traffic region information
 * 2017-01-19 | xxx.x   | Add category details in PickingResultDetailAddressBookPoi in MapInfos
 *                        Change type of m_addressBookGroup in PickingResultDetailAddressBookPoi class
 * 2017-01-19 | xxx.x   | Added vehicle type in Configuration Infos.
 * 2017-01-19 | xxx.x   | Added selectActiveRoute method for the cancel flow in route overview
 * 2017-01-20 | 253.0   | Import interface changes CW 01
 * 2017-01-20 | 254.0   | Import interface changes from Neusoft CW 01
 * 2016-01-20 | xxx.x   | New request interface requestAvailableUpdates(deviceId, downloadURL, requestType)
 * 2017-01-20 | xxx.x   | Added new interface removeUnusedRoutes() to remove unused route alternatives for active route
 * 2017-01-23 | xxx.x   | Fix coverity issues in copy-constructors
 * 2017-01-25 | 255.0   | Import interface changes CW 02 + CW 03
 * 2017-01-25 | xxx.x   | Change Temperature and WindSpeed attributes type to strings in weatherInfos
 * 2017-01-25 | xxx.x   | Move DestinationMemoryEntry::Category and DestinationMemoryEntryAttributes::Group enumerations to InfoTypes
 *                        Change type of m_addressBookGroup and m_category in PickingResultDetailAddressBookPoi class
 *                        Change type of argument category in storeEntry(), removeAllEntries() and requestEntryList()
 * 2017-01-27 | xxx.x   | Remove unused DESTINATIONMEMORY_ENTRY_REMOVED property update and
 *                        send similar updates on removeEntryByPoiId() like in removeEntry()
 * 2017-01-31 | 256.0   | Import interface changes CW 04
 * 2017-01-31 | xxx.x   | Extend enumeration ManeuverSymbol with an entry that indicates its size
 * 2017-01-31 | 256.0   | Import interface changes CW 04
 * 2017-02-01 | xxx.x   | Renamed centerMapToScreenPosition to centerMapToViewCoordinate
 * 2017-02-01 | xxx.x   | Provide register and unregister callbacks for locationbasedservices
 * 2017-02-01 | xxx.x   | Extend waypointInfo with information if waypoint is reached in guided route
 * 2017-02-01 | xxx.x   | Extend moveWaypoint() with parameter WaypointEditMode
 * 2017-02-02 | xxx.x   | Extend DestinationMemoryAttributesGroup enumeration with new subGroup.
 *                        Extend requestEntryList() to request entries filtered by DestinationMemoryAttributesGroup
 * 2017-02-06 | 257.0   | Import interface changes CW 05
 * 2017-02-08 | xxx.x   | Extend ArrivalInfos, ArrivalInfosAlternatives and RouteListInfo with road type info
 * 2017-02-09 | xxx.x   | Add route setting UseLearnedRoutes
 * 2017-02-13 | xxx.x   | Add setDefaultPosition-Interface for diagnosis factory-reset
 * 2017-02-13 | 258.0   | Import interface changes CW 06
 * 2017-02-15 | xxx.x   | Add an interface to get AddressFormat per Country
 * 2017-02-15 | xxx.x   | Added interfaces to support SDN data in NDS dataset
 * 2017-02-15 | xxx.x   | Provide SDS specific SdsPositionInfo in parallel to existing PositionInfo
 * 2017-02-15 | xxx.x   | Provide new properties for position quality and RNW data availability at current position
 * 2017-02-21 | 259.0   | Import Neusoft Interface Changes CW 07
 * 2017-02-21 | 260.0   | Import Interface Changes CW 07
 * 2017-02-22 | xxx.x   | Add DestinationMemoryAliasInfo. Extend LocationDetailInfo with DestinationMemoryAliasInfo
 * 2017-02-23 | xxx.x   | Remove doubled UseLearnedRoutes type
 * 2017-02-23 | xxx.x   | Extend SdsNdsIdStringInfo with SDSAddressElementType
 * 2017-02-23 | xxx.x   | Added Interfaces related to weather icon picking on map specific for Renault 2.1
 * 2017-02-23 | xxx.x   | Added new interfaces related to avoid area funtionality for Renault 2.1
 *                         - showAvoidAreaOverviewInMap(), getAvoidAreaHMIOverlay(), enum AvoidAreaVisibility
 *                         - addAvoidArea() and modifyAvoidArea() are overloaded
 *                         - new map property MAP_AVOIDAREA_HMI_OVERLAY_INFO_CHANGED
 *                         - new map camera mode MAP_MODE_AVOIDAREA_OVERVIEW
 *                         - modified AvoidAreaInfo class
 *                         - rename AvoidAreaInfo::Id to AvoidAreaId
 * 2017-02-28 | 261.0   | Import interface changes CW 08
 * 2017-02-27 | xxx.x   | Added FEET and YARD unit types to enum DistanceUnit
 * 2017-02-27 | xxx.x   | Extend deleteAvoidAreaPreview to support MapViewId
 * 2017-03-01 | xxx.x   | Fix the typo to STORM_CATEGORY_HURRICANE_CAT_1 in StormCategory
 * 2017-03-02 | xxx.x   | Modified RouteInfoProperties to provide Violated route options information
 * 2017-03-06 | 262.0   | Import interface changes CW 09
 * 2017-03-03 | xxx.x   | Extended navmiddleware::Image structure by icon id
 * 2017-03-07 | xxx.x   | Add requests for MapUpdate SOTA registration
 * 2017-03-07 | xxx.x   | Added new interface to skip Waypoint
 * 2017-03-09 | xxx.x   | Extended and renamed RouteCalculationErrorInfo as RouteCalculationInfo to provide route calculation reason additionally
 *                        renamed interface getRouteCalculationErrorInfo() as getRouteCalculationInfo()
 * 2017-02-09 | xxx.x   | Added new Engineering Debug Infos class.
 *                        Added new request for requesting, getting, releasing traffic debug information.
 *                        Added new property identifier for Engineering Debug Infos.
 * 2017-03-09 | xxx.x   | Extend enumeration DestinationMemoryEntry::SortingAlgorithm to support sort by access time with earliest on top.
 * 2017-03-13 | 263.0   | Import Interface CW 10
 * 2017-03-09 | xxx.x   | Extend ViewModeConfiguration structure with ViewModeOptions
 * 2017-03-16 | xxx.x   | Provide missing getters for AliasInfo.
 * 2017-03-16 | xxx.x   | Fixed copy constructor in PickingResultDetailWeatherIcon
 * 2017-03-16 | 264.0   | Import Interface CW 11
 * 2017-03-20 | xxx.x   | Added SignPostInfo to RouteListElementInfo in RouteInfos.h
 * 2017-03-21 | xxx.x   | Provide new property for vehicle movement status
 * 2017-03-22 | xxx.x   | Added TrafficEnforcementInfo, and corresponding property identifier GUIDANCE_TRAFFIC_ENFORCEMENT_INFO_CHANGED
 *                        Added TrafficEnforcement related settings to safetyCameraSettingsHandler
 * 2017-03-23 | xxx.x   | Fixed SignPostInfo's toString() error
 * 2017-03-27 | 265.0   | Import Interface CW 12
 * 2017-03-24 | xxx.x   | Fix typo in request setLocationWithFreeTextSearchResult
 * 2017-03-27 | xxx.x   | Provide MotorwaySelectionStatus and deny request for Freeway on Destination
 * 2017-03-27 | xxx.x   | Added new member DisplayAspectRatio to structure ScreenDimensions in ConfigurationInfos.h
 * 2017-03-24 | xxx.x   | Added toString() functions for enums in MapInfos.h & MapSettings.h
 * 2017-03-28 | xxx.x   | Added getSupplier function to differentiate between Bosch and Neusoft NavMiddleware
 * 2017-03-28 | xxx.x   | Remove unused route type RegularAdminClosed from RouteInfoProperties
 *                        Rename enum RouteInfoProperties::Status::STATUS__PRESENT_DESPITE_AVOIDING
 * 2017-03-29 | xxx.x   | Extended MapViewId enum with 2 additonal values and renamed the 2 existing values to naming convention
 * 2017-03-30 | xxx.x   | Reformatted the source code after formatSource.sh script was fixed
 * 2017-04-04 | 266.0   | Import Interface CW 13
 * 2017-04-03 | xxx.x   | Extended SignPostInfo as vector in RouteListElementInfo
 * 2017-04-04 | xxx.x   | Extend PositionStatusInfo with enums HemisphereLatitude and HemisphereLongitude
 * 2017-04-05 | xxx.x   | Added operator=() to class PickingResultDetailTm
 * 2017-04-05 | xxx.x   | Extend RouteCalculationInfo with RouteCalculationInfoAlternative
 * 2017-04-04 | xxx.x   | rename ScomoNavDataContext to NavDataContext and add new fields to UpdateRegion and Product of NavDataContext
 * 2017-04-06 | xxx.x   | Extend TrafficReceptionStatusInfo with the traffic message source
 * 2017-04-07 | 267.0   | Import Interface CW 14
 * 2017-04-07 | xxx.x   | Added new interfaces for speed and flow information in information bar
 * 2017-04-12 | xxx.x   | Added Const Qualifier for SdsNdsIdStringInfo::getSDSAdressElementType and Bugfixes in toString() functions
 *                        Added Additional description for Hemisphere variables in the class PositionStatusInfo
 * 2017-04-13 | xxx.x   | Added new interfaces transformViewPositions() and getTransformedViewPositionsInfo()
 *                        Added new map property MAP_TRANSFORMED_VIEW_POSITIONS_AVAILABLE
 * 2017-04-13 | xxx.x   | use AvoidAreaId-Type in showAvoidAreaOverviewInMap
 * 2017-04-17 | 268.0   | Import Interface CW 15
 * 2017-04-19 | xxx.x   | Extend WaypointInfos with OptimizationStatus
 * 2017-04-19 | xxx.x   | Added distanceToTrafficMessageInMeters attribute in TrafficMessageInfos for plotting traffic message on traffic information bar
 * 2017-04-24 | 269.0   | Import Interface CW 16
 * 2017-04-21 | xxx.x   | Extend SignpostInfo to provide road number image details with cardinal direction and language code.
 * 2017-04-21 | xxx.x   | Added new interface related to EV Reachable Area
 *                        - showReachableAreaOverviewInMap(), enum ReachableAreaVisibility
 *                        - new map camera mode MAP_MODE_REACHABLEAREA_OVERVIEW
 * 2017-04-25 | xxx.x   | Added new interfaces for set and get MapEvSettings.
 * 2017-04-27 | xxx.x   | Add new category DESTINATION_MEMORY_ENTRY_CATEGORY__ADDRESS_GADGET to DestinationMemoryEntryCategory
 *                        - Add new property DESTINATIONMEMORY_ADDRESS_GADGET_LIST_CHANGED, triggered when fetching/modifying ADDRESS_GADGET entry
 *                        - Add new interface functions to DestinationMemoryStatus:
 *                            getNumberOfAddressGadgetEntries()
 *                            setNumberOfAddressGadgetEntries()
 * 2017-04-27 | xxx.x   | Added new interfaces related to User Profiles and extended ConfigurationInfo with user profile enumeration
 *                        - setUserProfile(ConfigurationInfos::UserProfile userProfile)
 *                        - copyUserProfileToUser(ConfigurationInfos::UserProfile targetUserProfile)
 * 2017-04-27 | xxx.x   | Rename RoadNumberDetails to RoadNumberInfo.
                          Provide road number direction as a string.
 * 2017-04-27 | xxx.x   | Added EV battery status warning settings to navmiddleware interface
 * 2017-05-02 | 270.0   | Import Interface CW 17
 * 2017-05-02 | xxx.x   | toString() function extended to print Vector of InfoObjects
 * 2017-05-03 | xxx.x   | Added EV charging station auto save settings to navmiddleware interface
 * 2017-05-03 | xxx.x   | Use ManeuverID for all usages of IntersectionMapId; introduce ManeuverId in NextManeuverInfos
 * 2017-05-03 | xxx.x   | Extend GnssDataInfo by speed reliability value (CFNAVMW-3590)
 * 2017-05-04 | xxx.x   | Added new interface to provide VehicleModeType
 * 2017-05-04 | xxx.x   | Added new interface MoveMapCenterPoint()
 * 2017-05-04 | xxx.x   | Added new interface configureMapLocationMarker()
 * 2017-05-08 | 271.0   | Import Interface CW 18
 * 2017-05-05 | xxx.x   | Extend LocationInfo structure by LocationSource and EntryType (CFNAVMW-2592)
 * 2017-05-06 | xxx.x   | NavDataUpdateInfos.h: VersionDescripion added, baselineMapId aded to ProductVersionInfo, AvailableUpdatesResult added
 * 2017-05-08 | xxx.x   | Added MAP_MODE_WHERE_AM_I to enum MapCameraMode in MapInfos
 * 2017-05-09 | xxx.x   | Add new category DESTINATION_MEMORY_ENTRY_CATEGORY__PERSONAL_EPOI to DestinationMemoryEntryCategory
 *                        - Remove DESTINATION_MEMORY_ATTRIBUTES_GROUP__PERSONAL_EPOI SubGroup
 *                        - Add new property DESTINATIONMEMORY_PESRONAL_EPOI_LIST_CHANGED, triggered when fetching/modifying PESRONAL_EPOI entry
 *                        - Add new interface functions to DestinationMemoryStatus:
 *                            getNumberOfPersonalEPOIEntries()
 *                            setNumberOfPersonalEPOIEntries()
 * 2017-05-10 | xxx.x   | Add altitude info to PositionStatusInfo (CFNAVMW-3444)
 * 2017-05-10 | xxx.x   | Extend GnssDataInfo by channel infos for each satellite (CFNAVMW-3589)
 * 2017-05-10 | xxx.x   | Added new interface setter and getter for setting navigation data update favorite region
 * 2017-05-15 | 272.0   | Import Interface CW 19
 * 2017-05-17 | xxx.x   | Bugfix in toString() function of SdsUpdateRegionInfo and description corrected for setDisplayTimeOffset()
 * 2017-05-22 | 273.0   | Import Interface CW 20
 * 2017-05-18 | xxx.x   | Extend SignPostInfo with the direction info in the RouteListElementInfo
 * 2017-05-17 | xxx.x   | Extended HorizonEventInfo with Country code and Sub country code information
 *                        and added Country border crossing information to Guidance Settings
 * 2017-05-22 | xxx.x   | Add TmTextType as a parameter in requestTrafficMessageListForRange interface
 * 2017-05-23 | xxx.x   | Added packageId to NavDataContext (NavDataUpdateInfos)
 * 2017-05-23 | xxx.x   | Extend requestScomoDeinstallComponent to deal with multiple updateRegions
 * 2017-05-23 | xxx.x   | Added new enum CameraConfiguration to MapInfos
 *                        Extended interface switchToFreeMode() with parameter CameraConfiguration
 * 2017-05-23 | xxx.x   | Implement operator==() for PickingResultDetailWeatherIcon
 * 2017-05-23 | xxx.x   | Change the description for the interface moveMapCenterPoint().
 * 2017-05-29 | 274.0   | Import Interface CW 21
 * 2017-05-24 | xxx.x   | Implement operator==() in PickingResultDetail and use in derived classes
 * 2017-05-23 | xxx.x   | Added new interfaces: requestStreetViewPreviewImage() and getStreetViewPreviewImage() for Map
 *                        Added new property identifier MAP_STREET_VIEW_PREVIEW_IMAGE_AVAILABLE
 * 2017-05-30 | xxx.x   | NavDataDeviceInfo: Added new device type SOTA-HMI
 * 2017-05-31 | xxx.x   | Interfaces for DetourAll functionality in TrafficMessageList
 * 2017-06-01 | xxx.x   | Interfaces for activating IP TPEG test server
 * 2017-06-01 | xxx.x   | Modified the types of 'm_error' and 'm_indexActiveAternative' in RouteCalculationInfo as Valid Values
 * 2017-06-05 | 275.0   | Import Interface CW 22
 * 2017-06-02 | xxx.x   | Extend MapDynamicIconSettings::PoiCategoryInfo with an new member poiCategoryIcon.
 * 2017-06-12 | 276.0   | Import Interface CW 23
 * 2017-06-14 | xxx.x   | Return const reference instead of copy from NominalScaleInfos::getNominalScaleInfos()
 * 2017-06-14 | xxx.x   | Add LocationSettings.h with EvChargingStationFilterSettings (CFNAVMW-3564)
 * 2017-06-14 | xxx.x   | Added TrafficMessageTextType as a parameter in the requestTrafficMessageList
 * 2017-06-15 | xxx.x   | Add new interface function restartGuidanceToLastDestination().
 * 2017-06-19 | 277.0   | Import Interface CW 24
 * 2017-06-19 | xxx.x   | Add new enum UserProfileGroup to settings and extend restoreFactorySettings() with the enum as parameter
 * 2017-06-19 | xxx.x   | Add JPEG to Type enum in Image class in InfoTypes.
 * 2017-06-19 | xxx.x   | Provide new interfaces and property updates for location-details of any POI/FTS list entry.
 * 2017-06-19 | xxx.x   | Added new interface showPickedPOIsInMap()
 * 2017-06-20 | xxx.x   | Modified the comment for the interface showSatelliteImagesInMap()
 * 2017-06-21 | xxx.x   | Add new interfaces for starting and stopping RangePrediction for EVs at waypoint or destination.
 * 2017-06-21 | xxx.x   | Provide new user/addressbook icon info structure on middleware interface (getUserPoiIcons()).
 * 2017-06-22 | xxx.x   | Sds specific datatypes moved from LocationInfos.h to SdsLocationInfos.h
 * 2017-06-26 | 278.0   | Import Interface CW 25
 * 2017-06-22 | xxx.x   | Added new class for DestinationReachedInfo and enum ReachedDestinationType to GuidanceInfos.h
 *                        added new interface getDestinationReachedInfo()
 *                        added new property identifier GUIDANCE_DESTINATION_REACHED
 * 2017-06-23 | xxx.x   | reformat toString method of NavDataContext class
 * 2017-06-27 | xxx.x   | Adopt navDataUpdate to new interface FcOtaScomoCmpSrv.fidl
 * 2017-06-27 | xxx.x   | Extended NextManeuverInfos with min and max bargraph scale
 * 2017-06-28 | xxx.x   | Added Trip Replay as Traffic Message Source
 * 2017-07-02 | 279.0   | Import Interface CW 26
 * 2017-07-04 | xxx.x   | Fix initializer list of NavDataUpdateStatus
 * 2017-07-04 | xxx.x   | Add possibility for user input screen in engineering menu
 * 2017-07-05 | xxx.x   | Extend TrafficSettings by adding test server port as a valid value
 * 2017-07-05 | xxx.x   | Adapt ViewModeOptions with new parameters for TrafficFlow,PoiIcons and AddressbookIcons Visibility
 * 2017-07-06 | xxx.x   | Removed internalMapIconId and modified iconId as ValidValue in DestinationMemoryEntryAttributes
 * 2017-07-05 | xxx.x   | Added new LocationBasedServiceSettings class.
 *                        Added new method for weather data reception state and the corresponding property callback.
 *                        Updated the weather report class with the raw values for temperature/humidity/precipitation/wind.
 * 2017-07-06 | xxx.x   | Add new interface setStartPosition() and deleteStartPosition() independent of CVP
 *                        - Remove deprecated code m_signPostInfo in class RouteListElementInfo
 *                        - Extend toString() in class DestinationInfo to print LocationString
 *                        - Refactor interface stopRangePredictionAtWaypointOrDestination()
 *                        - Extend enum TrafficImpactCause with user defined blocking on route
 * 2017-07-06 | xxx.x   | Added new interfaces for GuardianAngelAlert
 *                        - Extended GuidanceInfos.h with GuardianAngelAlertInfo class, enum GuardianAngelAlertCategory,
 *                          enum PoiAlertType and added corresponding GUIDANCE_GUARDIAN_ANGEL_ALERT_CHANGED property
 *                        - added getGuardianAngelAlertInfo(), speakPoiAlert(PoiAlertType poiAlertType) to navmiddleware interface
 * 2017-07-06 | xxx.x   | Added SystemInfos.h with SystemInfos class and enum SystemPowerMode which currently provides
 *                        system power mode information and added getSystemInfos(),
 *                        setSystemPowerMode(SystemInfos::SystemPowerMode systemPowerMode)
 * 2017-07-02 | 280.0   | Import Interface CW 27
 * 2017-07-11 | xxx.x   | Modified documentation for getStreetViewPreviewImage() interface in Map
 * 2017-07-11 | xxx.x   | Provide category information for the exit POI categories with getExitPoiCategoryInfos().
 * 2017-07-11 | xxx.x   | Add testServerPort to relational operator (==) of class TrafficSettings
 * 2017-07-17 | 281.0   | Import Interface CW 28
 * 2017-07-14 | xxx.x   | Include route criterion check while checking ArrivalInfoAlternative equality
 * 2017-07-12 | xxx.x   | Add new interface startPoiInputWithInFtsChosenCategory()
 * 2017-07-20 | xxx.x   | Add new enum VehicleFuelType and VehicleBrandType to ConfigurationInfos
 * 2017-07-20 | xxx.x   | Added enumeration HomePositonStatus which describes about the status of vehicle position in relation with HOME location
 *                        Added new interface getHomeStatus() to get current HomePositonStatus on HOME_POSITION_STATUS_CHANGED
 * 2017-07-24 | 282.0   | Import Interface CW 29
 * 2017-07-25 | xxx.x   | HorizonEventInfo extension:
 *                        - enum HorizonEvent renamed to HorizonEventType.
 *                        - Values of this enum modified to act as a bitfield to indicate presence of more than one event.
 *                        - HorizonEventType extended with HORIZON_EVENT_TYPE__TOLL_BOOTH_APPROACH
 * 2017-07-25 | xxx.x   | Extend LocationInfo structure by CurrentSourceOfResults
 * 2017-07-25 | xxx.x   | Provide relative direction to waypoint/destination in the ArrivalInfo class
 * 2017-07-25 | xxx.x   | removed SystemInfos.h and moved enum SystemPowerMode to configurationInfos
 * 2017-07-25 | xxx.x   | Remove deprecated info from NavMiddleware for ScomoComponentId string
 * 2017-07-27 | xxx.x   | Added new getter for UpdateNavDataUpdateFavoriteRegionSettingsResult
 *                        Added UpdateFavoriteUpdateRegionsResult in NavDataUpdateInfos
 *                        Updated NavDataUpdateFavoriteRegionSettings
 *                        New property identifiers for favorite region settings.
 * 2017-07-27 | xxx.x   | Renamed GuardianAngelAlertInfo to EVAlertInfo which is generic info for EV alerts
 *                        - renamed enum GuardianAngelAlertCategory to AlertCategory, added enum EvAlertState,
 *                          extended enum PoiAlertType with POI_ALERT_TYPE__UNREACHABLE_DESTINATION
 *                          and added GUIDANCE_UNREACHABLE_DESTINATION_ALERT_CHANGED property
 *                        - added getUnreachableDestinationAlertInfo() to navmiddleware interface
 * 2017-07-27 | xxx.x   | Interface changes for Electric vehicle and State of Charge related handling
 *                      | - Introduced ElectricVehicleInfos.h with classses BatteryInfos and ElectricVehicleInfos
 *                      | - Add new interfaces setBatteryInfos() and setDriveMode()
 *                      | - Introduce class StateOfCharge in RouteInfos.h and extended the class ArrivalInfos::ArrivalInfo with the members
 *                          m_estimatedStateOfCharge, m_reachabilityMode, m_distanceToEmptyHighProbable, m_distanceToEmptyLowProbable
 * 2017-07-31 | 283.0   | Import Interface CW 30
 * 2017-07-27 | xxx.x   | Extended TrafficMessageInfoBase with new parameter TrafficTimeDelayInMinutes in TrafficMessageInfo.h
 * 2017-07-28 | xxx.x   | - Added new interface methods pickFromPickingResults() and getPickedPickingResultIndex() to pick from visible picking results
 *                        - Added new class PickedPickingResult to return the index of the picked element in visible picking results
 *                        - Renamed interface method showPickedPOIsInMap() to showPickedPoisInMap()
 * 2017-08-01 | xxx.x   | Introduced StateOfChargeAndReachabilityInfo class which contains the members - m_estimatedStateOfCharge, m_reachabilityMode,
 *                          m_distanceToEmptyHighProbability, m_distanceToEmptyLowProbability.
 *                        - Extended ArrivalInfoAlternative and ArrivalInfo classes with members of StateOfChargeAndReachabilityInfo
 *                        Introduced setter and getter methods for startPositionInfo in WaypointInfos class
 * 2017-08-07 | 284.0   | Import Interface CW 31
 * 2017-08-07 | xxx.x   | Extend DestinationMemoryAttributesGroup enumeration with new subGroup:
 *                        - DESTINATION_MEMORY_ATTRIBUTES_GROUP__CHARGING_STATION
 * 2017-08-08 | xxx.x   | Add new category DESTINATION_MEMORY_ENTRY_CATEGORY__FAVORITE_WEATHER_ALERTS to DestinationMemoryEntryCategory
 *                        Add new property DESTINATIONMEMORY_FAVORITE_WEATHER_ALERTS_LIST_CHANGED, triggered when fetching/modifying FAVORITE_WEATHER_ALERTS entry
 *                        Extend DestinationMemoryStatus with setNumberOfFavoriteWeatherAlertEntries() and getNumberOfFavoriteWeatherAlertEntries()
 * 2017-08-08 | xxx.x   | Remove static toString from NavDataUpdateInfos.h
 * 2017-08-08 | xxx.x   | Added new member SystemType and TCUStatus to ConfigurationInfos
 * 2017-08-09 | xxx.x   | Extend enumeration SoftwareVariant with a new value for PIVI.
 * 2017-08-09 | xxx.x   | Extend PositionStatusInfo with directionofPrayer in PositionInfos.h
 * 2017-08-09 | xxx.x   | Added a new propertIdenifier LOCATION_BASED_SERVICES_SETTINGS_CHANGED and
 *                        Extended LocationBasedServicesSetting with new parameter m_weatherDataCommunicationEnabled to check weatherDataCommunication is on or off
 * 2017-08-10 | xxx.x   | Added new interface showGeoFenceInMap.
 * 2017-08-10 | xxx.x   | Extend  PositionStatusInfo and GnssDataInfo with mapMatchedPositionAccuracy and gnssPosition resp. in PositionInfos.h
 * 2017-08-08 | xxx.x   | Add new interface getElectricVehicleInfos()
 * 2017-08-10 | xxx.x   | Interface fixes for Extend  PositionStatusInfo and GnssDataInfo with mapMatchedPositionAccuracy and gnssPosition resp. in PositionInfos.h
 * 2017-08-10 | xxx.x   | Added new interface getMapScaleRange() and new property identifier MAP_RECOMMENDED_SCALE_RANGE_CHANGED.
 * 2017-08-10 | xxx.x   | Extend LocationSearchScope by SearchRadius (LocationInfos.h) (CFNAVMW-3683)
 * 2017-08-10 | xxx.x   | Added new interface method cancelRouteOptimization()
 * 2017-08-10 | xxx.x   | Extend LocationInfo by LocationAttributeInfos (LocationInfos.h) (CFNAVMW-3373)
 * 2017-08-14 | 285.0   | Import Interface CW 32
 * 2017-08-11 | xxx.x   | Added new Interface for requesting addresses within a given radius.
 * 2017-08-10 | xxx.x   | Interface name changed from showTrafficOverviewMap() to showWeatherOverviewMap().
 *                        Added new interface showTrafficOverviewMap()
 * 2017-08-14 | xxx.x   | Fix for Interface Weather data Communication in LocationBasedServicesSettings
 * 2017-08-16 | xxx.x   | Extend configurationInfos with systemState parameter
 * 2017-08-16 | xxx.x   | Added UseAutomaticGuidanceProposal Settings to RouteSettings class.
 *                        Changed the relative direction to waypoint/destination in the ArrivalInfo class from type enum DirectionDescription
 *                        to unsigned integer.
 * 2017-08-17 | xxx.x   | Added new property identifier for EV battery status settings change update
 * 2017-08-17 | xxx.x   | Extend ::navmiddleware::PoiId by SourceId
 * 2017-08-21 | 286.0   | Import Interface CW 33
 * 2017-08-22 | xxx.x   | Add new settings class MapCarsorSettings to configure the Carsor model
 * 2017-08-23 | xxx.x   | Extend ::navmiddleware::LocationAttributeInfos with StringInfo to fit LocationDetailInfos.
 * 2017-08-22 | xxx.x   | Added new interface method setTCUStatus() to set the availability of TCU after initialize (CFNAVMW-4067)
 * 2017-08-24 | xxx.x   | Fix null-ptr flaws in ::navmiddleware::LocationAttributeInfos
 * 2017-08-24 | xxx.x   | Renamed interface configureMapLocationMarker() to configureMapLocationMarkers()
 *                        Renamed and moved MapLocationMarkerType enum inside the MapLocationMarkers class as MarkerType
 *                        Removed MAP_LOCATION_MARKER_TYPE__INVALID
 *                        Added new enum value to MarkerType (MARKER_TYPE__FAP)
 *                        Introduced new enum MarkerDisplayMode to MapLocationMarkers class
 *                        Introduced new enum MapLocationMarkerConfigurationOperation to MapLocationMarkers class
 * 2017-08-27 | 287.0   | Import interfaces CW 34
 * 2017-08-26 | xxx.x   | Extended requestTrafficMessageListtForRange with a new parameter isIncidentTrafficMessagesRequired
 * 2017-08-29 | xxx.x   | Added a new method cancelDetourAllTrafficMessagesAlongRoute in Traffic
 * 2017-08-30 | xxx.x   | Extend DestinationMemoryEntryAttributes with UserPoiIcon Image Data
 * 2017-08-30 | xxx.x   | Extend TrafficImpactRouteAlternativeInfos with ArrivalInfos for each waypoint
 * 2017-08-31 | xxx.x   | Extend MapCarsorSettings with operator==() & operator!=() functions.
 * 2017-09-04 | 288.0   | Import interfaces CW 35
 * 2017-09-05 | xxx.x   | - Removed getMapRepresentation() from NavMiddleware.h
 *                        - Added MapViewId to MapRepresentationInfo
 *                        - Removed enum MAP_SHOW_WEATHER_CHANGED
 *                        - Fixed implementation of PoiId::toString()
 * 2017-09-05 | xxx.x   | Added new interfaces: rotateCamera(), prepareStreetView(), getPrepareStreetViewStatusInfo(), cancelPrepareStreetView(),
 *                        cancelRequestStreetViewPreviewImage() for Map
 *                        Added new property identifier MAP_PREPARE_STREETVIEW_STATUS_CHANGED
 *                        Added new enumerations CoordinateAxis, PrepareStreetViewStatus and class PrepareStreetViewStatusInfo to MapInfos
 *                        Cleaned up documentation for startRotatingMap() interface.
 *                        Added new parameter 'address' to interface showStreetViewImagesInMap()
 * 2017-09-06 | xxx.x   | Added new property identifier MAP_ONLINE_FEATURE_AVAILABILITY_CHANGED and corresponding getter
 *                        getMapOnlineFeatureAvailabilityInfos()
 * 2017-09-06 | xxx.x   | modified the input parameter in requestWeatherData() from reportConfiguration to list of report configuration.
 *                        Changed the return type for the requestWeatherData() from void to RequestId(Unique handler for each request).
 *                        Add the requestId as a input parameter to getWeatherDataInfos().
 *                        Renamed the exiting WeatherDataInfos to WeatherDataInfo.
 *                        Added new type WeatherDataInfos which will contain the list of WeatherDataInfo.
 *                        Add the requestId as a input parameter to releaseWeatherData().
 *                        Modified the LocationType enumeration.
 *                        Added the destination index as a member in the WeatherConfigurationInformation.
 *                        Made the WeatherConfigurationInformation::m_geoCoordinate as ValidValue.
 *                        Added the requestId, destination index and weather report types as a member in WeatherDataInfos.
 *                        Added the weather icon type in the weather report.
 * 2017-09-06 | xxx.x   | Renamed interface pickFromPickingResults() to requestPickedIndexFromPoiIcons()
 *                        Renamed interface getPickedPickingResultIndex() to getPickedIndexFromPoiIcons()
 *                        Renamed MAP_PICK_FROM_PICKING_RESULTS_INDEX_AVAILABLE to MAP_PICKED_INDEX_FROM_POI_ICONS_CHANGED
 *                        Renamed PickedPickingResult structure to PickedIndexFromPoiIcons class in mapInfos.h
 * 2017-08-31 | xxx.x   | Extend enum VehicleBrandType and renamed setVehicleFuelype() to setVehicleFuelType().
 * 2017-09-07 | xxx.x   | Changes for POI category browsing in Renault:
 *                        Replaced enum FixedPoiCategory with hardcoded NavCore category ids by enum PredefinedPoiCategory,
 *                        replaced function startPoiInputWithFixedCategory by startPoiInputWithPredefinedCategory,
 *                        extended class LocationCategoryInfos::LocationCategoryInfo by member PredefinedPoiCategory
 * 2017-09-11 | 289.0   | Import interfaces CW 36
 * 2017-09-06 | xxx.x   | Interface changes for Trip File recording.
 * 2017-09-12 | xxx.x   | Extend ScomoInstallComponentResult by adding m_installStage and correct naming of enum NavDataUpdateInstallStage
 * 2017-09-13 | xxx.x   | Extend DataUpdateStatus with OUT_OF_SPACE error
 * 2017-09-13 | xxx.x   | Extend StateOfCharge class with member stateOfChargeAsPercentage
 * 2017-09-13 | xxx.x   | Extend Map camera mode to support MAP_MODE_GEO_FENCE
 * 2017-09-18 | 290.0   | Import interfaces CW 37
 * 2017-09-18 | xxx.x   | Added new property identifier ROUTE_LEARNED_ROUTES_DELETED
 *                        Added new interface deleteLearnedRoutes()
 * 2017-09-18 | xxx.x   | Introduce new enumeration ChargingType and
 *                        Extend DestinationMemoryEntryAttributes with new member to hold ChargingType
 * 2017-09-19 | xxx.x   | Added new input parameter poiCategoryFilter for Fixed and Predefined POI category Search.
 * 2017-09-19 | xxx.x   | Fix Compiler warnings in LocationInfos.h and MapInfos.h
 * 2017-09-20 | xxx.x   | Interface changes for Search Scope Information
 * 2017-09-20 | xxx.x   | Add error codes for subscription expired on map update functions
 * 2017-09-21 | xxx.x   | - Add ParkingSettings class which contains the following settings:
 *                          giveParkAndRigeOnly, giveParkingForReducedMobilityOnly and useHeightRestriction.
 *                        - Extend enum LocationSortOrder to allow sorting based on Availability and price.
 * 2017-09-21 | xxx.x   | Add comparison operators to class LocationCategoryInfo(s)
 * 2017-09-21 | xxx.x   | - Added new enum OnlineImageStatus in MapInfos.h
 *                        - Replaced PrepareStreetViewStatusInfo::PrepareStreetViewStatus with above enum OnlineImageStatus
 *                        - Added member of type enum OnlineImageStatus to StreetViewPreviewImageInfo
 *                        - Updated description for members of struct GeoFence
 *                        - In showSatelliteImagesInMap(), changed type of parameter mapScale from ValidValue<int32_t> to int32_t
 * 2017-09-21 | xxx.x   | Introduced new interface prepareSatelliteView and getPrepareSatelliteViewInfo.
 *                        Also modified property identifier MAP_PREPARE_STREETVIEW_STATUS_CHANGED to MAP_PREPARE_STREET_VIEW_DONE.
 * 2017-09-22 | 291.0   | Import interface changes CW 38
 * 2017-09-21 | xxx.x   | Remove unneeded LocationInfos::ENTRY_TYPE__SEARCH_TERM and add LOCATION_SOURCE__RECENTLY_SELECTED
 * 2017-09-21 | xxx.x   | Add new LocationAttribute PoiCategoryInfo
 * 2017-09-22 | xxx.x   | Converted ViewModeOptions struct to a class
 *                        Removed existing traffic flow setter/getter
 *                        Introduced new enum ViewModeOptions::UpperTrafficFlowDisplayLimit and getters/setters for the same
 *                        This addition allows for a more fine grained traffic flow display configuration
 *                        Converted VisibleListInfo struct to a class, improved encapsulation by making the data members
 *                        private and providing setters and getters.
 *                        The ListItemIndexDisplay enum was removed. A new struct ListItemDisplayOptions was introduced to extend
 *                        the previous functionality by not only allowing for list item index display but also for configuration of
 *                        the display of additional POI attributes, like fuel prices.
 *                        A new enum ListDisplayOption was introduced. This controls whether all list items will be displayed on map or
 *                        just the ones belonging to the current list window specified by offset and range.
 * 2017-09-27 | xxx.x   | Added new enum TrafficRouteOverviewMode to MapInfos.h where HMI can specify to show the whole route or section of the route
 *                        Extended the interface showTrafficDetourInMap() with parameter TrafficRouteOverviewMode
 *                        Added new method cancelPrepareSatelliteView() for Map
 * 2017-09-27 | xxx.x   | Extend LocationAttributeInfos with generic StringAttributeInfo (needed for opening hours)
 * 2017-09-28 | xxx.x   | Removed unused enum HOME_POSITION_STATUS__NOT_USED from HomePositionStatus
 * 2017-10-03 | 292.0   | Import interface changes CW 39
 * 2017-10-04 | xxx.x   | modify existing interface - pickInMap to include pickingfilter as additional parameter
 * 2017-10-04 | xxx.x   | Add interface for ConfigurationManager handling
 * 2017-09-22 | xxx.x   | Introduce new method to update route with changed route options
 * 2017-10-10 | 293.0   | Import interface changes CW 40
 * 2017-10-10 | xxx.x   | Added toString() functions in MapOnlineFeatureAvailabilityInfos class
 * 2017-10-10 | xxx.x   | Modify DestinationMemoryEntry::SortingAlgorithm by adding/removing relevant/irrelevant values.
 * 2017-10-10 | xxx.x   | Added "TRAFFICRECEPTIONSTATE_SUBSCRIPTION_EXPIRED" in trafficReceptionState and
 *                        "WEATHER_RECEPTION_STATE__SUBSCRIPTION_EXPIRED" in WeatherReceptionState.
 *                        In weatherInfos.h enhance the trace output for ReportConfiguration.
 * 2017-10-11 | xxx.x   | Extend DestinationMemoryDestinationDetails to expose all LocationDetails
 * 2017-10-11 | xxx.x   | Extended traffic setting with non-premium traffic source enabled.
 *                      | Added new property identifier for TRAFFICMESSAGE_SETTINGS_CHANGED.
 * 2017-10-11 | xxx.x   | - Added new method getRouteOptionSettingsFromRoute() to provide the route option settings for the current route
 *                        - Added comments for below methods, indicating they are not supported anymore and will removed soon
 *                           1. activateHighlightedRoute()
 *                           2. removeUnusedRoutes()
 *                           3. calculateMoreRoutes()
 * 2017-10-11 | xxx.x   | In ArrivalInfosAlternatives, rename m_alternativeCalculationStatus to m_alternativeCalculationStatusNextDest
 *                        and introduce m_alternativeCalculationStatusFinalDest
 * 2017-10-12 | xxx.x   | New error enumerations in case mapupdate cannot be executed
 * 2017-10-16 | 294.0   | Import interface changes CW 41
 * 2017-10-18 | xxx.x   | Fix wrong member variable in setValue() of ConfigItem
 * 2017-10-18 | xxx.x   | Add requests and getters for LocationAttributes (keeping those for LocationDetails in parallel);
 *                        deprecate requests and getters for LocationDetails.
 * 2017-10-18 | xxx.x   | Added new class PlannedRouteHistoryInfos to save all waypoint operations performed on planned route
 *                        Added new interface getPlannedRouteHistoryInfos() to retrieve all waypoint operations performed on planned route
 *                        Added new property identifiers
 *                            1. GUIDANCE_STARTED_ON_PLANNED_ROUTE
 *                            2. GUIDANCE_WAYPOINT_SKIPPED
 * 2017-10-19 | xxx.x   | Modify the interface description for showWeatherOverviewMap() and showWeatherInMap()
 * 2017-10-24 | 295.0   | Import interface changes CW 42
 * 2017-10-24 | xxx.x   | Add const to the getters for AddressInfoMap and AddressValue
 * 2017-10-25 | xxx.x   | - Added new MapCameraMode MAP_MODE_ROUTE_SEGMENT_SELECTION
 *            |         | - Added new interface method showRouteSegmentSelectionInMap()
 * 2017-10-26 | xxx.x   | Extend the structure RouteListElementInfo::TrafficInfo with m_trafficFlowColor
 * 2017-10-26 | xxx.x   | Added settings class for payment method.
 * 2017-10-25 | xxx.x   | Add deleteUserProfile to clear a user profile
 * 2017-10-26 | xxx.x   | Extend Application id in LocationInfos to support TomTom Weather.
 * 2017-10-31 | 296.0   | Import interface changes CW 43
 * 2017-11-02 | xxx.x   | getter methods getFilterList() and getFilterType() in PickingResultFilter are made const
 * 2017-11-02 | xxx.x   | Moved MapViewId and LineId type definitions to InfoTypes.h
 *                        Moved PickingResult related types to new header MapPickingResults.h
 *                        Adapted the naming of PickingResult related enum types to new naming convention
 * 2017-11-02 | xxx.x   | Differentiate scomo getAvailableUpdates by adding new PropertyCallback identifier
 * 2017-11-02 | xxx.x   | Introduce new class RangePredictionInfos in RouteInfos to notify error scenario during range prediction
 *                        Introduce new method getRangePredictionInfos()
 * 2017-11-02 | xxx.x   | Offer installed products catalogue status
 * 2017-11-07 | 297.0   | Import interface changes CW 44
 * 2017-11-03 | xxx.x   | Extend FuelPriceInfo class with member m_fuelType
 * 2017-11-08 | xxx.x   | Extend class DestinationInfos with m_locationAttributeInfos
 *                      | Move class LocationAttributeInfos from LocationInfo.h to InfoTypes.h
 * 2017-11-08 | xxx.x   | Add new type INITIAL_REQUEST_BY_DIAGNOSTIC to enum AvailableUpdatesRequestType in navDataUpdateInfos
 * 2017-11-09 | xxx.x   | Extend Location Attributes in InfoTypes.h to provide accepted payment method attribute to HMI.
 * 2017-11-09 | xxx.x   | Add enumeration StoreErrorStatus to describe extended error information on storing
 *                        Extend DestinationMemoryStoreEntryStatus and DestinationMemoryStoreRouteStatus with StoreErrorStatus
 * 2017-11-08 | xxx.x   | Add OpeningHoursStatus in ArrivalInfosAlternatives
 *                        and new property identifier ROUTE_OPENING_HOURS_REACHABILITY_INDICATION
 * 2017-11-09 | xxx.x   | Extend class LocationAttributeInfos with PhoneNumber.
 * 2017-11-09 | xxx.x   | Add new type UPDATING to enum CatalogueStatus in navDataUpdateInfos
 *                        Add new type INVALID_UPDATE_PACKAGE to enum DataUpdateStatus in navDataUpdateInfos
 * 2017-11-13 | 298.0   | Import interface changes CW 45
 * 2017-11-14 | xxx.x   | Introduce new method startStoredRouteCalculationWithFtsSelection()
 * 2017-11-16 | xxx.x   | Modified the interface showRouteSegmentSelectionInMap to take indexInRouteList as valid value.
 * 2017-11-16 | xxx.x   | Changed MapIconInfo::m_selectedIndex to a ValidValue
 * 2017-11-21 | 299.0   | Import interface changes CW 46
 * 2017-11-16 | xxx.x   | Added additional payment methods in PaymentMethodSettings
 * 2017-11-17 | xxx.x   | Extend FuelPriceInfo class with member m_fuelType
 * 2017-11-22 | xxx.x   | Extend LocationAttributes with Parking attribute
 * 2017-11-22 | xxx.x   | Extend FuelPrice,ParkingOcuupancy with TimeStamp. Added LastUpdateTime as an attribute.
 * 2017-11-22 | xxx.x   | Modified trafficMessageID vector type to uint32_t in showTrafficOverviewMap()
 * 2017-11-22 | xxx.x   | New error code defined for incompatible nav data update packages
 * 2017-11-22 | xxx.x   | Extend LocationAttributeInfos with LocationType, Coordinates and MotorwaySelectionStatus.
 *                        Add Alias info as an attribute.
 * 2017-11-23 | xxx.x   | Add location attribute LocationName, correct copy c-tor of class LocationAttributeInfos
 * 2017-11-28 | 300.0   | Import interface changes CW 47
 * 2017-11-29 | xxx.x   | Add interface isLocatorOnRoadWithAD2, to provide Automated Driving Level 2 data availability status.
 * 2017-11-29 | xxx.x   | Extend PickingResultDetailPoi, PickingResultDetailAddressBookPoi and
 *                        PickingResultDetailDestination classes with LocationAttributeInfos type
 * 2017-11-29 | xxx.x   | Added a new feature call showEditRouteOverviewInMap() and added new enumeration DeviceVariant to ConfigurationInfos.h
 * 2017-11-29 | xxx.x   | Add property update for Guidance proposal:
 *                        GUIDANCE_DESTINATION_DETECTED_BASED_ON_LEARNED_ROUTES, GUIDANCE_TRAFFIC_EVENTS_DETECTED_ON_LEARNED_ROUTES.
 *                        Re-order guidance property identifier enumerations.
 *                        Add PredictedDestinationInfo to provide predicted destination details.
 * 2017-12-05 | 301.0   | Import interface changes CW 48
 * 2017-12-04 | xxx.x   | Add protection against assigning to itself if ArrivalInfos and ArrivalInfosAlternatives
 * 2017-12-06 | xxx.x   | Corrected formatting of toString() function for VisibleListInfo in MapInfos
 * 2017-12-07 | xxx.x   | Support search in avoid area list
 * 2017-12-12 | 302.0   | Import interface changes CW 49
 * 2017-12-08 | xxx.x   | Extend DestinationMemoryDestination class with LocationAttributeInfos (m_attributes)
 * 2017-12-11 | xxx.x   | Addition of attribute Info members to toString()
 * 2017-12-12 | xxx.x   | Extend FuelPrice Attributes with Fuel Unit Information.
 * 2017-12-13 | xxx.x   | Add new member productTypeMask to ProductVersionInfo in navDataUpdateInfos
 * 2017-12-13 | xxx.x   | New DeinstallResult enum added for NavDataUpdateInfo
 * 2017-12-13 | xxx.x   | Added new property identifier POSITION_DEBUG_INFO_CHANGED
 *                        Added new interfaces
 *                            1. requestPositionDebugInfo()
 *                            2. releasePositionDebugInfo()
 *                            3. getPositionDebugInfo()
 *                        Extended PositionInfos.h with PositionDebugInfo class to provide Position debug info.
 * 2017-12-13 | xxx.x   | Added comments for below methods, indicating they are currently not supported in Bosch Navigation.
 *                        - getAdditionalAttributesDisplayState()
 *                        - setAdditionalAttributesDisplayState()
 * 2017-12-13 | xxx.x   | Rename attribute ParkingOccupanyInfo to OccupancyInfo for re-using reasons, e.g.
 *                        occupancy of EV charging stations
 * 2017-12-19 | 303.0   | Import interface changes CW 50
 * 2017-12-14 | xxx.x   | removeRoute(DestinationMemoryRoute::Id routeId) is deprecated.
 * 2017-12-18 | xxx.x   | Add unknown as a valid device status for NavDataUpdateDeviceInfos
 * 2017-12-19 | xxx.x   | Extend RouteInfos.h with class RouteCountryAndStateInfos to provide list of countries and states along route
 *                      | Add new property identifier ROUTE_COUNTRY_AND_STATE_INFO_CHANGED
 *                      | Add new interfaces
 *                           1. requestRouteCountryAndStateInfo()
 *                           2. getRouteCountryAndStateInfos()
 * 2017-12-19 | xxx.x   | Add LocatioAttribute OpeningStatusInfo providing "digital" information if a POI is open/closed
 * 2017-12-20 | xxx.x   | Add EvConnectorTypeFilterSettings
 * 2017-12-20 | xxx.x   | Add getAttributeInfos() to LocationAttributeInfos allowing access to overall attribute list
 * 2018-01-02 | 304.0   | Import interface changes CW 51
 * 2017-12-29 | xxx.x   | Added image class object in icon implementation in MapPickingResults.h
 * 2018-01-04 | xxx.x   | Added the below interfaces
 *                        getMapCameraInfos()
 *                        getViewStatusInfos()
 *                        getMapRepresentationInfo()
 *                        getMapScaleRange()
 *                        getMapCameraModeInfo()
 *                        getTouchEventInfo()
 *                        getPickingResults()
 *                        getPickedIndexFromPoiIcons()
 *                        getNominalScaleInfos()
 *                        getWeatherFeaturesStatusInfo()
 *                       AND
 *                        Marked the below secondary view related property updates as deprecated
 *                        MAP_SECONDARY_PRESENTATION_MODE_CHANGED,
 *                        MAP_SECONDARY_CAMERAINFOS_CHANGED,
 *                        MAP_SECONDARY_VIEWSTATUS_CHANGED,
 *                        MAP_SECONDARY_CAMERAMODE_CHANGED,
 *                        MAP_SECONDARY_TOUCH_EVENT,
 *                        MAP_SECONDARY_NOMINAL_SCALES_CHANGED
 * 2018-01-04 | xxx.x   | removeRoute(DestinationMemoryRoute::Id routeId) is removed
 * 2018-01-04 | xxx.x   | Extend enum SettingsGroup with SETTINGS_GROUP__RNAIVI_DRIVING_ASSISTANCE
 * 2018-01-04 | xxx.x   | Extended LocationInfo and LocationCategoryInfos with new image member.
 * 2018-01-09 | 305.0   | Import interface changes CW 01
 * 2017-01-10 | xxx.x   | Add documentation to all enum types and values, Unused Enums MapSplitMode and TouchPhase removed
 * 2018-01-09 | xxx.x   | New Scomo component defined for compatibility matrix, registration result indication added
 * 2018-01-10 | xxx.x   | Add function resumePoiInputInstance (POI input)
 * 2018-01-08 | xxx.x   | New request/classes to support new navigation data part number request to be offered to diagnostics
 * 2018-01-10 | xxx.x   | Add version to ScomoInstallComponentResult
 * 2018-01-11 | xxx.x   | Add componentName parameter to requestScomoInstallComponent as default parameter
 * 2018-01-16 | 306.0   | Import interface changes CW 02
 * 2018-01-12 | xxx.x   | Extended ViewModeOptions with new member for inception map.
 *                      | Add new interfaces in mapInfos.h
 *                           1. getInceptionMapState()
 *                           2. setInceptionMapState()
 * 2018-01-16 | xxx.x   | Added constructor and destructor to PickingResults class.
 * 2017-01-17 | xxx.x   | Removed MapIconSettings class and MapPOICategory from MapSettings.h
 *                        Removed the old static POI categories interfaces
 *                           1. updateMapIconSettings()
 *                           2. getMapIconSettings()
 * 2018-01-17 | xxx.x   | The existing Icon type members ie m_trafficImageBlob in class TrafficImpactRouteAlternativeInfos
 *                        and m_roadNumberImageBlobs in class RouteListElementInfo, marked as deprecated.
 *                        - New members of Image class m_trafficImage added in class TrafficImpactRouteAlternativeInfos
 *                        and m_roadNumberImages in class RouteListElementInfo
 * 2018-01-17 | xxx.x   | Extend requestWaypointList function with a parameter of type WaypointListMode
 * 2018-01-18 | xxx.x   | Add new interface deletePredictedDestinations()
 * 2018-01-22 | 307.0   | Import interface changes CW 03
 * 2018-01-18 | xxx.x   | Add location attribute BoundingBoxInfo
 * 2018-01-19 | xxx.x   | Add functions for requesting and getting full location attributes for POI and FTS list entries:
 *                          requestPoiEntryAttributes / getPoiEntryAttributes
 *                          requestFreeTextSearchResultAttributes / getFreeTextSearchResultAttributes
 * 2018-01-23 | xxx.x   | Modify function resumePoiInputInstance (POI input)
 * 2018-01-23 | xxx.x   | Used the Image class for the traffic icons in TrafficMessageInfos.h
 * 2018-01-24 | xxx.x   | Extend ElementSpellerInfo with m_allowAutoJumpToResultList
 * 2018-01-24 | xxx.x   | Add LocationSearchScope TYPE__ALONG_CURRENT_HIGHWAY
 * 2018-01-24 | xxx.x   | Add function startPoiInputWithinAllShortcutCategories (for proximity POI search)
 * 2018-01-24 | xxx.x   | Introduce configureRoadNetworkIllustration to define amount of roads shown in mapviewer (JP)
 * 2018-01-30 | 308.0   | Import interface changes CW 04
 * 2018-01-31 | xxx.x   | Introduce new route interface method startStoredRouteCalculationForPlanning()
 * 2018-01-31 | xxx.x   | Add function hasActiveRoute
 * 2018-02-06 | 309.0   | Import interface changes CW 05
 * 2018-02-01 | xxx.x   | Extend NavDataUpdateFavoriteRegionSettings with boolean flag to Enable Automatic Updates (JP)
 * 2018-02-02 | xxx.x   | Extend LocationAttributes with BrandName information.
 * 2018-02-07 | xxx.x   | Offer request to get navigation version string
 * 2018-02-07 | xxx.x   | Extend LocationAttributeInfos with EV attributes:
 *                          EvChargingTypeOccupancyInfo, EvConnectorTypesInfo, EvChargingSpeedsInfo, and EnergyProvider
 * 2018-02-13 | 310.0   | Import interface changes CW 06
 * 2018-02-08 | xxx.x   | Extend EVAlertInfo with enumeration SearchAreaType.
 * 2018-02-13 | xxx.x   | Added a new method setPrivacyMode() for setting the currentPrivacyMode in renault
 * 2018-02-13 | xxx.x   | SdsCheckAddress and startFreeTextSearchInput extended with LanguageCode as additional input parameter
 * 2018-02-14 | xxx.x   | Add new value INVALID to enums MapPitch and MapOrientation in Map
 * 2018-02-14 | xxx.x   | Extend ArrivalInfosAlternatives with distanceToDestinationNoUnit(for next and final) and distance unit
 * 2018-02-20 | 311.0   | Import interface changes CW 07
 * 2018-02-19 | xxx.x   | Extend LocationAttributes with AirDistance attribute.
 * 2018-02-20 | xxx.x   | Add new result SCOMO_INSTALL_RESULT__REBOOT_REQUIRED to indicate activation will happen on reboot only
 * 2018-02-20 | xxx.x   | Extension of enumeration PaymentMethod in PaymentMethodsInfo.
 * 2018-02-20 | xxx.x   | Extend LocationAttributes with LastUpdateStatus attribute.
 * 2018-02-21 | xxx.x   | Add SCOMO_INSTALL_RESULT__COMPATIBILITY_MATRIX_NOT_FOUND to report compatibility matrix not found in given urlPath
 *                        Add SCOMO_INSTALL_RESULT__INSTALLATION_RESULT_NOT_AVAILABLE to report that previous installation result is not available
 *                        Add DEINSTALL_RESULT__UNSUPPORTED_UPDATE_DEVICE to report error if any while accessing the device
 * 2018-02-21 | xxx.x   | Extend RouteInfoProperties with a new member m_restricted
 *                        Extend the DestinationInfos::DestinationInfo with a member m_destinationRouteInfoProperties of type
 *                           RouteInfoProperties.
 * 2018-02-21 | xxx.x   | Add a new method requestAbortScomoInstallComponent() for canceling the ongoing backGround installation for SOTA source
 * 2018-02-21 | xxx.x   | Extend LocationSearchSource with source for Google Places
 * 2018-02-27 | 312.0   | Import interface changes CW 08
 * 2018-03-06 | xxx.x   | Update documentation of function NavMiddleware::undoLastAddressInputStep()
 *                        Extend LocationAttribute ParkingInfo by flag isParkAndRide
 * 2018-03-13 | 313.0   | Import interface changes CW 10
 * 2018-03-08 | xxx.x   | Added a new property identifier "CONFIGURATION_E2E_STATUS_CHANGED for E2E status
 * 2018-03-12 | xxx.x   | SdsCountryList and SdsSubCountryList are extended with PoiRegionId and GlobalXrefId used in SDS context only
 * 2018-03-13 | xxx.x   | Extend LocationInfo and AddressInputInfo with additional member "NameAsInNavigationData" used in SDS context only
 * 2018-03-14 | xxx.x   | Added a new property identifier "ROUTE_PRE_CALCULATION_STARTED"
 *                        - Added new enum RouteCalculationMode in RouteInfos.h
 *                        - Extended method startRouteCalculation() with the parameter RouteCalculationMode
 * 2018-03-14 | xxx.x   | Extend LocationAttributes with Website Attribute
 * 2018-03-14 | xxx.x   | Added new class MapVideoStreamInfo inside ViewModeOptions class in MapInfos
 *                        Added new class MapVideoStreamStatusInfo in MapInfos
 *                        Added new getter method getMapVideoStreamStatusInfo()
 *                        Added new enum MapViewGroup in MapInfos
 *                        Added new parameter "MapViewGroup" to setMapCameraAndViewModes method.
 *                        Added new class MapCameraAndViewModesStatusInfo in MapInfos
 *                        Added new getter method getMapCameraAndViewModesStatusInfo
 *                        Added new property identifier "MAP_VIDEO_STREAM_STATUS_CHANGED"
 * 2018-03-15 | xxx.x   | Add missing compare operators in routeInfo.h structures
 *                         1.DestinationInfos
 *                         2.WaypointInfos
 *                         3.TrafficInfo
 *                         4.ExitPOIInfo
 *                         5.SignPostInfo
 *                         6.RouteListElementInfo
 *                         7.RouteListInfos
 *                         8.TourElement
 *                         9.Tour
 *                         10.RouteCountryAndStateInfos
 * 2018-03-20 | 314.0   | Import interface changes CW 11
 * 2018-03-16 | xxx.x   | Extend LocationAttributes with ContentProvider, This provides the poi source reference for Google Places.
                          Updated toString function for different attributes.
 * 2018-03-16 | xxx.x   | Extend Location Attributes with Google Picture Reference Attribute.
 * 2018-03-19 | xxx.x   | Add a new enum type TOUCH_GESTURE_MOVE to TouchGestureType.
 *                        Added new getter and setter function.
 *                        1) setTouchActionGestureMove
 *                        2) isTouchActionGestureMoveEnabled
 *                        Added new member variable "m_touchActionGestureMove "to class TouchActions
 * 2018-03-19 | xxx.x   | Added VehicleRestrictionsInfo and new property identifier GUIDANCE_VEHICLE_RESTRICTIONS_CHANGED
 * 2018-03-21 | xxx.x   | Add POI user ranking attribute in LocationAttributeInfos.
 * 2018-03-21 | xxx.x   | Add COMPATIBILITY_MATRIX_NOT_FOUND and COMPATIBILITY_MATRIX_OUTDATED to DataUpdateStatus enum.
 * 2018-03-21 | xxx.x   | Extended FuelPrice Attributes with ThreeLevelRating.
 * 2018-03-22 | xxx.x   | Added new getter and setter method getMapVideoStreamInfo() and setMapVideoStreamInfo()
 * 2018-03-22 | xxx.x   | Add UserProfileActionInfos and SETTINGS_RESTORE_STATUS_CHANGED, USER_PROFILE_STATUS_CHANGED
 * 2018-03-22 | xxx.x   | Extend LocationAttributes with Google UserReview.
 * 2018-03-27 | 315.0   | Import interface changes CW 12
 * 2018-03-27 | xxx.x   | Removed deprecated method showTmDetailInMap().
 * 2018-04-03 | 316.0   | Import interface changes CW 13
 * 2018-04-03 | xxx.x   | Added support to add external direct NDS database user, added deviceId to NavDataUpdateStatus
 * 2018-04-04 | xxx.x   | Removed deprecated LocationDetailInfos type from MapPickingResults.
 * 2018-04-04 | xxx.x   | Added two new members m_distanceWithoutUnit and m_distanceUnit in JamAheadListElement class
 * 2018-04-05 | xxx.x   | Extened OnlineServiceAvailability states with No Subscription state and fix typo for ONLINE_SERVICE_AVAILABILITY__AVAILABLE.
 * 2018-04-05 | xxx.x   | Extend Configuration Info's with Location Input EntryType like NAR style, EUR style or JPN style.
 * 2018-04-10 | 317.0   | Import interface changes CW 14
 * 2018-04-10 | xxx.x   | Extend class RouteCountryAndStateInfos with country and state codes
 * 2018-04-11 | xxx.x   | Move VehicleRestrictionsInfo from GuidanceInfos.h to InfoTypes.h
 * 2018-04-11 | xxx.x   | Addition of interface for Loading Image of a Google Place.
 * 2018-04-11 | xxx.x   | Add request startAddressInputClone to start Address Input via cloning the existing Address Input instance into the new instance.
 * 2018-04-11 | xxx.x   | Added new interface highlightRoad().
 *                        Added new member m_hasRestrictions to class PickingResultDetailRoad.
 * 2018-04-11 | xxx.x   | Added new member ValidValue<VehicleRestrictionsInfo> to class PickingResultDetailRoad.
 * 2018-04-17 | 318.0   | Import interface changes CW 15
 * 2018-04-13 | xxx.x   | LockType NONE added to tell no special lock handling required, any lock type is allowed
 * 2018-04-17 | xxx.x   | Remove svg format from Image class.
 * 2018-04-17 | xxx.x   | Introduction of ChargingInfos in Electric vehicle
 *                        Moved ChargingType to InfoTypes.h
 *                        Added new interface setChargingInfos()
 *                        Added new class ChargingInfos to store charging related information
 * 2018-04-18 | xxx.x   | Added a new enum UseChargingTimeEPois in RouteSettings.h
 *                        - Added an member  m_optionChargingTimeEPois of type UseChargingTimeEPois in class RouteOptionSettings
 *                        - Added new members to ArrivalInfo class
 *                          1. m_chargingTimeAtDestination
 *                          2. m_additionalDurationOfStay
 *                          3. m_chargingTimeAtDestinationAsInt
 *                          4. m_additionalDurationOfStayAsInt
 *                         - Added new members to ArrivalInfoAlternative class
 *                          1. m_chargingTimeAtNextDestination
 *                          2. m_additionalDurationOfStay
 * 2018-04-18 | xxx.x   | Extended showLocationsInMap() with new parameter optionalOverviewGeoCoordinates.
 * 2018-04-18 | xxx.x   | Prepare differentiation of multiple interface revisions based on software base line
 * 2018-04-18 | xxx.x   | Extend PositionStatusInfo with link Id and provide getter and setter methods to set and get the link id.
 *                        added new interface to request road restrictions for a particular link id.
 *                        added new property identifier GUIDANCE_VEHICLE_RESTRICTIONS_AVAILABLE.
 * 2018-04-18 | xxx.x   | Add OnlineServicesDiagnosticInfos and property ONLINE_SERVICES_DIAGNOSITC_INFO_UPDATED
 * 2018-04-18 | xxx.x   | Added new enumType "MAP_MODE_CAPTURE" in MapInfos.h and propertyIdentifier
 *                        "MAP_CAPTURE_RESULT_AVAILABLE"
 *                        Added new interface storeMapCapture() for storing active capture Map view and getter getMapCaptureResultInfo()
 * 2018-04-24 | 319.0   | Import interface changes CW 16
 * 2018-04-23 | xxx.x   | Added new member m_showStreetViewOnArrival and setter getter to class MapSettings.
 *                        1. isShowStreetViewOnArrivalEnabled()
 *                        2. setShowStreetViewOnArrival()
 *                        Added new enum StreetViewMode to MapInfos
 *                        Extended showStreetViewImagesInMap() with a new parameter streetViewMode.
 * 2018-04-25 | xxx.x   | Add new interface storeRoute() to store a non-transformed tour
 * 2018-04-25 | xxx.x   | Added CountryAndStateDetailsInfo and new property identifier GUIDANCE_COUNTRY_DETAILS_AVAILABLE.
 *                        added new interface to request country state details.
 *                        moved enumeration TrafficSense from RouteInfos to InfoTypes
 * 2018-04-26 | xxx.x   | Add new interface storeRoute() to store a non-transformed tour
 * 2018-04-25 | xxx.x   | Added new interface storeDataBeforeShutDown(), to store the current data before shutdown
 *                        Added new property identifier ELECTRICVEHICLE_EPOI_DETECTED to notify hmi that a new ePOI is detected
 * 2018-05-03 | 320.0   | Import interface changes CW 17
 * 2018-05-03 | xxx.x   | Add privacy mode as one of the status in OnlineServiceAvailability.
 * 2018-05-08 | xxx.x   | Provide register and unregister callbacks for ElectricVehicle
 * 2018-05-09 | xxx.x   | Introduced new enum ViewModeOptions::ReachabilityDisplayMode and getters/setters for the same in MapInfos.h
 * 2018-05-15 | 321.0   | Import interface changes CW 19
 * 2018-05-15 | xxx.x   | Updated documentation of the method moveMapCenterPoint()
 * 2018-05-15 | xxx.x   | Extended Traffic Text Type with DETAILED_WITH_SHORTENED_EVENT_NAME
 * 2018-05-22 | 322.0   | Import interface changes CW 20
 * 2018-05-22 | xxx.x   | Extend structure VehicleProfile in RouteOptionsSettings with new member numberOfAxles
 * 2018-05-22 | xxx.x   | Extended TimeRangeOfDayInfo, DateRangeOfYearInfo structures which are part of CountryAndStateDetailsInfo
 *                        with m_startTime, m_endTime and m_startDate, m_endDate respectively.
 * 2018-05-24 | xxx.x   | Marked TrafficMessageListInfo::m_text as deprecated.
 *                        Moved m_textSections from class TrafficMessageDetailsInfo to TrafficMessageInfoBase
 * 2018-05-29 | 323.0   | Import interface changes CW 21
 * 2018-04-28 | xxx.x   | Add vehicle identification number (VIN) to ConfigurationInfos
 * 2018-05-30 | xxx.x   | Add new interface resetMapDynamicIconSettings()
 * 2018-05-30 | xxx.x   | Extend LineId with lineType in InfoTypes.h
 * 2018-05-31 | xxx.x   | Added PickingResultDetailSafetyCamera class to PickingResults class in MapPickingResults.h
 * 2018-05-31 | xxx.x   | Extend LocationAttributes and LocationInfos by LocationOrigin,
 *                        extend LocationInfos::EntryType by value ENTRY_TYPE__QUERY_AUTO_COMPLETION
 * 2018-06-01 | 324.0   | Import interface changes CW 22
 * 2018-06-04 | xxx.x   | Add missing toString for Poi Index Map.
 * 2018-06-05 | xxx.x   | Remove Location Origin from Location Info's. Already exists in Location Attributes.
 * 2018-06-06 | xxx.x   | Modified the log of LineType in LineId class in InfoTypes.h.
 * 2018-06-06 | xxx.x   | Extend SoftwareVariant in ConfigurationInfos with SOFTWAREVARIANT_NIVI_2 and SOFTWAREVARIANT_RIVI_2
 * 2018-06-06 | xxx.x   | Added new classes SafetyCameraTypeInfo and SafetyCameraSpeedLimitInfo to LocationAttributeInfo class.
 *                        Moved SafetyCameraType from MapPickingResults.h to InfoTypes.h
 *                        Extended AttributeType with 2 new values in LocationAttributeInfos .
 * 2018-06-12 | 325.0   | Import interface changes CW 23
 * 2018-06-06 | xxx.x   | Extend Vehicle Profile class in RouteSettings with profile name and icon id.
 *                        Extend VehicleTypeValue enumeration with Light Truck
 * 2018-06-12 | xxx.x   | Remove deprecated entries for navDataUpdate in NavMiddleware interfaces.
 * 2018-06-12 | xxx.x   | Added install stage COMPLETED to NavDataUpdateInstallStage enum.
 * 2018-06-12 | xxx.x   | Extend LocationCategoryInfos and MapDynamicIconSettings with LanguageEntryInfo
 *                        operator==() and operator!=() implemented for LanguageEntryInfo
 * 2018-06-13 | xxx.x   | Changed the SafetyCameraSpeedLimitInfo::SPEED_UNIT__CENTIMETERS_PER_HOUR to
 *                        SafetyCameraSpeedLimitInfo::SPEED_UNIT__CENTIMETERS_PER_SECOND
 * 2018-06-13 | xxx.x   | Added new members m_alertIdentifier, m_alertDue, m_numStandardReachablePOI, m_numEcoReachablePOI, m_driveMode to EvAlertInfo.
 *                        Moved DriveMode to InfoTypes.
 *                        Added new interface confirmPoiAlert(alertIdentifier)
 *                        to indicate confirmation of poi alert by the user for the given alert identifier.
 * 2018-06-19 | 326.0   | Import interface changes CW 24
 * 2018-06-15 | xxx.x   | Added constructor to class LineId in InfoTypes.h
 *                        Added assignment operator= to class PickingResultDetailSafetyCamera in MapPickingResults.h
 * 2018-06-18 | xxx.x   | Extend VehicleRestrictionsInfo with m_lineId
 * 2018-06-19 | xxx.x   | Remove DestinationMemoryDestinationDetails from Destination Memory Infos
 * 2018-06-26 | 327.0   | Import interface changes CW 25
 * 2018-06-25 | xxx.x   | Add method setFreeTextSearchAutoCompletionMode and enum AutoCompletionMode,
 *                        extend LocationInfos with m_currentAutoCompletionMode,
 *                        extend AddressInputInfo with m_currentBoundingBox
 * 2018-06-26 | xxx.x   | Remove member m_isCurrentlyCharging from class ChargingInfos
 *                        Extend ChargingType with CHARGING_TYPE__QUICK_CHARGE and CHARGING_TYPE__ULTRA_FAST_CHARGE
 * 2018-07-03 | 328.0   | Import interface changes CW 26
 * 2018-06-29 | xxx.x   | Add new property identifer GUIDANCE_LOW_BATTERY_ALERT_CHANGED to notify low battery alerts.
 *                        Add method getLowBatteryAlertInfo() to access the info object.
 *                        Extend enum PoiAlertType with POI_ALERT_TYPE__LOW_BATTERY.
 * 2018-07-03 | xxx.x   | Added new scomo install result ACTIVATION_ON_SHUTDOWN_COMPLETED to inform HMI for resetting spmSubStateCustomerDownload
 * 2018-07-04 | xxx.x   | Added TimeDisplay in the MapSettings
 * 2018-07-04 | xxx.x   | Extended CameraConfiguration enum with CAMERA_CONFIGURATION_AVOID_AREA
 * 2018-07-04 | xxx.x   | Added new interface setConnectedClusterType(ConnectedClusterType connectedClusterType).
 * 2018-07-04 | xxx.x   | Extend EvAlertInfo with m_unreachableDestinationType and added an enum UnreachableDestinationType to GuidanceInfos.h
 * 2018-07-10 | 329.0   | Import interface changes CW 27
 * 2018-07-11 | xxx.x   | Added new class RouteRestrictionStatus in RouteInfos.h
 *                        Extend class RouteCalculationInfoAlternative with a member of type RouteRestrictionStatus
 * 2018-07-12 | xxx.x   | Extended TrafficMessageInfoBase and MapPickingDetailsTm with isUserDefinedTrafficMessage flag
 * 2018-07-17 | 330.0   | Import interface changes CW 28
 * 2018-07-12 | xxx.x   | Add new interface for getting the update history. Move DeviceStatus and DeviceType outside class NavDataDeviceInfo
 * 2018-07-16 | xxx.x   | Marked camera modes MAP_MODE_PREPARE_ROUTE_OVERVIEW, MAP_MODE_ROUTE_FLIGHT, MAP_MODE_CONTINUOUS_MOVEMENT as deprecated
 * 2018-07-18 | xxx.x   | Added a new property identifier ROUTE_RESTRICTION_AVOIDED to inform whenever a route restriction in the previous active route is avoided.
 * 2018-07-17 | 331.0   | Import interface changes CW 29
 * 2018-07-19 | xxx.x   | Extend SpeedInfo with a boolean member m_isUnlimitedSpeed to indicate no speed restriction to HMI
 *                        and extend SpeedLimitData with a boolean member m_isUnlimitedSpeed
 *                        to allow HMI to tell middleware if "free speed" is recognised by the external camera
 * 2018-07-23 | xxx.x   | Fixed formatting in NavDataUpdateInfos.h
 * 2018-07-26 | xxx.x   | Added new member UNKNOWN systemState type in systemState enumeration in ConfigurationInfos
 * 2018-07-31 | 332.0   | Import interface changes CW 30
 * 2018-07-31 | xxx.x   | Added new DataUpdateStatus MAP_DATA_NOT_COMPATIBLE to indicate that new map is not compatible with installed map
 * 2018-08-01 | xxx.x   | Extend CountryAndStateDetailsInfo with new member m_isMetricSystemUsed
 * 2018-08-07 | 333.0   | Import interface changes CW 31
 * 2018-08-02 | xxx.x   | Extend ViewModeOptions with new member m_isEPoiDisplayForced to force the display of ePOIs.
 * 2018-08-08 | xxx.x   | Add new interface method startRouteCalculationForPlanning() to start the route calculation from the first waypoint/destination
 *                        and not the current vehicle position
 * 2018-08-14 | 334.0   | Import interface changes CW 32
 * 2018-08-14 | xxx.x   | Extend the enum ScrollSpeed.
 * 2018-08-14 | xxx.x   | Provide RestoreStatus of route options and criteria
 *                        Introduced enum RestoreStatus in SettingTypes.h
 *                        Added new interface methods getLastRestoreStatusOfRouteCriteriaSettings and getLastRestoreStatusOfRouteOptionsSettings
 * 2018-08-21 | 335.0   | Import interface changes CW 33
 * 2018-08-14 | xxx.x   | Add new interface method startAutomaticChargingStationDetection(), getAutomaticChargingStationDetectionInfo(),
 *                        cancelAutomaticChargingStationDetection() and insertChargingStationsToRoute() for Smart Route Planner feature
 *                        Add new class AutomaticChargingStationDetectionInfo in RouteInfos.h
 * 2018-08-22 | xxx.x   | Adapt toString function in HorizonEventInfo to fix coverity warning
 * 2018-08-28 | 336.0   | Import interface changes CW 34
 * 2018-08-29 | xxx.x   | Added UseLearningNavigationValue to RouteSettings
 * 2018-08-30 | xxx.x   | Extend ArrivalInfo with new members m_stateOfChargeAfterCharging and m_stateOfChargeAfterChargingAsInt.
 *                        Extend ArrivalInfoAlternative with new members m_stateOfChargeAfterChargingAtNextDest, m_chargingTimeAtNextDestAsInt,
 *                        m_stateOfChargeAfterChargingAtNextDestAsInt and m_additionalDurationOfStayAsInt. Renamed m_additionalDurationOfStay as
 *                        m_additionalDurationOfStayAtNextDest.
 * 2018-08-30 | xxx.x   | Added new member to class MapCameraModeInfo m_isPreparationPending and respective getter and setter.
 * 2018-09-04 | 337.0   | Import interface changes CW 35
 * 2018-09-10 | xxx.x   | Removed deprecated camera mode "MAP_MODE_PREPARE_ROUTE_OVERVIEW" from MapInfos.h
 * 2018-09-11 | xxx.x   | Extend SignpostInfo to support overloaded functions for == and != operators.
 * 2018-09-18 | 338.0   | Import interface changes CW 37
 * 2018-09-17 | xxx.x   | Provide a new method requestWaypointListPlannedRoute()
 * 2018-09-18 | xxx.x   | Added new interface method updateLastDestinationHistoryList() to update History timestamp of Previous Destination Entry
 *                        Added new classes DestinationMemoryLastDestinationHistory and DestinationMemoryUpdatedLastDestinationList
 *                        in DestinationMemoryInfos
 *                        Extended property identifier to notify update last destination History changed.
 * 2018-09-18 | xxx.x   | Extend NextManeuverInfos with a vector containing scale values for bargraph.
 * 2018-09-18 | xxx.x   | Add NearestChargingStationInfo and corresponding property identifier GUIDANCE_NEAREST_CHARGING_STATION_INFO_CHANGED.
 * 2018-09-19 | xxx.x   | Modified the documentation for showReachableAreaOverviewInMap() method and modified the print statement for
 *                        viewModeCOnfiguration structure.
 * 2018-09-19 | xxx.x   | Extend LocationInfo,AddressInputInfo,LocationCategoryInfo,PoiCategoryInfo With SdsGlobalNamedObjectId
 *                        Extend LocationAttributeInfo with Phoneme
 * 2018-09-19 | xxx.x   | Added new route property identifier ROUTE_APPROACHING_CHARGING_STATION to indicate an approaching charging station.
 * 2018-09-25 | 339.0   | Import interface changes CW 38
 * 2018-09-21 | ---.-   | Suppress false positive cppcheck findings in InfoTypes.h, LocationAttributeInfos
 * 2018-09-25 | xxx.x   | Added new method setFavoriteUpdateRegionsUsage() for de-activating and activating favorite update region ids
 *                        Added new enumerations FavoriteUpdateRegionsUsage and FavoriteUpdateRegionsUsageResult
 *                        Added new property identifier NAVDATAUPDATE_FAVORITE_UPDATE_REGIONS_USAGE_RESULT_CHANGED
 *                        Extended FavoriteUpdateRegionStatus with DEACTIVATED_SETTINGS
 * 2018-09-26 | xxx.x   | Marked freezeMap() as deprecated and add a new version for the freezmap with
 *                        additional parameters for freeze duration and rendering status.
 *                        Added new method setMapFrameRate()
 *                        Extended DataRendering status with RENDERING_STATUS_FREEZE_KEEP_DATA
 * 2018-09-26 | xxx.x   | Marked m_trafficTimeDelayInMinutes as deprecated and added m_trafficTimeDelayInSeconds in TrafficMessageInfoBase
 * 2018-10-01 | xxx.x   | Removed deprecated property identifiers and the deprecated MapInfo gettter interfaces.
 * 2018-10-09 | 340.0   | Import interface changes CW 40
 * 2018-10-04 | xxx.x   | Extended RouteRestrictionStatus with a new member m_isLcvRestrictionViolated.
 *                        Added new property identifier ROUTE_LCV_RESTRICTION_VIOLATION_STATUS_CHANGED.
 * 2018-10-05 | xxx.x   | Added new interface method insertLastDestinationList() to insert last Destinations in Previous Destination Entry
 *                        Added new class DestinationMemoryLastDestination in DestinationMemoryInfos
 *                        Extended property identifier to notify insert last destination status changed.
 * 2018-10-10 | xxx.x   | Added new interface methods addDynamicIconsOnMap() and deleteDynamicIconsOnMap()
 *                        Added new class DynamicIconInfo which will be passed while adding dynamic icon on map.
 *                        Extended Picking Result Detail with the new type for the dynamic icon.
 * 2018-10-16 | 341.0   | Import interface changes CW 41
 * 2018-10-12 | xxx.x   | Extended a getter method for AutomaticChargingStationDetectionStatus in RouteInfos
 * 2018-10-23 | 342.0   | Import interface changes CW 42
 * 2018-10-24 | xxx.x   | Removed favoriteUpdateRegionUsage interfaces and added a separate settings interfaces
 *                        AutomaticMapUpdateSatus for activating/deactivating map automatic updates
 * 2018-10-30 | 343.0   | Import interface changes CW 43
 * 2018-10-25 | xxx.x   | Added a new attribute HouseNumberRangeInfo in Location Attributes in InfoTypes.h
 * 2018-10-30 | xxx.x   | Added new Settings group for EV settings
 * 2018-10-30 | xxx.x   | Extended CountryAndStateInfo with new members m_countryFlag and m_stateFlag.
 * 2018-11-06 | 344.0   | Import interface changes CW 44
 * 2018-11-09 | xxx.x   | Correct the toString statement for m_NoHouseNumbersAvailableInSelectedStreet.
 * 2018-11-12 | xxx.x   | Updated comments in VehilceProfile indicating the acceptable units of vehicle dimensions and weight.
 * 2018-11-19 | xxx.x   | toString() functions in NavDataUpdateSettings.h are made as inline.
 * 2018-11-20 | 345.0   | Import interface changes CW 46
 * 2018-11-20 | xxx.x   | Added new getter type for HouseNumberRangeInfo in InfoTypes.h
 * 2018-11-21 | xxx.x   | Replace property getLocationOnlineSearchAvailability / LOCATION_ONLINE_SEARCH_AVAILABILITY_CHANGED
 *                        by getOnlineFreeTextSearchAvailability / LOCATION_ONLINE_FREE_TEXT_SEARCH_AVAILABILITY_CHANGED,
 *                        add new structure OnlineFreeTextSearchAvailabilityInfo,
 *                        extend PoiInputInfo by member OnlineServiceAvailability m_onlineSearchAvailability,
 *                        extend enum OnlineServiceAvailability by states NO_CONNECTION and NOT_PROVIDED
 * 2018-11-27 | 346.0   | Import interface changes CW 47
 * 2018-12-03 | xxx.x   | Added TrafficMessageDetourResult enum to inform HMI about detour traffic message result
 * 2018-12-04 | xxx.x   | Added new interface to Activate/Deactivate EcoNavigation
 * 2018-12-05 | xxx.x   | Add new interface for setAdvancedTrafficLoggingState to control advanced logging of raw TPEG data related to
 *                        Traffic and LocationBasedServices
 * 2018-12-11 | 347.0   | Import interface changes CW 49
 * 2018-12-10 | xxx.x   | Modify VehicleRestrictionsInfo to get a list of vehicle types restricted for a particular road link
 * 2018-12-11 | xxx.x   | Added FeatureStatus NOT_SUBSCRIBED and OFF in MapInfos.h
 *                        Added ReceptionState NOT_PROVIDED in TrafficMessageInfos.h and WeatherInfos.h
 *                        Added TestServerTypes CUSTOMER_AUX, AUX and WU6CHE_DE in TrafficSettings.h
 * 2018-12-12 | xxx.x   | Added FotaBearerType enum to configurationInfos to know about vNext services availability in the region.
 *                        Extended enum RegionType with REGIONTYPE_OTH_GOM and REGIONTYPE_ISR.
 * 2018-12-13 | xxx.x   | Add requestSdsRefinementList with CategoryType as an additional parameter and deprecate the interface without Parameter
 * 2018-12-18 | 348.0   | Import interface changes CW 50
 * 2018-12-13 | xxx.x   | Add new interface for storeEntries store an entry for a given category by explicitly specifying destination data,
 *                        attributes and position
 *                        Extend the info class DestinationMemoryDestination to accommodate language, source and unique place Id
 *                        information which are required for synchronizing the locations
 * 2019-01-08 | 349.0   | Import interface changes CW 51
 * 2018-10-12 | xxx.x   | Added new interface requestLastDestinationsHistory()
 * 2018-10-12 | xxx.x   | Added new class SdsCountryInfo containing SdsGlobalNamedObjectIdWithPoiAndXrefIdInfo and ISO CountryCode
 *                       SdsCountryAndSubCountryInfos will now return CountryIds of type SdsCountryInfo
 * 2019-01-17 | xxx.x   | Added new getter type for EvConnectorTypeFilterSettings in LocationSettings.h
 * 2019-01-22 | 350.0   | Import interface changes CW 03
 * 2019-01-21 | xxx.x   | Added new property update MAP_ADD_DYNAMICICON_RESULT_AVAILABLE
 *                        Added new class AddDynamicIconResult in MapInfos.h to provide the result for addDynamicIconsOnMap call().
 *                        Added new getter getAddDynamicIconResult() in navmiddleware.h
 * 2019-01-23 | xxx.x   | Added new class RouteVisibilityOptions in MapInfos.h to handle the route, destination flag
 *                        and carsor display in Route Overview screen
 *                        Extended showEditRouteOverviewInMap() to include routeVisibilityOptions
 * 2019-01-24 | xxx.x   | Fix Initialization order in the class FuzzyTimeInfo and WeatherInfo in InfoTypes.h
 * 2019-01-24 | xxx.x   | Added new attribute BookingInfo in LocationAttributes support the booking/reservation of an charging station in InfoTypes.h
 * 2019-01-29 | 351.0   | Import interface changes CW 04
 * 2019-01-25 | xxx.x   | Extend ConfigurationInfo with CompatibleChargingConfigurationInfo
 * 2019-01-28 | xxx.x   | Extend LocationSettings with EvChargingSpeedFilterSettings to support new chargingSpeed filters.
 * 2019-01-30 | xxx.x   | Add new interface getOnlinePoiAvailability for Poi Online Service status.
 * 2019-01-30 | xxx.x   | Added Unspecified getter type for EvConnectorTypeFilterSettings in LocationSettings.h
 * 2019-01-31 | xxx.x   | Extend ExternalLocation with Location origin and unique id in InfoTypes to indicate the source of the location.
                          Add UniqueId attribute in LocationAttributeInfos.
 * 2019-02-05 | 352.0   | Import interface changes CW 05
 * 2019-02-07 | xxx.x   | Removed the arguments in the toString() of RouteVisibilityOptions and changed it as const function.
 *                        Updated the AddDynamicIconResult class to return the list of icons for which addition failed
 * 2019-02-07 | xxx.x   | Added Combo Type 1 filter and extended enumeration evConnectorTypes with additional Connector types.
 * 2019-02-12 | 353.0   | Import interface changes CW 06
 * 2019-02-19 | xxx.x   | Added new enumeration VehicleInletType and extended charging cable group.
 * 2019-02-20 | xxx.x   | Set default value of chargingType in class chargingInfos to CHARGING_TYPE__UNKNOWN
 *                        in ElectricVehicleInfos.h
 * 2019-02-26 | 354.0   | Import interface changes CW 08
 * 2019-02-27 | xxx.x   | Provide the LastUpdateStatus attribute in LocationAttributeInfos in no. of days
 * 2019-03-05 | 355.0   | Import interface changes CW 09
 * 2019-03-06 | xxx.x   | Remove ValidValue types for Location origin and unique id in ExternalLocation in InfoTypes.
 * 2019-03-11 | 356.0   | Import interface changes CW 10
 * 2019-03-11 | xxx.x   | Extend SortingAlgorithm in DestinationMemoryInfos to handle SORTINGALGORITHM_BY_ICON_AND_ALPHABETICAL_BY_ALIAS_ASC
 *                        And SORTINGALGORITHM_BY_GROUP_AND_ALPHABETICAL_BY_ALIAS_ASC
 * 2019-03-11 | xxx.x   | Added new enumeration PreferredResultLocationType in LocationInfos.h
 * 2019-03-12 | xxx.x   | Added new enumeration ChargeFactorType in ConfigurationInfos.h
 * 2019-03-19 | 357.0   | Import interface changes CW 11
 * 2019-03-20 | xxx.x   | Modified the comments for touchGestures in MapInfos.h.
 *                        Enhanced the logging for Map Modes.
 * 2019-03-26 | 358.0   | Import interface changes CW 12
 * 2019-03-29 | xxx.x   | Extended class WaypointInfo with a new member of type LocationAttributeInfos.
 * 2019-04-03 | xxx.x   | - Renamed MAP_MODE_SETTINGS_LEFT_MAP_SCALE to MAP_MODE_SETTINGS_SECONDARY_MAP_SCALE in MapCameraMode
 *                        - Renamed setters and getters for Orientation, LongRange, MapScale from LeftView to SecondaryView in MapSettings
 * 2019-04-09 | 359.0   | Import interface changes CW 14
 * 2019-04-04 | xxx.x   | Extend the HorizonEventInfo to provide the country name for Border crossing Horizon event
 * 2019-04-05 | xxx.x   | Added interface setIncludeGooglePlacesInListRequests to Set the filter for Address Book /History.
 * 2019-04-10 | xxx.x   | Extended enumeration ChargeFactorType with CHARGE_FACTOR_TYPE__DC, CHARGE_FACTOR_TYPE__NORMAL_ACCELERATED_AND_FAST
 *                        and CHARGE_FACTOR_TYPE__NORMAL_ACCELERATED_FAST_AND_DC in ConfigurationInfos.h
 * 2019-04-10 | xxx.x   | Add new NavDataUpdate method getAutomaticFullUpdateStatus to get the status of MapUpdate in case of a yellow stick update
 *                        Add new NavDataUpdate method setAutomaticMapUpdateStatus to inform NavMW about Automatic Full Update Failures in HMI
 *                        Add new NavDataUpdate property NAVDATAUPDATE_AUTOMATIC_FULL_UPDATE_STATUS_CHANGED to indicate MapUpdate status change
 *                        in case of a yellow stick update
 *                        Add DeviceStatus AUTOMATIC_FULL_UPDATE in NavDataUpdateInfos to inform HMI to perform automatic update without user consent
 *                        This is required for updating an yellow stick(Map+SW update)
 * 2019-04-16 | 360.0   | Import interface changes CW 15
 * 2019-04-16 | xxx.x   | Extend DestinationMemoryDestination in DestinationMemoryInfos to accommodate sourceId and placeId in constructor.
 * 2019-04-16 | 361.0   | Import interface changes CW 16
 * 2019-04-24 | xxx.x   | Added new enumeration ConnectedServicesStatus and ConnectedServicesAvailabilityInfos in ConnectedServicesInfos.h.
 *                        Added COUNTRY_SPECIFIC_CONNECTED_SERVICES_AVAILABILITY_CHANGED in PropertyIdentifiers.h
 * 2019-04-24 | xxx.x   | Add Request to refresh expired entries for location and destination memory.
 *                        Add PropertyUpdate and status to indicate entry selection status.
 * 2019-04-30 | 362.0   | Import interface changes CW 17
 * 2019-04-25 | xxx.x   | Extend class MapDynamicIconInfo to with a new member of type MapDynamicIconId and removed member iconId.
 *                        Added new structure MapDynamicIconId to identify the dynamic icons using the id and intent.
 *                        Updated the deleteDynamicIconsOnMap to take the list of MapDynamicIconId instead of uint64_t ids.
 *                        Added a new property update MAP_DYNAMICICON_REQUEST_RESULT_AVAILABLE and MAP_ADD_DYNAMICICON_RESULT_AVAILABLE is deprecated.
 *                        Removed the class AddDynamicIconRequestResult and added new class DynamicIconRequestResult for feedback
 *                        Removed the getter getAddDynamicIconRequestResult and added new getter getDynamicIconRequestResult
 * 2019-04-26 | xxx.x   | Add method to get DestinationInfos for last mile navigation
 * 2019-04-30 | xxx.x   | RequestId will be returned for requestNamesForNdsIds/requestPhonemesForNdsIds to be able to handle multiple parallel requests
 *                        class SdsNdsIdStringInfos is added which contains the Strings for Names/Phonemes along with the requestId to match response with request
 * 2019-05-07 | 363.0   | Import interface changes CW 18
 * 2019-05-03 | xxx.x   | Added PICKING_RESULT_TYPE__TRAFFIC_ICON to toString() method for PickingResultType.
 * 2019-04-30 | xxx.x   | Extend SafetyGuidanceSettings to set overspeed warning acoustic and symbolic warnings independently.
 * 2019-05-06 | xxx.x   | Modify the existing interface getOnlinePoiAvailability to handle different sources for different poi categories.
 * 2019-05-07 | xxx.x   | Extended DestinationMemoryDestination to accommodate EntrySelectionStatus in DestinationMemoryInfos.
 * 2019-05-14 | 364.0   | Import interface changes CW 19
 * 2019-05-08 | xxx.x   | Updated MapDynamicIconId structure to overload < operator since this is used as key in map
 * 2019-05-21 | 365.0   | Import interface changes CW 20
 * 2019-05-17 | xxx.x   | Extend GuidanceSettings with Traffic Signs Master Setting "m_isGlobalTrafficSignWarningsEnabled"
 * 2019-05-28 | 366.0   | Import interface changes CW 21
 * 2019-05-28 | xxx.x   | Added new setting to MapSettings for show current street on map
 * 2019-05-30 | xxx.x   | Modify PropertyUpdate and Status with LOCATION_ATTRIBUTES_AVAILABLE/LOCATION_ATTRIBUTES_ERROR to Motorway Usage.
 * 2019-06-04 | 367.0   | Import interface changes CW 22
 * 2019-05-31 | xxx.x   | Added class AssociatedServiceInfo which contains enum for Associated Service to POI categories
 * 2019-06-03 | xxx.x   | Added a new interface requestUpdateBySelection with the path for the updates, to delay the cache directory path input to MW from HMI
 * 2019-06-04 | xxx.x   | Added toString() functions in PrepareStreetViewStatusInfo,PrepareSatelliteViewInfo and PickingResultFilter classes.
 *                        Added toString() function for enum PickingResultFilterType.
 * 2019-06-04 | xxx.x   | Updated the comment regarding insertWaypoint() interface usage
 * 2019-06-05 | xxx.x   | Extended ArrivalInfos with bool m_isRouteCalcCompletedForAllDestinations
 * 2019-06-06 | xxx.x   | Extend ArrivalInfos::ArrivalInfo with route criterion info
 * 2019-06-11 | 368.0   | Import interface changes CW 23
 * 2019-06-10 | xxx.x   | Added XC2C and OTHER to ::navmiddleware::VehicleType.
 * 2019-06-12 | xxx.x   | Added struct MapScaleInfo to MapCameraInfos
 *            |         | Added toString() method for ::navmiddleware::DistanceUnit
 * 2019-06-12 | xxx.x   | Added new member m_countryCode to ConnectedServiceAvailabilityInfos
 * 2019-06-13 | xxx.x   | Added a new member variable m_entryListCount in DestinationMemoryEntryList to indicate the total count of destinations in AddressBook.
 *                        Added a new member variable m_itemListCount in DestinationMemoryItemList to indicate the total count of destinations in History/PreviousDestination.
 * 2019-06-18 | 369.0   | Import interface changes CW 24
 * 2019-06-22 | xxx.x   | Added valid value print for LocationSearchSource in LocationInfos class.
 * 2019-06-26 | xxx.x   | Added new enum EvHvacType in ConfigurationInfos.h.
 *                        Fixed the text in MapScaleInfo::toString() method.
 * 2019-06-27 | xxx.x   | Added bool m_isDetourPossible in Class TrafficImpactRouteAlternativeInfos in RouteInfos
 * 2019-07-02 | 370.0   | Import interface changes CW 26
 * 2019-07-02 | xxx.x   | Corrected the way C-style array is compared in class VehicleProfileSettings, RouteSettings.h
 * 2019-07-09 | 371.0   | Import interface changes CW 27
 * 2019-07-05 | xxx.x   | Added new enum EvAllianceReachAreaType in ConfigurationInfos.h.
 * 2019-07-16 | 372.0   | Import interface changes CW 28
 * 2019-07-18 | xxx.x   | Location attributes extended with SpecialRestrictionsInfo
 * 2019-07-19 | xxx.x   | Location attributes extended with getPictureReferenceInfos to get all pictureReferences as list.
 * 2019-07-22 | xxx.x   | class Refresh Info is added to get the background Refresh Status and its count.
 * 2019-07-23 | xxx.x   | LocationAttributes extended with OpeningHours Class and OpeningHours As StringAttribute is depricated.
 * 2019-07-25 | xxx.x   | Extend ReviewInfos Attribute to support Total Reviews Count.
 * 2019-07-30 | 373.0   | Import interface changes CW 30
 * 2019-07-31 | xxx.x   | Added new enum EXIT_POI_CATEGORY__EV_CHARGING_STATION in InfoTypes.h
 * 2019-08-06 | 374.0   | Import interface changes CW 31
 * 2019-08-06 | xxx.x   | Remove deprecated for getPictureReferenceInfo to support picture References as single and list.
 * 2019-08-06 | xxx.x   | Initialized LocationOrigin inside default constructor of LocationDetails to fix the coverity warning.
 * 2019-08-12 | xxx.x   | Extend PreDefinedPOICategories with Leisure category
 * 2019-08-05 | xxx.x   | LocationAttributes extended with OpeningHours Class and OpeningHours As StringAttribute is depricated.
 * 2019-08-20 | 375.0   | Import interface changes CW 33
 * 2019-08-20 | xxx.x   | Added new property identifier NAVDATAUPDATE_INVENTORY_INFO_CHANGED to inform HMI on change of any inventory info except on start-up
 *                        Added a new IF setFotaInventoryUpdateStatus() for HMI, to inform MW, if the inventory update is sent properly to FOTA
 * 2019-08-27 | 376.0   | Import interface changes CW 34
 * 2019-09-12 | xxx.x   | Added addDynamicAreaUserStyle() and class DynamicAreaUserStyle for adding weather alert data in yellow zone
 * 2019-09-17 | 377.0   | Import interface changes CW 37
 * 2019-09-13 | xxx.x   | Added new property identifier LOCATION_COORDINATE_RESOLVE_FAILED to inform HMI on invalid coordinates
 * 2019-09-16 | xxx.x   | Extend ConfigurationInfos with a boolean indicating traffic sign recognition availability.
 * 2019-10-15 | 378.0   | Import interface changes CW 38
 * 2019-09-26 | xxx.x   | Added missing ManeuverSymbolInfo to toString for logging
 * 2019-10-09 | xxx.x   | Added a new IF movePoiShortcut() for Drag and Drop feature.
 * 2019-10-16 | xxx.x   | Added enum EcoNavStatus to indicate the EcoNavStatus of the EcoNavSytem
 * 2019-10-16 | xxx.x   | Extend HmiContext enumaration with HMICONTEXT__MAP value.
 * 2019-10-18 | 379.0   | Import interface changes CW 42
 * 2019-10-15 | xxx.x   | Extended WeatherDataInfo with the new member UnknownWeatherSituationIcon in InfoTypes.h
 * 2019-10-16 | xxx.x   | Extended UpdateRegionInfo class with AreaInfo structure containing m_areaName and m_areaflag,
 *                        and another structure CountryAndSubCountryInfo containing m_countryInfo and m_subCountryInfo.
 * 2019-10-25 | xxx.x   | Extended context for storing the shortcut.
 *                        Added a new IF deletePoiCategoryAsShortcut() for POi shortcuts.
 * 2019-10-31 | xxx.x   | Extended the EcoNavStatus with new enum value of ECONAV_STATE__NO_ZEV_ZONE_FUNCTION
 * 2019-11-05 | xxx.x   | Add a new interface is added to specify whether validation for the given house Number is to be done or not.
 * 2019-11-07 | xxx.x   | Add a new interface to created form based address input from Fts Results.
 * 2019-11-12 | 380.0   | Import interface changes CW 44 (Nuesoft) and CW45(Bosch)
 * 2019-11-11 | xxx.x   | Added a new class EvMiscellaneousSettings in GuidanceSettings.h to handle the Non navigation functional settings.
 * 2019-11-14 | xxx.x   | Extend EvAutoSaveChargingStationSettings according to Japan Specification
 *                        Extend ChargingType to have 1 to 1 match with CAN input
 * 2019-11-14 | xxx.x   | Extend ConnectedServiceAvailabilityInfo with subscription status and
 *                        rename ConnectedServiceStatus to CountrySpecificAvailabilityStatus
 * 2019-11-15 | xxx.x   | Add new setting for use truck restrictions or not and new variable indicating that profile is modified by User or not
 *                        and vector used for cargo type allowing HMI to define multiple cargo types
 * 2019-11-15 | 381.0   | Import interface changes CW46
 * 2019-11-25 | xxx.x   | Extended the VehicleFuelType with enum value of VEHICLE_FUEL_TYPE__PLUG_IN_HYBRID in ConfigurationInfos
 * 2019-11-27 | xxx.x   | Extend TouchGestureSwipe with TouchGestureSwipeType and Speed in MapInfos.h
 * 2019-11-27 | xxx.x   | Added new method configureRouteVisibilityOnMap() in NavMiddleware.h
 * 2019-12-03 | 382.0   | Import interface changes CW48
 * 2019-12-26 | xxx.x   | Extend MapColorStyle with MAPCOLORSTYLE_TYPE_5 and extend MapCameraInfos with m_cameraPitch.
 * 2019-12-30 | xxx.x   | Add storeEntry interface to be able to accept DestinationMemoryAttributes
                          Extend DestinationMemoryStoreEntryStatus with Destination object.
 * 2020-01-02 | xxx.x   | Provide subscription status for FTS online services based on trigger from AIVI
 * 2020-01-02 | xxx.x   | Extended method insertChargingStationsToRoute() with the parameter RouteCalculationMode
 *                        Added new property identifier ROUTE_PRE_CALCULATION_WITH_AUTOMATIC_CHARGING_STATIONS_STATUS_CHANGED
 *                        Added new enum RouteCalculationStatus to class AutomaticChargingStationDetectionInfo
 *                        Modified the members m_totalNumberOfDetectedChargingStations, m_totalExtaTime, m_totalExtraDistance in
 *                        the class AutomaticChargingStationDetectionInfo as valid values
 * 2020-01-03 | 383.0   | Import interface changes CW01
 * 2020-01-07 | xxx.x   | Added new method getVehicleRestrictionsStatus()
 * 2020-01-13 | xxx.x   | Renamed existing sort order and extended new sort order in LocationInfos
 * 2020-01-16 | xxx.x   | Add missed members comparison in the == operator overloading implementation in RouteOptionsSettings
 * 2020-01-17 | xxx.x   | Changed requestEntryList interface description
 * 2020-01-23 | xxx.x   | Extended requestAddressAttributesForCoordinate with a bool to specify on-board matching is required or not
 * 2020-01-31 | 385.0   | Import interface changes CW05
 * 2020-01-31 | xxx.x   | Extended DestinationMemoryStoreEntryStatus class with DestinationMemoryAttribues info object
 * 2020-02-03 | xxx.x   | Add new property identifier ROUTE_AUTOMATIC_CHARGING_STATION_DETECTION_INVALIDATE
 * 2020-02-11 | 386.0   | Import interface changes CW06 (Bosch and Neusoft)
 * 2020-02-10 | xxx.x   | Add RequestId in requestLocationAttributes and corresponding Info objects to match the request-response.
 * 2020-02-14 | 387.0   | Import interface changes CW07 (Bosch and Neusoft)
 * 2020-02-20 | xxx.x   | Added a new class DirectionDescriptionInfo in InfoTypes.h
 * 2020-02-27 | xxx.x   | Extend new ErrorCode as No Online Subscription in LocationInfos.
 * 2020-02-14 | 388.0   | Import interface changes CW09
 * 2020-03-10 | xxx.x   | Updated documentation for SelectAddressCategoryForInput
 * 2020-03-12 | xxx.x   | Non-static class member m_cameraPitch is initialized in MapInfos.h
 * 2020-04-28 | xxx.x   | Extended interface to provide destination details of resumed guidance on startup.
 *                        Added property identifier GUIDANCE_LAST_GUIDED_ITEM_DETAILS_AVAILABLE.
 * 2020-05-18 | xxx.x   | Extended showRouteOverview with boolean showPlannedAndGuidedRoute.
 * 2020-05-26 | xxx.x   | Added new property identifier ROUTE_LIST_ERROR.
 *                      | Added new enum RouteListError in RouteInfos.h.
 *                      | Extended class RouteListInfos with m_requestId and m_routeListError
 *                      | Return type of requestRouteList method is changed to ValidValue<RequestId>
 * 2020-07-09 | xxx.x   | Return type of PickInMap() updated to ValidValue<RequestId>
 *                      | PickingResult extended with ValidValue<RequestId> and ValidValue<PickingError>
 *                      | Added new enum PickingError to indicate picking failure
 * 2020-07-09 | xxx.x   | Added new structure TimeValuesIncludingChargingTime in RouteInfos.h.
 *                      | Extended class RouteListElementInfo with m_timeValuesIncludingChargingTime,
 *                      | m_timeOfElementInSeconds, m_formattedChargingTimeAtElement and m_chargingTimeAtElementInSeconds
 * 2020-07-17 | 389.0   | Import interface changes Bosch proposal and Neusoft proposal
 * 2020-07-27 | xxx.x   | Exteded enum SettingsGroup with SETTINGS_GROUP__RNAIVI_ELECTRIC_VEHICLE_CONNECTOR_TYPE
 *                        and SETTINGS_GROUP__RNAIVI_ELECTRIC_VEHICLE_CHARGE_TYPE in SettingTypes.h
 * 2020-07-27 | xxx.x   | Added enum AutomaticChargingStationDetectionReason to AutomaticChargingStationDetectionInfo
 * 2020-08-04 | xxx.x   | Updated documentation for getPoiShortcutCategoryInfos in navMiddleware.h
 * 2020-08-07 | 390.0   | Import interface changes Bosch proposal CW31 and CW32
 * 2020-08-20 | xxx.x   | Combined Online and Offline Associated service values in Infotypes.h
 * 2020-08-25 | xxx.x   | Extended OnlineImageStatus enum with ONLINE_IMAGE_STATUS__UNKNOWN and ONLINE_IMAGE_STATUS__NO_SUBSCRIPTION in MapInfos.
 * 2020-08-26 | xxx.x   | Add new method requestPoiOnlineServerAvailability
 * 2020-08-29 | 391.0   | Import interface changes Bosch proposal CW35
 * 2020-09-16 | xxx.x   | Added new IF setFreeTextSearchAutoCompleteCategories() with autoCompletionConfiguration to fetch the history entries.
 * 2020-09-28 | xxx.x   | Deleted the deprecated LI-MW interfaces: requestLocationDetails,getLocationDetails,getRequestLocationDetailsError,
 *                      | requestAddressDetailsForCoordinate,getAddressDetailsOfCoordinate, requestPoiEntryDetails,
 *                      | getPoiEntryDetails,requestFreeTextSearchResultDetails,getFreeTextSearchResultDetails
 * 2020-10-15 | 393.0   | Import interface changes Bosch proposal CW38, CW41 and Neusoft Proposal CW37
 * 2020-11-03 | xxx.x   | Added Null Pointer check in the toString() method of PickingResults
 * 2020-11-06 | 394.0   | Import interface changes Bosch proposal CW45 and Neusoft Proposal CW45
 * 2020-11-04 | xxx.x   | Added Country&State codes,uniqueID to class PositionInfo and uniqueID to class PositionStatusInfo in PositionInfos.h
 * 2020-11-12 | xxx.x   | Extend RouteOptionsSettings with new enums EstimatedTime and DestinationTimeDisplay
 * 2020-11-13 | xxx.x   | Add new interface to support multiple icons for poi shortcuts.
 * 2020-11-18 | xxx.x   | Extend VisibleListInfo with MapIconOffSet to set the icon start number for each page.
 * 2020-11-18 | xxx.x   | Fix compiler warnings in GuidanceInfos.h,
 *                      | Modified a log statement in GuidanceInfos.h
 * 2020-11-20 | 395.0   | Import interface changes Bosch proposal CW47
 * 2020-12-02 | xxx.x   | Extend DestinationInfos with ExpirationStatus in RouteInfos.h
 * 2020-11-20 | 396.0   | Import interface changes Bosch proposal CW49 and Neusoft Proposal CW49
 * 2020-12-09 | xxx.x   | Extended new enum FtsSearchFilterType in AutoCompletionConfiguration structure.
 * 2021-01-08 | 397.0   | Import interface changes Bosch proposal CW02
 * 2020-12-17 | xxx.x   | Added new interface methods setUrbanZevDrivingOption() and getUrbanZevDrivingOptionStatus() in Navmiddleware.h
 *                      | Added enum UrbanZevDrivingOption in Guidanceinfos.h
 *                      | Added PropertyIdentifier GUIDANCE_URBAN_ZEV_DRIVING_OPTION_STATUS_CHANGED
 * 2021-01-06 | xxx.x   | Added enum LOCATION_FREE_TEXT_SEARCH_RESULT_ATTRIBUTES_ERROR, LOCATION_POI_ENTRY_ATTRIBUTES_ERROR,
 *                      | removed enum LOCATION_POI_ENTRY_DETAILS_AVAILABLE, LOCATION_FREE_TEXT_SEARCH_RESULT_DETAILS_AVAILABLE
 *                      | in PropertyIdentifiers.h and Interface description updated accordingly
 *                      | Added new interface getFreeTextSearchResultAttributesError() and getPoiEntryAttributesError().
 * 2021-01-15 | 398.0   | Import interface changes Bosch proposal CW02
 * 2021-01-29 | 399.0   | Import interface changes Neusoft proposal CW04
 * 2021-02-17 | xxx.x   | Renamed m_mapIconStartOffset to m_mapIconStartNumber,setMapIconStartOffset() to setMapIconStartNumber(),
 *                      | getMapIconStartOffset() to getMapIconStartNumber() in MapInfos.h
 * 2021-02-19 | 400.0   | Import interface changes Bosch and Neusoft proposal CW07
 * 2021-03-04 | 401.0   | Import interface changes Neusoft proposal CW08
 * 2021-02-17 | xxx.x   | m_scaleBarWidthInPixel and corresponding getter/setter in MapCameraInfos is deprecated and
 *                      | a new member m_scaleBarWidthInPercentage is added.
 * 2021-03-19 | 402.0   | Import interface changes Neusoft and Bosch proposal CW11
 * 2021-04-16 | 403.0   | Import interface changes Neusoft proposal CW15
 * 2021-03-22 | xxx.x   | toString() function of class PoiIconInfos extended to print Poi Category Id and Variant in LocationInfos.h
 * 2021-04-01 | xxx.x   | Add function resumeFreeTextSearchInstance (FTS input)
 * 2021-04-14 | xxx.x   | Added DateTime structure and m_productionDateTime in ConfigurationInfos.h
 * 2021-04-22 | xxx.x   | Add RequestId in requestAddressAttributesForCoordinate() to match the request-response.
 * 2021-04-27 | xxx.x   | Updated the LI MW Interface documentation.
 * 2021-05-04 | xxx.x   | New structure ResumeFreeTextSearchStatusInfo is introduced
 *                      | Added PropertyIdentifier LOCATION_FREE_TEXT_SEARCH_RESUME_STATUS_CHANGED
 *                      | Updated the return type for the function resumeFreeTextSearchInstance()
 *                      | Added new interface method getResumeFreeTextSearchStatusInfo()
 * 2021-05-07 | 404.0   | Import interface changes Bosch proposal CW18
 * 2021-05-25 | xxx.x   | Add new infos ShapePointsInfo, ShapePointsAvailabilityInfo in RouteInfos.h
 *                      | Add new PropertyIdentifiers ROUTE_SHAPE_POINTS_AVAILABILITY_CHANGED,
 *                      | ROUTE_SHAPE_POINTS_INFO_CHANGED in PropertyIdentifiers.h
 *                      | Add getShapePointsAvailabilityInfo(), requestShapePoints(), getShapePointsInfo()
 *                      | new methods in NavMiddleware
 * 2021-06-04 | 405.0   | Import interface changes Bosch proposal CW22
 * 2021-07-07 | xxx.x   | Added toString() for enum Type in Image class and AddressInfoType in AddressDetailInfo class
 * 2021-07-16 | 406.0   | Import interface changes Bosch proposal CW28 and Neusoft proposal CW28
 * 2021-07-23 | xxx.x   | Extended LocationAttribute ParkingInfo with member variable m_totalCapacity, availableSpaces, tendency, timeStamp
 * 2021-08-16 | xxx.x   | Extend RouteCalculationInfo with ValidValue boolean member m_isRouteGuided
 * 2021-08-20 | 407.0   | Import interface changes Bosch proposal CW33 and Neusoft proposal CW32
 * 2021-08-24 | xxx.x   | Extended ScomoInstallComponentResult with member variable m_updateRegionName in NavDataUpdateInfos
 * 2021-09-03 | 408.0   | Import interface changes Bosch proposal CW35
 * 2021-09-17 | 409.0   | Import interface changes Neusoft proposal CW36 and CW37
 * 2021-09-20 | xxx.x   | Extend DestinationMemoryAliasInfo with member variable m_phoneNumberList in InfoTypes.h
 * 2021-09-31 | xxx.x   | Update documentation for showLocationsInMap(), showPickedPOIsInMap() and showAddressbookIconsInMap() in Navmiddleware
 * 2021-10-01 | 410.0   | Import interface changes Neusoft and Bosch proposal CW39
 * 2021-10-19 | xxx.x   | Add new user profile
 * 2021-10-20 | xxx.x   | Add a new interface method clearVoiceTags().
 * 2021-10-22 | 411.0   | Import interface changes Bosch proposal CW42
 * 2021-12-02 | xxx.x   | Extend Arrival infos with ValidValue boolean member m_isRouteGuided
 * 2021-12-06 | xxx.x   | Extended enum VehicleBrandType with VEHICLE_BRAND_TYPE__RENAULT_TRUCKS in ConfigurationInfos.h
 * 2021-12-06 | xxx.x   | Extended enum LocationError with LOCATION_ERROR__ABORT_BY_CLIENT in LocationInfos.h
 * 2022-01-11 | xxx.x   | Extend enum Error with ERROR__ABORTED_BY_CLIENT in RouteInfos.h
 * 2022-01-14 | 412.0   | Import interface changes Bosch proposal CW02 2022
 * 2022-03-29 | 413.0   | Import Neusoft Proposal CW12
 * 2022-03-08 | xxx.x   | Fix missing initialization of phone number list variable in constructor of class DestinationMemoryAliasInfo.
 * 2022-03-22 | xxx.x   | Added the default constructor for the member variables initialization of MapVideoStreamInfo class in MapInfos.h
 * 2022-04-04 | xxx.x   | Extended the Map Dynamic Icon setting to accept addtional POI configurations.
 * 2022-04-07 | 414.0   | Import Bosch Proposal CW14
 * 2022-04-18 | xxx.x   | Initialized trafficIconType of TrafficInfo in RouteInfos.h
 * 2022-05-04 | xxx.x   | Extended WeatherDataReport with the Weather Report Time
 * 2022-05-06 | 415.0   | Import Bosch and Neusoft Proposal CW18
 * 2022-07-23 | xxx.x   | Extended configuration infos with Navigation Variant
 * 2022-08-05 | 416.0   | Import Bosch Proposal CW31
 * 2022-08-08 | xxx.x   | Extended method applyWaypointListChange() with the parameter waypointEditMode with default value of WAYPOINT_EDIT_MODE__WITHOUT_RECALCULATION
 * 2022-08-10 | xxx.x   | Extend Location Attributes with a generic Pricing Structure to show Parking Prices.
 * 2022-08-12 | 417.0   | Import Bosch Proposal CW32
 * 2022-10-03 | xxx.x   | Update Docu for Fts Tagged Search and Correct Property name for SDS Check Address.
 * 2022-10-10 | xxx.x   | Extend PostionInfo Attributes with time zone values.
 * 2022-10-14 | 418.0   | Import Bosch Proposal and Neusoft Proposal CW41
 * 2022-10-27 | xxx.x   | Extend ArrivalInfo class in RouteInfos.h with member m_stateOfChargeAfterChargingWithBatterySegments
 * 2022-11-18 | 419.0   | Import Bosch Proposal CW46
 * 2022-11-24 | xxx.x   | Move nested class StateOfCharge out of StateOfChargeAndReachabilityInfo,
 *                      | Extend class StateOfCharge with m_stateOfChargeAsPercentageString
 *                      | Rename class StateOfChargeAndReachabilityInfo as ReachabilityInfo,rename respective variables accordingly
 *                      | Extend ArrivalInfo class in RouteInfos.h with members m_stateOfChargeOnArrival, m_stateOfChargeOnDeparture.
 *                      | Extend ArrivalInfoAlternative class in RouteInfos.h with members m_stateOfChargeOnArrivalNextDest,m_stateOfChargeOnDepartureNextDest, m_stateOfChargeOnArrivalFinalDest
 *                      | Removed member m_soc from class ExtendedListElementInfo in RouteInfosExtension.h.
 *                      |  Extended class ExtendedListElementInfo with new members m_reachabilityInfo and m_stateOfChargeOnArrival of class ReachabilityInfo and StateOfCharge respectively.
 * 2022-11-29 | xxx.x   | Extended WaypointInfos with ChargingStationAdditionType, WaypointSource
 *                        Extended WaypointType with Charging station
 *                        Extended TourElement with WaypointType, ChargingStationAdditionType, ChargingDetails
 * 2022-12-01 | 420.0   | Import Bosch Proposal CW48
 * 2022-12-08 | xxx.x   | Extend the vehicle type in InfoTypes.h
 * 2022-12-09 | 421.0   | Import Bosch Proposal CW49
 * 2023-01-30 | xxx.x   | Updated documentation for LOCATION_ONLINE_SEARCH_AVAILABILITY_CHANGED in PropertyIdentifiers.h, handle only for Japan navigation.
 * 2023-01-03 | xxx.x   | Extended the ManeuverViewInfo with JunctionView Image Type with 2 type: JUNCTION_VIEW_IMAGETYPE__BLOB and JUNCTION_VIEW_IMAGETYPE__DESCRIPTION. Client bases on it to use blob image or JunctionView image description.
 *                        Adding JunctionView image description
 * 2023-02-13 | xxx.x   | Update LastInputCategory member as part of AddressInputInfo Structure to support the PostalCode Identification as part of City Selection
 * 2023-02-21 | xxx.x   | Added Enum UpdateReason as member of LocationInfos to provide the reasoning for which API call the LOCATION_POI_ENTRIES_CHANGED is sent.
 * 2023-02-24 | 422.0   | Import Bosch Proposal CW08
 */

static const int NAVMIDDLEWARE_VERSION_MAJOR = 422;
static const int NAVMIDDLEWARE_VERSION_MINOR = 0;
static const ::std::string NAVMIDDLEWARE_SW_BASE_VERSION = "3.1";

using namespace navmiddleware;

NavMiddleware::Supplier NavMiddleware::getSupplier() const
{
   return SUPPLIER__BOSCH;
}

::std::string NavMiddleware::getVersionString() const
{
   ::std::stringstream stringStream;
   //TODO(spn2hi) add NAVMIDDLEWARE_SW_BASE_VERSION after interface changes are released
   stringStream << NAVMIDDLEWARE_SW_BASE_VERSION << "_" << NAVMIDDLEWARE_VERSION_MAJOR << "." << NAVMIDDLEWARE_VERSION_MINOR;
   return stringStream.str();
}

int NavMiddleware::getMajorVersion() const
{
   LOG(TAG"getMajorVersion(%d)\n", NAVMIDDLEWARE_VERSION_MAJOR);
   return NAVMIDDLEWARE_VERSION_MAJOR;
}

int NavMiddleware::getMinorVersion() const
{
   LOG(TAG"getMinorVersion(%d)\n", NAVMIDDLEWARE_VERSION_MINOR);
   return NAVMIDDLEWARE_VERSION_MINOR;
}

::std::string NavMiddleware::getSwBaseVersion() const
{
   LOG(TAG"getSwBaseVersion(%s)\n", NAVMIDDLEWARE_SW_BASE_VERSION.c_str());
   return NAVMIDDLEWARE_SW_BASE_VERSION;
}
