/**
* @file Export.h
* @copyright (c) 2015 Robert Bosch Car Multimedia GmbH
* @addtogroup NavMiddleware
* @{
*/

#ifndef EXPORT_H
#define EXPORT_H

#include <cstdio>
#include <assert.h>

#define LOG(...) printf(__VA_ARGS__)
#define TAG "NavMiddleware::"
#define NOTSUPPORTED "Not supported!"

#ifdef _MSC_VER
#include <windows.h>
#else
#include <unistd.h>
#define Sleep(x) usleep((x)*1000)
#endif

#ifdef _MSC_VER
#  define WARNINGS_DISABLE \
   __pragma(warning(push)) \
   __pragma(warning(push, 1)) \
   __pragma(warning(disable : 4068))
#  define WARNINGS_RESTORE \
   __pragma(warning(pop)) \
   __pragma(warning(pop))
#else
#  define WARNINGS_DISABLE
#  define WARNINGS_RESTORE
#endif

#endif // EXPORT_H
