/* ***************************************************************************************
* FILE:          Project_Trace.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  Project_Trace.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef PROJECT_TRACE_H
#define PROJECT_TRACE_H

#ifndef HMI_TRACE_IF_INCLUDED
#error "Please include hmi_trace_if.h only"
#endif

// global define in di_linux_os/component/bosch_includes/trace/mc_trace.h
// predefined trace ids
//   TR_COMP_UI_APP_HMI_MASTER       //  ((256 * 21) +   0)
//   TR_COMP_UI_APP_HMI_PLAYGROUND   //  ((256 * 21) +  64)
//
// free trace ids for hmi applications (xx = 01-15)
//	 TR_COMP_UI_APP_HMI_xx

// predefined input channels
//  TR_TTFIS_UI_APP_HMI_MASTER     //((TR_tenTraceChan)276)
//  TR_TTFIS_UI_APP_HMI_PLAYGROUND //((TR_tenTraceChan)277)
//
// free input channels for hmi applications

// use macro to define basic trace classes and input channel
//   APPHMI_STANDARD_TRACE_SET__PREDEF_ID(component)
//   APPHMI_STANDARD_TRACE_SET(id,component)

#ifdef APPHMI_MASTER
APPHMI_STANDARD_TRACE_SET(MASTER, MASTER)
#include "App/AppHmi_Master_Trace.h"
#endif

#ifdef APPHMI_TUNER
APPHMI_STANDARD_TRACE_SET(02, TUNER)
#include "App/AppHmi_Tuner_Trace.h"
#endif

#ifdef APPHMI_NAVIGATION
APPHMI_STANDARD_TRACE_SET(03, NAVIGATION)
#include "App/AppHmi_Navigation_Trace.h"
#endif

#ifdef APPHMI_MEDIA
APPHMI_STANDARD_TRACE_SET(04, MEDIA)
#include "App/AppHmi_Media_Trace.h"
#endif

#ifdef APPHMI_SDS
APPHMI_STANDARD_TRACE_SET(05, SDS)
#include "App/AppHmi_Sds_Trace.h"
#endif

#ifdef APPHMI_SYSTEM
APPHMI_STANDARD_TRACE_SET(07, SYSTEM)
#include "App/AppHmi_System_Trace.h"
#endif

#ifdef APPHMI_SPI
APPHMI_STANDARD_TRACE_SET(08, SPI)
#include "App/AppHmi_SPI_Trace.h"
#endif

#ifdef APPHMI_PHONE
APPHMI_STANDARD_TRACE_SET(09, PHONE)
#include "App/AppHmi_Phone_Trace.h"
#endif

#ifdef APPHMI_TESTMODE
APPHMI_STANDARD_TRACE_SET(10, TESTMODE)
#include "App/AppHmi_Testmode_Trace.h"
#endif

#ifdef APPHMI_CAMERA
APPHMI_STANDARD_TRACE_SET(11, CAMERA)
#include "App/AppHmi_Camera_Trace.h"
#endif

#ifdef APPHMI_SXM
APPHMI_STANDARD_TRACE_SET(14, SXM)
#include "App/AppHmi_Sxm_Trace.h"
#endif

#endif // PROJECT_TRACE_H
