/**************************************************************************************
* @file         : VehicleConfigurationReader.h
* @author       :
* @addtogroup   : HMI-COMMON
* @brief        :
* @copyright    : (C) 2016 Robert Bosch GmbH
*                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef VEHICLECONFIGURATIONREADER_H_
#define VEHICLECONFIGURATIONREADER_H_


#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"
#include "AppBase/ServiceAvailableIF.h"

namespace App {
namespace Core {

class IMarketRegionValue
{
   public:
      virtual ~IMarketRegionValue() {};
      virtual void updateRegionStatusValue(const uint8) = 0;
};


class VehicleConfigurationReader  :
   public hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public ::VEHICLE_MAIN_FI::SwivMonAutoOpenCallbackIF,
   public ::VEHICLE_MAIN_FI::RegionStatusCallbackIF
{
   public:
      ~VehicleConfigurationReader();
      static VehicleConfigurationReader* getInstance();

      void registerForRegionUpdate(IMarketRegionValue*);
      void deRegisterForRegionUpdate(IMarketRegionValue*);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);

      virtual void onSwivMonAutoOpenError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
                                          const ::boost::shared_ptr< VEHICLE_MAIN_FI::SwivMonAutoOpenError >& error);
      virtual void onSwivMonAutoOpenStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< VEHICLE_MAIN_FI::SwivMonAutoOpenStatus >& status);

      virtual void onRegionStatusError(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< VEHICLE_MAIN_FI::RegionStatusError >& error);

      virtual void onRegionStatusStatus(const ::boost::shared_ptr< VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy,
                                        const ::boost::shared_ptr< VEHICLE_MAIN_FI::RegionStatusStatus >& status);

   private:
      VehicleConfigurationReader();
      VehicleConfigurationReader(const VehicleConfigurationReader&);
      VehicleConfigurationReader& operator=(const VehicleConfigurationReader&);
      void sendUpdateToClients() const;
      static VehicleConfigurationReader* _pVehicleConfigurationReader;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy> _vehicleProxy;
      act_t _swivMonAutoOpen_RegId;
      act_t _marketRegionId;
      ::std::vector<IMarketRegionValue*> _clients;
      uint8 _regionValue;
};


} //namespace Core
} //namespace App

#endif /* VEHICLECONFIGURATIONREADER_H_ */
