/**
 * @file         : VariantHandling.h
 * @author       : INF4CV - Team
 * @addtogroup   : COMMON VariantHandling
 * @brief        : VariantHandling is to handle the variant information
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef VARIANTHANDLING_HEADER
#define VARIANTHANDLING_HEADER

#include <asf/core/Types.h>

enum CMCVariantType
{
   VARIANTTYPE_UNKNOWN    = 0x0,
   VARIANTTYPE_NAVI       = 0x1,
   VARIANTTYPE_NONNAVI    = 0x2,
   VARIANTTYPE_NO_THREE_D = 0x3,  //Not used
   VARIANTTYPE_CC         = 0x4
};


/**
 *  Classes Declaration
 */


namespace App {
namespace Core {

class VariantHandling
{
   public:
      /**
       *  Member Functions Declaration
       */
      virtual ~VariantHandling();
      static VariantHandling* getInstance();
      static void destroyInstance();

      uint8 getVariantType();

   private:
      /**
       *  Member Functions Declaration
       */
      VariantHandling();
      VariantHandling(const VariantHandling& obj);
      VariantHandling& operator= (const VariantHandling& obj);

      void readKDSVariantType();

      /**
       *  Member Variables Declaration
       */
      uint8 _variantType;
};


} //namespace Core
} //namespace App


#endif /* VARIANTHANDLING_HEADER */
