/**
 * @file         : VariantHandling.cpp
 * @author       : INF4CV - Team
 * @addtogroup   : COMMON VariantHandling
 * @brief        : VariantHandling is to handle the variant information
 * @copyright    : (c) 2020-2020 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "hall_std_if.h"
#include "../CommonTrace.h"
#include "hmi_trace_if.h"
#include "VariantHandling.h"


#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_COMMON
#include "trcGenProj/Header/VariantHandling.cpp.trc.h"
#endif


/**
 *  Static Variables Initialization
 */

namespace App {
namespace Core {

static VariantHandling* _variantHandlingInstance = NULL;
} //namespace Core
} //namespace App

#define DEFAULT_VARIANT_TYPE 0xFF


/**
 *  SM "C" Functions Definition
 */
uint16 fnGetVariantType()
{
   uint16 variantType = 0;
   if (NULL != ::App::Core::_variantHandlingInstance)
   {
      variantType = ::App::Core::_variantHandlingInstance->getVariantType();
   }
   return variantType;
}


/**
 *  Member Functions Definition
 */

namespace App {
namespace Core {

VariantHandling::VariantHandling() :  _variantType(DEFAULT_VARIANT_TYPE)
{
   ETG_TRACE_COMP(("VariantHandling: CTOR"));
   _variantHandlingInstance = this;
   readKDSVariantType();
}


VariantHandling::~VariantHandling()
{
   ETG_TRACE_COMP(("VariantHandling: DTOR"));
   _variantHandlingInstance = NULL;
}


VariantHandling* VariantHandling::getInstance()
{
   ETG_TRACE_COMP(("VariantHandling::getInstance()"));
   if (NULL == _variantHandlingInstance)
   {
      _variantHandlingInstance = new VariantHandling();
   }
   return _variantHandlingInstance;
}


void VariantHandling::destroyInstance()
{
   ETG_TRACE_COMP(("VariantHandling::destroyInstance()"));
   if (NULL != _variantHandlingInstance)
   {
      delete _variantHandlingInstance;
      _variantHandlingInstance = NULL;
   }
}


uint8 VariantHandling::getVariantType()
{
   return _variantType;
}


void VariantHandling::readKDSVariantType()
{
   uint8 variantType = 0;
   if (DP_S32_NO_ERR == DP_s32GetConfigItem("AIVIVariantCoding", "VariantSelection", &variantType, 1))
   {
      ETG_TRACE_USR1(("VariantHandling::getKDSVariantType::%d", variantType));
      _variantType = variantType;
   }
}


} //namespace Core
} //namespace App
