/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2018 - 2019
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                : PluginMsgTracing.cpp
* COMPONENT Name      : PluginClientHandler
* DESCRIPTION         : ProjectPluginMsg traces
* AUTHOR              : Preethi Alagappan
* Date                : 15.10.2018
* Revision History    : 0.1
* Date 15.10.2018     : Initial version
* Revision History    : 0.2
* Date 15.11.2018     : Added Append function for EventListDataUtility
****************************************************************************/

#include "ProjectPluginMsgs.h"

#if defined(FEATSTD_STRINGBUFFER_APPENDER_ENABLED)
namespace FeatStd {

template<> ::FeatStd::UInt32 StringBufferAppender< boost::shared_ptr<EventDataUtility> >::Append(::FeatStd::StringBuffer& stringBuffer, boost::shared_ptr<EventDataUtility> const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::EventDataUtility { ");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}

template<> ::FeatStd::UInt32 StringBufferAppender< boost::shared_ptr<EventListDataUtility> >::Append(::FeatStd::StringBuffer& stringBuffer, boost::shared_ptr<EventListDataUtility> const& object)
{
   PARAM_UNUSED(object);
   ::FeatStd::UInt32 tcharCount = 0;
   tcharCount += stringBuffer.Append("::EventListDataUtility { ");
   tcharCount += stringBuffer.Append(" }");
   return tcharCount;
}
}
#endif
