/**
 * @file         : VehicleServiceClient.h
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : VehicleServiceClient is to handle the vehicle service
 *                 client implementation
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef VEHICLE_SERVICE_CLIENT_H
#define VEHICLE_SERVICE_CLIENT_H


#include "VEHICLE_MAIN_FIProxy.h"
#include "LanguageHandlerInterface.h"
#include <AppBase/ServiceAvailableIF.h>


/**
 *  Defines Declaration
 */

#define NS_VEHICLE_FI ::VEHICLE_MAIN_FI


/**
 * Classes declaration
 */

namespace languageHandler {


class VehicleServiceClient : public IVehicleServiceClient
   , public ::hmibase::ServiceAvailableIF
   , public NS_VEHICLE_FI::LanguageCallbackIF
{
   public:
      /**
       *  Member Function Declaration
       */
      VehicleServiceClient();
      virtual ~VehicleServiceClient();
      bool fetchLanguageStatusInfo(uint32& languageId) const;
      void registerLanguageStatusPropertyUpdate(ILanguageStatusPropertyUpdateCB& imp);
      void deregisterLanguageStatusPropertyUpdate(ILanguageStatusPropertyUpdateCB& imp);
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void onLanguageError(const ::boost::shared_ptr< NS_VEHICLE_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< NS_VEHICLE_FI::LanguageError >& error);
      void onLanguageStatus(const ::boost::shared_ptr< NS_VEHICLE_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< NS_VEHICLE_FI::LanguageStatus >& status);

      inline void init()
      {
         initVehicleServiceProxy();
      }

      inline void setConfigurator(IServiceClientConfigurator& imp)
      {
         _configurator = dynamic_cast< IVehicleServiceClientConfigurator* >(&imp);
      }

   private:
      /**
       *  Member Function Declaration
       */
      VehicleServiceClient(const VehicleServiceClient& obj);
      VehicleServiceClient& operator = (const VehicleServiceClient& obj);
      uint32 getLanguageId(const NS_VEHICLE_FI::LanguageStatus& info) const;
      void clear();
      void initVehicleServiceProxy();

      inline bool isMyVehicleServiceProxy(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy) const
      {
         bool isValid = ((NULL != _vehicleProxy.get()) && (_vehicleProxy == proxy)) ? true : false;
         return isValid;
      }
      /**
       *  Member Variable Declaration
       */
      act_t _languageStatus_RegId;
      IVehicleServiceClientConfigurator* _configurator;
      ::boost::shared_ptr< NS_VEHICLE_FI::VEHICLE_MAIN_FIProxy > _vehicleProxy;
      ::std::vector< ILanguageStatusPropertyUpdateCB* > _languageStatusPropertyUpdateCBInfo;
};


}// namespace languageHandler


#undef NS_VEHICLE_FI


#endif /* VEHICLE_SERVICE_CLIENT_H */
