/**
 * @file         : LanguageISOCodeHandler.h
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : LanguageISOCodeHandler is to handle the language ISO code information
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef LANGUAGE_ISO_CODE_HANDLER_H
#define LANGUAGE_ISO_CODE_HANDLER_H


#include "LanguageHandlerInterface.h"
#include <AppBase/ServiceAvailableIF.h>


/**
 * Classes declaration
 */

namespace languageHandler {


class LanguageISOCodeHandler : public ILanguageISOCodeHandler
{
   public:
      /**
       *  Member Function Declaration
       */
      LanguageISOCodeHandler();
      virtual ~LanguageISOCodeHandler();

      inline uint32 getLanguageId(const ::std::string& code) const
      {
         uint32 tId = 0;
         for (::std::map< uint32, ::std::string >::const_iterator itr = _languageISOCodeInfo.begin(); (itr != _languageISOCodeInfo.end()); ++itr)
         {
            if (strcmp(itr->second.c_str(), code.c_str()) == 0)
            {
               tId = itr->first;
               break;
            }
         }
         return tId;
      }

      inline ::std::string getLanguageISOCode(const uint32 languageId) const
      {
         ::std::string tISOCode = "";
         ::std::map< uint32, ::std::string >::const_iterator itr = _languageISOCodeInfo.find(languageId);
         if (itr != _languageISOCodeInfo.end())
         {
            tISOCode = itr->second;
         }
         return tISOCode;
      }

      inline void init()
      {
         initLanguageISOCode();
      }

   private:
      /**
       *  Member Function Declaration
       */
      LanguageISOCodeHandler(const LanguageISOCodeHandler& obj);
      LanguageISOCodeHandler& operator = (const LanguageISOCodeHandler& obj);
      ::std::map< uint32, ::std::string > getLanguageISOCodeInfo() const;
      void clear();
      void initLanguageISOCode();
      /**
       *  Member Variable Declaration
       */
      ::std::map< uint32, ::std::string > _languageISOCodeInfo;
};


}// namespace languageHandler


#endif /* LANGUAGE_ISO_CODE_HANDLER_H */
