/**
 * @file         : LanguageISOCodeHandler.cpp
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : LanguageISOCodeHandler is to handle the language ISO code information
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#include "LanguageISOCodeHandler.h"
#include "vehicle_main_fi_typesConst.h"
#include "unistd.h"
#include "CommonTrace.h"
#include "hmi_trace_if.h"
#include <Trace/TraceUtils.h>


using namespace ::hmibase::trace;
using namespace ::vehicle_main_fi_types;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_COMMON
#include "trcGenProj/Header/LanguageISOCodeHandler.cpp.trc.h"
#endif /* VARIANT_S_FTR_ENABLE_TRC_GEN */


namespace languageHandler {


LanguageISOCodeHandler::LanguageISOCodeHandler()
{
   ETG_TRACE_USR1(("LanguageISOCodeHandler: INFO: APP: %25s : PID: %d : CTOR",  getAppName().c_str(), getpid()));
   clear();
}


LanguageISOCodeHandler::~LanguageISOCodeHandler()
{
   ETG_TRACE_USR1(("LanguageISOCodeHandler: INFO: APP: %25s : PID: %d : DTOR",  getAppName().c_str(), getpid()));
   clear();
}


LanguageISOCodeHandler::LanguageISOCodeHandler(const LanguageISOCodeHandler& obj)
{
   ETG_TRACE_USR1(("LanguageISOCodeHandler: INFO: APP: %25s : PID: %d : CTOR",  getAppName().c_str(), getpid()));
   clear();
   *this = obj;
}


LanguageISOCodeHandler& LanguageISOCodeHandler::operator= (const LanguageISOCodeHandler& obj)
{
   if (this != &obj)
   {
      clear();
      _languageISOCodeInfo = obj._languageISOCodeInfo;
   }
   return *this;
}


void LanguageISOCodeHandler::clear()
{
   _languageISOCodeInfo.clear();
}


void LanguageISOCodeHandler::initLanguageISOCode()
{
   if (_languageISOCodeInfo.empty())
   {
      _languageISOCodeInfo = getLanguageISOCodeInfo();
   }
}


::std::map< uint32, ::std::string > LanguageISOCodeHandler::getLanguageISOCodeInfo() const
{
#define CONFIGURE_LANGUAGE_ISO_CODE_INFO
#include "LanguageISOCodeInfo.dat"
#undef CONFIGURE_LANGUAGE_ISO_CODE_INFO
}


} // namespace languageHandler
