/**
 * @file         : LanguageDpHandler.hpp
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : LanguageDpHandler is to handle the LanguageHandler feature
 *                 datapool implementation.
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef LANGUAGE_DP_HANDLER_H
#define LANGUAGE_DP_HANDLER_H


#include "LanguageHandlerInterface.h"
#include <dp/dpIfGlob.h>


/**
 *  Classes Declaration
 */

namespace languageHandler {


template<typename dpType>
class LanguageDpHandler : public ILanguageDpHandler
{
   public:
      /**
       *  Member Function Declaration
       */
      LanguageDpHandler() : _currentLanguageId(0)
         , _languageISOCodeHandler(NULL)
      {}

      virtual ~LanguageDpHandler()
      {
         _currentLanguageId      = 0;
         _languageISOCodeHandler = NULL;
      }

      inline uint32 getLanguageId() const
      {
         return _currentLanguageId;
      }

      inline void init()
      {
         loadLanguageId();
      }

      inline void setLanguageId(const uint32 languageId)
      {
         if (_currentLanguageId != languageId)
         {
            _currentLanguageId = languageId;
            _dpInfo.vSetData(languageId);
         }
      }

      inline void setLanguageISOCodeHandler(const ILanguageISOCodeHandler& imp)
      {
         _languageISOCodeHandler = (&imp);
      }

   private:
      /**
       *  Member Function Declaration
       */
      LanguageDpHandler(const LanguageDpHandler& obj);
      LanguageDpHandler& operator= (const LanguageDpHandler& obj);

      inline void loadLanguageId()
      {
         _currentLanguageId = _dpInfo.tGetData();
         if ((_currentLanguageId == 0) && (NULL != _languageISOCodeHandler))
         {
            setLanguageId(_languageISOCodeHandler->getLanguageId("en_US")); //TODO: Upgrade the default steps according to the region -sve2cob
         }
      }
      /**
       *  Member Variables Declaration
       */
      uint32 _currentLanguageId;
      dpType _dpInfo;
      const ILanguageISOCodeHandler* _languageISOCodeHandler;
};


} //namespace languageHandler


#endif /* LANGUAGE_DP_HANDLER_H */
