/**
 * @file         : LanguageHandlerAdapter.h
 * @author       :
 * @addtogroup   : AppHmi_App_PRJ_Common
 * @brief        : LanguageHandlerAdapter is to handle the adapter implementation of LanguageHandler
 * @copyright    : (C) 2016 Robert Bosch GmbH
 *                 (C) 2016 Robert Bosch Engineering and Business Solutions Limited
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */


#ifndef LANGUAGE_HANDLER_ADAPTER_H
#define LANGUAGE_HANDLER_ADAPTER_H


#include <Core/LanguageHandlerInterface.h>


/**
 * Classes Forward declaration
 */

namespace Courier {


class Message;
} // namespace Courier


/**
 * Classes declaration
 */

namespace languageHandler {


class LanguageHandlerAdapter : public IHmiInfoServiceClientConfigurator
   , public IVehicleServiceClientConfigurator
{
   public:
      /**
       *  Member Function Declaration
       */
      LanguageHandlerAdapter();
      LanguageHandlerAdapter(const bool extended);
      virtual ~LanguageHandlerAdapter();
      virtual void configureHmiInfoServicePortName(::std::string& name, bool& isWiredRunTime);
      virtual void configureVehicleServicePortName(::std::string& name, bool& isWiredRunTime);

   protected:
      /**
       *  Member Function Declaration
       */
      void initLanguageHandler();
      virtual bool OnMessage(const ::Courier::Message& Msg);
      virtual void initLanguageDpHandler() {}

   private:
      /**
       *  Member Function Declaration
       */
      LanguageHandlerAdapter(const LanguageHandlerAdapter& obj);
      LanguageHandlerAdapter& operator = (const LanguageHandlerAdapter& obj);
      void initServiceClient();
};


}// namespace languageHandler


#endif /* LANGUAGE_HANDLER_ADAPTER_H */
