/* ***************************************************************************************
* FILE:          FocusOnTouchHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FocusOnTouchHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __FOCUS_ON_TOUCH_HANDLER_H__
#define __FOCUS_ON_TOUCH_HANDLER_H__

#include <Focus/FManager.h>
#include <Focus/FManagerConfig.h>

///////////////////////////////////////////////////////////////////////////////
class FocusOnTouchHandler : public Focus::FMsgReceiver
{
   public:
      FocusOnTouchHandler(Focus::FManager& manager) : _manager(manager) {}

      virtual bool onMessage(const Focus::FMessage& msg);

   private:
      FocusOnTouchHandler(const FocusOnTouchHandler&);
      FocusOnTouchHandler& operator=(const FocusOnTouchHandler&);

      Focus::FManager& _manager;
};


#endif
