/* ***************************************************************************************
* FILE:          DefaultFocusReqHandler.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultFocusReqHandler.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"
#include "ProjectBaseMsgs.h"

#include "DefaultFocusReqHandler.h"
#include <Focus/Default/FDefaultAvgBuilder.h>

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_HMI_FW_FOCUS
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/DefaultFocusReqHandler.cpp.trc.h"
#endif

COURIER_LOG_SET_REALM(Candera::Diagnostics::LogRealm::User);

bool DefaultFocusReqHandler::onMessage(Focus::FSession& session, Focus::FGroup& group, const Focus::FMessage& msg)
{
   (void)group;

   bool consumed = false;
   if (msg.GetId() == FocusReqMsg::ID)
   {
      const FocusReqMsg* reqMsg = Courier::message_cast<const FocusReqMsg*>(&msg);
      if (reqMsg != NULL)
      {
         if ((_manager.getActivityTimer() != NULL) && (reqMsg->GetTimerAction() != FOCUS_TIMER_NO_ACTION))
         {
            _manager.getActivityTimer()->stop();
         }

         switch (reqMsg->GetAction())
         {
            case FOCUS_SHOW:
            {
               _manager.setFocus(session, reqMsg->GetView(), reqMsg->GetWidget().GetCString());
               if (!_manager.isFocusVisible())
               {
                  _manager.generateNewSequenceId();
                  _manager.setFocusVisible(true);
               }
            }
            break;

            case FOCUS_SET:
            {
               _manager.setFocus(session, reqMsg->GetView(), reqMsg->GetWidget().GetCString());
               session.Data.set(Focus::FSessionFocusVisibilityUpdateConfig(false));
            }
            break;

            case FOCUS_HIDE:
            {
               if (reqMsg->GetView() != Focus::Constants::InvalidViewId)
               {
                  if (!_manager.getCurrentAppState().PointsToNull())
                  {
                     Focus::FViewState* viewState = _manager.getCurrentAppState()->getChild(reqMsg->GetView());         //lint !e1793
                     if (viewState != NULL)
                     {
                        viewState->setData(Focus::FViewFocusVisible(false));
                     }
                  }
               }
               else
               {
                  _manager.setFocusVisible(false);
               }

               //prevent avg builder to overwrite the visibility info of the views at the end of a session
               session.Data.set(Focus::FSessionFocusVisibilityUpdateConfig(false));
            }
            break;

            default:
               break;
         }

         if ((_manager.getActivityTimer() != NULL) && (reqMsg->GetTimerAction() == FOCUS_TIMER_RESTART))
         {
            _manager.getActivityTimer()->restart();
         }
         consumed = true;
      }
   }
   return consumed;
}
