/* ***************************************************************************************
* FILE:          DefaultFocusInput.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  DefaultFocusInput.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef __DEFAULT_FOCUS_INPUT_H__
#define __DEFAULT_FOCUS_INPUT_H__

#include <Focus/FManager.h>
#include <Focus/FManagerConfig.h>

///////////////////////////////////////////////////////////////////////////////
class DefaultInputMsgChecker : public Focus::FInputMsgChecker
{
   public:
      virtual bool isFocusInputMessage(const Focus::FMessage& msg) const;

   private:
      bool isFocusInputHKMessage(const HKStatusChangedUpdMsg& msg) const;
      bool isFocusInputEnterKeyMessage(const EnterKeyStatusChangedUpdMsg& msg) const;
      bool isFocusInputEncoderMessage(const EncoderStatusChangedUpdMsg& msg) const;
      bool isFocusInputJoystickMessage(const JoystickStatusChangedUpdMsg& msg) const;
};


///////////////////////////////////////////////////////////////////////////////
class DefaultHKtoEnterKeyConverter : public Focus::FMsgReceiver
{
   public:
      DefaultHKtoEnterKeyConverter(Focus::FManager& manager) : _manager(manager) {}

      virtual bool onMessage(const Focus::FMessage& msg);

   private:
      DefaultHKtoEnterKeyConverter(const DefaultHKtoEnterKeyConverter&);
      DefaultHKtoEnterKeyConverter& operator=(const DefaultHKtoEnterKeyConverter&);

      Focus::FManager& _manager;
};


#endif
