/* ***************************************************************************************
* FILE:         NavigationModeDBHandler.h
* SW-COMPONENT: HMI-COMMON
* DESCRIPTION:  NavigationModeDBHandler.h
* COPYRIGHT: (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef NAVIGATION_MODE_DB_HANDLER_H
#define NAVIGATION_MODE_DB_HANDLER_H

#include "ProjectBaseDataBinding.h"
#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "ProjectBaseMsgs.h"


/**
 *  Classes Declaration
 */

class StartupSync;

using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;

class NavigationModeDBHandler :  public StartupSync::PropertyRegistrationIF
   , public NavigationModeChangeTriggerCallbackIF
   , public hmibase::ServiceAvailableIF
{
   public:
      virtual ~NavigationModeDBHandler();
      static NavigationModeDBHandler* getInstance();

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& /*stateChange*/);

      virtual void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      virtual void onNavigationModeChangeTriggerError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr< NavigationModeChangeTriggerError >& error);
      virtual void onNavigationModeChangeTriggerSignal(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr< NavigationModeChangeTriggerSignal >& signal);

   private:
      NavigationModeDBHandler();
      NavigationModeDBHandler(const NavigationModeDBHandler& obj);//copy constructor
      NavigationModeDBHandler& operator= (const NavigationModeDBHandler& obj);

      static NavigationModeDBHandler* _instance;

      ::boost::shared_ptr< HmiInfoServiceProxy> _hmiInfoServiceProxyClient;
      act_t _navigationModeChangeUpdate_RegId;
};


#endif  // NAVIGATION_MODE_DB_HANDLER_H
