/* ***************************************************************************************
* FILE:          NavigationModeDBHandler.cpp
* SW-COMPONENT:  HMI-COMMON
*  DESCRIPTION:  NavigationModeDBHandler.cpp
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "../CommonTrace.h"
#include "hmi_trace_if.h"
#include "NavigationModeDBHandler.h"

using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_COMMON
#include "trcGenProj/Header/NavigationModeDBHandler.cpp.trc.h"
#endif

/**
 *  Defines Declaration
 */
#define NAVIGATION_MODE_REGID_DEFAULT 0

NavigationModeDBHandler* NavigationModeDBHandler::_instance = NULL;

NavigationModeDBHandler::NavigationModeDBHandler()
   : _hmiInfoServiceProxyClient(HmiInfoServiceProxy::createProxy("hmiinfoservicePort", *this))
   , _navigationModeChangeUpdate_RegId(NAVIGATION_MODE_REGID_DEFAULT)
{
   ETG_TRACE_USR1(("NavigationModeDBHandler: CTOR"));
   if (_hmiInfoServiceProxyClient.get())
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _hmiInfoServiceProxyClient->getPortName());
   }
}


NavigationModeDBHandler::~NavigationModeDBHandler()
{
}


NavigationModeDBHandler* NavigationModeDBHandler::getInstance()
{
   ETG_TRACE_USR1(("NavigationModeDBHandler: getInstance"));
   if (_instance == NULL)
   {
      _instance = new NavigationModeDBHandler();
   }
   return _instance;
}


void NavigationModeDBHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("NavigationModeDBHandler::registerProperties entered"));
}


void NavigationModeDBHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("NavigationModeDBHandler::deregisterProperties entered"));
}


void NavigationModeDBHandler::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("NavigationModeDBHandler::onAvailable entered"));
   if (_hmiInfoServiceProxyClient && _hmiInfoServiceProxyClient == proxy)
   {
      _navigationModeChangeUpdate_RegId = _hmiInfoServiceProxyClient->sendNavigationModeChangeTriggerRegister(*this);
   }
}


void NavigationModeDBHandler::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("NavigationModeDBHandler::onUnavailable entered"));
   if (_hmiInfoServiceProxyClient && _hmiInfoServiceProxyClient == proxy)
   {
      _hmiInfoServiceProxyClient->sendNavigationModeChangeTriggerDeregister(_navigationModeChangeUpdate_RegId);
      _navigationModeChangeUpdate_RegId = NAVIGATION_MODE_REGID_DEFAULT;
   }
}


void NavigationModeDBHandler::onNavigationModeChangeTriggerError(const ::boost::shared_ptr<bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& /* proxy*/, const ::boost::shared_ptr<NavigationModeChangeTriggerError >& error)
{
   if ((NULL != error.get()) && (error->getAct() == _navigationModeChangeUpdate_RegId))
   {
      ETG_TRACE_USR4(("NavigationModeDBHandler::onNavigationModeChangeTriggerError()"));
   }
}


void NavigationModeDBHandler::onNavigationModeChangeTriggerSignal(const ::boost::shared_ptr<bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy >& /*proxy*/, const ::boost::shared_ptr<NavigationModeChangeTriggerSignal >& signal)
{
   if ((NULL != signal.get()) && (signal->getAct() == _navigationModeChangeUpdate_RegId))
   {
      ETG_TRACE_USR4(("NavigationModeDBHandler::onNavigationModeChangeTriggerSignal carModeStatus: %d, coachModeStatus: %d", signal->getCarModeActive(), signal->getCoachModeActive()));

      NavigationCarModeInfo* oMsg =  COURIER_MESSAGE_NEW(NavigationCarModeInfo)(signal->getCarModeActive(), signal->getCoachModeActive());
      if (NULL != oMsg)
      {
         oMsg->Post();
      }
   }
}
